/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.pages;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.TransactionToFilePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.ValidationDelegate;

public abstract class ExtnTransactionToFile
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    public static final String PAGE_NAME = "ExtnTransactionToFile";

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract Double getAmount();

    public abstract void setAmount(Double var1);

    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract UserManager getUserManager();

    public abstract ApplicationLogManager getApplicationLogManager();

    public abstract AccountManager getAccountManager();

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public String getPageTitle() {
        String title = this.getTransactionToFilePlugin().getPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(this.createAmountsModel());
        }
        if (!this.getRequestCycle().isRewinding() && !this.getTransactionToFilePlugin().isLicensed()) {
            this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
        }
    }

    public void formSubmit(IRequestCycle cycle) {
        ValidationDelegate delegate = (ValidationDelegate)this.getBeans().getBean("delegate");
        if (delegate.getHasErrors()) {
            this.addErrorMessage(delegate.getFirstError().toString());
            return;
        }
        if (this.getAmount() == null || this.getAmount() <= 0.0) {
            this.addErrorMessage("Please select an amount.");
            return;
        }
        String userName = this.getUser().getUserName();
        TransactionToFilePlugin.TransactionResponse response = this.getTransactionToFilePlugin().performTransaction(userName, this.getAmount());
        if (response.isSuccess()) {
            this.addStatusMessage("Funds have been added to your account");
        } else {
            this.addErrorMessage(GatewayConfig.getInstance().getUserErrorMessage());
            this.addErrorMessage(response.getMessage());
        }
    }

    private IPropertySelectionModel createAmountsModel() {
        return GatewayUtils.createAllowedAmountsModel("transaction-to-file.allowed-amounts", (BasePaperCutPage)this);
    }

    public String getNoAccessMsg() {
        return GatewayConfig.getInstance().getNoAccessMessage();
    }

    public String getHeading() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String heading = conf.getString("transaction-to-file.page-heading");
        if (StringUtils.isBlank((String)heading)) {
            heading = "Add Credit";
        }
        return heading;
    }

    public String getUsagePolicyMessage() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String msg = conf.getString("transaction-to-file.usage-policy");
        return StringUtils.trimToEmpty((String)msg);
    }

    private TransactionToFilePlugin getTransactionToFilePlugin() {
        return (TransactionToFilePlugin)PluginManager.getInstance().getPluginByClass(TransactionToFilePlugin.class);
    }

    public boolean isAccessibleByUser() {
        return this.getTransactionToFilePlugin().userHasAccess(this.getPaperCutVisit().getUserName());
    }

    public List<Double> getAllowedAmounts() {
        GatewayConfig conf = GatewayConfig.getInstance();
        return conf.getDoubleList("transaction-to-file.allowed-amounts");
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public String getPageMessage() {
        return ExtnTransactionToFile.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return ExtnTransactionToFile.getGatewayConfig().getPageMessageAvailable();
    }
}

