/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.pages;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.MonerisPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonerisRedirect
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(MonerisRedirect.class);

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract double getAmount();

    public abstract void setAmount(double var1);

    public abstract String getOrderId();

    public abstract void setOrderId(String var1);

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void activate(IRequestCycle cycle, User user, double amount) {
        this.setUser(user);
        this.setAmount(amount);
        HttpServletRequest r = this.getRequest();
        String returnRedirectURL = r.getScheme() + "://" + r.getServerName() + ":" + r.getServerPort() + "/app?service=external/ExtnMoneris";
        String orderId = this.getMonerisPlugin().createNewOrder(user.getUserName(), amount, returnRedirectURL);
        this.setOrderId(orderId);
        logger.debug("Associated return redirect URL {} with order {} for user {}", new Object[]{returnRedirectURL, orderId, user.getUserName()});
        cycle.activate((IPage)this);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            throw new PageRedirectException("ExtnMoneris");
        }
    }

    public String getPaymentPageURL() {
        return GatewayConfig.getInstance().getString("moneris.payment-page-url");
    }

    public String getStoreId() {
        return GatewayConfig.getInstance().getString("moneris.store-id");
    }

    public String getPayPageToken() {
        return GatewayConfig.getInstance().getString("moneris.pay-page-token");
    }

    public String getLanguage() {
        String language = GatewayConfig.getInstance().getString("moneris.lang");
        return language == null ? "en-ca" : language;
    }

    public String getFormattedAmount() {
        return GatewayUtils.formatNumber(this.getAmount(), 2, Locale.US, false);
    }

    private MonerisPlugin getMonerisPlugin() {
        return (MonerisPlugin)PluginManager.getInstance().getPluginByClass(MonerisPlugin.class);
    }
}

