/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.pages;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.ThreeDSecureFormData;
import biz.papercut.pcng.ext.paymentgateway.realex.RealexRRPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.ConfigManager;
import biz.papercut.pcng.service.NotificationUtils;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;

public abstract class RealexRRRedirect
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Log logger = LogFactory.getLog(RealexRRRedirect.class);
    public static final String PAGE_NAME = "RealexRRRedirect";

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract double getAmount();

    public abstract void setAmount(double var1);

    public abstract String getOrderId();

    public abstract void setOrderId(String var1);

    public abstract String getTimestamp();

    public abstract void setTimestamp(String var1);

    public abstract ThreeDSecureFormData getFormData();

    public abstract void setFormData(ThreeDSecureFormData var1);

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void activate(IRequestCycle cycle, User user, double amount, ThreeDSecureFormData formData) {
        this.setUser(user);
        this.setAmount(amount);
        this.setFormData(formData);
        HttpServletRequest r = this.getRequest();
        String returnRedirectURL = r.getScheme() + "://" + r.getServerName() + ":" + r.getServerPort() + "/app?service=external/ExtnRealexRR";
        String orderId = this.getRealexRRPlugin().createNewOrder(user.getUserName(), amount, returnRedirectURL);
        this.setOrderId(orderId);
        logger.debug((Object)("Created order " + orderId + " for user " + user.getUserName() + ". Redirecting user to Realex HOP."));
        cycle.activate((IPage)this);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            throw new PageRedirectException("ExtnRealexRR");
        }
        if (this.getFormData() == null) {
            throw new PageRedirectException("ExtnRealexRR");
        }
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        this.setTimestamp(timestamp);
    }

    public String getCurrency() {
        return this.getRealexRRPlugin().getCurrency();
    }

    public String getFormattedAmount() {
        double amount = this.getAmount();
        double amountCents = amount * 100.0;
        return GatewayUtils.formatNumber(amountCents, 0, Locale.US, false);
    }

    public String getHostedOrderPageURL() {
        try {
            return this.getRealexRRPlugin().getHostedOrderPageURL().toString();
        }
        catch (Exception e) {
            String errorMsg = "Unable to parse hosted order page URL: " + e.getMessage();
            logger.error((Object)errorMsg, (Throwable)e);
            this.returnToAddCreditPageAndLogError(errorMsg);
            return null;
        }
    }

    public String getMerchantId() {
        return this.getRealexRRPlugin().getMerchantId();
    }

    public String getRealexSubAccountName() {
        return this.getRealexRRPlugin().getRealexSubAccountName();
    }

    public String getSHA1Hash() {
        try {
            return this.getRealexRRPlugin().calculateSHA1HashForOrder(this.getTimestamp(), this.getOrderId(), this.getFormattedAmount());
        }
        catch (Exception e) {
            String errorMsg = "Unable to generate Realex SHA-1 hash: " + e.getMessage();
            logger.error((Object)errorMsg, (Throwable)e);
            this.returnToAddCreditPageAndLogError(errorMsg);
            return null;
        }
    }

    public String getUserNameFieldName() {
        return "USER_NAME";
    }

    public String getUserName() {
        return this.getUser().getUserName();
    }

    public String getUserFullNameFieldName() {
        return "USER_FULL_NAME";
    }

    public String getUserFullName() {
        return this.getUser().getFullName();
    }

    public String getUserEmailFieldName() {
        return "USER_EMAIL";
    }

    public String getUserEmail() {
        return NotificationUtils.getUserEmailAddress((ConfigManager)this.getConfigManager(), (User)this.getUser());
    }

    public String getReturnRedirectURLFieldName() {
        return "RETURN_REDIRECT_URL";
    }

    public String getReturnRedirectURL() {
        HttpServletRequest r = this.getRequest();
        return r.getScheme() + "://" + r.getServerName() + ":" + r.getServerPort() + "/app?service=external/ExtnRealexRR&order-id=" + this.getOrderId();
    }

    public String getTransactionComment() {
        return this.getRealexRRPlugin().getTransactionComment();
    }

    protected void returnToAddCreditPageAndLogError(String errorMsg) {
        EventLog.getInstance().logEvent(errorMsg);
        this.addErrorMessage(this.getRealexRRPlugin().getUserErrorMessage());
        this.getRequestCycle().activate("ExtnRealexRR");
    }

    private RealexRRPlugin getRealexRRPlugin() {
        return (RealexRRPlugin)PluginManager.getInstance().getPluginByClass(RealexRRPlugin.class);
    }
}

