/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.payex;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexPlugin;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.CreditSourceManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.components.StringPropertySelectionModel;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import biz.papercut.pcng.web.util.WebUtils;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.ValidationDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnPayex
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    protected static final Logger logger = LoggerFactory.getLogger(ExtnPayex.class);
    public static final String PAGE_NAME = "ExtnPayex";

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract Double getPayexBalance();

    public abstract void setPayexBalance(Double var1);

    public abstract Double getAmount();

    public abstract void setAmount(Double var1);

    @Nullable
    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract AccountManager getAccountManager();

    public abstract CreditSourceManager getCreditSourceManager();

    public abstract UserManager getUserManager();

    public abstract void setPaymentMethodModel(IPropertySelectionModel var1);

    @Nullable
    public abstract IPropertySelectionModel getPaymentMethodModel();

    public abstract void setPaymentMethod(String var1);

    @Nullable
    public abstract String getPaymentMethod();

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public String getPageTitle() {
        String title = ExtnPayex.getPayexPlugin().getManualTransferPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public String getHeading() {
        return ExtnPayex.getPayexPlugin().getManualTransferPageHeading();
    }

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(GatewayUtils.createAllowedAmountsModel("payex.manual-transfer.allowed-amounts", (BasePaperCutPage)this));
        }
        Object[] paymentMethods = ExtnPayex.getPayexPlugin().getPaymentMethod();
        if (this.getPaymentMethodModel() == null) {
            this.setPaymentMethodModel((IPropertySelectionModel)new StringPropertySelectionModel((String[])paymentMethods));
        }
        PayexResponse response = null;
        if (ArrayUtils.contains((Object[])paymentMethods, (Object)"WyWallet")) {
            response = ExtnPayex.getPayexPlugin().getWyWalletBalanceForUser(this.getUser());
        } else if (ArrayUtils.contains((Object[])paymentMethods, (Object)"Micro Account")) {
            response = ExtnPayex.getPayexPlugin().getPayexMicroAccountBalance(this.getUser());
        }
        if (response != null) {
            if (response.isErrorCodeOK()) {
                this.setPayexBalance(response.getBalanceMerchantCurrency());
            } else if (this.getErrorMessages().isEmpty()) {
                this.addErrorMessage(ExtnPayex.getPayexPlugin().getManualTransferUserErrorMessage() + " (Error retrieving PayEx balance: " + response.getDescription() + ")");
            }
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!ExtnPayex.getPayexPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = ExtnPayex.getPayexPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTransaction(IRequestCycle cycle) {
        String csrftoken;
        ValidationDelegate delegate = (ValidationDelegate)this.getBeans().getBean("delegate");
        if (delegate.getHasErrors()) {
            this.addErrorMessage(delegate.getFirstError().toString());
            return;
        }
        if (!this.isAccessibleByUser()) {
            this.addErrorMessage("You do not have permission to access this feature.");
            return;
        }
        if (this.getAmount() == null || this.getAmount() <= 0.0) {
            this.addErrorMessage("Please select the amount to transfer to your account.");
            return;
        }
        String selectedPaymentMethod = this.getPaymentMethod();
        if (selectedPaymentMethod == null) {
            if (this.getPaymentMethodModel() != null && this.getPaymentMethodModel().getOptionCount() > 1) {
                this.addErrorMessage("Please select payment method");
                return;
            }
            selectedPaymentMethod = ExtnPayex.getPayexPlugin().getPaymentMethod()[0];
        }
        if ((csrftoken = this.getRequest().getParameter("csrftoken")) == null || !csrftoken.equalsIgnoreCase(this.getCsrfToken())) {
            this.addErrorMessage("Unable to submit request due to invalid security token.");
            return;
        }
        HttpServletRequest r = this.getRequest();
        StringBuilder returnURL = new StringBuilder(r.getRequestURL());
        returnURL.append("?service=external/");
        returnURL.append(PAGE_NAME);
        double amount = this.getAmount();
        boolean success = false;
        Object errorSuffix = "";
        String dynamicRedirectUrl = "";
        try {
            String desc;
            PayexResponse response = null;
            switch (selectedPaymentMethod) {
                case "Micro Account": {
                    response = ExtnPayex.getPayexPlugin().performDebitOnMicroAccount(this.getUser(), amount);
                    String string = response.getDescription();
                    break;
                }
                case "WyWallet": {
                    response = ExtnPayex.getPayexPlugin().performDebitOnWyWallet(this.getUser(), amount);
                    String string = response.getWyWalletTransactionStatusDesc();
                    break;
                }
                case "Credit Card": {
                    response = ExtnPayex.getPayexPlugin().performDebitOnCreditCard(this.getUser(), amount, returnURL.toString());
                    String string = response.getDescription();
                    break;
                }
                default: {
                    response = ExtnPayex.getPayexPlugin().performDebitOnMicroAccount(this.getUser(), amount);
                    String string = desc = response.getDescription();
                }
            }
            if (response.isErrorCodeOK()) {
                if (!selectedPaymentMethod.equals("Credit Card")) {
                    this.fundsUpdate(cycle, amount);
                    return;
                }
                dynamicRedirectUrl = response.getDynamicReturnUrl();
                success = true;
            } else {
                if (desc == null) {
                    desc = "Unknown Error";
                }
                errorSuffix = (String)errorSuffix + " (Transaction declined by PayEx: " + desc + ")";
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error performing PayEx debit transaction for user: {}", (Object)this.getUser().getUserName(), (Object)e);
        }
        if (!success) {
            this.addErrorMessage(ExtnPayex.getPayexPlugin().getManualTransferUserErrorMessage() + (String)errorSuffix);
            return;
        }
        WebUtils.redirectToURL((IRequestCycle)cycle, (String)dynamicRedirectUrl);
    }

    private void fundsUpdate(IRequestCycle cycle, double amount) {
        String txnComment = ExtnPayex.getPayexPlugin().getManualTransferTransactionComment();
        GatewayUtils.addCreditToUser(this.getAccountManager(), this.getCreditSourceManager(), this.getUser(), amount, txnComment);
        this.addStatusMessage(this.formatBalance(amount) + " was successfully added to your account.");
        cycle.activate("UserSummary");
    }

    public boolean isAccessibleByUser() {
        return ExtnPayex.getPayexPlugin().isManualTransferAccessibleByUser(this.getPaperCutVisit().getUserName());
    }

    public String getNoAccessMsg() {
        return GatewayConfig.getInstance().getNoAccessMessage();
    }

    public String getUserAndFullName() {
        StringBuilder s = new StringBuilder();
        s.append(this.getUser().getUserName());
        if (StringUtils.isNotBlank((String)this.getUser().getFullName())) {
            s.append(" (");
            s.append(this.getUser().getFullName());
            s.append(")");
        }
        return s.toString();
    }

    public void activateExternalPage(Object[] arguments, IRequestCycle cycle) {
        HttpServletRequest r = this.getRequest();
        String orderRef = r.getParameter("orderRef");
        if (orderRef == null) {
            String errorMessage = "Unable to process transaction with PayEx";
            this.addErrorMessage(errorMessage);
            return;
        }
        PayexResponse completeResponse = ExtnPayex.getPayexPlugin().complete(orderRef);
        if (completeResponse.isErrorCodeOK()) {
            String statusMessage = "Funds have been added to your account";
            this.addStatusMessage(statusMessage);
        } else {
            String errorMessage = "Unable to process transaction with OrderRef: " + orderRef;
            this.addErrorMessage(errorMessage);
        }
    }

    public String getPayexBalanceLabel() {
        return ExtnPayex.getPayexPlugin().getBalanceDisplayLabel();
    }

    public String getPayexAvailableCreditLabel() {
        return ExtnPayex.getPayexPlugin().getBalanceDisplayAvailableCreditLabel();
    }

    public String getPageMessage() {
        return GatewayConfig.getInstance().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return GatewayConfig.getInstance().getPageMessageAvailable();
    }

    public boolean isUserNeedPaymentMethodOptions() {
        return this.getPaymentMethodModel() != null && this.getPaymentMethodModel().getOptionCount() > 1;
    }

    private static PayexPlugin getPayexPlugin() {
        return (PayexPlugin)PluginManager.getInstance().getPluginByClass(PayexPlugin.class);
    }
}

