/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.payex;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.payex.ClientDetails;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayexAccountLookup {
    private static final Logger logger = LoggerFactory.getLogger(PayexAccountLookup.class);
    private static final String CONFIG_PREFIX = "payex.";
    private static final String CONFIG_ACCOUNT_LOOKUP_PREFIX = "payex.account-lookup.";
    private static final String CONFIG_ACCOUNT_LOOKUP_MODE = "payex.account-lookup.mode";
    private static final String CONFIG_ACCOUNT_LOOKUP_DB_DRIVER = "payex.account-lookup.db-driver";
    private static final String CONFIG_ACCOUNT_LOOKUP_DB_URL = "payex.account-lookup.db-url";
    private static final String CONFIG_ACCOUNT_LOOKUP_DB_USERNAME = "payex.account-lookup.db-username";
    static final String CONFIG_ACCOUNT_LOOKUP_DB_PASSWORD = "payex.account-lookup.db-password";
    private static final String CONFIG_ACCOUNT_LOOKUP_DB_SQL = "payex.account-lookup.db-sql";
    @Nullable
    @GuardedBy(value="this")
    private ComboPooledDataSource _dataSource;

    public void checkConfiguration() throws ConfigurationException {
        String errorPrefix = "Configuration problem: ";
        String errorSuffix = "  Please check the payment gateway config file.";
        GatewayConfig gc = GatewayConfig.getInstance();
        if (this.isDBLookupEnabled()) {
            if (StringUtils.isBlank((String)gc.getString(CONFIG_ACCOUNT_LOOKUP_DB_DRIVER))) {
                throw new ConfigurationException(errorPrefix + "No database driver specified (payex.account-lookup.db-driver)." + errorSuffix);
            }
            if (StringUtils.isBlank((String)gc.getString(CONFIG_ACCOUNT_LOOKUP_DB_URL))) {
                throw new ConfigurationException(errorPrefix + "No database connection URL specified (payex.account-lookup.db-url)." + errorSuffix);
            }
            if (StringUtils.isBlank((String)gc.getString(CONFIG_ACCOUNT_LOOKUP_DB_USERNAME))) {
                throw new ConfigurationException(errorPrefix + "No database username specified (payex.account-lookup.db-username)." + errorSuffix);
            }
            if (StringUtils.isBlank((String)gc.getString(CONFIG_ACCOUNT_LOOKUP_DB_SQL))) {
                throw new ConfigurationException(errorPrefix + "No database lookup SQL specified (payex.account-lookup.db-sql)." + errorSuffix);
            }
        } else {
            if (PayexAccountLookup.getPayexPlugin().isWyWalletOnDemandTransferPresent()) {
                throw new ConfigurationException(errorPrefix + "Need to define external database lookup for WyWallet On Demand transfer." + errorSuffix);
            }
            String mode = StringUtils.trimToEmpty((String)gc.getString(CONFIG_ACCOUNT_LOOKUP_MODE));
            if (!(mode.equalsIgnoreCase("USERNAME") || mode.equalsIgnoreCase("EMAIL") || mode.equalsIgnoreCase("INTERNAL_ID_NO"))) {
                throw new ConfigurationException(errorPrefix + "Invalid payex.account-lookup.mode: " + mode + " (choose from: EXTERNAL_DATABASE, USERNAME, EMAIL, INTERNAL_ID_NO)");
            }
        }
    }

    @CheckForNull
    public ClientDetails getPayexAccount(User user) {
        ClientDetails details = null;
        if (this.isDBLookupEnabled()) {
            if (!PayexAccountLookup.getPayexPlugin().isWyWalletOnDemandTransferPresent()) {
                details = this.lookUpAccountInDatabase(user);
            }
        } else {
            String mode = StringUtils.trimToEmpty((String)GatewayConfig.getInstance().getString(CONFIG_ACCOUNT_LOOKUP_MODE)).toUpperCase(Locale.US);
            if (mode.equals("EMAIL")) {
                String email = user.getEmail();
                if (email != null && !email.isEmpty()) {
                    details = new ClientDetails(email);
                    logger.debug("Using email: {}", (Object)email);
                } else {
                    logger.error("Cannot identify Payex account for user {} as email is blank", (Object)user.getUserName());
                }
            } else if (mode.equals("USERNAME")) {
                String username = user.getUserName();
                if (username != null && !username.isEmpty()) {
                    details = new ClientDetails(username);
                    logger.debug("Using username: {}", (Object)username);
                } else {
                    logger.error("Cannot identify Payex user {} as username is blank", (Object)user.getFullName());
                }
            } else {
                String cardno = user.getCardNumber();
                if (cardno != null && !cardno.isEmpty()) {
                    details = new ClientDetails(cardno);
                    logger.debug("Using internal id number: {}", (Object)cardno);
                } else {
                    logger.error("Cannot identify Payex account for user {} as card number is blank", (Object)user.getUserName());
                }
            }
        }
        return details;
    }

    @CheckForNull
    public ClientDetails getPayexAccountForWyWallet(User user) {
        ClientDetails details = null;
        if (this.isDBLookupEnabled() && PayexAccountLookup.getPayexPlugin().isWyWalletOnDemandTransferPresent()) {
            details = this.lookUpAccountInDatabase(user);
        }
        return details;
    }

    private boolean isDBLookupEnabled() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String s = StringUtils.trimToEmpty((String)conf.getString(CONFIG_ACCOUNT_LOOKUP_MODE)).toUpperCase(Locale.US);
        return s.equals("EXTERNAL_DATABASE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private ClientDetails lookUpAccountInDatabase(User user) {
        PreparedStatement stmt;
        ResultSet rs;
        Connection conn;
        block8: {
            ClientDetails clientDetails;
            String agreementRef;
            String clientRef;
            block9: {
                logger.debug("Looking up Payex client details in database for user: {}", (Object)user.getUserName());
                conn = null;
                rs = null;
                stmt = null;
                conn = this.openDBConnection();
                stmt = this.createLookupSQLStatement(conn, user);
                rs = stmt.executeQuery();
                if (!rs.next()) break block8;
                clientRef = rs.getString(1);
                agreementRef = null;
                if (rs.getMetaData().getColumnCount() > 1) {
                    agreementRef = rs.getString(2);
                }
                if (logger.isDebugEnabled() && rs.next()) {
                    String nextAcctNo = rs.getString(1);
                    logger.debug("Payex account lookup returned more than one result for user: {}. Match 1: {} Match 2: {} More matches: {}. Using first match.", new Object[]{user.getUserName(), clientRef, nextAcctNo, rs.next()});
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Found Payex account: {}, agreementRef: {} for user: {} in lookup DB.", new Object[]{clientRef, agreementRef, user.getUserName()});
                }
                if (clientRef != null) break block9;
                clientDetails = null;
                DbUtils.closeQuietly((ResultSet)rs);
                DbUtils.closeQuietly((Statement)stmt);
                DbUtils.closeQuietly((Connection)conn);
                return clientDetails;
            }
            try {
                clientDetails = new ClientDetails(clientRef, agreementRef);
            }
            catch (Exception e) {
                try {
                    String msg = "Error occurred looking up Payex account details in external database for user: " + user.getUserName() + ". " + e.getMessage();
                    EventLog.getInstance().logEvent(msg);
                    logger.error(msg, (Throwable)e);
                    PayexAccountLookup.getPayexPlugin().getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(rs);
                    DbUtils.closeQuietly(stmt);
                    DbUtils.closeQuietly((Connection)conn);
                    throw throwable;
                }
                DbUtils.closeQuietly((ResultSet)rs);
                DbUtils.closeQuietly((Statement)stmt);
                DbUtils.closeQuietly((Connection)conn);
            }
            DbUtils.closeQuietly((ResultSet)rs);
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((Connection)conn);
            return clientDetails;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
        return null;
    }

    private PreparedStatement createLookupSQLStatement(Connection conn, User user) throws SQLException {
        PreparedStatement stmt;
        String sqlTemplate = GatewayConfig.getInstance().getString(CONFIG_ACCOUNT_LOOKUP_DB_SQL);
        Matcher m = Pattern.compile("\\{\\s*(\\p{Alpha}+)\\s*\\}").matcher(sqlTemplate);
        if (logger.isDebugEnabled()) {
            logger.debug("SQL template: {}", (Object)sqlTemplate);
        }
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        while (m.find()) {
            String key;
            switch (key = m.group(1).trim().toLowerCase()) {
                case "username": {
                    params.add(user.getUserName());
                    break;
                }
                case "idnumber": {
                    params.add(user.getCardNumber());
                    break;
                }
                case "fullname": {
                    params.add(user.getFullName());
                    break;
                }
                default: {
                    throw new RuntimeException("Configuration error - unexpected replacement in SQL: " + key);
                }
            }
            m.appendReplacement(sql, "?");
        }
        m.appendTail(sql);
        if (params.isEmpty()) {
            throw new RuntimeException("Configuration error - Payex lookup SQL does not contain any parameters/replacements. SQL: " + sqlTemplate);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Parsed SQL: \"{}\", params: {}", (Object)sql, params);
        }
        if ((stmt = conn.prepareStatement(sql.toString())).getParameterMetaData().getParameterCount() != params.size()) {
            throw new SQLException("Problem with replacements in account lookup SQL (payex.account-lookup.db-sql). Ensure replacements are not quoted.");
        }
        for (int i = 0; i < params.size(); ++i) {
            stmt.setString(i + 1, (String)params.get(i));
        }
        return stmt;
    }

    private synchronized Connection openDBConnection() throws SQLException {
        if (this._dataSource == null) {
            this._dataSource = this.createDataSource();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Getting DB connection from: {}", (Object)this._dataSource);
        }
        try {
            return this._dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new SQLException(StringUtils.trimToEmpty((String)e.getMessage()) + " - Please check database is available and Payex payment gateway account lookup database settings are correct.");
        }
    }

    private synchronized ComboPooledDataSource createDataSource() {
        GatewayConfig gc = GatewayConfig.getInstance();
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        try {
            dataSource.setDriverClass(StringUtils.trimToEmpty((String)gc.getString(CONFIG_ACCOUNT_LOOKUP_DB_DRIVER)));
        }
        catch (PropertyVetoException ve) {
            throw new RuntimeException("Unable to configure database driver: " + gc.getString(CONFIG_ACCOUNT_LOOKUP_DB_DRIVER) + ". " + ve.getMessage(), ve);
        }
        dataSource.setJdbcUrl(StringUtils.trimToEmpty((String)gc.getString(CONFIG_ACCOUNT_LOOKUP_DB_URL)));
        dataSource.setUser(StringUtils.trimToEmpty((String)gc.getString(CONFIG_ACCOUNT_LOOKUP_DB_USERNAME)));
        dataSource.setPassword(StringUtils.trimToEmpty((String)gc.getString(CONFIG_ACCOUNT_LOOKUP_DB_PASSWORD)));
        dataSource.setInitialPoolSize(0);
        dataSource.setMinPoolSize(1);
        dataSource.setMaxPoolSize(50);
        dataSource.setMaxIdleTime(300);
        dataSource.setCheckoutTimeout(10000);
        dataSource.setAcquireIncrement(1);
        dataSource.setAcquireRetryAttempts(2);
        dataSource.setAcquireRetryDelay(500);
        return dataSource;
    }

    private static PayexPlugin getPayexPlugin() {
        return (PayexPlugin)PluginManager.getInstance().getPluginByClass(PayexPlugin.class);
    }
}

