/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.payex;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.payex.ClientDetails;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexAccountLookup;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexResponse;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexSoapDriver;
import biz.papercut.pcng.ext.paymentgateway.payex.PxAgreementHelper;
import biz.papercut.pcng.ext.paymentgateway.payex.PxClientHelper;
import biz.papercut.pcng.ext.paymentgateway.payex.PxOrderHelper;
import biz.papercut.pcng.ext.paymentgateway.payex.PxWyWalletHelper;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.NetworkUtils;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PayexPlugin
extends BasePaymentGatewayPlugin {
    private static final Logger logger = LoggerFactory.getLogger(PayexPlugin.class);
    private static final String PAYMENT_GATEWAY_PAGE_NAME = "ExtnPayex";
    private static final double ROUNDING_TOLERANCE = 1.0E-5;
    private static final String CONFIG_PREFIX = "payex.";
    private static final String CONFIG_ENABLED = "payex.enabled";
    private static final Integer AGREEMENT_REF_VERIFIED = 1;
    private static final String CONFIG_BALANCE_DISPLAY_PREFIX = "payex.balance-display.";
    private static final String CONFIG_BALANCE_DISPLAY_ENABLED = "payex.balance-display.enabled";
    private static final String CONFIG_BALANCE_DISPLAY_LABEL = "payex.balance-display.label";
    private static final String CONFIG_BALANCE_DISPLAY_AVAILABLE_CREDIT_PREFIX = "payex.balance-display.available-credit.";
    private static final String CONFIG_BALANCE_DISPLAY_AVAILABLE_CREDIT_LABEL = "payex.balance-display.available-credit.label";
    private static final String CONFIG_SERVER_PREFIX = "payex.server.";
    private static final String CONFIG_SERVER_TESTSERVER = "payex.server.is-test-server";
    private static final String CONFIG_SERVER_ACCOUNT_NUMBER = "payex.server.merchant-account-number";
    @AESProperty
    public static final String CONFIG_SERVER_ENCRYPTION_KEY = "payex.server.merchant-encryption-key";
    private static final String CONFIG_SERVER_ACQUIRERID = "payex.server.acquirerId";
    private static final String CONFIG_SERVER_AGREEMENTID = "payex.server.agreementId";
    @AESProperty
    public static final String CONFIG_SERVER_SHAREDSECRET = "payex.server.shared-secret";
    private static final String CONFIG_SERVER_CLIENT_TYPE = "payex.server.payex-client-type";
    private static final String CONFIG_SERVER_CLIENT_LANG = "payex.server.client-language";
    private static final String CONFIG_SERVER_RETURN_URL = "payex.server.return-url";
    private static final String CONFIG_SERVER_MAX_ATTEMPTS = "payex.server.max-connection-attempts";
    private static final String CONFIG_SERVER_RETRY_WAIT_MS = "payex.server.connection-retry-wait-ms";
    private static final String CONFIG_PROVIDER = "payex.provider";
    private static final String CONFIG_CURRENCY = "payex.currency";
    public static final String CONFIG_PAYMENTMETHOD = "payment-method";
    private static final String CONFIG_MANUAL_PREFIX = "payex.manual-transfer.";
    private static final String CONFIG_MANUAL_TRANSFER_ENABLED = "payex.manual-transfer.enabled";
    private static final String CONFIG_MANUAL_TRANSFER_PAGE_TITLE = "payex.manual-transfer.page.title";
    private static final String CONFIG_MANUAL_TRANSFER_PAGE_HEADING = "payex.manual-transfer.page.heading";
    private static final String CONFIG_MANUAL_TRANSFER_TRANSACTION_COMMENT = "payex.manual-transfer.transaction-comment";
    protected static final String CONFIG_MANUAL_TRANSFER_ALLOWED_AMOUNTS = "payex.manual-transfer.allowed-amounts";
    private static final String CONFIG_MANUAL_TRANSFER_ALLOWED_GROUPS = "payex.manual-transfer.allowed-groups";
    private static final String CONFIG_MANUAL_TRANSFER_USER_ERROR_MESSAGE = "payex.manual-transfer.user-error-message";
    private static final String CONFIG_ON_DEMAND_PREFIX = "payex.on-demand-transfer.";
    private static final String CONFIG_ON_DEMAND_TRANSFER_ENABLED = "payex.on-demand-transfer.enabled";
    private static final String CONFIG_ON_DEMAND_TRANSFER_MIN_TRANSFER_AMOUNT = "payex.on-demand-transfer.min-transfer-amount";
    private static final String CONFIG_ON_DEMAND_TRANSFER_MAX_TRANSFER_AMOUNT = "payex.on-demand-transfer.max-transfer-amount";
    private static final String CONFIG_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT = "payex.on-demand-transfer.transaction-comment";
    private static final String CONFIG_ON_DEMAND_TRANSFER_ENABLED_GROUPS = "payex.on-demand-transfer.enabled-groups";
    private static final String CONFIG_ON_DEMAND_PAYMENT_METHOD = "payex.on-demand-transfer.payment-method";
    @AESProperty
    public static final String NOT_USE_CONFIG_ACCOUNT_LOOKUP_DB_PASSWORD = "payex.account-lookup.db-password";
    private static final String DEFAULT_PAPERCUT_PROVIDER = "PaperCut";
    private static final String DEFAULT_MANUAL_TRANSFER_TRANSACTION_COMMENT = "Funds added from PayEx";
    private static final String DEFAULT_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT = "Automatic transfer from PayEx";
    public static final String MICROACCOUNT_PAYMENT_METHOD = "Micro Account";
    public static final String CREDIT_CARD_PAYMENT_METHOD = "Credit Card";
    public static final String WYWALLET_PAYMENT_METHOD = "WyWallet";
    private final int _defaultMaxAttempts = 3;
    private final int _defaultRetryWaitMs = 60000;
    private volatile PxClientHelper _pxClientHelper;
    private volatile PxOrderHelper _pxOrderHelper;
    private volatile PxAgreementHelper _pxAgreementHelper;
    private volatile PxWyWalletHelper _pxWyWalletHelper;
    private static String[] paymentMethod;
    private final boolean _isPayexTestServer = false;
    private static final AtomicInteger _orderIdSuffix;
    private final String _serverIpAddress = NetworkUtils.getIpAddress();
    @Nullable
    private volatile ApplicationContext _ctx;
    private final PayexAccountLookup _accountLookup = new PayexAccountLookup();

    public String getIsConfigured() {
        String missingOrInvalid = "is missing or invalid.";
        if (this.getPaymentMethod().length != 1 || !this.getPaymentMethod()[0].equalsIgnoreCase(WYWALLET_PAYMENT_METHOD)) {
            Long acctno = this.getMerchantAccountNumber();
            if (acctno == null) {
                return this.reportInvalidConfig(CONFIG_SERVER_ACCOUNT_NUMBER, missingOrInvalid);
            }
            if (this.getEncryptionKey() == null) {
                return this.reportInvalidConfig(CONFIG_SERVER_ENCRYPTION_KEY, missingOrInvalid);
            }
            if (this.getReturnUrl() == null) {
                return this.reportInvalidConfig(CONFIG_SERVER_RETURN_URL, missingOrInvalid);
            }
            int clientType = this.getClientType();
            if (clientType < 1) {
                return this.reportInvalidConfig(CONFIG_SERVER_CLIENT_TYPE, missingOrInvalid + " (Choose from: " + Arrays.toString(PxClientHelper.ClientTypeStrings) + ")");
            }
        }
        if (ArrayUtils.contains((Object[])this.getPaymentMethod(), (Object)WYWALLET_PAYMENT_METHOD)) {
            if (this.getAcquirerID() == null) {
                return this.reportInvalidConfig(CONFIG_SERVER_ACQUIRERID, missingOrInvalid);
            }
            if (this.getAgreementID() == null) {
                return this.reportInvalidConfig(CONFIG_SERVER_AGREEMENTID, missingOrInvalid);
            }
            if (this.getSharedSecret() == null) {
                return this.reportInvalidConfig(CONFIG_SERVER_SHAREDSECRET, missingOrInvalid);
            }
        }
        if (this.getCurrency() == null) {
            return this.reportInvalidConfig(CONFIG_CURRENCY, missingOrInvalid);
        }
        try {
            this.getManualTransferAllowedAmounts();
        }
        catch (Exception e) {
            return this.reportInvalidConfig(CONFIG_MANUAL_TRANSFER_ALLOWED_AMOUNTS, "uses the wrong format");
        }
        if (this.getManualTransferAllowedAmounts().isEmpty()) {
            return this.reportInvalidConfig(CONFIG_MANUAL_TRANSFER_ALLOWED_AMOUNTS, "must have at least one valid payment amount");
        }
        if (this.isOnDemandTransferEnabled()) {
            Double minTransferAmount = this.getOnDemandTransferMinTransferAmount();
            if (minTransferAmount == null) {
                return this.reportInvalidConfig(CONFIG_ON_DEMAND_TRANSFER_MIN_TRANSFER_AMOUNT, missingOrInvalid);
            }
            Double maxTransferAmount = this.getOnDemandTransferMaxTransferAmount();
            if (maxTransferAmount == null) {
                return this.reportInvalidConfig(CONFIG_ON_DEMAND_TRANSFER_MAX_TRANSFER_AMOUNT, missingOrInvalid);
            }
            if (minTransferAmount > maxTransferAmount) {
                return this.reportInvalidConfig(CONFIG_ON_DEMAND_TRANSFER_MIN_TRANSFER_AMOUNT, "is greater than payex.on-demand-transfer.max-transfer-amount");
            }
        }
        List<String> paymentMethods = PxOrderHelper.PaymentMethod.getPropertyValues();
        for (String pm : this.getPaymentMethod()) {
            if (paymentMethods.contains(pm)) continue;
            return this.reportInvalidConfig(CONFIG_ON_DEMAND_PAYMENT_METHOD, missingOrInvalid);
        }
        try {
            this._accountLookup.checkConfiguration();
        }
        catch (ConfigurationException ce) {
            logger.error(ce.getMessage());
            EventLog.getInstance().logEvent(ce.getMessage());
            return ce.getMessage();
        }
        return null;
    }

    private String reportInvalidConfig(String fieldName, String message) {
        String errorMsg = "Configuration problem: PayEx field: " + fieldName + " " + message + "  Please check the payment gateway config file.";
        GatewayUtils.LogHelper.logError(logger, errorMsg, null, this.getApplicationLogManager());
        return errorMsg;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isManualTransferEnabled() && this.isManualTransferAccessibleByUser(username)) {
            return List.of(PAYMENT_GATEWAY_PAGE_NAME);
        }
        return null;
    }

    @Override
    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    @Override
    public void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    public void setPaymentMethod(String[] paymentMethod) {
        PayexPlugin.paymentMethod = paymentMethod;
    }

    public String[] getPaymentMethod() {
        if (paymentMethod == null) {
            String paymentString = StringUtils.trimToEmpty((String)GatewayConfig.getInstance().getString("payex.payment-method"));
            if (paymentString.isEmpty()) {
                paymentMethod = new String[]{MICROACCOUNT_PAYMENT_METHOD};
            } else if (paymentString.contains(",")) {
                paymentMethod = paymentString.split(",");
                Arrays.sort(paymentMethod);
            } else {
                paymentMethod = new String[]{paymentString};
            }
        }
        return paymentMethod;
    }

    public LicenseManager getLicenceManager() {
        return (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
    }

    @Override
    public String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    @Override
    public boolean isLicensed() {
        return GatewayUtils.isLicensed(this.getLicenceManager(), "payment-gateways-payex");
    }

    @Override
    public UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    @Override
    public ApplicationLogManager getApplicationLogManager() {
        return (ApplicationLogManager)this.getApplicationContext().getBean("applicationLogManager", ApplicationLogManager.class);
    }

    public PayexResponse getPayexMicroAccountBalance(User user) {
        PxClientHelper clientHelper;
        try {
            clientHelper = this.getClientHelper();
        }
        catch (ConfigurationException ce) {
            return new PayexResponse("Error_ConfigurationError", ce.getMessage());
        }
        ClientDetails details = this._accountLookup.getPayexAccount(user);
        if (details == null) {
            return new PayexResponse("Error_account", "Cannot determine PayEx account details for user: " + user.getUserName());
        }
        Long acctNo = this.getMerchantAccountNumber();
        if (acctNo == null) {
            return new PayexResponse("Error_ConfigurationError", "Merchant account number is not configured");
        }
        if (StringUtils.isNotBlank((String)details.getAgreementRef())) {
            PxAgreementHelper agreementHelper;
            try {
                agreementHelper = this.getAgreementHelper();
            }
            catch (ConfigurationException ce) {
                return new PayexResponse("Error_ConfigurationError", ce.getMessage());
            }
            logger.debug("Account Number : {} AgreementRef : {}", (Object)acctNo, (Object)details.getAgreementRef());
            PayexResponse checkResponse = agreementHelper.checkAgreement(acctNo, details.getAgreementRef());
            if (checkResponse.isErrorCodeOK()) {
                if (Integer.valueOf(checkResponse.getAgreementStatus()) != AGREEMENT_REF_VERIFIED) {
                    logger.debug("AgreementRef is NOT Verified.");
                    return new PayexResponse("Error_AccountLookupError", "PayEx account for user " + user.getUserName() + " does not have a verified Agreement.");
                }
                logger.debug("AgreementRef is Verified.");
            } else {
                logger.debug("AgreementRef provided is not Valid.");
                return new PayexResponse("Error_AccountLookupError", "AgreementRef provided is not Valid : " + details.getAgreementRef());
            }
        }
        return clientHelper.getClientInfo3(acctNo, this.getClientType(), details.getClientRef(), "", false);
    }

    public PayexResponse getWyWalletBalanceForUser(User user) {
        PxWyWalletHelper pxWyWalletHelper;
        try {
            pxWyWalletHelper = this.getPxWyWalletHelper();
        }
        catch (ConfigurationException ce) {
            return new PayexResponse("Error_ConfigurationError", ce.getMessage());
        }
        ClientDetails details = this._accountLookup.getPayexAccountForWyWallet(user);
        if (details == null) {
            return new PayexResponse("Error_MSISDN", "Cannot determine MSISDN details for user: " + user.getUserName());
        }
        String acquirerID = this.getAcquirerID();
        String agreementID = this.getAgreementID();
        PayexResponse getMSISDNInfoResponse = pxWyWalletHelper.getMSISDNInfo(acquirerID, agreementID, details.getClientRef(), 0);
        return Objects.requireNonNullElseGet(getMSISDNInfoResponse, () -> new PayexResponse("Error_NoResponse", "No response received from PayEx-WyWallet"));
    }

    public PayexResponse performDebitOnCreditCard(User user, double amount, String returnUrl) {
        PxOrderHelper orderHelper;
        PxOrderHelper.PaymentMethod pm = PxOrderHelper.PaymentMethod.CreditCard;
        DecimalFormat fmt = new DecimalFormat("0");
        String amountStr = fmt.format(amount * 100.0);
        Long acctNo = this.getMerchantAccountNumber();
        if (acctNo == null) {
            return new PayexResponse("Error_ConfigurationError", "Merchant account number is not configured");
        }
        try {
            orderHelper = this.getOrderHelper();
        }
        catch (ConfigurationException ce) {
            return new PayexResponse("Error_ConfigurationError", ce.getMessage());
        }
        String productNumber = "";
        String additionalInfo = "";
        productNumber = PayexPlugin.getProvider();
        String orderId = this.createNewOrder(user.getUserName(), amount);
        PayexResponse initResponse = orderHelper.initialize8(acctNo, pm.getPurchaseOperation(), NumberUtils.toInt((String)amountStr), "", this.getCurrency(), 0, orderId, productNumber, this.getManualTransferTransactionComment(), this._serverIpAddress, additionalInfo, returnUrl, pm.getView(), returnUrl, this.getClientLang());
        Object source = "PayEx Credit Card";
        if (this.isTestServer()) {
            source = (String)source + " Test Server";
        }
        if (initResponse.getOrderRef() != null) {
            EventLog.getInstance().logTransaction(user.getUserName(), initResponse.getOrderRef(), amount, (String)source);
        }
        if (!initResponse.isErrorCodeOK()) {
            logger.debug("PayEx initialize8 call returned: {} {}", (Object)initResponse.getErrorCode(), (Object)initResponse.getDescription());
            return initResponse;
        }
        return initResponse;
    }

    public PayexResponse complete(String orderRef) {
        Long acctNo = this.getMerchantAccountNumber();
        PayexResponse completeResponse = null;
        try {
            completeResponse = this.getOrderHelper().complete(acctNo, orderRef);
        }
        catch (ConfigurationException ce) {
            return new PayexResponse("Error_ConfigurationError", ce.getMessage());
        }
        String orderId = completeResponse.getOrderId();
        String transactionNumber = completeResponse.getTransactionNumber();
        String amount = completeResponse.getValue("amount");
        String description = completeResponse.getDescription();
        String errorCode = completeResponse.getErrorCode();
        Double paymentAmount = null;
        try {
            paymentAmount = Double.valueOf(amount);
            paymentAmount = paymentAmount / 100.0;
        }
        catch (Exception e) {
            String msg = "Invalid transaction amount. Transaction number: " + transactionNumber + ", order id: " + orderId;
            logger.error(msg);
            EventLog.getInstance().logEvent("ERROR: " + msg);
            this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
            this.getCreditCardGatewayPlugin().cancelOrder(orderId);
            return new PayexResponse("Error_InvalidResponse", msg);
        }
        String logSuffix = " Transaction number: " + transactionNumber + ", order id: " + orderId + ", payment amount: " + paymentAmount + ", error message: " + description + ".";
        String fullDetails = " Reported transaction details: " + completeResponse.getResponseDataToString();
        if (!completeResponse.isErrorCodeOK()) {
            String msg = "PayEx transaction response contains invalid payment response data. Detected error: \"" + errorCode + "-" + description + "\" Order will not be confirmed." + logSuffix;
            logger.error("{}{}", (Object)msg, (Object)fullDetails);
            EventLog.getInstance().logEvent("ERROR: " + msg + fullDetails);
            this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
            this.getCreditCardGatewayPlugin().cancelOrder(orderId);
            return new PayexResponse("Error_InvalidResponse", msg);
        }
        if (!completeResponse.getTransactionStatus().equals((Object)PayexResponse.TransactionStatus.Sale)) {
            String msg = "Order was canceled or declined by Payex: " + completeResponse.getTransactionErrorDescription() + logSuffix;
            logger.error("{}{}", (Object)msg, (Object)fullDetails);
            EventLog.getInstance().logEvent(msg);
            this.getCreditCardGatewayPlugin().cancelOrder(orderId);
            return new PayexResponse("Error_InvalidResponse", msg);
        }
        CreditCardGatewayPlugin.OrderResponse response = this.getCreditCardGatewayPlugin().confirmOrder(orderId, paymentAmount);
        if (!response.isSuccess()) {
            String msg = "Could not confirm Payex order. Message: " + response.getMessage() + ". Manual reconciliation may be required." + logSuffix;
            logger.error("{}{}", (Object)msg, (Object)fullDetails);
            EventLog.getInstance().logEvent("ERROR: " + msg + fullDetails);
            this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
            return new PayexResponse("Error_InvalidResponse", msg);
        }
        String msg = "Order confirmed." + logSuffix;
        logger.info(msg);
        EventLog.getInstance().logEvent(msg);
        return completeResponse;
    }

    public PayexResponse performOnDemandDebit(User user, double amount) {
        if (this.isWyWalletOnDemandTransferPresent()) {
            return this.performDebitOnWyWallet(user, amount);
        }
        return this.performDebitOnMicroAccount(user, amount);
    }

    public PayexResponse performDebitOnWyWallet(User user, double amount) {
        PxWyWalletHelper pxWyWalletHelper;
        ClientDetails details = null;
        String acquirerID = this.getAcquirerID();
        String userName = user.getUserName();
        if (acquirerID == null) {
            return new PayexResponse("Error_ConfigurationError", "Merchant AcquirerID  is not configured");
        }
        String agreementID = this.getAgreementID();
        if (agreementID == null) {
            return new PayexResponse("Error_ConfigurationError", "Merchant AgreementID  is not configured");
        }
        String sharedSecret = this.getSharedSecret();
        if (sharedSecret == null) {
            return new PayexResponse("Error_ConfigurationError", "Shared Secret is not configured");
        }
        try {
            pxWyWalletHelper = this.getPxWyWalletHelper();
        }
        catch (ConfigurationException ce) {
            return new PayexResponse("Error_ConfigurationError", ce.getMessage());
        }
        details = this._accountLookup.getPayexAccountForWyWallet(user);
        if (details == null) {
            logger.debug("No MSISDN number found for user {}", (Object)userName);
            return new PayexResponse("Error_NoDataError", "User MSISDN number is not present");
        }
        logger.debug("MSISDN number found for user: {}-{}", (Object)userName, (Object)details.getClientRef());
        PayexResponse initResponse = pxWyWalletHelper.getMSISDNInfo(acquirerID, agreementID, details.getClientRef(), 0);
        if (initResponse == null) {
            EventLog.getInstance().logEvent("Error : No response received from PayEx-WyWallet getMSISDNInfo method for user " + userName);
            return new PayexResponse("Error_NoResponse", "No response received from PayEx-WyWallet");
        }
        if (!initResponse.isErrorCodeOK()) {
            logger.debug("PayEx purchasePx call returned: {} {}", (Object)initResponse.getWyWalletTransactionStatus(), (Object)initResponse.getWyWalletTransactionStatusDesc());
            EventLog.getInstance().logEvent("Error : PayEx purchasePx call returned " + initResponse.getWyWalletTransactionStatus() + " " + initResponse.getWyWalletTransactionStatusDesc() + " for user " + userName + "amount " + amount);
            return initResponse;
        }
        PayexResponse purchaseResponse = null;
        String accountNumber = initResponse.getValue("PAN");
        if (accountNumber == null) {
            logger.debug("PayEx initResponse returned no PAN number");
            EventLog.getInstance().logEvent("Error : PayEx initResponse returned no PAN number for user " + userName + "amount " + amount);
            return new PayexResponse("Error_PayEx", "PayEx initResponse returned no PAN number");
        }
        purchaseResponse = pxWyWalletHelper.purchase3(acquirerID, agreementID, 0, PayexPlugin.currencyInLowestUnitRounded(amount), 0, this.getCurrency(), accountNumber, PayexPlugin.generateUniqueOrderId(), "0", this.getOnDemandTransferTransactionComment(), 0, 0);
        if (purchaseResponse == null) {
            EventLog.getInstance().logEvent("Error : No response received from PayEx-WyWallet purchase3 method for user : " + userName);
            return new PayexResponse("Error_NoResponse", "No response received from PayEx-WyWallet");
        }
        if (!purchaseResponse.isErrorCodeOK()) {
            logger.debug("PayEx purchasePx call returned: {} {}", (Object)initResponse.getWyWalletTransactionStatus(), (Object)initResponse.getWyWalletTransactionStatusDesc());
            EventLog.getInstance().logEvent("Error : PayEx purchase3 call returned " + initResponse.getWyWalletTransactionStatus() + " " + initResponse.getWyWalletTransactionStatusDesc() + " for user " + userName + "amount " + amount);
        } else {
            Object source = "PayEx WyWallet";
            if (this.isTestServer()) {
                source = (String)source + " Test Server";
            }
            EventLog.getInstance().logTransaction(user.getUserName(), purchaseResponse.getWyWalletTransactionID(), amount, (String)source);
        }
        return purchaseResponse;
    }

    public PayexResponse performDebitOnMicroAccount(User user, double amount) {
        PayexResponse purchaseResponse;
        ClientDetails details = this._accountLookup.getPayexAccount(user);
        if (details == null) {
            return new PayexResponse("Error_AccountLookupError", "Cannot determine PayEx account details for user " + user.getUserName());
        }
        int price = PayexPlugin.currencyInLowestUnitRounded(amount);
        Long acctNo = this.getMerchantAccountNumber();
        if (acctNo == null) {
            return new PayexResponse("Error_ConfigurationError", "Merchant account number is not configured");
        }
        if (details.getAgreementRef() == null) {
            PxOrderHelper orderHelper;
            try {
                orderHelper = this.getOrderHelper();
            }
            catch (ConfigurationException ce) {
                return new PayexResponse("Error_ConfigurationError", ce.getMessage());
            }
            PayexResponse initResponse = orderHelper.initialize8(acctNo, "SALE", price, "", this.getCurrency(), 0, PayexPlugin.generateUniqueOrderId(), PayexPlugin.getProvider(), this.getOnDemandTransferTransactionComment(), this._serverIpAddress, "", this.getReturnUrl(), "PX", "", this.getClientLang());
            if (!initResponse.isErrorCodeOK()) {
                logger.debug("PayEx initialize8 call returned: {} {}", (Object)initResponse.getErrorCode(), (Object)initResponse.getDescription());
                return initResponse;
            }
            String orderRef = initResponse.getOrderRef();
            purchaseResponse = orderHelper.purchasePx(acctNo, orderRef, this.getClientType(), details.getClientRef(), "");
        } else if (StringUtils.isNotBlank((String)details.getAgreementRef())) {
            PxAgreementHelper agreementHelper;
            try {
                agreementHelper = this.getAgreementHelper();
            }
            catch (ConfigurationException ce) {
                return new PayexResponse("Error_ConfigurationError", ce.getMessage());
            }
            purchaseResponse = agreementHelper.autoPay3(acctNo, details.getAgreementRef(), price, PayexPlugin.getProvider(), this.getOnDemandTransferTransactionComment(), PayexPlugin.generateUniqueOrderId(), "SALE", this.getCurrency());
        } else {
            return new PayexResponse("Error_AccountLookupError", "PayEx account for user " + user.getUserName() + " does not have a known AutoPay Agreement");
        }
        if (!purchaseResponse.isErrorCodeOK()) {
            logger.debug("PayEx purchasePx call returned: {} {}", (Object)purchaseResponse.getErrorCode(), (Object)purchaseResponse.getDescription());
        }
        if (purchaseResponse.getTransactionStatus() != PayexResponse.TransactionStatus.Sale) {
            return new PayexResponse("Error_BadStatus", "PayEx purchasePx call returned unexpected transaction status: " + String.valueOf((Object)purchaseResponse.getTransactionStatus()));
        }
        Object source = "PayEx";
        if (this.isTestServer()) {
            source = (String)source + " Test Server";
        }
        EventLog.getInstance().logTransaction(user.getUserName(), purchaseResponse.getTransactionNumber(), amount, (String)source);
        return purchaseResponse;
    }

    public static int currencyInLowestUnitRounded(double dollars) {
        double dollarsToRound = dollars - 1.0E-5;
        return (int)Math.ceil(dollarsToRound * 100.0);
    }

    private static String generateUniqueOrderId() {
        Date now = new Date();
        long timestamp = now.getTime();
        return timestamp + "." + _orderIdSuffix.getAndIncrement();
    }

    public String createNewOrder(String username, double amount) {
        return this.getCreditCardGatewayPlugin().createNewOrder(username, amount);
    }

    @Override
    public boolean isPluginEnabled() {
        return BooleanUtils.isTrue((Boolean)GatewayConfig.getInstance().getBoolean(CONFIG_ENABLED));
    }

    public static String getProvider() {
        try {
            String provider = GatewayConfig.getInstance().getString(CONFIG_PROVIDER);
            if (provider != null) {
                return provider;
            }
        }
        catch (Exception e) {
            logger.error("Invalid provider name.", (Throwable)e);
        }
        return DEFAULT_PAPERCUT_PROVIDER;
    }

    public boolean isBalanceDisplayEnabled() {
        return BooleanUtils.isTrue((Boolean)GatewayConfig.getInstance().getBoolean(CONFIG_BALANCE_DISPLAY_ENABLED));
    }

    public String getBalanceDisplayLabel() {
        return StringUtils.trimToEmpty((String)GatewayConfig.getInstance().getString(CONFIG_BALANCE_DISPLAY_LABEL));
    }

    public String getBalanceDisplayAvailableCreditLabel() {
        return StringUtils.trimToEmpty((String)GatewayConfig.getInstance().getString(CONFIG_BALANCE_DISPLAY_AVAILABLE_CREDIT_LABEL));
    }

    public boolean isTestServer() {
        return BooleanUtils.isTrue((Boolean)GatewayConfig.getInstance().getBoolean(CONFIG_SERVER_TESTSERVER));
    }

    public Long getMerchantAccountNumber() {
        try {
            return Long.valueOf(GatewayConfig.getInstance().getString(CONFIG_SERVER_ACCOUNT_NUMBER));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public String getEncryptionKey() {
        return StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_SERVER_ENCRYPTION_KEY));
    }

    @Nullable
    public String getAcquirerID() {
        return StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_SERVER_ACQUIRERID));
    }

    @Nullable
    public String getAgreementID() {
        return StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_SERVER_AGREEMENTID));
    }

    @Nullable
    public String getSharedSecret() {
        return StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_SERVER_SHAREDSECRET));
    }

    public int getClientType() {
        String typestr = StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_SERVER_CLIENT_TYPE));
        return typestr == null ? 0 : 1 + ArrayUtils.indexOf((Object[])PxClientHelper.ClientTypeStrings, (Object)typestr);
    }

    public String getClientLang() {
        String lang = StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_SERVER_CLIENT_LANG));
        if (lang == null || ArrayUtils.indexOf((Object[])PxOrderHelper.Languages, (Object)lang) < 0) {
            lang = "en-US";
        }
        return lang;
    }

    public String getReturnUrl() {
        return StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_SERVER_RETURN_URL));
    }

    private int getMaxConnectionAttempts() {
        Integer maxAttempts = GatewayConfig.getInstance().getInteger(CONFIG_SERVER_MAX_ATTEMPTS);
        if (maxAttempts == null) {
            return 3;
        }
        return maxAttempts;
    }

    private int getRetryWaitMs() {
        Integer retryWaitMs = GatewayConfig.getInstance().getInteger(CONFIG_SERVER_RETRY_WAIT_MS);
        if (retryWaitMs == null) {
            return 60000;
        }
        return retryWaitMs;
    }

    public String getCurrency() {
        return StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_CURRENCY));
    }

    public boolean isOnDemandTransferEnabled() {
        return BooleanUtils.isTrue((Boolean)GatewayConfig.getInstance().getBoolean(CONFIG_ON_DEMAND_TRANSFER_ENABLED));
    }

    @Nullable
    public Double getOnDemandTransferMinTransferAmount() {
        Double amount = null;
        try {
            amount = GatewayConfig.getInstance().getDouble(CONFIG_ON_DEMAND_TRANSFER_MIN_TRANSFER_AMOUNT);
        }
        catch (Exception e) {
            logger.error("Invalid on-demand transfer default transfer amount.", (Throwable)e);
        }
        return amount;
    }

    @Nullable
    public Double getOnDemandTransferMaxTransferAmount() {
        Double amount = null;
        try {
            amount = GatewayConfig.getInstance().getDouble(CONFIG_ON_DEMAND_TRANSFER_MAX_TRANSFER_AMOUNT);
        }
        catch (Exception e) {
            logger.error("Invalid on-demand transfer max transfer amount.", (Throwable)e);
        }
        return amount;
    }

    public String getOnDemandTransferTransactionComment() {
        Object txnComment = StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT));
        if (txnComment == null) {
            txnComment = DEFAULT_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT;
        }
        if (this.isTestServer()) {
            txnComment = (String)txnComment + " (Warning: Transaction is with PayEx Test Server)";
        } else if (!this.isLicensed()) {
            txnComment = (String)txnComment + " (" + GatewayUtils.getNotLicensedUserMessage() + ")";
        }
        return txnComment;
    }

    public boolean isOnDemandTransferEnabledForUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        if (!this.isOnDemandTransferEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, CONFIG_ON_DEMAND_TRANSFER_ENABLED_GROUPS, this.getUserManager());
    }

    public boolean isManualTransferEnabled() {
        return BooleanUtils.isTrue((Boolean)GatewayConfig.getInstance().getBoolean(CONFIG_MANUAL_TRANSFER_ENABLED));
    }

    @CheckForNull
    public String getManualTransferPageTitle() {
        return GatewayConfig.getInstance().getString(CONFIG_MANUAL_TRANSFER_PAGE_TITLE);
    }

    public String getManualTransferPageHeading() {
        return StringUtils.trimToEmpty((String)GatewayConfig.getInstance().getString(CONFIG_MANUAL_TRANSFER_PAGE_HEADING));
    }

    public String getManualTransferTransactionComment() {
        Object txnComment = StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_MANUAL_TRANSFER_TRANSACTION_COMMENT));
        if (txnComment == null) {
            txnComment = DEFAULT_MANUAL_TRANSFER_TRANSACTION_COMMENT;
        }
        if (this.isTestServer()) {
            txnComment = (String)txnComment + " (Warning: Transaction is with PayEx Test Server)";
        }
        if (!this.isLicensed()) {
            txnComment = (String)txnComment + " (" + GatewayUtils.getNotLicensedUserMessage() + ")";
        }
        return txnComment;
    }

    public List<Double> getManualTransferAllowedAmounts() {
        return GatewayConfig.getInstance().getDoubleList(CONFIG_MANUAL_TRANSFER_ALLOWED_AMOUNTS);
    }

    public boolean isManualTransferAccessibleByUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, CONFIG_MANUAL_TRANSFER_ALLOWED_GROUPS, this.getUserManager());
    }

    public String getManualTransferUserErrorMessage() {
        String userError = StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_MANUAL_TRANSFER_USER_ERROR_MESSAGE));
        if (userError == null) {
            userError = "An error has occurred, please try again. If you continue to receive this error please contact a network administrator for assistance.";
        }
        return userError;
    }

    public boolean isWyWalletOnDemandTransferPresent() {
        String paymentMethod = StringUtils.trimToEmpty((String)GatewayConfig.getInstance().getString(CONFIG_ON_DEMAND_PAYMENT_METHOD));
        return paymentMethod.equalsIgnoreCase(WYWALLET_PAYMENT_METHOD);
    }

    private void preparePayexConnection() throws ConfigurationException {
        String configError = this.getIsConfigured();
        if (configError != null) {
            logger.error(configError);
            throw new ConfigurationException(configError);
        }
        PayexSoapDriver.PayexEnvironment env = this.isTestServer() ? PayexSoapDriver.PayexEnvironment.Test : PayexSoapDriver.PayexEnvironment.Production;
        PayexSoapDriver driver = new PayexSoapDriver(this.getEncryptionKey(), env);
        int sleepMs = this.getRetryWaitMs();
        int maxTries = this.getMaxConnectionAttempts();
        this._pxClientHelper = new PxClientHelper(driver, sleepMs, maxTries);
        this._pxOrderHelper = new PxOrderHelper(driver, sleepMs, maxTries);
        this._pxAgreementHelper = new PxAgreementHelper(driver, sleepMs, maxTries);
        this._pxWyWalletHelper = new PxWyWalletHelper(driver, sleepMs, maxTries, this.getSharedSecret());
    }

    private PxClientHelper getClientHelper() throws ConfigurationException {
        if (this._pxClientHelper == null || this.isTestServer()) {
            this.preparePayexConnection();
        }
        return this._pxClientHelper;
    }

    private PxWyWalletHelper getPxWyWalletHelper() throws ConfigurationException {
        if (this._pxWyWalletHelper == null || this.isTestServer()) {
            this.preparePayexConnection();
        }
        return this._pxWyWalletHelper;
    }

    private PxOrderHelper getOrderHelper() throws ConfigurationException {
        if (this._pxOrderHelper == null || this.isTestServer()) {
            this.preparePayexConnection();
        }
        return this._pxOrderHelper;
    }

    private PxAgreementHelper getAgreementHelper() throws ConfigurationException {
        if (this._pxAgreementHelper == null || this.isTestServer()) {
            this.preparePayexConnection();
        }
        return this._pxAgreementHelper;
    }

    static {
        _orderIdSuffix = new AtomicInteger(1);
    }
}

