/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.payex;

import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class PayexResponse {
    private final Map<String, String> _responseMap;

    public PayexResponse(Map<String, String> responseMap) {
        this._responseMap = responseMap;
    }

    public PayexResponse(String errorCode, String errorDescription) {
        this._responseMap = new HashMap<String, String>();
        this._responseMap.put("errorCode", errorCode);
        this._responseMap.put("description", errorDescription);
    }

    public String getValue(String key) {
        return this._responseMap != null ? this._responseMap.get(key) : null;
    }

    public String getErrorCode() {
        return this.getValue("errorCode");
    }

    public boolean isErrorCodeOK() {
        if (this.getErrorCode() != null) {
            return "OK".equals(this.getErrorCode());
        }
        return this.getWyWalletTransactionStatusDesc() != null && this.getWyWalletTransactionStatusDesc().equals("OK");
    }

    public String getDescription() {
        return this.getValue("description");
    }

    public String getAgreementStatus() {
        return this.getValue("agreementStatus");
    }

    @Nullable
    public Double getBalanceMerchantCurrency() {
        Double balance;
        String doubleStr = "";
        if (this._responseMap.containsKey("balanceMerchantCurrency")) {
            doubleStr = this.getValue("balanceMerchantCurrency");
        } else if (this._responseMap.containsKey("amount")) {
            doubleStr = this.getValue("amount");
        }
        try {
            balance = GatewayUtils.parseDoubleExtended(doubleStr);
            balance = Math.floor(balance) / 100.0;
        }
        catch (NumberFormatException nfe) {
            balance = null;
        }
        return balance;
    }

    @Nullable
    public Double getAgreementMaxAmount() {
        Double amount = null;
        if (this._responseMap.containsKey("maxAmount")) {
            String doubleStr = this.getValue("maxAmount");
            try {
                amount = GatewayUtils.parseDoubleExtended(doubleStr);
                amount = Math.floor(amount) / 100.0;
            }
            catch (NumberFormatException nfe) {
                amount = null;
            }
        }
        return amount;
    }

    @Nullable
    public String getMerchantCurrency() {
        return StringUtils.trimToNull((String)this.getValue("currencyMerchant"));
    }

    @Nullable
    public String getOrderRef() {
        return StringUtils.trimToNull((String)this.getValue("orderRef"));
    }

    public String getDynamicReturnUrl() {
        return StringUtils.trimToEmpty((String)this.getValue("redirectUrl"));
    }

    public TransactionStatus getTransactionStatus() {
        try {
            int statusix = Integer.parseInt(this.getValue("transactionStatus"));
            return TransactionStatus.values()[statusix];
        }
        catch (Exception e) {
            return TransactionStatus.Unknown;
        }
    }

    public String getWyWalletTransactionStatusDesc() {
        return StringUtils.trimToEmpty((String)this.getValue("transactionStatusDesc"));
    }

    public String getWyWalletTransactionStatus() {
        return StringUtils.trimToEmpty((String)this.getValue("transactionStatus"));
    }

    public String getWyWalletTransactionID() {
        return StringUtils.trimToEmpty((String)this.getValue("transactionID"));
    }

    @Nullable
    public String getTransactionNumber() {
        return StringUtils.trimToNull((String)this.getValue("transactionNumber"));
    }

    public String getTransactionErrorDescription() {
        return StringUtils.trimToEmpty((String)this.getValue("transactionErrorDescription"));
    }

    public String getOrderId() {
        return StringUtils.trimToEmpty((String)this.getValue("orderId"));
    }

    public Map<String, String> getResponseData() {
        return this._responseMap;
    }

    public String getResponseDataToString() {
        StringBuilder sb = new StringBuilder();
        this._responseMap.forEach((key, value) -> sb.append("Key : ").append((String)key).append(" Value : ").append((String)value));
        return sb.toString();
    }

    public static enum TransactionStatus {
        Sale,
        Initialize,
        Credit,
        Authorize,
        Cancel,
        Failure,
        Capture,
        Unknown;

    }
}

