/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.payex;

import biz.papercut.pcng.ext.paymentgateway.util.SOAPLogMessageHandler;
import com.payex.external.pxagreement.PxAgreement;
import com.payex.external.pxagreement.PxAgreementSoap;
import com.payex.external.pxclient.PxClient;
import com.payex.external.pxclient.PxClientSoap;
import com.payex.external.pxorder.PxOrder;
import com.payex.external.pxorder.PxOrderSoap;
import com.payex.map.PaymentService;
import jakarta.xml.ws.Service;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class PayexSoapDriver {
    public static final String ERROR_CODE = "errorCode";
    public static final String ERROR_CODE_OK = "OK";
    public static final String ERROR_DESC = "description";
    private static final Logger logger = LoggerFactory.getLogger(PayexSoapDriver.class);
    private static final Service clientServiceTest;
    private static final Service clientServiceProduction;
    private static final Service orderServiceTest;
    private static final Service orderServiceProduction;
    private static final Service agreementServiceTest;
    private static final Service agreementServiceProduction;
    private static final Service wyWalletServiceTest;
    private static final Service wyWalletServiceProduction;
    private final String _encryptionKey;
    private final PayexEnvironment _env;

    private static Service addLogger(Service svc) {
        return SOAPLogMessageHandler.attachPayloadLogger(svc, Service.class);
    }

    public PayexSoapDriver(String encryptionKey, PayexEnvironment environment) {
        this._encryptionKey = encryptionKey;
        this._env = environment;
    }

    public PxClientSoap getPxClient() {
        return this._env == PayexEnvironment.Test ? (PxClientSoap)clientServiceTest.getPort(PxClientSoap.class) : (PxClientSoap)clientServiceProduction.getPort(PxClientSoap.class);
    }

    public PxOrderSoap getPxOrder() {
        return this._env == PayexEnvironment.Test ? (PxOrderSoap)orderServiceTest.getPort(PxOrderSoap.class) : (PxOrderSoap)orderServiceProduction.getPort(PxOrderSoap.class);
    }

    public PxAgreementSoap getPxAgreement() {
        return this._env == PayexEnvironment.Test ? (PxAgreementSoap)agreementServiceTest.getPort(PxAgreementSoap.class) : (PxAgreementSoap)agreementServiceProduction.getPort(PxAgreementSoap.class);
    }

    public PaymentService getPxWyWallet() {
        return this._env == PayexEnvironment.Test ? (PaymentService)wyWalletServiceTest.getPort(PaymentService.class) : (PaymentService)wyWalletServiceProduction.getPort(PaymentService.class);
    }

    public String getHash(String data) {
        StringBuilder sb = new StringBuilder();
        try {
            byte[] result;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(data.getBytes());
            for (byte b : result = md5.digest(this._encryptionKey.getBytes())) {
                String s = Integer.toHexString(b);
                int length = s.length();
                if (length >= 2) {
                    sb.append(s, length - 2, length);
                    continue;
                }
                sb.append("0");
                sb.append(s);
            }
            md5.reset();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Failed to crate md5 hash for payex param data", (Throwable)e);
        }
        return sb.toString();
    }

    public Map<String, String> parseResponse(String response) {
        final HashMap<String, String> resultmap = new HashMap<String, String>();
        if (response == null) {
            resultmap.put(ERROR_CODE, "Error_NoResponse");
            resultmap.put(ERROR_DESC, "No response received from Payex");
            return resultmap;
        }
        DefaultHandler handler = new DefaultHandler(this){
            String _currentElem = null;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                this._currentElem = qName;
            }

            @Override
            public void endElement(String uri, String localName, String qName) {
                this._currentElem = null;
            }

            @Override
            public void characters(char[] ch, int start, int length) {
                if (this._currentElem != null) {
                    resultmap.put(this._currentElem, new String(ch, start, length));
                }
            }
        };
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setContentHandler(handler);
            ByteArrayInputStream strm = new ByteArrayInputStream(response.getBytes());
            xr.parse(new InputSource(strm));
        }
        catch (IOException e) {
            logger.error("IOException on parsing Payex response: {}, error: {}", (Object)response, (Object)e.getMessage());
        }
        catch (SAXException e) {
            logger.error("SAXException on parsing Payex response: {}, error: {}", (Object)response, (Object)e.getMessage());
        }
        if (!resultmap.containsKey(ERROR_CODE)) {
            resultmap.put(ERROR_CODE, "Error_EmptyResponse");
            resultmap.put(ERROR_DESC, "Empty response received from Payex");
        }
        return resultmap;
    }

    static {
        URL clientWsdlURL = PxClient.class.getResource("pxclient.wsdl");
        clientServiceTest = PayexSoapDriver.addLogger(Service.create((URL)clientWsdlURL, (QName)new QName("http://external.payex.com/PxClient/", "PxClientTest")));
        clientServiceProduction = PayexSoapDriver.addLogger(Service.create((URL)clientWsdlURL, (QName)new QName("http://external.payex.com/PxClient/", "PxClient")));
        URL orderWsdlURL = PxOrder.class.getResource("pxorder.wsdl");
        orderServiceTest = PayexSoapDriver.addLogger(Service.create((URL)orderWsdlURL, (QName)new QName("http://external.payex.com/PxOrder/", "PxOrderTest")));
        orderServiceProduction = PayexSoapDriver.addLogger(Service.create((URL)orderWsdlURL, (QName)new QName("http://external.payex.com/PxOrder/", "PxOrder")));
        URL agreementWsdlURL = PxAgreement.class.getResource("pxagreement.wsdl");
        agreementServiceTest = PayexSoapDriver.addLogger(Service.create((URL)agreementWsdlURL, (QName)new QName("http://external.payex.com/PxAgreement/", "PxAgreementTest")));
        agreementServiceProduction = PayexSoapDriver.addLogger(Service.create((URL)agreementWsdlURL, (QName)new QName("http://external.payex.com/PxAgreement/", "PxAgreement")));
        URL wyWalletWsdlURL = PaymentService.class.getResource("PaymentService.wsdl");
        wyWalletServiceTest = PayexSoapDriver.addLogger(Service.create((URL)wyWalletWsdlURL, (QName)new QName("http://map.payex.com/", "PaymentServiceTest")));
        wyWalletServiceProduction = PayexSoapDriver.addLogger(Service.create((URL)wyWalletWsdlURL, (QName)new QName("http://map.payex.com/", "PaymentServiceProd")));
    }

    public static enum PayexEnvironment {
        Test,
        Production;

    }
}

