/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.payex;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexPlugin;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin3;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin4;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayexTopupAccountOnDemandPlugin
implements TopupAccountOnDemandPlugin4 {
    private static final Logger logger = LoggerFactory.getLogger(PayexTopupAccountOnDemandPlugin.class);

    public Map<String, Double> getBalance(Map<String, String> userDetails) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        PayexPlugin pp = PayexTopupAccountOnDemandPlugin.getPayexPlugin();
        if (!pp.isBalanceDisplayEnabled()) {
            logger.debug("PayEx balance display disabled.");
            return null;
        }
        String username = userDetails.get("username");
        User user = pp.getUserManager().getUser(username);
        if (user == null) {
            logger.error("Unknown user: {}", (Object)username);
            return null;
        }
        PayexResponse resp = null;
        resp = pp.isWyWalletOnDemandTransferPresent() ? pp.getWyWalletBalanceForUser(user) : pp.getPayexMicroAccountBalance(user);
        if (!resp.isErrorCodeOK()) {
            String errormsg = "Unable to retrieve PayEx balance for user \"" + username + "\": " + resp.getDescription();
            GatewayUtils.LogHelper.logError(logger, errormsg, null, null);
            return null;
        }
        HashMap<String, Double> balances = new HashMap<String, Double>();
        balances.put(pp.getBalanceDisplayLabel(), resp.getBalanceMerchantCurrency());
        return balances;
    }

    @Nullable
    @CheckForNull
    public TopupAccountOnDemandPlugin3.AvailableCredit getAvailableCreditForTopUp(String username, @Nullable String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            return null;
        }
        PayexPlugin pp = PayexTopupAccountOnDemandPlugin.getPayexPlugin();
        if (!pp.isOnDemandTransferEnabledForUser(username)) {
            logger.debug("PayEx top-up on demand plugin not enabled for user '{}'.", (Object)username);
            return null;
        }
        User user = pp.getUserManager().getUser(username);
        if (user == null) {
            logger.error("Unknown user: {}", (Object)username);
            return null;
        }
        PayexResponse resp = null;
        resp = pp.isWyWalletOnDemandTransferPresent() ? pp.getWyWalletBalanceForUser(user) : pp.getPayexMicroAccountBalance(user);
        if (!resp.isErrorCodeOK()) {
            String errormsg = "Unable to retrieve PayEx available credit (balance) for user \"" + username + "\": " + resp.getDescription();
            GatewayUtils.LogHelper.logError(logger, errormsg, null, null);
            return null;
        }
        Double balance = resp.getBalanceMerchantCurrency();
        Double maxAmount = resp.getAgreementMaxAmount();
        Double availableCredit = balance;
        if (maxAmount != null && balance != null) {
            logger.debug("User {} has balance: {} limited to agreement max of: {}", new Object[]{username, balance, maxAmount});
            availableCredit = Math.min(balance, maxAmount);
        } else if (balance != null) {
            logger.debug("User {} has balance: {} with no maxAmount limit", (Object)username, (Object)balance);
        } else {
            logger.debug("User {} balance could not be retrieved. Using maxAmount: {}", (Object)username, (Object)maxAmount);
        }
        return new TopupAccountOnDemandPlugin3.AvailableCredit(false, availableCredit.doubleValue());
    }

    public TopupAccountOnDemandPlugin.TopupResponse getTopup(double amountRequired, String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged, Map<String, String> usageDetails) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            logger.debug("PayEx top-up on demand plugin is not enabled for shared accounts.");
            return null;
        }
        double topupAmount = this.calcTopUpAmount(amountRequired);
        if (topupAmount <= 0.0) {
            return null;
        }
        PayexPlugin pp = PayexTopupAccountOnDemandPlugin.getPayexPlugin();
        User user = pp.getUserManager().getUser(username);
        if (user == null) {
            logger.debug("Unknown user: {}", (Object)username);
            return null;
        }
        if (!pp.isOnDemandTransferEnabledForUser(username)) {
            logger.debug("PayEx top-up on demand plugin not enabled for user '{}'.", (Object)username);
            return null;
        }
        String txnComment = pp.getOnDemandTransferTransactionComment();
        return GatewayUtils.performTopupDebit((TopupAccountOnDemandPlugin3)this, amount -> {
            PayexResponse resp = pp.performOnDemandDebit(user, amount);
            logger.debug("Result: {}", (Object)resp.getErrorCode());
            Double result = null;
            if (resp.isErrorCodeOK()) {
                if (pp.isWyWalletOnDemandTransferPresent() && resp.getWyWalletTransactionStatusDesc().equals("OK")) {
                    result = amount;
                } else if (resp.getTransactionStatus() == PayexResponse.TransactionStatus.Sale) {
                    result = amount;
                }
            }
            return result;
        }, topupAmount, amountRequired, username, sharedAccount, accountCharged, usageDetails, txnComment);
    }

    public boolean isPluginEnabled() {
        PayexPlugin pp = PayexTopupAccountOnDemandPlugin.getPayexPlugin();
        return pp.isPluginEnabled() && pp.isOnDemandTransferEnabled();
    }

    private double calcTopUpAmount(double amountRequired) {
        if (amountRequired <= 0.0) {
            return 0.0;
        }
        PayexPlugin cp = PayexTopupAccountOnDemandPlugin.getPayexPlugin();
        Double minAmount = cp.getOnDemandTransferMinTransferAmount();
        Double maxAmount = cp.getOnDemandTransferMaxTransferAmount();
        if (minAmount == null || maxAmount == null) {
            return 0.0;
        }
        int cents = PayexPlugin.currencyInLowestUnitRounded(amountRequired);
        double topupAmount = (double)cents / 100.0;
        if (minAmount > 0.0 && maxAmount > 0.0 && minAmount > maxAmount) {
            logger.warn("PayEx min transfer amount is greater than the max transfer amount.  Using min transfer amount as max amount.");
            maxAmount = minAmount;
        }
        if (minAmount > 0.0 && amountRequired < minAmount) {
            logger.debug("Using minimum transfer amount of {}", (Object)minAmount);
            topupAmount = minAmount;
        }
        if (maxAmount > 0.0 && topupAmount > maxAmount) {
            logger.debug("Transfer amount of {} exceeds maximum of {}", (Object)topupAmount, (Object)maxAmount);
            topupAmount = 0.0;
        }
        return topupAmount;
    }

    private static PayexPlugin getPayexPlugin() {
        return (PayexPlugin)PluginManager.getInstance().getPluginByClass(PayexPlugin.class);
    }
}

