/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.payex;

import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexResponse;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexSoapDriver;
import com.payex.external.pxagreement.PxAgreementSoap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PxAgreementHelper {
    private static final Logger logger = LoggerFactory.getLogger(PxAgreementHelper.class);
    private final PayexSoapDriver _driver;
    private final PxAgreementSoap _pxSoap;
    private final int _sleepMs;
    private final int _maxTries;

    public PxAgreementHelper(PayexSoapDriver driver, int sleepMs, int maxTries) {
        this._driver = driver;
        this._pxSoap = this._driver.getPxAgreement();
        this._sleepMs = sleepMs;
        this._maxTries = maxTries;
    }

    public PayexResponse autoPay3(long accountNumber, String agreementRef, int price, String productNumber, String description, String orderId, String purchaseOp, String currency) {
        String hashInput = accountNumber + agreementRef + price + productNumber + description + orderId + purchaseOp + currency;
        String hash = this._driver.getHash(hashInput);
        String response = null;
        for (int attempt = 1; attempt <= this._maxTries; ++attempt) {
            try {
                if (attempt != 1) {
                    Thread.sleep(this._sleepMs);
                }
                response = this._pxSoap.autoPay3(accountNumber, agreementRef, price, productNumber, description, orderId, purchaseOp, currency, hash);
                break;
            }
            catch (Exception ex) {
                logger.error("Attempt {}: exception in PxAgreement.autoPay3: ", (Object)attempt, (Object)ex);
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): unable to invoke PxAgreement.autoPay3: " + ex.getMessage());
                continue;
            }
        }
        return new PayexResponse(this._driver.parseResponse(response));
    }

    public PayexResponse checkAgreement(long accountNumber, String agreementRef) {
        String hashInput = accountNumber + agreementRef;
        String hash = this._driver.getHash(hashInput);
        String response = null;
        for (int attempt = 1; attempt <= this._maxTries; ++attempt) {
            try {
                if (attempt != 1) {
                    Thread.sleep(this._sleepMs);
                }
                response = this._pxSoap.check(accountNumber, agreementRef, hash);
                break;
            }
            catch (Exception ex) {
                logger.error("Attempt {}: exception in PxAgreement.checkAgreement: ", (Object)attempt, (Object)ex);
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): unable to invoke PxAgreement.checkAgreement: " + ex.getMessage());
                continue;
            }
        }
        return new PayexResponse(this._driver.parseResponse(response));
    }
}

