/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.payex;

import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexResponse;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexSoapDriver;
import com.payex.external.pxclient.PxClientSoap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PxClientHelper {
    public static final String[] ClientTypeStrings = new String[]{"ACCOUNT_NUMBER", "EMAIL", "GSM"};
    private static final Logger logger = LoggerFactory.getLogger(PxClientHelper.class);
    private final PayexSoapDriver _driver;
    private final PxClientSoap _pxSoap;
    private final int _sleepMs;
    private final int _maxTries;

    public PxClientHelper(PayexSoapDriver driver, int sleepMs, int maxTries) {
        this._driver = driver;
        this._pxSoap = this._driver.getPxClient();
        this._sleepMs = sleepMs;
        this._maxTries = maxTries;
    }

    public PayexResponse getClientInfo3(long accountNumber, int clientType, String clientRef, String password, boolean validate) {
        String hashInput = Long.toString(accountNumber) + clientType + clientRef + password + (validate ? "1" : "0");
        String hash = this._driver.getHash(hashInput);
        String response = null;
        for (int attempt = 1; attempt <= this._maxTries; ++attempt) {
            try {
                if (attempt != 1) {
                    this.wait(this._sleepMs);
                }
                response = this._pxSoap.getClientInfo3(accountNumber, clientType, clientRef, password, validate, hash);
                logger.debug("Response from getClientInfo3: {}", (Object)response);
                break;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return null;
            }
            catch (Exception ex) {
                logger.error("Attempt {}: exception calling PxClient.getClientInfo3: ", (Object)attempt, (Object)ex);
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): error invoking PxClient.getClientInfo3: " + ex.getMessage());
                continue;
            }
        }
        return new PayexResponse(this._driver.parseResponse(response));
    }

    public PayexResponse generateTemporaryPassword(long accountNumber, int clientType, String clientRef) {
        String hashInput = Long.toString(accountNumber) + clientType + clientRef;
        String hash = this._driver.getHash(hashInput);
        String response = null;
        for (int attempt = 1; attempt <= this._maxTries; ++attempt) {
            try {
                if (attempt != 1) {
                    Thread.sleep(this._sleepMs);
                }
                response = this._pxSoap.generateTemporaryPassword(accountNumber, clientType, clientRef, hash);
                break;
            }
            catch (Exception ex) {
                logger.error("Attempt {}: exception in PxClient.generateTemporaryPassword: ", (Object)attempt, (Object)ex);
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): unable to invoke PxClient.generateTemporaryPassword: " + ex.getMessage());
                continue;
            }
        }
        return new PayexResponse(this._driver.parseResponse(response));
    }
}

