/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.payex;

import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexResponse;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexSoapDriver;
import com.payex.external.pxorder.PxOrderSoap;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PxOrderHelper {
    public static final String[] Currencies = new String[]{"SEK", "DKK", "NOK", "EUR"};
    public static final String[] Views = new String[]{"PX", "CREDITCARD", "DIRECTDEBIT", "CPA", "IVR", "EVC", "INVOICE", "LOAN", "GC", "CA", "PAYPAL", "FINANCING"};
    public static final String[] Languages = new String[]{"nb-NO", "da-DK", "en-US", "sv-SE", "es-ES", "de-DE", "fi-FI", "fr-FR", "pl-PL", "cs-CZ", "hu-HU", "it-IT", "pt-BR", "sk-SK", "nl-NL"};
    private static final Logger logger = LoggerFactory.getLogger(PxOrderHelper.class);
    private static final String _agreementRef = "";
    private final PayexSoapDriver _driver;
    private final PxOrderSoap _pxSoap;
    private final int _sleepMs;
    private final int _maxTries;

    public PxOrderHelper(PayexSoapDriver driver, int sleepMs, int maxTries) {
        this._driver = driver;
        this._pxSoap = this._driver.getPxOrder();
        this._sleepMs = sleepMs;
        this._maxTries = maxTries;
    }

    public PayexResponse initialize8(long accountNumber, String purchaseOperation, int price, String priceArgList, String currency, int vat, String orderID, String productNumber, String description, String clientIPAddress, String additionalValues, String returnURL, String view, String cancelURL, String clientLang) {
        String externalID = _agreementRef;
        String clientID = _agreementRef;
        String hashInput = accountNumber + purchaseOperation + price + priceArgList + currency + vat + orderID + productNumber + description + clientIPAddress + clientID + additionalValues + externalID + returnURL + view + cancelURL + clientLang;
        String hash = this._driver.getHash(hashInput);
        String response = null;
        for (int attempt = 1; attempt <= this._maxTries; ++attempt) {
            try {
                if (attempt != 1) {
                    Thread.sleep(this._sleepMs);
                }
                response = this._pxSoap.initialize8(accountNumber, purchaseOperation, (long)price, priceArgList, currency, vat, orderID, productNumber, description, clientIPAddress, clientID, additionalValues, externalID, returnURL, view, _agreementRef, cancelURL, clientLang, hash);
                break;
            }
            catch (Exception ex) {
                logger.error("Attempt {}: exception in PxOrder.initialize8: ", (Object)attempt, (Object)ex);
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): unable to invoke PxOrder.Initialize8: " + ex.getMessage());
                continue;
            }
        }
        return new PayexResponse(this._driver.parseResponse(response));
    }

    public PayexResponse purchasePx(long accountNumber, String orderRef, int userType, String userRef, String password) {
        String hashInput = accountNumber + orderRef + userType + userRef + password;
        String hash = this._driver.getHash(hashInput);
        String response = null;
        for (int attempt = 1; attempt <= this._maxTries; ++attempt) {
            try {
                if (attempt != 1) {
                    Thread.sleep(this._sleepMs);
                }
                response = this._pxSoap.purchasePX(accountNumber, orderRef, userType, userRef, password, hash);
                break;
            }
            catch (Exception ex) {
                logger.error("Attempt {}: exception in PxOrder.purchasePx: ", (Object)attempt, (Object)ex);
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): unable to invoke PxOrder.purchasePx: " + ex.getMessage());
                continue;
            }
        }
        return new PayexResponse(this._driver.parseResponse(response));
    }

    public PayexResponse complete(long accountNumber, String orderRef) {
        String hashInput = accountNumber + orderRef;
        String hash = this._driver.getHash(hashInput);
        String response = null;
        for (int attempt = 1; attempt <= this._maxTries; ++attempt) {
            try {
                if (attempt != 1) {
                    Thread.sleep(this._sleepMs);
                }
                response = this._pxSoap.complete(accountNumber, orderRef, hash);
                break;
            }
            catch (InterruptedException ie) {
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): Interrupt exception in PxOrder.complete: " + ie.getMessage());
                logger.error("Attempt {}: Interrupt exception in PxOrder.complete: ", (Object)attempt, (Object)ie);
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Exception ex) {
                logger.error("Attempt {}: exception in PxOrder.complete: ", (Object)attempt, (Object)ex);
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): unable to invoke PxOrder.complete: " + ex.getMessage());
            }
        }
        return new PayexResponse(this._driver.parseResponse(response));
    }

    public PayexResponse purchasePremiumSms(long accountNumber, String msisdn, String orderRef, String message) {
        String hashInput = accountNumber + orderRef + msisdn + message;
        String hash = this._driver.getHash(hashInput);
        String response = null;
        for (int attempt = 1; attempt <= this._maxTries; ++attempt) {
            try {
                if (attempt != 1) {
                    Thread.sleep(this._sleepMs);
                }
                response = this._pxSoap.purchasePremiumSms(accountNumber, orderRef, msisdn, message, hash);
                break;
            }
            catch (InterruptedException ie) {
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): Interrupt exception in PxOrder.purchasePremiumSms: " + ie.getMessage());
                logger.error("Attempt {}: Interrupt exception in PxOrder.purchasePremiumSms: ", (Object)attempt, (Object)ie);
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Exception ex) {
                logger.error("Attempt {}: exception in PxOrder.purchasePremiumSms: ", (Object)attempt, (Object)ex);
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): unable to invoke PxOrder.purchasePremiumSms: " + ex.getMessage());
            }
        }
        return new PayexResponse(this._driver.parseResponse(response));
    }

    public static enum PaymentMethod {
        WyWallet("SALE", "PREMIUMSMS", "WyWallet"),
        CreditCard("SALE", "CREDITCARD", "Credit Card"),
        MicroAccount("SALE", "PX", "Micro Account");

        private final String purchaseOperation;
        private final String view;
        private final String propertyValue;

        private PaymentMethod(String purchaseOperation, String view, String propertyValue) {
            this.purchaseOperation = purchaseOperation;
            this.view = view;
            this.propertyValue = propertyValue;
        }

        public String getPurchaseOperation() {
            return this.purchaseOperation;
        }

        public String getView() {
            return this.view;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public static List<String> getPropertyValues() {
            return Arrays.stream(PaymentMethod.values()).map(pm -> pm.propertyValue).collect(Collectors.toList());
        }

        public static PaymentMethod getEnum(String propertyValue) {
            return Arrays.stream(PaymentMethod.values()).filter(e -> e.propertyValue.equalsIgnoreCase(propertyValue)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Unsupported type %s.", propertyValue)));
        }
    }
}

