/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.payex;

import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexResponse;
import biz.papercut.pcng.ext.paymentgateway.payex.PayexSoapDriver;
import com.payex.map.AccountInfo2;
import com.payex.map.Footer;
import com.payex.map.GetMSISDNInfoRequest;
import com.payex.map.GetMSISDNInfoRequestWrapper;
import com.payex.map.GetMSISDNInfoResp;
import com.payex.map.GetMSISDNInfoResponseWrapper;
import com.payex.map.Header;
import com.payex.map.Header2;
import com.payex.map.MapClientIdEnum;
import com.payex.map.PaymentService;
import com.payex.map.PurchaseRequestWrapper3;
import com.payex.map.PurchaseResponseWrapper3;
import com.payex.map.SalesRequest3;
import com.payex.map.SalesResp;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PxWyWalletHelper {
    private static final Logger logger = LoggerFactory.getLogger(PxWyWalletHelper.class);
    private final PayexSoapDriver _driver;
    private final PaymentService _pxSoap;
    private final int _sleepMs;
    private final int _maxTries;
    private final String _sharedSecret;
    public static final int DEFAULT_POSTBACK_TIMEOUT = 0;
    public static final int DEFAULT_VAT = 0;
    public static final int DEFAULT_GET_DELIVERYADDRESS = 0;
    public static final int DEFAULT_PAYMENT_TERMS = 0;
    public static final String DEFAULT_PRODUCTID = "0";

    public PxWyWalletHelper(PayexSoapDriver driver, int sleepMs, int maxTries, String sharedSecret) {
        this._driver = driver;
        this._pxSoap = this._driver.getPxWyWallet();
        this._sleepMs = sleepMs;
        this._maxTries = maxTries;
        this._sharedSecret = sharedSecret;
    }

    public PayexResponse getMSISDNInfo(String acquirerID, String agreementID, String msisdn, int postbackTimeout) {
        AccountInfo2 response = null;
        String time = PxWyWalletHelper.getCurrentTimeStamp();
        String hash = this.getHashSHA1(acquirerID + agreementID + time + postbackTimeout + msisdn + this._sharedSecret);
        GetMSISDNInfoRequestWrapper getMSISDNInfoRequestWrapper = new GetMSISDNInfoRequestWrapper();
        GetMSISDNInfoRequest getMSISDNInfoRequest = new GetMSISDNInfoRequest();
        getMSISDNInfoRequest.setMSISDN(msisdn);
        Header2 header2 = new Header2();
        header2.setAcquirerID(acquirerID);
        header2.setAgreementID(agreementID);
        header2.setTransmissionTime(time);
        header2.setPostbackTimeout(postbackTimeout);
        Footer footer = new Footer();
        footer.setMAC(hash);
        getMSISDNInfoRequestWrapper.setHeader(header2);
        getMSISDNInfoRequestWrapper.setFooter(footer);
        getMSISDNInfoRequestWrapper.setRequest(getMSISDNInfoRequest);
        GetMSISDNInfoResponseWrapper responseWrapper = null;
        logger.debug(" Input Request for getMSISDNInfo : {}", (Object)getMSISDNInfoRequestWrapper);
        for (int attempt = 1; attempt <= this._maxTries; ++attempt) {
            try {
                if (attempt != 1) {
                    Thread.sleep(this._sleepMs);
                }
                responseWrapper = this._pxSoap.getMSISDNInfo(getMSISDNInfoRequestWrapper);
                break;
            }
            catch (InterruptedException ie) {
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): Interrupt exception in PxWyWalletHelper.getMSISDNInfo: " + ie.getMessage());
                logger.error("Attempt {}: Interrupt exception in PxWyWalletHelper.getMSISDNInfo: ", (Object)attempt, (Object)ie);
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Exception ex) {
                logger.error("Attempt {}: exception in PxWyWalletHelper.getMSISDNInfo: ", (Object)attempt, (Object)ex);
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): unable to invoke PxWyWalletHelper.getMSISDNInfo: " + ex.getMessage());
            }
        }
        if (responseWrapper == null) {
            return null;
        }
        GetMSISDNInfoResp getMSISDNInfoResp = responseWrapper.getResponse();
        if (responseWrapper.getStatus().getTransactionStatus() == 0 && getMSISDNInfoResp != null) {
            List accounts = getMSISDNInfoResp.getAccounts();
            accounts.sort(Comparator.comparing(AccountInfo2::getPrio));
            for (AccountInfo2 accountInfo2 : accounts) {
                if (accountInfo2.getAmount() <= 0) continue;
                response = accountInfo2;
                break;
            }
        }
        Map<Object, Object> accountInfo2 = new HashMap();
        if (response != null) {
            accountInfo2 = this.convertMap((Map<Object, Object>)new BeanMap(response));
        }
        Map<String, String> status = this.convertMap((Map<Object, Object>)new BeanMap((Object)responseWrapper.getStatus()));
        accountInfo2.putAll(status);
        return new PayexResponse(accountInfo2);
    }

    public PayexResponse purchase3(String acquirerID, String agreementID, int postbackTimeOut, int amount, int vat, String currency, String ClientID, String orderId, String productId, String description, Integer paymentTerms, int deliveryAddress) {
        String transmissionTime = PxWyWalletHelper.getCurrentTimeStamp();
        Header2 header2 = new Header2();
        header2.setAcquirerID(acquirerID);
        header2.setAgreementID(agreementID);
        header2.setTransmissionTime(transmissionTime);
        header2.setPostbackTimeout(postbackTimeOut);
        Footer footer = new Footer();
        String hash = this.getHashSHA1(acquirerID + agreementID + transmissionTime + amount + vat + currency + MapClientIdEnum.ACCOUNT_NUMBER.value() + ClientID + orderId + transmissionTime + productId + description + paymentTerms + deliveryAddress + this._sharedSecret);
        footer.setMAC(hash);
        SalesRequest3 saleRequest3 = new SalesRequest3();
        saleRequest3.setGetDeliveryAddress(deliveryAddress);
        saleRequest3.setAmount(amount);
        saleRequest3.setVatAmount(vat);
        saleRequest3.setCurrencyISOString(currency);
        saleRequest3.setClientIdType(MapClientIdEnum.ACCOUNT_NUMBER);
        saleRequest3.setClientId(ClientID);
        saleRequest3.setOrderId(orderId);
        saleRequest3.setReconciliationTime(transmissionTime);
        saleRequest3.setProductId(productId);
        saleRequest3.setDescription(description);
        saleRequest3.setPaymentTerms(paymentTerms);
        PurchaseRequestWrapper3 purchaseRequestWrapper3 = new PurchaseRequestWrapper3();
        purchaseRequestWrapper3.setRequest(saleRequest3);
        purchaseRequestWrapper3.setHeader((Header)header2);
        purchaseRequestWrapper3.setFooter(footer);
        PurchaseResponseWrapper3 purchaseResponseWrapper3 = null;
        for (int attempt = 1; attempt <= this._maxTries; ++attempt) {
            try {
                if (attempt != 1) {
                    Thread.sleep(this._sleepMs);
                }
                purchaseResponseWrapper3 = this._pxSoap.purchase3(purchaseRequestWrapper3);
                break;
            }
            catch (InterruptedException ie) {
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): Interrupt exception in PxWyWalletHelper.purchase3: " + ie.getMessage());
                logger.error("Attempt {}: Interrupt exception in PxWyWalletHelper.purchase3: ", (Object)attempt, (Object)ie);
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Exception ex) {
                logger.error("Attempt {}: exception in PxWyWalletHelper.purchase3: ", (Object)attempt, (Object)ex);
                EventLog.getInstance().logEvent("PayEx error (attempt " + attempt + "): unable to invoke PxWyWalletHelper.purchase3: " + ex.getMessage());
            }
        }
        if (purchaseResponseWrapper3 == null) {
            return null;
        }
        SalesResp salesResp = purchaseResponseWrapper3.getResponse();
        Map<Object, Object> salesRespMap = new HashMap();
        if (salesResp != null) {
            salesRespMap = this.convertMap((Map<Object, Object>)new BeanMap((Object)salesResp));
        }
        Map<String, String> status = this.convertMap((Map<Object, Object>)new BeanMap((Object)purchaseResponseWrapper3.getStatus()));
        salesRespMap.putAll(status);
        return new PayexResponse(salesRespMap);
    }

    public static String getCurrentTimeStamp() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    public Map<String, String> convertMap(Map<Object, Object> map) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof String) {
                newMap.put((String)entry.getKey(), (String)entry.getValue());
            }
            if (!(entry.getValue() instanceof Integer)) continue;
            newMap.put((String)entry.getKey(), entry.getValue().toString());
        }
        return newMap;
    }

    public String getHashSHA1(String data) {
        String sResp = null;
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(data.getBytes(StandardCharsets.UTF_8));
            byte[] result = sha1.digest();
            String hash = new String(Base64.getEncoder().encode(result));
            sResp = hash.substring(0, hash.length() / 2);
            sha1.reset();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Failed to create SHA1 hash for payex params", (Throwable)e);
        }
        return sResp;
    }
}

