/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.paypal.payflow;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.paypal.payflow.PayPalPayflowLinkPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.Formatter;
import biz.papercut.pcng.web.Visit;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnPayflowLink
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnPayflowLink.class);
    public static final String PAGE_NAME = ExtnPayflowLink.class.getSimpleName();
    private static final String CONFIG_PREFIX = "payflowlink.";
    private static final String CONFIG_PAGE_HEADING = "payflowlink.page-heading";
    private static final String CONFIG_LOGIN = "payflowlink.login";
    private static final String CONFIG_PARTNER = "payflowlink.partner";
    private static final String CONFIG_ALLOWED_AMOUNTS = "payflowlink.allowed-amounts";
    private static final String CONFIG_CURRENCY = "payflowlink.currency";

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract Double getAmount();

    public abstract void setAmount(Double var1);

    public abstract AccountManager getAccountManager();

    public abstract ApplicationLogManager getApplicationLogManager();

    public abstract LicenseManager getLicenseManager();

    public abstract UserManager getUserManager();

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public String getPageTitle() {
        String title = this.getPayflowLinkPlugin().getPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            String userName = ((Visit)this.getVisit()).getUserName();
            User u = this.getUserManager().getUser(userName);
            this.setUser(u);
            GatewayUtils.LogHelper.logDebug(logger, "[Payflow] User %s accessed Payflow Link page.", userName);
        }
        if (!event.getRequestCycle().isRewinding()) {
            String currency;
            GatewayConfig conf;
            String qs = this.getRequest().getQueryString();
            if (qs.contains("error=true")) {
                GatewayUtils.LogHelper.logError(logger, "[Payflow] User returning from PayPal payment pages after a failed transaction [user=%s]", this.getPaperCutVisit().getUserName());
                this.addErrorMessage(ExtnPayflowLink.getGatewayConfig().getUserErrorMessage());
            }
            if (qs.contains("success=true")) {
                GatewayUtils.LogHelper.logDebug(logger, "[Payflow] User returning from PayPal payment pages after a successful transaction [user=%s]", this.getPaperCutVisit().getUserName());
                this.addStatusMessage("Funds have been added to your account");
            }
            if (!this.getPayflowLinkPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if (StringUtils.isBlank((String)(conf = ExtnPayflowLink.getGatewayConfig()).getString(CONFIG_LOGIN)) || StringUtils.isBlank((String)conf.getString(CONFIG_PARTNER))) {
                this.addWarningMessage("This module is not configured. \nPlease check that the login and partner information configured in the gateway config file.");
                GatewayUtils.LogHelper.logError(logger, "[Payflow] Payflow Link plugin is not correctly configured");
            }
            if (!this.isCurrencyValid(currency = conf.getString(CONFIG_CURRENCY))) {
                this.addWarningMessage("Configured currency: " + currency + " is not valid. Defaulting to USD");
            }
        }
    }

    public String getReturnRedirectUrl() {
        HttpServletRequest r = this.getRequest();
        return r.getScheme() + "://" + r.getServerName() + ":" + r.getServerPort() + "/app?service=page/" + PAGE_NAME;
    }

    public String getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return this.formatBalance(GatewayUtils.getUserBalance(this.getAccountManager(), user));
    }

    public String getNoAccessMsg() {
        return GatewayConfig.getInstance().getNoAccessMessage();
    }

    public String getHeading() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String heading = conf.getString(CONFIG_PAGE_HEADING);
        if (StringUtils.isBlank((String)heading)) {
            heading = "Add credit using a Credit Card";
        }
        return heading;
    }

    public String formatAmountInDropdown(double amount) {
        if (amount < 0.01) {
            return "--- Select the amount ---";
        }
        return this.formatBalance(amount);
    }

    public String getPayflowLogin() {
        GatewayConfig conf = GatewayConfig.getInstance();
        return StringUtils.trimToEmpty((String)conf.getString(CONFIG_LOGIN));
    }

    public String getPayflowPartner() {
        GatewayConfig conf = GatewayConfig.getInstance();
        return StringUtils.trimToEmpty((String)conf.getString(CONFIG_PARTNER));
    }

    protected PayPalPayflowLinkPlugin getPayflowLinkPlugin() {
        return (PayPalPayflowLinkPlugin)PluginManager.getInstance().getPluginByClass(PayPalPayflowLinkPlugin.class);
    }

    public String getOrderId() {
        return this.getPayflowLinkPlugin().createOrder(this.getPaperCutVisit().getUserName());
    }

    public boolean isAccessibleByUser() {
        return this.getPayflowLinkPlugin().isAccessibleByUser(this.getPaperCutVisit().getUserName());
    }

    public List<Double> getAllowedAmounts() {
        GatewayConfig conf = GatewayConfig.getInstance();
        return conf.getDoubleList(CONFIG_ALLOWED_AMOUNTS);
    }

    public String formatAmount(double amount) {
        return Formatter.formatNumber((double)amount, (int)2, (Locale)Locale.US);
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public String getPageMessage() {
        return ExtnPayflowLink.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return ExtnPayflowLink.getGatewayConfig().getPageMessageAvailable();
    }

    public String getCurrency() {
        String currencyStr = ExtnPayflowLink.getGatewayConfig().getString(CONFIG_CURRENCY);
        if (this.isCurrencyValid(currencyStr)) {
            return currencyStr;
        }
        return Currency.USD.toString();
    }

    private boolean isCurrencyValid(String currency) {
        try {
            Currency.valueOf(currency);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static enum Currency {
        AUD,
        CAD,
        EUR,
        GBP,
        JPY,
        USD;

    }
}

