/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.paypal.payflow;

import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.ParameterMapValuesStringBuilder;
import biz.papercut.pcng.ext.paymentgateway.paypal.payflow.PayPalPayflowLinkPostbackServlet;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PayPalPayflowLinkPlugin
implements UserLinkPlugin,
WebServerPlugin,
SpringContextPlugin,
EnableablePlugin {
    private static final Logger logger = LoggerFactory.getLogger(PayPalPayflowLinkPlugin.class);
    public static final String BASE_SERVLET_PATH = "/rpc/gateway/payflow";
    public static final String USER_VAR_ORDER_ID = "USER1";
    public static final String USER_VAR_USERNAME = "USER2";
    public static final String USER_VAR_RETURN_REDIRECT_URL = "USER3";
    public static final String CURRENCY = "CURRENCY";
    private static final String CONFIG_PREFIX = "payflowlink.";
    private static final String CONFIG_ENABLED = "payflowlink.enabled";
    @AESProperty
    public static final String CONFIG_SECURITY_TOKEN = "payflowlink.security-token";
    private static final String CONFIG_ENABLE_PORT_80 = "payflowlink.enable-port-80";
    private static final String CONFIG_ALLOWED_IP = "payflowlink.allowed-ip";
    private static final String CONFIG_ALLOWED_GROUPS = "payflowlink.allowed-groups";
    private static final String CONFIG_PAGE_TITLE = "payflowlink.page-title";
    private static final List<String> PAGES = Collections.singletonList("ExtnPayflowLink");
    private static final String RESPONSE_SUCCESS = "0";
    private static final String RESPMSG_APPROVED = "Approved";
    @Nullable
    private ApplicationContext _applicationContext;

    public boolean isPluginEnabled() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean(CONFIG_ENABLED));
    }

    public boolean isLicensed() {
        return GatewayUtils.isLicensed(this.getLicenseManager(), "payment-gateways-paypal-payflow");
    }

    public boolean isAccessibleByUser(String username) {
        return this.isPluginEnabled() && GatewayUtils.isAccessibleByUser(username, CONFIG_ALLOWED_GROUPS, this.getUserManager());
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return PAGES;
        }
        return null;
    }

    @CheckForNull
    public String getPageTitle() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_TITLE));
    }

    public void preStartupHook(WebServerPlugin.WebServer server) {
        if (!this.isPluginEnabled()) {
            return;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            Boolean port80 = GatewayConfig.getInstance().getBoolean(CONFIG_ENABLE_PORT_80);
            if (port80 == null || port80.booleanValue()) {
                server.listenOnPort(80);
            }
        } else {
            logger.debug("[Payflow] Not on Windows so not enabling port 80 for PayPal Payflow Link module.");
        }
        server.addServlet(PayPalPayflowLinkPostbackServlet.class, "/rpc/gateway/payflow/*");
    }

    public void processPostback(HttpServletRequest request, HttpServletResponse response) throws IOException {
        double amountAdded;
        if (logger.isDebugEnabled()) {
            String logMessage = "[Payflow] Postback request URI: " + request.getRequestURI();
            GatewayUtils.LogHelper.logDebug(logger, logMessage + ", params: " + this.buildLogMessageFromParameters(request.getParameterMap()));
        }
        GatewayUtils.LogHelper.logInfo(logger, "[Payflow] Payflow postback request received from IP: " + request.getRemoteAddr());
        String token = GatewayConfig.getInstance().getString(CONFIG_SECURITY_TOKEN);
        if (StringUtils.isNotBlank((String)token) && !request.getRequestURI().contains(token)) {
            GatewayUtils.LogHelper.logError(logger, "[Payflow] Invalid Payflow postback URL (contains invalid security token). URI: " + request.getRequestURI());
            response.sendError(403);
            return;
        }
        if (!GatewayUtils.isIPAddressValid(request.getRemoteAddr(), this.getGatewayConfig().getString(CONFIG_ALLOWED_IP))) {
            GatewayUtils.LogHelper.logError(logger, "[Payflow] Invalid IP address accessing Payflow postback URL: " + request.getRemoteAddr());
            response.sendError(403);
            return;
        }
        String orderId = this.extractOrderIdFromRequest(request);
        String username = this.extractUsernameFromRequest(request);
        String amountStr = request.getParameter("AMT");
        if (StringUtils.isBlank((String)amountStr)) {
            amountStr = request.getParameter("AMOUNT");
        }
        String result = request.getParameter("RESULT");
        String respMsg = StringUtils.trimToEmpty((String)request.getParameter("RESPMSG"));
        if (!StringUtils.isNumeric((String)result)) {
            GatewayUtils.LogHelper.logError(logger, "[Payflow] Invalid Payflow post data. Invalid result code: %s", result);
            response.sendError(500);
            return;
        }
        try {
            amountAdded = Double.parseDouble(amountStr);
        }
        catch (Exception e) {
            GatewayUtils.LogHelper.logError(logger, "[Payflow] Invalid Payflow post data. Invalid amount: %s", amountStr);
            response.sendError(500);
            return;
        }
        if (orderId == null || username == null) {
            GatewayUtils.LogHelper.logError(logger, "[Payflow] Invalid Payflow post data. Missing user data.");
            response.sendError(500);
            return;
        }
        String postbackData = String.format("User: %s, order: %s, result: %s, respMsg: %s, amount: %s", username, orderId, result, respMsg, amountStr);
        GatewayUtils.LogHelper.logDebug(logger, "[Payflow] Received postback data: " + postbackData);
        if (!RESPONSE_SUCCESS.equals(result) || !StringUtils.startsWithIgnoreCase((String)respMsg, (String)RESPMSG_APPROVED)) {
            if (respMsg.equalsIgnoreCase("AVSDECLINED")) {
                GatewayUtils.LogHelper.logDebug(logger, "[Payflow] PayPal reporting transaction declined due to AVS failure. Possible temporary decline (user may retry).");
            } else if (respMsg.equalsIgnoreCase("CSCDECLINED")) {
                GatewayUtils.LogHelper.logDebug(logger, "[Payflow] PayPal reporting transaction declined due to invalid CSC. Possible temporary decline (user may retry).");
            } else {
                GatewayUtils.LogHelper.logInfo(logger, "[Payflow] PayPal server reported declined/failed transaction (may be temporary): RESULT=%s RESPMSG=%s DATA=%s", result, respMsg, postbackData);
            }
            return;
        }
        GatewayUtils.LogHelper.logInfo(logger, "[Payflow] Received valid transaction from Payflow Link server: " + postbackData);
        String paymentRef = request.getParameter("PNREF");
        CreditCardGatewayPlugin.OrderResponse orderResponse = this.getCreditCardGatewayPlugin().confirmOrder(orderId, paymentRef, amountAdded);
        if (!orderResponse.isSuccess()) {
            if (paymentRef != null) {
                GatewayUtils.LogHelper.logError(logger, "[Payflow] Cannot complete order due to invalid/unknown order id [orderId=%s, paymentRef=%s]: %s", orderId, paymentRef, orderResponse.getMessage());
            } else {
                GatewayUtils.LogHelper.logError(logger, "[Payflow] Cannot complete order due to invalid/unknown order id [orderId=%s]: %s", orderId, orderResponse.getMessage());
            }
            response.sendError(500);
            return;
        }
        if (paymentRef != null) {
            GatewayUtils.LogHelper.logInfo(logger, "[Payflow] Order processed successfully [orderId=%s, paymentRef=%s]", orderId, paymentRef);
        } else {
            GatewayUtils.LogHelper.logInfo(logger, "[Payflow] Order processed successfully [orderId=%s]", orderId);
        }
    }

    String buildLogMessageFromParameters(Map<String, String[]> parameters) {
        ParameterMapValuesStringBuilder stringBuilder = new ParameterMapValuesStringBuilder(parameters);
        this.getParametersToLog().forEach(stringBuilder::add);
        return stringBuilder.build();
    }

    private List<String> getParametersToLog() {
        return List.of(USER_VAR_ORDER_ID, USER_VAR_USERNAME, USER_VAR_RETURN_REDIRECT_URL, "AMT", "AMOUNT", "RESULT", "RESPMSG", "PNREF");
    }

    public void handleUserReturn(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String returnRedirectUrl = this.extractReturnRedirectUrlFromRequest(request);
        String result = request.getParameter("RESULT");
        String respMsg = StringUtils.trimToEmpty((String)request.getParameter("RESPMSG"));
        boolean success = this.isResponseSuccess(result, respMsg);
        if (returnRedirectUrl != null) {
            String resultParam = success ? "&success=true" : "&error=true";
            String url = returnRedirectUrl + resultParam;
            GatewayUtils.LogHelper.logInfo(logger, "[Payflow] User returning from PayPal payment pages, redirecting to %s", url);
            response.sendRedirect(url);
        } else {
            GatewayUtils.LogHelper.logWarn(logger, "[Payflow] User returning from Payflow but missing URL to redirect them to. Redirecting to login page instead.");
            response.sendRedirect("/user");
        }
    }

    private boolean isResponseSuccess(String result, String respMsg) {
        return RESPONSE_SUCCESS.equals(result) && StringUtils.startsWithIgnoreCase((String)respMsg, (String)RESPMSG_APPROVED);
    }

    @CheckForNull
    protected String extractOrderIdFromRequest(HttpServletRequest request) {
        return StringUtils.trimToNull((String)request.getParameter(USER_VAR_ORDER_ID));
    }

    @CheckForNull
    protected String extractUsernameFromRequest(HttpServletRequest request) {
        return StringUtils.trimToNull((String)request.getParameter(USER_VAR_USERNAME));
    }

    @CheckForNull
    protected String extractReturnRedirectUrlFromRequest(HttpServletRequest request) {
        return StringUtils.trimToNull((String)request.getParameter(USER_VAR_RETURN_REDIRECT_URL));
    }

    public String createOrder(String username) {
        return this.getCreditCardGatewayPlugin().createNewOrder(username, -1.0);
    }

    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    private CreditCardGatewayPlugin getCreditCardGatewayPlugin() {
        return (CreditCardGatewayPlugin)PluginManager.getInstance().getPluginByClass(CreditCardGatewayPlugin.class);
    }

    public GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public LicenseManager getLicenseManager() {
        return (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }
}

