/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.paypal.payflow;

import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.PaymentGatewayRequestLogMessageBuilder;
import biz.papercut.pcng.ext.paymentgateway.paypal.payflow.PayPalPayflowLinkPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayPalPayflowLinkPostbackServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(PayPalPayflowLinkPostbackServlet.class);
    private final PaymentGatewayRequestLogMessageBuilder logMessageBuilder = new PaymentGatewayRequestLogMessageBuilder("[Payflow] Payflow silent post URL").withSelectedParameters(this.getParametersToLog());

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.debugLogRequest(request);
            this.getPayPalPayflowLinkPlugin().processPostback(request, response);
        }
        catch (Exception e) {
            response.sendError(400);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.debugLogRequest(request);
            if (request.getParameterMap().containsKey("RESULT") && request.getParameterMap().containsKey("RESPMSG") || request.getParameterMap().containsKey("USER3")) {
                this.getPayPalPayflowLinkPlugin().handleUserReturn(request, response);
            } else {
                this.createPageAccessibleResponse(response);
            }
        }
        catch (Exception e) {
            response.sendError(400);
        }
    }

    protected void createPageAccessibleResponse(HttpServletResponse response) throws IOException {
        response.getWriter().write("<html><body><h1>The Payflow Link Postback URL is accessible as of " + String.valueOf(new Date()) + "</h1><p>Remember to ensure that the URL is externally accessible (i.e. PayPal server has access)</p></body></html>");
    }

    private void debugLogRequest(HttpServletRequest request) {
        if (logger.isDebugEnabled()) {
            GatewayUtils.LogHelper.logDebug(logger, this.buildLogMessageFromRequest(request));
        }
    }

    String buildLogMessageFromRequest(HttpServletRequest request) {
        return this.logMessageBuilder.buildFrom(request);
    }

    private List<String> getParametersToLog() {
        return List.of("USER1", "USER2", "USER3", "AMT", "AMOUNT", "RESULT", "RESPMSG", "PNREF");
    }

    protected PayPalPayflowLinkPlugin getPayPalPayflowLinkPlugin() {
        return (PayPalPayflowLinkPlugin)PluginManager.getInstance().getPluginByClass(PayPalPayflowLinkPlugin.class);
    }
}

