/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.paypal.wps;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.paypal.wps.PayPalWPSPlugin;
import biz.papercut.pcng.ext.paymentgateway.paypal.wps.PayPalWPSRedirect;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnPayPalWPS
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnPayPalWPS.class);
    public static final String PAGE_NAME = ExtnPayPalWPS.class.getSimpleName();

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract double getAmount();

    public abstract void setAmount(double var1);

    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract AccountManager getAccountManager();

    public abstract UserManager getUserManager();

    public void activateExternalPage(Object[] arguments, IRequestCycle cycle) {
        HttpServletRequest r = this.getRequest();
        String orderId = r.getParameter("order-id");
        String status = r.getParameter("status");
        switch (this.getPayPalWPSPlugin().getOrderStatus(orderId)) {
            case Approved: {
                this.addStatusMessage("Funds have been added to your account.");
                break;
            }
            case Declined: {
                this.addStatusMessage("Your payment was declined." + this.getPayPalWPSPlugin().getUserErrorMessage());
                break;
            }
            case Pending: {
                this.addStatusMessage("Your payment is being processed and will be actioned soon.");
                break;
            }
            case Unknown: {
                this.addStatusMessage(this.getPayPalWPSPlugin().getUserErrorMessage());
                break;
            }
            default: {
                logger.error("Unexpected state: {}", (Object)status);
            }
        }
    }

    public void pageBeginRender(PageEvent arg0) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(GatewayUtils.createAllowedAmountsModel("paypal.allowed-amounts", (BasePaperCutPage)this));
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!this.getPayPalWPSPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getPayPalWPSPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
            }
        }
    }

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void formSubmit(IRequestCycle cycle) {
        if (this.getAmount() <= 0.0) {
            this.addErrorMessage("Please select an amount to add");
            return;
        }
        PayPalWPSRedirect redirectPage = (PayPalWPSRedirect)cycle.getPage(PayPalWPSRedirect.PAGE_NAME);
        redirectPage.activate(cycle, this.getUser(), this.getAmount());
    }

    public boolean isAccessibleByUser() {
        return this.getPayPalWPSPlugin().isAccessibleByUser(this.getUserName());
    }

    public String getNoAccessMsg() {
        return this.getGatewayConfig().getNoAccessMessage();
    }

    public String getPageTitle() {
        String title = this.getPayPalWPSPlugin().getPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public String getHeading() {
        return this.getPayPalWPSPlugin().getPageHeading();
    }

    public String getUserName() {
        return this.getUser().getUserName();
    }

    public String getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return this.formatBalance(GatewayUtils.getUserBalance(this.getAccountManager(), user));
    }

    public String getPageMessage() {
        return this.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return this.getGatewayConfig().getPageMessageAvailable();
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private PayPalWPSPlugin getPayPalWPSPlugin() {
        return (PayPalWPSPlugin)PluginManager.getInstance().getPluginByClass(PayPalWPSPlugin.class);
    }
}

