/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.paypal.wps;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.ParameterMapValuesStringBuilder;
import biz.papercut.pcng.ext.paymentgateway.paypal.wps.ExtnPayPalWPS;
import biz.papercut.pcng.ext.paymentgateway.paypal.wps.PayPalWPSOrderStatus;
import biz.papercut.pcng.ext.paymentgateway.paypal.wps.PayPalWPSPOSTBackServlet;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.ConfigManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.NotificationUtils;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.ApplicationInfo;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PayPalWPSPlugin
implements EnableablePlugin,
WebServerPlugin,
SpringContextPlugin,
UserLinkPlugin {
    private static final Logger logger = LoggerFactory.getLogger(PayPalWPSPlugin.class);
    private static final String CONFIG_PREFIX = "paypal.";
    private static final String CONFIG_ENABLED = "paypal.enabled";
    private static final String CONFIG_ID = "paypal.id";
    private static final String CONFIG_CURRENCY = "paypal.currency";
    private static final String CONFIG_ITEM_NAME = "paypal.item-name";
    @AESProperty
    public static final String CONFIG_SHARED_SECRET = "paypal.shared-secret";
    private static final String CONFIG_RETURN_BUTTON_TEXT = "paypal.return-button-text";
    private static final String CONFIG_PAYMENT_PAGE_STYLE = "paypal.payment-page-style";
    private static final String CONFIG_PAGE_TITLE = "paypal.page-title";
    private static final String CONFIG_PAGE_HEADING = "paypal.page-heading";
    private static final String CONFIG_ALLOWED_GROUPS = "paypal.allowed-groups";
    public static final String CONFIG_ALLOWED_AMOUNTS = "paypal.allowed-amounts";
    private static final String CONFIG_POSTBACK_ALLOWED_IP = "paypal.postback-allowed-ip";
    private static final String CONFIG_ENABLE_PORT_80 = "paypal.enable-port-80";
    private static final String CONFIG_SUBMIT_URL = "paypal.submit-url";
    private static final String CONFIG_IPN_URL = "paypal.ipn-url";
    private static final String CONFIG_REDIECT_URL = "paypal.redirect-url";
    private static final String CONFIG_PROXY_HOST = "paypal.proxy.host";
    private static final String CONFIG_PROXY_PORT = "paypal.proxy.port";
    private static final String IPN_PARAM_AMOUNT = "mc_gross";
    private static final String IPN_PARAM_CURRENCY = "mc_currency";
    private static final String IPN_PARAM_INVOICE = "invoice";
    private static final String IPN_PARAM_PAYMENT_STATUS = "payment_status";
    private static final String IPN_PARAM_PAYMENT_STATUS_COMPLETED = "Completed";
    private static final String IPN_PARAM_RECEIVER_EMAIL = "receiver_email";
    private static final int PAYMENT_PAGE_STYLE_MAX_LENGTH = 30;
    private static final String POSTBACK_URL_PATH = "/rpc/gateway/paypal-wps";
    private static final int MAX_ORDER_NUMBER_LENGTH = 127;
    private static final int MAX_USER_EMAIL_LENGTH = 127;
    private static final List<String> ADDITIONAL_PAGES = List.of(ExtnPayPalWPS.PAGE_NAME);
    private volatile ApplicationContext _applicationContext;

    public boolean isPluginEnabled() {
        Boolean enabled = this.getGatewayConfig().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public void preStartupHook(WebServerPlugin.WebServer server) {
        Boolean port80;
        if (!this.isPluginEnabled()) {
            return;
        }
        if (SystemUtils.IS_OS_WINDOWS && ((port80 = GatewayConfig.getInstance().getBoolean(CONFIG_ENABLE_PORT_80)) == null || port80.booleanValue())) {
            server.listenOnPort(80);
        }
        server.addServlet(PayPalWPSPOSTBackServlet.class, "/rpc/gateway/paypal-wps/*");
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return ADDITIONAL_PAGES;
        }
        return null;
    }

    @CheckForNull
    public String getIsConfigured() {
        String errorSuffix = " Please check the payment gateway config file.";
        if (this.getPayPalID() == null) {
            String error = "PayPal ID not provided.";
            GatewayUtils.LogHelper.logError(logger, error);
            return error + errorSuffix;
        }
        if (this.getCurrency() == null) {
            String error = "Currency not provided.";
            GatewayUtils.LogHelper.logError(logger, error);
            return error + errorSuffix;
        }
        if (this.getAllowedAmounts() == null) {
            String error = "Must specify at least one allowed payment amount.";
            GatewayUtils.LogHelper.logError(logger, error);
            return error + errorSuffix;
        }
        try {
            this.getGatewayConfig().getURL(CONFIG_SUBMIT_URL);
        }
        catch (Exception e) {
            GatewayUtils.LogHelper.logError(logger, "Invalid hosted order page URL: " + this.getSubmitURL());
            return "Invalid hosted order page URL." + errorSuffix;
        }
        return null;
    }

    public String createNewOrder(String userName, double amount) {
        return this.getCreditCardGatewayPlugin().createNewOrder(userName, amount, 127);
    }

    public boolean isAccessibleByUser(String username) {
        return GatewayUtils.isAccessibleByUser(username, CONFIG_ALLOWED_GROUPS, this.getUserManager());
    }

    public boolean isLicensed() {
        return GatewayUtils.isLicensed(this.getLicenseManager(), "payment-gateways-paypal-wps");
    }

    public String getAllowedAmounts() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_ALLOWED_AMOUNTS));
    }

    public String getBN() {
        ApplicationInfo ai = ApplicationInfo.getInstance();
        return ai.getCopyrightOwner() + "_BuyNow_" + ai.getApplicationName() + "_AU";
    }

    public String getCurrency() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_CURRENCY));
    }

    public String getItemName() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_ITEM_NAME));
    }

    public String getPaymentPageStyle() {
        String paymentPageStyle = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_PAYMENT_PAGE_STYLE));
        return StringUtils.left((String)paymentPageStyle, (int)30);
    }

    public String getPayPalID() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_ID));
    }

    @CheckForNull
    public String getPageTitle() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_TITLE));
    }

    @CheckForNull
    public String getPageHeading() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_HEADING));
    }

    public String getSubmitURL() {
        return this.getGatewayConfig().getString(CONFIG_SUBMIT_URL);
    }

    public String getReturnURL(String scheme, String serverName, int serverPort, String orderId) {
        return this.getBaseReturnURL(scheme, serverName, serverPort, orderId) + "&status=check";
    }

    public String getReturnButtonText() {
        return this.getGatewayConfig().getString(CONFIG_RETURN_BUTTON_TEXT);
    }

    public String getReturnCancelURL(String scheme, String serverName, int serverPort, String orderId) {
        return this.getBaseReturnURL(scheme, serverName, serverPort, orderId) + "&status=cancel";
    }

    private String getBaseReturnURL(String scheme, String serverName, int serverPort, String orderId) {
        return scheme + "://" + serverName + ":" + serverPort + "/app?service=external/" + ExtnPayPalWPS.PAGE_NAME + "&order-id=" + orderId;
    }

    public String getUserEmail(User user) {
        String email = StringUtils.trimToEmpty((String)NotificationUtils.getUserEmailAddress((ConfigManager)this.getConfigManager(), (User)user));
        return StringUtils.left((String)email, (int)127);
    }

    public String getUserErrorMessage() {
        return this.getGatewayConfig().getUserErrorMessage();
    }

    public String getIpnURL() {
        return this.getGatewayConfig().getString(CONFIG_IPN_URL);
    }

    public String getRedirectUrl() {
        return this.getGatewayConfig().getString(CONFIG_REDIECT_URL);
    }

    public PayPalWPSOrderStatus getOrderStatus(String orderId) {
        CreditCardGatewayPlugin ccgp = this.getCreditCardGatewayPlugin();
        if (!ccgp.isOrderExists(orderId)) {
            return PayPalWPSOrderStatus.Unknown;
        }
        CreditCardGatewayPlugin.OrderResponse or = ccgp.getExistingOrderReponse(orderId);
        if (or == null) {
            return PayPalWPSOrderStatus.Pending;
        }
        if (or.isSuccess()) {
            return PayPalWPSOrderStatus.Approved;
        }
        return PayPalWPSOrderStatus.Declined;
    }

    public void cancelOrder(String orderId) {
        GatewayUtils.LogHelper.logInfo(logger, "Canceling order " + orderId);
        this.getCreditCardGatewayPlugin().cancelOrder(orderId);
    }

    public boolean validateIPNAndCompleteOrder(String remoteAddress, String requestURI, Map<String, String> params) {
        double amount;
        boolean validated;
        GatewayUtils.LogHelper.logInfo(logger, "Receiving IPN from PayPal. IP: " + remoteAddress + ", details: " + this.buildLogMessageFromParameters(params));
        if (!GatewayUtils.isIPAddressValid(remoteAddress, this.getGatewayConfig().getString(CONFIG_POSTBACK_ALLOWED_IP))) {
            GatewayUtils.LogHelper.logWarn(logger, "Received transaction details (IPN) from a disallowed IP address. Transaction ignored. See payment gateway log file for details.", null, this.getApplicationLogManager());
            return false;
        }
        String localSecret = this.getGatewayConfig().getString(CONFIG_SHARED_SECRET);
        if (StringUtils.isBlank((String)localSecret)) {
            GatewayUtils.LogHelper.logDebug(logger, "Shared secret not configured. Skipping validation.");
        } else if (!requestURI.contains(localSecret)) {
            GatewayUtils.LogHelper.logWarn(logger, "PayPal reported a transaction (IPN) but it could not be processed due to incorrect information (invalid shared secret). See payment gateway log file for details.", null, this.getApplicationLogManager());
            return false;
        }
        try {
            validated = this.validateIPNWithPayPal(params);
        }
        catch (IOException ioe) {
            GatewayUtils.LogHelper.logError(logger, "Error validating IPN with PayPal: " + ioe.getMessage());
            validated = false;
        }
        GatewayUtils.LogHelper.logInfo(logger, "IPN validation complete (valid=" + validated + ")");
        if (!validated) {
            return false;
        }
        String orderId = params.get(IPN_PARAM_INVOICE);
        if (StringUtils.isBlank((String)orderId)) {
            GatewayUtils.LogHelper.logWarn(logger, "PayPal reported a transaction (IPN) but it could not be processed due to missing information (no order id). See payment gateway log file for details.", null, this.getApplicationLogManager());
            return false;
        }
        String paymentStatus = params.get(IPN_PARAM_PAYMENT_STATUS);
        if (paymentStatus == null) {
            GatewayUtils.LogHelper.logWarn(logger, "PayPal reported a transaction (IPN) but it could not be processed due to missing information (no payment status). See payment gateway log file for details.", null, this.getApplicationLogManager());
            return false;
        }
        GatewayUtils.LogHelper.logInfo(logger, "PayPal reporting updated status for order id " + orderId + ": " + paymentStatus);
        if (!IPN_PARAM_PAYMENT_STATUS_COMPLETED.equals(paymentStatus)) {
            GatewayUtils.LogHelper.logInfo(logger, "Order id " + orderId + " not yet complete, no further processing required.");
            return true;
        }
        String receiverEmail = params.get(IPN_PARAM_RECEIVER_EMAIL);
        if (!this.getPayPalID().equals(receiverEmail)) {
            GatewayUtils.LogHelper.logWarn(logger, "PayPal IPN receiver_email '" + receiverEmail + "' does not match configured PayPal ID '" + this.getPayPalID() + "'. Ignoring.");
            GatewayUtils.LogHelper.logWarn(logger, "PayPal reported a transaction (IPN) but it could not be processed due incorrect information (payment is for a different PayPal ID). See payment gateway log file for details.", null, this.getApplicationLogManager());
            return false;
        }
        String currency = params.get(IPN_PARAM_CURRENCY);
        if (!this.getCurrency().equals(currency)) {
            GatewayUtils.LogHelper.logWarn(logger, "PayPal IPN currency '" + currency + "' does not match configured currency '" + this.getCurrency() + "'. Ignoring.");
            GatewayUtils.LogHelper.logWarn(logger, "PayPal reported a transaction (IPN) but it could not be processed due incorrect information (payment was in a different currency). See payment gateway log file for details.", null, this.getApplicationLogManager());
            return false;
        }
        String amountStr = params.get(IPN_PARAM_AMOUNT);
        try {
            amount = Double.parseDouble(amountStr);
        }
        catch (NumberFormatException nfe) {
            GatewayUtils.LogHelper.logWarn(logger, "PayPal IPN contains invalid payment amount: " + amountStr + "'. Ignoring.");
            GatewayUtils.LogHelper.logWarn(logger, "PayPal reported a transaction (IPN) but it could not be processed due incorrect information (invalid payment amount). See payment gateway log file for details.", null, this.getApplicationLogManager());
            return false;
        }
        GatewayUtils.LogHelper.logInfo(logger, "Completing order " + orderId + " for " + amount);
        CreditCardGatewayPlugin.OrderResponse result = this.getCreditCardGatewayPlugin().confirmOrder(orderId, amount);
        GatewayUtils.LogHelper.logInfo(logger, "Order " + orderId + " result: " + result.isSuccess() + ", previously processed? " + result.isAlreadyProcessed() + ", message: " + result.getMessage());
        return result.isSuccess();
    }

    private boolean validateIPNWithPayPal(Map<String, String> params) throws IOException {
        GatewayUtils.LogHelper.logDebug(logger, "Validating IPN with PayPal...");
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        formParams.add(new BasicNameValuePair("cmd", "_notify-validate"));
        for (Map.Entry<String, String> e : params.entrySet()) {
            formParams.add(new BasicNameValuePair(e.getKey(), e.getValue()));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, StandardCharsets.UTF_8);
        HttpPost httppost = new HttpPost(this.getSubmitURL());
        httppost.setEntity((HttpEntity)entity);
        boolean valid = false;
        try {
            String proxyPort;
            HttpClientBuilder builder = HttpClientBuilder.create();
            String proxyHost = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_PROXY_HOST));
            if (!proxyHost.isEmpty() && !(proxyPort = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_PROXY_PORT))).isEmpty() && StringUtils.isNumeric((String)proxyPort)) {
                builder.setProxy(new HttpHost("http", proxyHost, Integer.parseInt(proxyPort)));
                GatewayUtils.LogHelper.logDebug(logger, "Validating IPN with PayPal using proxy host :" + proxyHost + " port: " + proxyPort);
            }
            try (CloseableHttpClient client = builder.build();){
                valid = (Boolean)client.execute((ClassicHttpRequest)httppost, response -> {
                    boolean valid1 = false;
                    HttpEntity entity1 = response.getEntity();
                    if (entity1 != null) {
                        String responseString = EntityUtils.toString((HttpEntity)entity1);
                        GatewayUtils.LogHelper.logDebug(logger, "Received IPN verification response: " + responseString);
                        valid1 = responseString.equals("VERIFIED");
                    }
                    return valid1;
                });
            }
        }
        catch (IOException ioe) {
            GatewayUtils.LogHelper.logError(logger, "Error validating transaction with PayPal. See Payment Gateway event.log file for details.", null, this.getApplicationLogManager());
            GatewayUtils.LogHelper.logError(logger, "Error validating transaction with PayPal: " + ioe.getMessage());
            throw ioe;
        }
        return valid;
    }

    private ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    private ApplicationLogManager getApplicationLogManager() {
        return (ApplicationLogManager)this.getApplicationContext().getBean("applicationLogManager", ApplicationLogManager.class);
    }

    private CreditCardGatewayPlugin getCreditCardGatewayPlugin() {
        return (CreditCardGatewayPlugin)PluginManager.getInstance().getPluginByClass(CreditCardGatewayPlugin.class);
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private LicenseManager getLicenseManager() {
        return (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    private ConfigManager getConfigManager() {
        return (ConfigManager)this.getApplicationContext().getBean("configManager", ConfigManager.class);
    }

    String buildLogMessageFromParameters(Map<String, String> parameters) {
        ParameterMapValuesStringBuilder stringBuilder = new ParameterMapValuesStringBuilder(parameters);
        this.getParametersToLog().forEach(stringBuilder::add);
        return stringBuilder.build();
    }

    private List<String> getParametersToLog() {
        return List.of(IPN_PARAM_INVOICE, IPN_PARAM_PAYMENT_STATUS, IPN_PARAM_RECEIVER_EMAIL, IPN_PARAM_CURRENCY, IPN_PARAM_AMOUNT);
    }
}

