/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.paypal.wps;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.paypal.wps.ExtnPayPalWPS;
import biz.papercut.pcng.ext.paymentgateway.paypal.wps.PayPalWPSPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import javax.annotation.CheckForNull;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PayPalWPSRedirect
extends BasePaperCutPage
implements PageRenderListener {
    private static final Logger logger = LoggerFactory.getLogger(PayPalWPSRedirect.class);
    public static final String PAGE_NAME = PayPalWPSRedirect.class.getSimpleName();

    @CheckForNull
    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract double getAmount();

    public abstract void setAmount(double var1);

    public abstract String getOrderId();

    public abstract void setOrderId(String var1);

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void activate(IRequestCycle cycle, User user, double amount) {
        this.setUser(user);
        this.setAmount(amount);
        String orderId = this.getPayPalWPSPlugin().createNewOrder(user.getUserName(), amount);
        this.setOrderId(orderId);
        logger.debug("Created order {} for user {}. Redirecting user to PayPal.", (Object)orderId, (Object)user.getUserName());
        cycle.activate((IPage)this);
    }

    public void pageBeginRender(PageEvent arg0) {
        if (this.getUser() == null) {
            throw new PageRedirectException(ExtnPayPalWPS.PAGE_NAME);
        }
    }

    public String getPayPalID() {
        return this.getPayPalWPSPlugin().getPayPalID();
    }

    public String getBN() {
        return this.getPayPalWPSPlugin().getBN();
    }

    public String getFormattedAmount() {
        return GatewayUtils.formatNumber(this.getAmount(), 2, Locale.US, false);
    }

    public String getItemName() {
        return this.getPayPalWPSPlugin().getItemName();
    }

    public String getCurrency() {
        return this.getPayPalWPSPlugin().getCurrency();
    }

    public String getPaymentPageStyle() {
        return this.getPayPalWPSPlugin().getPaymentPageStyle();
    }

    public String getReturnURL() {
        if (this.getPayPalWPSPlugin().getRedirectUrl() != null) {
            return this.getPayPalWPSPlugin().getRedirectUrl();
        }
        HttpServletRequest r = this.getRequest();
        return this.getPayPalWPSPlugin().getReturnURL(r.getScheme(), r.getServerName(), r.getServerPort(), this.getOrderId());
    }

    public String getReturnButtonText() {
        return this.getPayPalWPSPlugin().getReturnButtonText();
    }

    public String getReturnCancelURL() {
        HttpServletRequest r = this.getRequest();
        return this.getPayPalWPSPlugin().getReturnCancelURL(r.getScheme(), r.getServerName(), r.getServerPort(), this.getOrderId());
    }

    public String getSubmitURL() {
        return this.getPayPalWPSPlugin().getSubmitURL();
    }

    public String getUserEmail() {
        return this.getPayPalWPSPlugin().getUserEmail(this.getUser());
    }

    public String getIpnURL() {
        return this.getPayPalWPSPlugin().getIpnURL();
    }

    private PayPalWPSPlugin getPayPalWPSPlugin() {
        return (PayPalWPSPlugin)PluginManager.getInstance().getPluginByClass(PayPalWPSPlugin.class);
    }
}

