/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.rbsworldpay;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.pages.BasePaymentGatewayPage;
import biz.papercut.pcng.ext.paymentgateway.rbsworldpay.RBSWorldPayPlugin;
import biz.papercut.pcng.ext.paymentgateway.rbsworldpay.RBSWorldPayRedirect;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnRBSWorldPay
extends BasePaymentGatewayPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnRBSWorldPay.class);
    public static final String PAGE_NAME = "ExtnRBSWorldPay";

    @Override
    public abstract AccountManager getAccountManager();

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(this.createAmountsModel());
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!this.getRBSWorldPayPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getRBSWorldPayPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
            }
        }
    }

    public void formSubmit(IRequestCycle cycle) {
        if (this.getAmount() == null) {
            this.addErrorMessage("Please select an amount to add");
            return;
        }
        RBSWorldPayRedirect redirectPage = (RBSWorldPayRedirect)cycle.getPage("RBSWorldPayRedirect");
        redirectPage.activate(cycle, this.getAmount());
    }

    public void redirectToSummaryPage(IRequestCycle cycle) {
        cycle.activate("UserSummary");
    }

    @Override
    public BasePaymentGatewayPlugin getPlugin() {
        return this.getRBSWorldPayPlugin();
    }

    public void activateExternalPage(Object[] arguments, IRequestCycle cycle) {
        HttpServletRequest r = this.getRequest();
        String success = r.getParameter("success");
        String message = r.getParameter("message");
        if (Boolean.parseBoolean(success)) {
            Object statusMessage = "Funds have been added to your account";
            if (StringUtils.isNotBlank((String)message)) {
                statusMessage = (String)statusMessage + ". " + message;
            }
            this.addStatusMessage((String)statusMessage);
        } else if (StringUtils.isBlank((String)message)) {
            this.addErrorMessage(this.getRBSWorldPayPlugin().getUserErrorMessage());
        } else {
            this.addErrorMessage(message);
        }
    }

    public String getPageContentAbove() {
        return this.getRBSWorldPayPlugin().getPageContentAbove();
    }

    public String getPageContentBelow() {
        return this.getRBSWorldPayPlugin().getPageContentBelow();
    }

    public String getLogoScriptURL() {
        return this.getRBSWorldPayPlugin().getLogoScriptURL();
    }

    private RBSWorldPayPlugin getRBSWorldPayPlugin() {
        return (RBSWorldPayPlugin)PluginManager.getInstance().getPluginByClass(RBSWorldPayPlugin.class);
    }
}

