/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.rbsworldpay;

import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.ParameterMapValuesStringBuilder;
import biz.papercut.pcng.ext.paymentgateway.PaymentGatewayRequestLogMessageBuilder;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.service.LicenseManager;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBSWorldPayPlugin
extends BasePaymentGatewayPlugin
implements WebServerPlugin {
    protected static final Logger logger = LoggerFactory.getLogger(RBSWorldPayPlugin.class);
    public static final String BASE_SERVLET_PATH = "/rpc/gateway/rbs-worldpay";
    public static final String CONFIG_PREFIX = "rbs-worldpay.";
    public static final String CONFIG_INSTALLATION_ID = "installation-id";
    public static final String CONFIG_MERCHANT_CODE = "merchant-code";
    public static final String CONFIG_TEST_MODE = "test-mode";
    @AESProperty
    public static final String CONFIG_PAYMENT_RESPONSE_PASSWORD = "rbs-worldpay.payment-response-password";
    public static final String CONFIG_MD5_HASH_VALUE = "md5-hash-value";
    public static final String CONFIG_MD5_ENCRYPTION_VALUES = "md5-encryption-values";
    public static final String CONFIG_CURRENCY = "currency";
    public static final String CONFIG_ITEM_DESCRIPTION = "item-description";
    public static final String CONFIG_PAGE_CONTENT_ABOVE = "page-content-above";
    public static final String CONFIG_PAGE_CONTENT_BELOW = "page-content-below";
    public static final String CONFIG_HOSTED_PAYMENT_PAGE_URL = "hosted-payment-page-url";
    public static final String CONFIG_USER_FACING_ADDRESS_IN_RETURN_URL = "user-facing-address-in-return-url";
    public static final String CONFIG_LOGO_SCRIPT_URL = "logo-script-url";
    public static final String CONFIG_POSTBACK_ALLOWED_IP = "postback-allowed-ip";
    public static final String PATH_TRANSACTION = "/transaction";
    public static final String PATH_RETURN = "/return";
    public static final String PATH_CHECK = "/check";
    private static final List<String> PAGES = List.of("ExtnRBSWorldPay");
    private static final String FINGERPRINT_HASH_FIELD_SEPARATOR = ":";

    @Override
    public String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    @Override
    public boolean isLicensed() {
        LicenseManager lm = (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
        return GatewayUtils.isLicensed(lm, "payment-gateways-rbs-worldpay");
    }

    public String createNewOrder(String username, double amount) {
        return this.getCreditCardGatewayPlugin().createNewOrder(username, amount);
    }

    public String getIsConfigured() {
        String errorSuffix = "  Please check the payment gateway config file.";
        if (this.getInstallationId() == null) {
            EventLog.getInstance().logEvent("Installation id not provided.");
            return "Installation id not provided." + errorSuffix;
        }
        if (this.getPaymentResponsePassword() == null) {
            EventLog.getInstance().logEvent("Payment response password not provided.");
            return "Payment response password not provided." + errorSuffix;
        }
        if (this.getCurrency() == null) {
            EventLog.getInstance().logEvent("Currency not provided.");
            return "Currency not provided." + errorSuffix;
        }
        if (this.getAllowedAmounts() == null) {
            EventLog.getInstance().logEvent("Must specify at least one allowed payment amount.");
            return "Must specify at least one allowed payment amount." + errorSuffix;
        }
        if (this.getMD5HashValue() != null && this.getMD5EncryptionValues() == null) {
            EventLog.getInstance().logEvent("MD5 Encryption values cannot be empty, if MD5 encryption is enabled.");
            return "MD5 Encryption values cannot be empty, if MD5 encryption is enabled." + errorSuffix;
        }
        URL paymentPageURL = null;
        try {
            paymentPageURL = this.getHostedPaymentPageURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (paymentPageURL == null) {
            EventLog.getInstance().logEvent("Invalid hosted payment page URL: " + this.getGatewayConfig().getString("rbs-worldpay.hosted-payment-page-url") + ".");
            return "Invalid hosted payment page URL." + errorSuffix;
        }
        return null;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return PAGES;
        }
        return null;
    }

    public void preStartupHook(WebServerPlugin.WebServer server) {
        if (!this.isPluginEnabled()) {
            return;
        }
        server.addServlet(RBSWorldPayPOSTBackServlet.class, "/rpc/gateway/rbs-worldpay/*");
    }

    public String digestMD5AsHexString(String installationId, String amount, String currency, String cartId, String desc, String name, String email, String returnURL, String merchantCode) {
        String hashKey = this.getMD5HashValue() + FINGERPRINT_HASH_FIELD_SEPARATOR;
        String values = this.getMD5EncryptionValues();
        Object message = hashKey + values.replace(",", FINGERPRINT_HASH_FIELD_SEPARATOR);
        message = StringUtils.replaceEach((String)message, (String[])new String[]{"instId", "amount", CONFIG_CURRENCY, "cartId", "desc", "name", "email", "MC_return_url", "accId1"}, (String[])new String[]{installationId, amount, currency, cartId, desc, name, email, returnURL, merchantCode});
        return StringUtils.lowerCase((String)DigestUtils.md5Hex((String)message));
    }

    public String getInstallationId() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("rbs-worldpay.installation-id"));
    }

    public String getMerchantCode() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("rbs-worldpay.merchant-code"));
    }

    public String getMD5HashValue() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("rbs-worldpay.md5-hash-value"));
    }

    public String getMD5EncryptionValues() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("rbs-worldpay.md5-encryption-values"));
    }

    public boolean isTestMode() {
        String s = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("rbs-worldpay.test-mode"));
        return s.toUpperCase().startsWith("Y");
    }

    public String getPaymentResponsePassword() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAYMENT_RESPONSE_PASSWORD));
    }

    public String getCurrency() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString("rbs-worldpay.currency"));
    }

    public String getItemDescription() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("rbs-worldpay.item-description"));
    }

    public String getPageContentAbove() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("rbs-worldpay.page-content-above"));
    }

    public String getPageContentBelow() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("rbs-worldpay.page-content-below"));
    }

    public URL getHostedPaymentPageURL() throws MalformedURLException {
        return this.getGatewayConfig().getURL("rbs-worldpay.hosted-payment-page-url");
    }

    public boolean isUserFacingAddressInReturnURL() {
        String s = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString("rbs-worldpay.user-facing-address-in-return-url"));
        return s.toUpperCase().startsWith("Y");
    }

    public String getLogoScriptURL() {
        String u = StringUtils.trimToNull((String)this.getGatewayConfig().getString("rbs-worldpay.logo-script-url"));
        return u == null ? null : u + this.getInstallationId();
    }

    protected void processTransaction(Map<String, String> parameters, String remoteAddress) {
        String msg;
        CreditCardGatewayPlugin.OrderResponse response = null;
        String orderId = parameters.get("cartId");
        String amount = parameters.get("amount");
        String currency = parameters.get(CONFIG_CURRENCY);
        String authAmount = parameters.get("authAmount");
        String authCurrency = parameters.get("authCurrency");
        String logSuffix = " Order id: " + orderId + ", payment amount: " + amount + " " + currency + ".";
        if (!this.getCurrency().equalsIgnoreCase(authCurrency)) {
            logSuffix = logSuffix + " (paid as " + authAmount + " " + authCurrency + ")";
        }
        String fullDetails = " Reported transaction details: " + RBSWorldPayPlugin.buildStringFromParameters(parameters);
        if (!this.isIPAddressValid(remoteAddress, this.getGatewayConfig().getString("rbs-worldpay.postback-allowed-ip"))) {
            msg = "Invalid IP address (" + remoteAddress + ") accessing the RBS WorldPay transaction URL. Ignoring request.";
            logger.error(msg);
            EventLog.getInstance().logEvent("ERROR: " + msg + fullDetails);
            response = new CreditCardGatewayPlugin.OrderResponse(false, "Order failed validation.");
        }
        if (!this.isValid(parameters)) {
            msg = "RBS WorldPay transaction response contains invalid payment response password. Order will not be confirmed." + logSuffix;
            logger.error("{}{}", (Object)msg, (Object)fullDetails);
            EventLog.getInstance().logEvent("ERROR: " + msg + fullDetails);
            this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
            response = new CreditCardGatewayPlugin.OrderResponse(false, "Order failed validation.");
        }
        if (response == null && !this.isTransactionApproved(parameters)) {
            msg = "Order was canceled or declined by RBS WorldPay." + logSuffix;
            logger.info(msg);
            EventLog.getInstance().logEvent(msg);
            response = new CreditCardGatewayPlugin.OrderResponse(false, "Order canceled or declined by processor.");
        }
        if (response == null) {
            Double paymentAmount = null;
            try {
                paymentAmount = Double.valueOf(amount);
            }
            catch (Exception e) {
                String msg2 = "Invalid transaction amount." + logSuffix;
                logger.error(msg2);
                EventLog.getInstance().logEvent("ERROR: " + msg2);
                this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg2);
                response = new CreditCardGatewayPlugin.OrderResponse(false, "Invalid order amount: " + amount);
            }
            if (paymentAmount != null) {
                response = this.getCreditCardGatewayPlugin().confirmOrder(orderId, paymentAmount);
                if (response.isSuccess()) {
                    String msg3 = "Order confirmed." + logSuffix;
                    logger.info(msg3);
                    EventLog.getInstance().logEvent(msg3);
                } else {
                    String msg4 = "Could not confirm RBS WorldPay order. Message: " + response.getMessage() + ". Manual reconciliation may be required." + logSuffix;
                    logger.error("{}{}", (Object)msg4, (Object)fullDetails);
                    EventLog.getInstance().logEvent("ERROR: " + msg4 + fullDetails);
                    this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg4);
                }
            }
        } else {
            this.getCreditCardGatewayPlugin().cancelOrder(orderId);
        }
    }

    protected String processUserReturn(HttpServletRequest request, Map<String, String> parameters) {
        String orderId = parameters.get("order-id");
        String message = parameters.get("message");
        CreditCardGatewayPlugin.OrderResponse response = this.getCreditCardGatewayPlugin().getExistingOrderReponse(orderId);
        if (response == null) {
            String msg = "Tried to send user back to the web interface but the provided order id does not exist or has not yet been processed.  Order id: " + orderId + ". Sending user to login page.";
            logger.error(msg);
            EventLog.getInstance().logEvent("ERROR: " + msg);
            return "/";
        }
        StringBuilder returnRedirectURL = new StringBuilder();
        returnRedirectURL.append(request.getScheme());
        returnRedirectURL.append("://");
        returnRedirectURL.append(request.getServerName());
        returnRedirectURL.append(FINGERPRINT_HASH_FIELD_SEPARATOR);
        returnRedirectURL.append(request.getServerPort());
        returnRedirectURL.append("/app?service=external/");
        returnRedirectURL.append("ExtnRBSWorldPay");
        returnRedirectURL.append("&success=");
        returnRedirectURL.append(response.isSuccess());
        if (StringUtils.isNotBlank((String)message)) {
            returnRedirectURL.append("&message=");
            returnRedirectURL.append(message);
        }
        String msg = "User returned from payment pages, redirecting to: " + String.valueOf(returnRedirectURL);
        logger.debug(msg);
        EventLog.getInstance().logEvent(msg);
        return returnRedirectURL.toString();
    }

    private boolean isValid(Map<String, String> parameters) {
        String paymentResponsePassword = StringUtils.trimToEmpty((String)parameters.get("callbackPW"));
        return paymentResponsePassword.equals(this.getPaymentResponsePassword());
    }

    private boolean isTransactionApproved(Map<String, String> parameters) {
        String transactionStatus = StringUtils.trimToEmpty((String)parameters.get("transStatus"));
        return transactionStatus.equalsIgnoreCase("Y");
    }

    private static String buildStringFromParameters(Map<String, ?> parameterMap) {
        ParameterMapValuesStringBuilder stringBuilder = new ParameterMapValuesStringBuilder(parameterMap);
        RBSWorldPayPlugin.getParametersToLog().forEach(stringBuilder::add);
        return stringBuilder.build();
    }

    private static List<String> getParametersToLog() {
        return List.of("cartId", "amount", CONFIG_CURRENCY, "authAmount", "authCurrency", "callbackPW", "transStatus", "order-id", "message");
    }

    public static class RBSWorldPayPOSTBackServlet
    extends HttpServlet {
        private final PaymentGatewayRequestLogMessageBuilder logMessageBuilder = new PaymentGatewayRequestLogMessageBuilder("RBS WorldPay servlet").withSelectedParameters(RBSWorldPayPlugin.getParametersToLog());

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.handleRequest(request, response);
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.handleRequest(request, response);
        }

        private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.debugLogRequest(request);
            Map<String, String> parameters = this.normalizeParameterValues(request.getParameterMap());
            String pathInfo = StringUtils.trimToEmpty((String)request.getPathInfo()).toLowerCase(Locale.US);
            if (pathInfo.startsWith(RBSWorldPayPlugin.PATH_TRANSACTION)) {
                this.getRBSWorldPayPlugin().processTransaction(parameters, request.getRemoteAddr());
            } else if (pathInfo.startsWith(RBSWorldPayPlugin.PATH_RETURN)) {
                String returnRedirectURL = this.getRBSWorldPayPlugin().processUserReturn(request, parameters);
                response.sendRedirect(returnRedirectURL);
            } else if (pathInfo.startsWith(RBSWorldPayPlugin.PATH_CHECK)) {
                response.getWriter().write("<html><body><h1>The WorldPay URL is accessible as of " + String.valueOf(new Date()) + "</h1><p>Remember to ensure that the URL is externally accessible (i.e. that the WorldPay server has access)</p></body></html>");
            } else {
                String msg = "RBS WorldPay URL accessed with invalid parameters: " + request.getRequestURI();
                logger.debug(msg);
                EventLog.getInstance().logEvent(msg);
                response.setStatus(404);
            }
        }

        private Map<String, String> normalizeParameterValues(Map<String, String[]> parameters) {
            HashMap<String, String> normalizedParameters = new HashMap<String, String>(parameters.size());
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                normalizedParameters.put(entry.getKey(), StringUtils.join((Object[])entry.getValue(), (String)","));
            }
            return normalizedParameters;
        }

        private RBSWorldPayPlugin getRBSWorldPayPlugin() {
            return (RBSWorldPayPlugin)PluginManager.getInstance().getPluginByClass(RBSWorldPayPlugin.class);
        }

        private void debugLogRequest(HttpServletRequest request) {
            String logMessage = this.buildLogMessageFromRequest(request);
            logger.debug(logMessage);
            EventLog.getInstance().logEvent(logMessage);
        }

        String buildLogMessageFromRequest(HttpServletRequest request) {
            return this.logMessageBuilder.buildFrom(request);
        }
    }
}

