/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.rbsworldpay;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.rbsworldpay.RBSWorldPayPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.ConfigManager;
import biz.papercut.pcng.service.NotificationUtils;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import biz.papercut.pcng.web.util.WebUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RBSWorldPayRedirect
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(RBSWorldPayRedirect.class);
    public static final String PAGE_NAME = "RBSWorldPayRedirect";

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract double getAmount();

    public abstract void setAmount(double var1);

    public abstract String getOrderId();

    public abstract void setOrderId(String var1);

    public abstract UserManager getUserManager();

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void activate(IRequestCycle cycle, double amount) {
        this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        this.setAmount(amount);
        if (this.getUser() == null) {
            WebUtils.redirectToPage((IRequestCycle)cycle, (String)"ExtnRBSWorldPay");
        }
        String orderId = this.getRBSWorldPayPlugin().createNewOrder(this.getUser().getUserName(), amount);
        this.setOrderId(orderId);
        logger.debug("Created order {} for user {}. Redirecting user to RBS WorldPay HPP.", (Object)orderId, (Object)this.getUser().getUserName());
        cycle.activate((IPage)this);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            WebUtils.redirectToPage((IRequestCycle)this.getRequestCycle(), (String)"ExtnRBSWorldPay");
        }
    }

    public String getHostedPaymentPageURL() {
        try {
            return this.getRBSWorldPayPlugin().getHostedPaymentPageURL().toString();
        }
        catch (Exception e) {
            String errorMsg = "Unable to parse hosted payment page URL: " + e.getMessage();
            logger.error(errorMsg, (Throwable)e);
            this.returnToAddCreditPageAndLogError(errorMsg);
            return null;
        }
    }

    public String getMD5DigestString() {
        return this.getRBSWorldPayPlugin().digestMD5AsHexString(this.getInstallationId(), this.getFormattedAmount(), this.getCurrency(), this.getOrderId(), this.getItemDescription(), this.getUserFullName(), this.getEmail(), this.getReturnURL(), this.getMerchantCode());
    }

    public String getInstallationId() {
        return this.getRBSWorldPayPlugin().getInstallationId();
    }

    public String getMerchantCode() {
        return this.getRBSWorldPayPlugin().getMerchantCode();
    }

    public String getMD5HashValue() {
        return this.getRBSWorldPayPlugin().getMD5HashValue();
    }

    public String getTestMode() {
        return this.getRBSWorldPayPlugin().isTestMode() ? "100" : "0";
    }

    public String getFormattedAmount() {
        return GatewayUtils.formatNumber(this.getAmount(), 2, Locale.US, false);
    }

    public String getCurrency() {
        return this.getRBSWorldPayPlugin().getCurrency();
    }

    public String getItemDescription() {
        return this.getRBSWorldPayPlugin().getItemDescription();
    }

    public String getEmail() {
        return NotificationUtils.getUserEmailAddress((ConfigManager)this.getConfigManager(), (User)this.getUser());
    }

    public String getUserFullName() {
        String fullName = this.getUser().getFullName();
        return StringUtils.trimToEmpty((String)fullName) + " (" + this.getUser().getUserName() + ")";
    }

    public String getReturnURL() {
        Object baseUrl;
        ConfigManager cm = this.getConfigManager();
        String userFacingAddress = cm.getString("system.network-address.user-facing", "");
        if (this.getRBSWorldPayPlugin().isUserFacingAddressInReturnURL() && StringUtils.isNotBlank((String)userFacingAddress)) {
            baseUrl = WebUtils.getServerBaseUrlUserFacing((ConfigManager)cm).build(new Object[0]).toString();
        } else {
            HttpServletRequest r = this.getRequest();
            baseUrl = r.getScheme() + "://" + r.getServerName() + ":" + r.getServerPort();
        }
        return (String)baseUrl + "/rpc/gateway/rbs-worldpay/return?order-id=" + this.getOrderId();
    }

    protected void returnToAddCreditPageAndLogError(String errorMsg) {
        EventLog.getInstance().logEvent(errorMsg);
        this.addErrorMessage(this.getRBSWorldPayPlugin().getUserErrorMessage());
        this.getRequestCycle().activate("ExtnRBSWorldPay");
    }

    private RBSWorldPayPlugin getRBSWorldPayPlugin() {
        return (RBSWorldPayPlugin)PluginManager.getInstance().getPluginByClass(RBSWorldPayPlugin.class);
    }
}

