/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.realex;

import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.PaymentGatewayRequestLogMessageBuilder;
import biz.papercut.pcng.ext.paymentgateway.realex.RealexRRPlugin;
import biz.papercut.pcng.ext.paymentgateway.realex.RealexRRResponse;
import biz.papercut.pcng.ext.paymentgateway.realex.TransactionVerificationResponse;
import biz.papercut.pcng.plugin.PluginManager;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealexRRPOSTBackServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(RealexRRPOSTBackServlet.class);
    private final PaymentGatewayRequestLogMessageBuilder logMessageBuilder = new PaymentGatewayRequestLogMessageBuilder("POSTback servlet").withSelectedParameters(this.getParametersToLog());

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.debugLogRequest(request);
        RealexRRResponse rrrr = new RealexRRResponse(request.getRemoteAddr(), request.getParameter("TIMESTAMP"), request.getParameter("MERCHANT_ID"), request.getParameter("ACCOUNT"), request.getParameter("ORDER_ID"), request.getParameter("AUTHCODE"), request.getParameter("RESULT"), request.getParameter("MESSAGE"), request.getParameter("CVNRESULT"), request.getParameter("PASREF"), request.getParameter("BATCHID"), request.getParameter("SHA1HASH"), request.getParameter("TSS"));
        TransactionVerificationResponse tvResult = this.getRealexRRPlugin().verifyTransaction(rrrr);
        this.sendTransactionResponsePage(response, tvResult);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.debugLogRequest(request);
        response.setContentType("text/html");
        response.getWriter().write("<html><body><h1>The Realex POSTback URL is accessible as of " + String.valueOf(new Date()) + "</h1><p>Remember to ensure that the URL is externally accessible (i.e. that the Realex server has access)</p></body></html>");
    }

    private void sendTransactionResponsePage(HttpServletResponse response, TransactionVerificationResponse tvResponse) throws IOException {
        response.setContentType("text/html");
        EventLog.getInstance().logEvent("sendTransactionResponsePage");
        if (tvResponse.isError()) {
            response.setStatus(500);
        }
        response.getWriter().write(tvResponse.getPageTemplate());
        if (logger.isDebugEnabled()) {
            logger.debug("Sending text/html response page (status={}) : {}", (Object)(tvResponse.isError() ? 500 : 200), (Object)tvResponse.getPageTemplate());
        }
    }

    private RealexRRPlugin getRealexRRPlugin() {
        return (RealexRRPlugin)PluginManager.getInstance().getPluginByClass(RealexRRPlugin.class);
    }

    private void debugLogRequest(HttpServletRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug(this.buildLogMessageFromRequest(request));
        }
    }

    String buildLogMessageFromRequest(HttpServletRequest request) {
        return this.logMessageBuilder.buildFrom(request);
    }

    private List<String> getParametersToLog() {
        return List.of("TIMESTAMP", "MERCHANT_ID", "ACCOUNT", "ORDER_ID", "AUTHCODE", "RESULT", "MESSAGE", "CVNRESULT", "PASREF", "BATCHID", "TSS");
    }
}

