/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.realex;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.BasePaymentGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.CountryRepository;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.realex.RealexRROrder;
import biz.papercut.pcng.ext.paymentgateway.realex.RealexRRPOSTBackServlet;
import biz.papercut.pcng.ext.paymentgateway.realex.RealexRRResponse;
import biz.papercut.pcng.ext.paymentgateway.realex.TransactionVerificationResponse;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.ConfigManager;
import biz.papercut.pcng.service.CreditUtilities;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.NotificationUtils;
import biz.papercut.pcng.service.UserManager;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class RealexRRPlugin
extends BasePaymentGatewayPlugin
implements WebServerPlugin {
    private static final Log logger = LogFactory.getLog(RealexRRPlugin.class);
    public static final String CONFIG_PREFIX = "realex-rr.";
    public static final String CONFIG_ALLOWED_GROUPS = "realex-rr.allowed-groups";
    public static final String CONFIG_ALLOWED_AMOUNTS = "realex-rr.allowed-amounts";
    public static final String CONFIG_CURRENCY = "realex-rr.currency";
    public static final String CONFIG_THREE_D_SECURE_ENABLED = "realex-rr.3ds.enabled";
    public static final String CONFIG_THREE_D_SECURE_FORM_ELEMENTS = "realex-rr.3ds.form-elements";
    public static final String CONFIG_THREE_D_SECURE_PROMPT_STRING = "realex-rr.3ds.prompt-string";
    public static final String CONFIG_THREE_D_SECURE_DEFAULT_COUNTRY = "realex-rr.3ds.default-country-code";
    public static final String CONFIG_ENABLED = "realex-rr.enabled";
    public static final String CONFIG_FAILURE_NO_CHARGE_MESSAGE = "realex-rr.failure-no-charge-message";
    public static final String CONFIG_FAILURE_POSSIBLE_CHARGE_MESSAGE = "realex-rr.failure-possible-charge-message";
    public static final String CONFIG_HOSTED_ORDER_PAGE_URL = "realex-rr.hosted-order-page-url";
    public static final String CONFIG_MERCHANT_ID = "realex-rr.merchant-id";
    public static final String CONFIG_PAGE_TITLE = "realex-rr.page-title";
    public static final String CONFIG_PAGE_HEADING = "realex-rr.page-heading";
    public static final String CONFIG_POSTBACK_ALLOWED_IP = "postback-allowed-ip";
    @AESProperty
    public static final String CONFIG_SHARED_SECRET = "realex-rr.shared-secret";
    public static final String CONFIG_SUB_ACCOUNT_NAME = "realex-rr.sub-account-name";
    public static final String CONFIG_SUCCESS_MESSAGE = "realex-rr.success-message";
    public static final String CONFIG_TRANSACTION_COMMENT = "realex-rr.transaction-comment";
    public static final String POSTBACK_URL_PATH = "/rpc/gateway/realex-rr";
    public static final String REQUEST_CUSTOM_FIELD_RETURN_REDIRECT_URL = "RETURN_REDIRECT_URL";
    public static final String REQUEST_CUSTOM_FIELD_USER_NAME = "USER_NAME";
    public static final String REQUEST_CUSTOM_FIELD_USER_FULL_NAME = "USER_FULL_NAME";
    public static final String REQUEST_CUSTOM_FIELD_USER_EMAIL = "USER_EMAIL";
    private static final String ALGORITHM_NAME_SHA_1 = "SHA";
    private static final List<String> ADDITIONAL_PAGES = List.of("ExtnRealexRR");
    private static final int MAX_ORDER_NUMBER_LENGTH = 40;
    private volatile ApplicationContext _applicationContext;
    private final Map<String, RealexRROrder> _realexOrders = Collections.synchronizedMap(new HashMap());

    @Override
    public boolean isPluginEnabled() {
        Boolean enabled = this.getGatewayConfig().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    @Override
    public boolean isAccessibleByUser(String username) {
        return GatewayUtils.isAccessibleByUser(username, CONFIG_ALLOWED_GROUPS, this.getUserManager());
    }

    @Override
    public String getConfigPrefix() {
        return CONFIG_PREFIX;
    }

    @Override
    public boolean isLicensed() {
        return GatewayUtils.isLicensed(this.getLicenseManager(), "payment-gateways-realex-rr");
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return ADDITIONAL_PAGES;
        }
        return null;
    }

    public void preStartupHook(WebServerPlugin.WebServer server) {
        if (!this.isPluginEnabled()) {
            return;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            server.listenOnPort(80);
        }
        server.addServlet(RealexRRPOSTBackServlet.class, "/rpc/gateway/realex-rr/*");
    }

    public String getIsConfigured() {
        String errorSuffix = "  Please check the payment gateway config file.";
        try {
            MessageDigest.getInstance(ALGORITHM_NAME_SHA_1);
        }
        catch (NoSuchAlgorithmException nsae) {
            String error = "Required cryptographic functionality is not present.  Contact support for assistance.";
            this.logError(error, false);
            return error;
        }
        if (this.getMerchantId() == null) {
            String error = "Merchant id not provided.";
            this.logError(error, false);
            return error + errorSuffix;
        }
        this.logDebug("currency determined is " + this.getCurrency());
        if (this.getCurrency() == null) {
            String error = "Currency not provided.";
            this.logError(error, false);
            return error + errorSuffix;
        }
        if (this.getAllowedAmounts() == null) {
            String error = "Must specify at least one allowed payment amount.";
            this.logError(error, false);
            return error + errorSuffix;
        }
        if (this.getThreeDSecureEnabled()) {
            if (this.getThreeDSecureFormElements() == null) {
                String error = "Must specify the form elements for 3DS/SCA compliance.";
                this.logError(error, false);
                return error + errorSuffix;
            }
            if (this.getThreeDSecureDefaultCountryCode() != null && CountryRepository.getInstance().getDefaultCountry() == null) {
                Optional<CountryRepository.Country> defaultCountry = CountryRepository.getInstance().findCountryByCode(this.getThreeDSecureDefaultCountryCode());
                if (defaultCountry.isPresent()) {
                    CountryRepository.getInstance().setDefaultCountry(defaultCountry.get());
                } else {
                    String error = "Invalid Country Code.";
                    this.logError(error, false);
                    return error + errorSuffix;
                }
            }
        }
        URL orderPageURL = null;
        try {
            orderPageURL = this.getHostedOrderPageURL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (orderPageURL == null) {
            this.logError("Invalid hosted order page URL: " + this.getGatewayConfig().getString("realex-rr.realex-rr.hosted-order-page-url") + ".", false);
            return "Invalid hosted order page URL." + errorSuffix;
        }
        return null;
    }

    public String createNewOrder(String userName, double amount, String returnRedirectURL) {
        String orderId = this.getCreditCardGatewayPlugin().createNewOrder(userName, amount, 40);
        EventLog.getInstance().logEvent("orderId for realex transaction " + orderId);
        returnRedirectURL = (String)returnRedirectURL + "&order-id=" + orderId;
        RealexRROrder realexOrder = new RealexRROrder(false, userName, amount, (String)returnRedirectURL, false, null, this.getCurrency());
        this._realexOrders.put(orderId, realexOrder);
        EventLog.getInstance().logEvent("orderId processed");
        return orderId;
    }

    @Override
    public String getAllowedAmounts() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_ALLOWED_AMOUNTS));
    }

    public boolean getThreeDSecureEnabled() {
        Boolean enabled = this.getGatewayConfig().getBoolean(CONFIG_THREE_D_SECURE_ENABLED);
        return enabled != null && enabled != false;
    }

    public String getThreeDSecureFormElements() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_THREE_D_SECURE_FORM_ELEMENTS));
    }

    public String getCurrency() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_CURRENCY));
    }

    public URL getHostedOrderPageURL() throws MalformedURLException {
        return this.getGatewayConfig().getURL(CONFIG_HOSTED_ORDER_PAGE_URL);
    }

    public String getMerchantId() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_MERCHANT_ID));
    }

    @Override
    public String getPageTitle() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_TITLE));
    }

    @Override
    public String getPageHeading() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_HEADING));
    }

    public String getRealexSubAccountName() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_SUB_ACCOUNT_NAME));
    }

    public String getTransactionComment() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_TRANSACTION_COMMENT));
    }

    public String getThreeDSecurePromptString() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_THREE_D_SECURE_PROMPT_STRING));
    }

    public String getThreeDSecureDefaultCountryCode() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_THREE_D_SECURE_DEFAULT_COUNTRY));
    }

    public String calculateSHA1HashForOrder(String timestamp, String orderId, String formattedAmount) {
        String run1Data = timestamp + "." + this.getMerchantId() + "." + orderId + "." + formattedAmount + "." + this.getCurrency();
        String run1Hash = this.calculateSHA1Hash(run1Data);
        String run2Data = run1Hash + "." + this.getSharedSecret();
        return this.calculateSHA1Hash(run2Data);
    }

    public String calculateSHA1HashForResponse(String timestamp, String orderId, String resultCode, String resultMessage, String transactionId, String authcode) {
        String run1Data = timestamp + "." + this.getMerchantId() + "." + orderId + "." + resultCode + "." + resultMessage + "." + transactionId + "." + authcode;
        String run1Hash = this.calculateSHA1Hash(run1Data);
        String run2Data = run1Hash + "." + this.getSharedSecret();
        return this.calculateSHA1Hash(run2Data);
    }

    protected String calculateSHA1Hash(String data) {
        String digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM_NAME_SHA_1);
            md.update(data.getBytes());
            byte[] digestBytes = md.digest();
            digest = String.valueOf(Hex.encodeHex((byte[])digestBytes));
        }
        catch (Exception e) {
            this.logError("Unable to calculate signature: " + e.getMessage(), false);
        }
        return digest;
    }

    public String getSharedSecret() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_SHARED_SECRET));
    }

    public synchronized TransactionVerificationResponse verifyTransaction(RealexRRResponse rr) {
        this.logInfo("Receiving transaction details from " + rr.getRemoteAddress());
        RealexRROrder realexOrder = this._realexOrders.get(rr.getOrderId());
        if (realexOrder == null) {
            this.logWarn("Unknown order ID: " + rr.getOrderId() + ". Ignoring order and sending error page.", true);
            return new TransactionVerificationResponse(true, this.formatFailurePossibleChargeMessage(rr, null));
        }
        if (!GatewayUtils.isIPAddressValid(rr.getRemoteAddress(), this.getGatewayConfig().getString(CONFIG_POSTBACK_ALLOWED_IP))) {
            this.logWarn("Denying access from disallowed IP address: " + rr.getRemoteAddress(), true);
            return new TransactionVerificationResponse(true, this.formatFailurePossibleChargeMessage(rr, null));
        }
        String calculatedHash = this.calculateSHA1HashForResponse(rr.getTimestamp(), rr.getOrderId(), rr.getResultCode(), rr.getResultMessage(), rr.getTransactionId(), rr.getAuthcode());
        this.logDebug("Calculated digest on '" + String.valueOf(rr) + "': '" + calculatedHash + "', expected: '" + rr.getSha1Hash() + "'");
        if (!calculatedHash.equals(rr.getSha1Hash())) {
            this.logWarn("Received transaction response with an invalid digest. Configuration error or possible attack attempt. Ensure that the configured shared secret is correct.", true);
            return new TransactionVerificationResponse(true, this.formatFailurePossibleChargeMessage(rr, realexOrder));
        }
        this._realexOrders.remove(rr.getOrderId());
        if (!rr.isResultCodeSuccess()) {
            this.logInfo("Realex reported failed transaction for order id " + rr.getOrderId() + ". Code: " + rr.getResultCode() + ", message: " + rr.getResultMessage());
            return new TransactionVerificationResponse(false, this.formatFailureNoChargeMessage(rr, realexOrder));
        }
        this.logInfo("Realex reported successful transaction for order id " + rr.getOrderId() + ". Completing order.");
        EventLog.getInstance().logEvent("Realex reported successful transaction for order id " + rr.getOrderId() + ". Completing order.");
        CreditCardGatewayPlugin.OrderResponse orderResponse = this.getCreditCardGatewayPlugin().confirmOrder(rr.getOrderId());
        EventLog.getInstance().logEvent("end of transaction verify.");
        if (orderResponse.isSuccess()) {
            this.logInfo("Order " + rr.getOrderId() + " completed.");
            String redirectURL = realexOrder.getReturnRedirectURL() + "&success=true";
            realexOrder = new RealexRROrder(true, realexOrder.getUserName(), realexOrder.getAmount(), redirectURL, true, rr.getResultMessage(), this.getCurrency());
            return new TransactionVerificationResponse(false, this.formatSuccessMessage(rr, realexOrder));
        }
        this.logError("Could not confirm order " + rr.getOrderId() + ", message: " + orderResponse.getMessage(), true);
        String redirectURL = realexOrder.getReturnRedirectURL() + "&success=false";
        realexOrder = new RealexRROrder(true, realexOrder.getUserName(), realexOrder.getAmount(), redirectURL, true, rr.getResultMessage(), this.getCurrency());
        return new TransactionVerificationResponse(true, this.formatFailurePossibleChargeMessage(rr, realexOrder));
    }

    private String formatSuccessMessage(RealexRRResponse rr, RealexRROrder realexOrder) {
        String template = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_SUCCESS_MESSAGE));
        return this.formatMessage(template, rr, realexOrder);
    }

    private String formatFailurePossibleChargeMessage(RealexRRResponse rr, RealexRROrder realexOrder) {
        String template = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_FAILURE_POSSIBLE_CHARGE_MESSAGE));
        return this.formatMessage(template, rr, realexOrder);
    }

    private String formatFailureNoChargeMessage(RealexRRResponse rr, RealexRROrder realexOrder) {
        String template = StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_FAILURE_NO_CHARGE_MESSAGE));
        return this.formatMessage(template, rr, realexOrder);
    }

    private String formatMessage(String template, RealexRRResponse rr, RealexRROrder realexOrder) {
        HashMap<String, String> notificationData = new HashMap<String, String>();
        User user = null;
        if (realexOrder != null) {
            String formattedAmount = this.getCreditUtilities().formatCost(realexOrder.getAmount(), Locale.getDefault());
            notificationData.put("amount", formattedAmount);
            notificationData.put("return-url", realexOrder.getReturnRedirectURL());
            user = this.getUserManager().getUser(realexOrder.getUserName());
        }
        notificationData.put("response-code", rr.getResultCode());
        notificationData.put("response-message", rr.getResultMessage());
        String formattedMessage = NotificationUtils.formatMessage((ConfigManager)this.getConfigManager(), (CreditUtilities)this.getCreditUtilities(), (String)template, user, notificationData);
        formattedMessage = formattedMessage.replaceAll("\u00a3", "&pound;").replaceAll("\u20ac", "&euro;");
        return formattedMessage;
    }

    private void logDebug(String msg) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)msg);
            EventLog.getInstance().logEvent("DEBUG: " + msg);
        }
    }

    private void logInfo(String msg) {
        logger.info((Object)msg);
        EventLog.getInstance().logEvent(msg);
    }

    private void logWarn(String msg, boolean doAppLog) {
        logger.warn((Object)msg);
        EventLog.getInstance().logEvent("WARN: " + msg);
        if (doAppLog) {
            this.getApplicationLogManager().logRaw(null, ApplicationLogLevelEnum.WARNING, "Realex payment gateway: " + msg);
        }
    }

    private void logError(String msg, boolean doAppLog) {
        logger.error((Object)msg);
        EventLog.getInstance().logEvent("ERROR: " + msg);
        if (doAppLog) {
            this.getApplicationLogManager().logRaw(null, ApplicationLogLevelEnum.ERROR, "Realex payment gateway: " + msg);
        }
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        this._applicationContext = applicationContext;
    }

    @Override
    protected ApplicationLogManager getApplicationLogManager() {
        return (ApplicationLogManager)this.getApplicationContext().getBean("applicationLogManager", ApplicationLogManager.class);
    }

    protected CreditUtilities getCreditUtilities() {
        return (CreditUtilities)this.getApplicationContext().getBean("creditUtilities", CreditUtilities.class);
    }

    protected LicenseManager getLicenseManager() {
        return (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
    }

    @Override
    protected UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    protected ConfigManager getConfigManager() {
        return (ConfigManager)this.getApplicationContext().getBean("configManager", ConfigManager.class);
    }
}

