/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.touchnet;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.touchnet.TouchNetPlugin;
import biz.papercut.pcng.ext.paymentgateway.touchnet.TouchNetRedirect;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.Formatter;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.request.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnTouchNet
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    private static final Logger logger = LoggerFactory.getLogger(ExtnTouchNet.class);
    public static final String PAGE_NAME = ExtnTouchNet.class.getSimpleName();

    @Nullable
    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract double getAmount();

    @Nullable
    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract AccountManager getAccountManager();

    public abstract ApplicationLogManager getApplicationLogManager();

    public abstract UserManager getUserManager();

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public String getUserName() {
        return this.getUser().getUserName();
    }

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void addErrorMessage(@Nullable String customMessage) {
        Object errorMessage = this.getTouchNetPlugin().getUserErrorMessage();
        if (StringUtils.isNotBlank((String)customMessage)) {
            errorMessage = customMessage + " " + (String)errorMessage;
        }
        super.addErrorMessage((String)errorMessage);
    }

    public void activateExternalPage(Object[] parameters, IRequestCycle cycle) {
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            User user = this.getUserManager().getUser(this.getPaperCutVisit().getUserName());
            if (user == null) {
                throw new IllegalStateException("Unknown logged in user: " + this.getPaperCutVisit().getUserName());
            }
            this.setUser(user);
        }
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(GatewayUtils.createAllowedAmountsModel("touchnet.allowed-amounts", (BasePaperCutPage)this));
        }
        if (!event.getRequestCycle().isRewinding()) {
            String configError;
            String qs = this.getRequest().getQueryString();
            if (qs == null) {
                qs = "";
            }
            if (!this.getTouchNetPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = this.getTouchNetPlugin().getIsConfigured(this.getUser())) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
            }
            if (qs.contains("status=error")) {
                this.cancelOrder(this.getRequestCycle().getRequestContext().getParameter("EXT_TRANS_ID"), true);
            } else if (qs.contains("status=success")) {
                double amountAdded;
                RequestContext rc = this.getRequestCycle().getRequestContext();
                String sessionId = rc.getParameter("session_identifier");
                String orderId = rc.getParameter("EXT_TRANS_ID");
                String amountAddedParam = rc.getParameter("pmt_amt");
                if (StringUtils.isBlank((String)sessionId) || StringUtils.isBlank((String)orderId) || StringUtils.isBlank((String)amountAddedParam) || !this.getTouchNetPlugin().isOrderExists(orderId)) {
                    this.logError("TouchNet payment gateway received bad payment authorization request from " + this.getRequest().getRemoteAddr() + ", session ID: " + sessionId + ", order ID: " + orderId + ", amount: " + amountAddedParam + ". Ignoring.", true);
                    this.addErrorMessage(null);
                    return;
                }
                try {
                    amountAdded = Double.parseDouble(amountAddedParam);
                }
                catch (NumberFormatException nfe) {
                    this.addErrorMessage(null);
                    return;
                }
                this.completeOrder(sessionId, orderId, amountAdded);
            } else if (qs.contains("status=cancel")) {
                this.cancelOrder(this.getRequestCycle().getRequestContext().getParameter("EXT_TRANS_ID"), false);
            }
        }
    }

    public void formSubmit(IRequestCycle cycle) {
        if (this.getAmount() <= 0.0) {
            this.addErrorMessage("Please select an amount to add");
            return;
        }
        TouchNetRedirect redirectPage = (TouchNetRedirect)cycle.getPage("TouchNetRedirect");
        redirectPage.activate(cycle, this.getUser(), this.getAmount());
    }

    public String getNoAccessMsg() {
        return GatewayConfig.getInstance().getNoAccessMessage();
    }

    public String getPageTitle() {
        String title = this.getTouchNetPlugin().getPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public String getHeading() {
        return this.getTouchNetPlugin().getPageHeading();
    }

    public boolean isAccessibleByUser() {
        return this.getTouchNetPlugin().isAccessibleByUser(this.getUserName());
    }

    public String formatAmount(double amount) {
        return Formatter.formatNumber((double)amount, (int)2, (Locale)Locale.US);
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public String getPageMessage() {
        return ExtnTouchNet.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return ExtnTouchNet.getGatewayConfig().getPageMessageAvailable();
    }

    private void logError(String msg, boolean doAppLog) {
        logger.error(msg);
        EventLog.getInstance().logEvent("ERROR: " + msg);
        if (doAppLog) {
            this.getApplicationLogManager().logRaw(null, ApplicationLogLevelEnum.ERROR, "TouchNet payment gateway: " + msg);
        }
    }

    private void completeOrder(String sessionId, String orderId, double amountAdded) {
        if (this.getTouchNetPlugin().confirmOrder(sessionId, orderId, amountAdded, this.getUser().getUserName())) {
            this.addStatusMessage(this.formatCost(amountAdded) + " has been added to your account");
        } else {
            this.addErrorMessage(null);
        }
    }

    private void cancelOrder(String orderId, boolean error) {
        if (StringUtils.isNotBlank((String)orderId)) {
            if (error) {
                this.addErrorMessage(null);
            } else {
                String statusMsg = "User opted to cancel payment in uPay, order ID: " + orderId;
                if (logger.isDebugEnabled()) {
                    logger.debug(statusMsg);
                }
                EventLog.getInstance().logEvent(statusMsg);
                this.addWarningMessage("Your payment was cancelled");
            }
            this.getTouchNetPlugin().cancelOrder(orderId);
        }
    }

    private TouchNetPlugin getTouchNetPlugin() {
        return (TouchNetPlugin)PluginManager.getInstance().getPluginByClass(TouchNetPlugin.class);
    }
}

