/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.touchnet;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.touchnet.ExtnTouchNet;
import biz.papercut.pcng.ext.paymentgateway.util.SOAPLogMessageHandler;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.NetworkUtils;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import com.touchnet.securelink.service.SecureLinkException;
import com.touchnet.securelink.service.TPGSecureLink;
import com.touchnet.securelink.service.TPGSecureLink_Service;
import com.touchnet.securelink.types.AuthorizeAccountRequest;
import com.touchnet.securelink.types.AuthorizeAccountResponse;
import com.touchnet.securelink.types.GenerateSecureLinkTicketRequest;
import com.touchnet.securelink.types.GenerateSecureLinkTicketResponse;
import com.touchnet.securelink.types.NameValuePair;
import jakarta.xml.ws.BindingProvider;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class TouchNetPlugin
implements UserLinkPlugin,
SpringContextPlugin,
EnableablePlugin {
    private static final Logger logger = LoggerFactory.getLogger(TouchNetPlugin.class);
    private static final String CONFIG_PREFIX = "touchnet.";
    private static final String CONFIG_PAGE_TITLE = "touchnet.page-title";
    private static final String CONFIG_PAGE_HEADING = "touchnet.page-heading";
    private static final String CONFIG_ENABLED = "touchnet.enabled";
    private static final String CONFIG_UPAY_SITE_URL = "touchnet.upay-site-url";
    private static final String CONFIG_UPAY_SITE_ID = "touchnet.upay-site-id";
    private static final String CONFIG_UPAY_SITE_ID_BY_GROUP = "touchnet.upay-site-id-override-by-group";
    private static final String CONFIG_UPAY_WS_ENDPOINT = "touchnet.web-service-endpoint";
    private static final String CONFIG_USERNAME = "touchnet.username";
    @AESProperty
    public static final String CONFIG_PASSWORD = "touchnet.password";
    private static final String CONFIG_ALLOWED_GROUPS = "touchnet.allowed-groups";
    protected static final String CONFIG_ALLOWED_AMOUNTS = "touchnet.allowed-amounts";
    private static final String CONFIG_AUTO_POPULATE_FULL_NAME = "touchnet.auto-populate-full-name";
    private static final String CONFIG_AUTO_POPULATE_EMAIL = "touchnet.auto-populate-email";
    private static final String CONFIG_SUCCESS_LINK_TEXT = "touchnet.success-link-text";
    private static final String CONFIG_ERROR_LINK_TEXT = "touchnet.error-link-text";
    private static final String CONFIG_CANCEL_LINK_TEXT = "touchnet.cancel-link-text";
    private static final String CONFIG_USE_CONFIGURED_LINKS = "touchnet.use-configured-links";
    private static final String DEFAULT_RETURN_LINK_TEXT = "Continue";
    private static final String DEFAULT_CANCEL_LINK_TEXT = "Cancel";
    public static final String RETURN_STATUS_SUCCESS = "success";
    public static final String RETURN_STATUS_ERROR = "error";
    public static final String RETURN_STATUS_CANCEL = "cancel";
    private static final List<String> ADDITIONAL_PAGES = List.of(ExtnTouchNet.PAGE_NAME);
    private static final TPGSecureLink_Service TPG_SECURE_LINK_SERVICE = SOAPLogMessageHandler.attachPayloadLogger(new TPGSecureLink_Service(TPGSecureLink_Service.class.getResource("secureLink-partner.wsdl"), new QName("http://service.secureLink.touchnet.com", "TPGSecureLink")), TPGSecureLink_Service.class);
    @Nullable
    private ApplicationContext _ctx;

    public boolean isPluginEnabled() {
        Boolean enabled = this.getGatewayConfig().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public boolean isLicensed() {
        return GatewayUtils.isLicensed(this.getLicenseManager(), "payment-gateways-touchnet");
    }

    @CheckForNull
    public String getIsConfigured(User user) {
        String errorSuffix = " Please check the payment gateway config file.";
        String uPayWSEndpoint = this.getUPayWSEndpoint();
        if (uPayWSEndpoint != null) {
            try {
                new URL(uPayWSEndpoint);
            }
            catch (Exception e) {
                uPayWSEndpoint = null;
            }
        }
        if (uPayWSEndpoint == null) {
            EventLog.getInstance().logEvent("The configured uPay web service endpoint is invalid: \"" + uPayWSEndpoint + "\"");
            return "The uPay web service endpoint is invalid. Please check the payment gateway config file.";
        }
        String uPaySite = this.getUPaySiteURL();
        try {
            new URL(uPaySite);
        }
        catch (Exception e) {
            EventLog.getInstance().logEvent("The configured uPay site URL is invalid: \"" + uPaySite + "\"");
            return "The uPay site URL is invalid. Please check the payment gateway config file.";
        }
        if (this.getUsername() == null) {
            String error = "TouchNet username not provided.";
            this.logError(error, false);
            return error + errorSuffix;
        }
        if (this.getPassword() == null) {
            String error = "TouchNet password not provided.";
            this.logError(error, false);
            return error + errorSuffix;
        }
        if (this.getUPaySiteId(user) == null) {
            String error = "uPay site id not provided.";
            this.logError(error, false);
            return error + errorSuffix;
        }
        return null;
    }

    public boolean isAccessibleByUser(String username) {
        return GatewayUtils.isAccessibleByUser(username, CONFIG_ALLOWED_GROUPS, this.getUserManager());
    }

    @Nullable
    private String getUsername() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_USERNAME));
    }

    @Nullable
    private String getPassword() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PASSWORD));
    }

    @Nullable
    protected String getUPaySiteId(User user) {
        GatewayUtils.GroupIdMap idmap;
        String id;
        String siteIdGroupConfig = this.getGatewayConfig().getString(CONFIG_UPAY_SITE_ID_BY_GROUP);
        if (StringUtils.isNotBlank((String)siteIdGroupConfig) && StringUtils.isNotBlank((String)(id = (idmap = new GatewayUtils.GroupIdMap(siteIdGroupConfig)).lookupIdForUser(user)))) {
            return id;
        }
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_UPAY_SITE_ID));
    }

    @CheckForNull
    private String getUPayWSEndpoint() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_UPAY_WS_ENDPOINT));
    }

    @Nullable
    protected String getUPaySiteURL() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_UPAY_SITE_URL));
    }

    @CheckForNull
    public String getPageTitle() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_TITLE));
    }

    @Nullable
    public String getPageHeading() {
        return StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_PAGE_HEADING));
    }

    public boolean isAutoPopulateFullName() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean(CONFIG_AUTO_POPULATE_FULL_NAME));
    }

    public boolean isAutoPopulateEmail() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean(CONFIG_AUTO_POPULATE_EMAIL));
    }

    public String getSuccessLinkText() {
        String s = StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_SUCCESS_LINK_TEXT));
        if (s == null) {
            s = DEFAULT_RETURN_LINK_TEXT;
        }
        return s;
    }

    public String getErrorLinkText() {
        String s = StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_ERROR_LINK_TEXT));
        if (s == null) {
            s = DEFAULT_RETURN_LINK_TEXT;
        }
        return s;
    }

    public String getCancelLinkText() {
        String s = StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_CANCEL_LINK_TEXT));
        if (s == null) {
            s = DEFAULT_CANCEL_LINK_TEXT;
        }
        return s;
    }

    public boolean useConfiguredLinks() {
        return BooleanUtils.toBoolean((String)this.getGatewayConfig().getString(CONFIG_USE_CONFIGURED_LINKS));
    }

    @CheckForNull
    public String createTicket(User user, double amount, String scheme, String serverName, int serverPort) {
        String orderId = this.getCCGatewayPlugin().createNewOrder(user.getUserName(), amount);
        GenerateSecureLinkTicketResponse ticket = this.sendTicketRequest(user, orderId, amount, scheme, serverName, serverPort);
        return ticket == null ? null : ticket.getTicket();
    }

    public boolean isOrderExists(String orderId) {
        return this.getCCGatewayPlugin().isOrderExists(orderId);
    }

    public boolean confirmOrder(String sessionId, String orderId, double amountAdded, String userName) {
        String receiptNum;
        if (!GatewayConfig.getInstance().getDoubleList(CONFIG_ALLOWED_AMOUNTS).contains(amountAdded)) {
            return false;
        }
        AuthorizeAccountResponse authResponse = this.sendAuthorizeRequest(sessionId, orderId, userName);
        if (authResponse == null) {
            String errorMsg = "Order " + orderId + " cancelled due to error authorizing payment with uPay.";
            logger.error(errorMsg);
            EventLog.getInstance().logEvent(errorMsg);
            this.cancelOrder(orderId);
            return false;
        }
        if (authResponse.getCreditResponse() != null) {
            receiptNum = authResponse.getCreditResponse().getReceiptNumber();
        } else if (authResponse.getAchResponse() != null) {
            receiptNum = authResponse.getAchResponse().getReceiptNumber();
        } else {
            String errorMsg = "Unable to confirm order " + orderId + ": could not find a receipt number.";
            logger.error(errorMsg);
            EventLog.getInstance().logEvent(errorMsg);
            this.cancelOrder(orderId);
            return false;
        }
        String statusMsg = "Payment for order " + orderId + " authorized by uPay, receipt number: " + receiptNum;
        if (logger.isDebugEnabled()) {
            logger.debug(statusMsg);
        }
        EventLog.getInstance().logEvent(statusMsg);
        CreditCardGatewayPlugin.OrderResponse orderResponse = this.getCCGatewayPlugin().confirmOrder(orderId, amountAdded);
        return orderResponse.isSuccess();
    }

    public void cancelOrder(String orderId) {
        if (this.getCCGatewayPlugin().isOrderExists(orderId)) {
            String statusMsg = "Cancelling order " + orderId;
            if (logger.isDebugEnabled()) {
                logger.debug(statusMsg);
            }
            EventLog.getInstance().logEvent(statusMsg);
            this.getCCGatewayPlugin().cancelOrder(orderId);
        } else {
            String errorMsg = "Tried to cancel order " + orderId + ", but no order by that ID exists.";
            logger.error(errorMsg);
            EventLog.getInstance().logEvent(errorMsg);
        }
    }

    private CreditCardGatewayPlugin getCCGatewayPlugin() {
        return (CreditCardGatewayPlugin)PluginManager.getInstance().getPluginByClass(CreditCardGatewayPlugin.class);
    }

    public String getUserErrorMessage() {
        return this.getGatewayConfig().getUserErrorMessage();
    }

    private TPGSecureLink getPort() {
        TPGSecureLink port = TPG_SECURE_LINK_SERVICE.getTPGSecureLink();
        Map rc = ((BindingProvider)port).getRequestContext();
        rc.put("jakarta.xml.ws.service.endpoint.address", this.getUPayWSEndpoint());
        rc.put("jakarta.xml.ws.security.auth.username", this.getUsername());
        rc.put("jakarta.xml.ws.security.auth.password", this.getPassword());
        try {
            rc.put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", NetworkUtils.getTrustAllSSLSocketFactory());
        }
        catch (Exception e) {
            logger.warn("Failed to configure per-connection security for TouchNet. Applying application-wide settings.");
            try {
                NetworkUtils.setupHTTPSToIgnoreHostnameAndTrustErrors();
            }
            catch (Exception e2) {
                logger.error("Failed to configure TouchNet security settings.");
            }
        }
        return port;
    }

    @CheckForNull
    private GenerateSecureLinkTicketResponse sendTicketRequest(User user, String orderId, double amount, String scheme, String serverName, int serverPort) {
        String userEmail;
        String userFullName;
        String ticketName = user.getUserName();
        String amountFormatted = GatewayUtils.formatNumber(amount, 2, Locale.US, false);
        String successLink = this.buildReturnURL(scheme, serverName, serverPort, RETURN_STATUS_SUCCESS);
        String errorLink = this.buildReturnURL(scheme, serverName, serverPort, RETURN_STATUS_ERROR);
        String cancelLink = this.buildReturnURL(scheme, serverName, serverPort, RETURN_STATUS_CANCEL);
        String statusMsg = "Calling uPay web service to get a ticket for " + user.getUserName() + ". Order ID: " + orderId + ", amount: " + amountFormatted;
        if (logger.isDebugEnabled()) {
            logger.debug(statusMsg);
        }
        EventLog.getInstance().logEvent(statusMsg);
        GenerateSecureLinkTicketRequest ticketRequest = new GenerateSecureLinkTicketRequest();
        ticketRequest.setTicketName(ticketName);
        this.addRequestOption(ticketRequest, RequestOption.TransactionId, orderId);
        this.addRequestOption(ticketRequest, RequestOption.Amount, amountFormatted);
        if (!this.useConfiguredLinks()) {
            this.addRequestOption(ticketRequest, RequestOption.SuccessLink, successLink);
            this.addRequestOption(ticketRequest, RequestOption.SuccessLinkText, this.getSuccessLinkText());
            this.addRequestOption(ticketRequest, RequestOption.ErrorLink, errorLink);
            this.addRequestOption(ticketRequest, RequestOption.ErrorLinkText, this.getErrorLinkText());
            this.addRequestOption(ticketRequest, RequestOption.CancelLink, cancelLink);
            this.addRequestOption(ticketRequest, RequestOption.CancelLinkText, this.getCancelLinkText());
        }
        if (this.isAutoPopulateFullName() && StringUtils.isNotBlank((String)(userFullName = user.getFullName()))) {
            this.addRequestOption(ticketRequest, RequestOption.BillingName, userFullName);
        }
        if (this.isAutoPopulateEmail() && StringUtils.isNotBlank((String)(userEmail = user.getEmail()))) {
            this.addRequestOption(ticketRequest, RequestOption.BillingEmail, userEmail);
        }
        GenerateSecureLinkTicketResponse ticket = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("uPay ticket request constructed for order {}, sending.", (Object)orderId);
            }
            ticket = this.getPort().generateSecureLinkTicket(ticketRequest);
        }
        catch (SecureLinkException sle) {
            String errorMsg = "Failed to create a uPay ticket for order " + orderId + ". Error from uPay: " + sle.getFaultInfo().getDescription();
            logger.error(errorMsg, sle.getCause());
            EventLog.getInstance().logEvent(errorMsg);
        }
        catch (Exception e) {
            String errorMsg = "Failed to create a uPay ticket for order " + orderId + ": " + e.getMessage();
            logger.error(errorMsg, (Throwable)e);
            EventLog.getInstance().logEvent(errorMsg);
        }
        if (ticket != null) {
            statusMsg = "uPay ticket created for order " + orderId + ", expires: " + String.valueOf(ticket.getTicketExpire());
            if (logger.isDebugEnabled()) {
                logger.debug(statusMsg);
            }
            EventLog.getInstance().logEvent(statusMsg);
        }
        return ticket;
    }

    private String buildReturnURL(String scheme, String serverName, int serverPort, String status) {
        return scheme + "://" + serverName + ":" + serverPort + "/app?service=external/" + ExtnTouchNet.PAGE_NAME + "&status=" + status;
    }

    @CheckForNull
    private AuthorizeAccountResponse sendAuthorizeRequest(String sessionId, String orderId, String userName) {
        AuthorizeAccountRequest authRequest = new AuthorizeAccountRequest();
        String statusMsg = "Calling uPay web service to authorize payment for order " + orderId;
        if (logger.isDebugEnabled()) {
            logger.debug(statusMsg);
        }
        EventLog.getInstance().logEvent(statusMsg);
        authRequest.setSession(sessionId);
        authRequest.setInvoiceNumber(orderId);
        authRequest.setAncillaryData(userName);
        authRequest.setApplication(ApplicationInfo.getInstance().getApplicationName());
        AuthorizeAccountResponse authResponse = null;
        try {
            authResponse = this.getPort().authorizeAccount(authRequest);
        }
        catch (SecureLinkException sle) {
            String errorMsg = "Failed to authorize payment with uPay for order " + orderId + ", error from uPay: " + sle.getFaultInfo().getDescription();
            logger.error(errorMsg, sle.getCause());
            EventLog.getInstance().logEvent(errorMsg);
        }
        return authResponse;
    }

    private void addRequestOption(GenerateSecureLinkTicketRequest request, RequestOption option, String value) {
        NameValuePair nvp = new NameValuePair();
        nvp.setName(option.getName());
        nvp.setValue(value);
        request.getNameValuePairs().add(nvp);
    }

    private void logError(String msg, boolean doAppLog) {
        logger.error(msg);
        EventLog.getInstance().logEvent("ERROR: " + msg);
        if (doAppLog) {
            this.getApplicationLogManager().logRaw(null, ApplicationLogLevelEnum.ERROR, "TouchNet payment gateway: " + msg);
        }
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isAccessibleByUser(username)) {
            return ADDITIONAL_PAGES;
        }
        return null;
    }

    private ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private ApplicationLogManager getApplicationLogManager() {
        return (ApplicationLogManager)this.getApplicationContext().getBean("applicationLogManager", ApplicationLogManager.class);
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    private LicenseManager getLicenseManager() {
        return (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    private static enum RequestOption {
        Amount("AMT"),
        TransactionId("EXT_TRANS_ID"),
        BillingName("BILL_NAME"),
        BillingEmail("BILL_EMAIL_ADDRESS"),
        SuccessLink("SUCCESS_LINK"),
        SuccessLinkText("SUCCESS_LINK_TEXT"),
        ErrorLink("ERROR_LINK"),
        ErrorLinkText("ERROR_LINK_TEXT"),
        CancelLink("CANCEL_LINK"),
        CancelLinkText("CANCEL_LINK_TEXT");

        private final String _name;

        private RequestOption(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }
    }
}

