/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.touchnet;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.touchnet.TouchNetPlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;

public abstract class TouchNetRedirect
extends BasePaperCutPage
implements PageRenderListener,
IExternalPage {
    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract double getAmount();

    public abstract void setAmount(double var1);

    public abstract String getTicketId();

    public abstract void setTicketId(String var1);

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public void activate(IRequestCycle cycle, User user, double amount) {
        this.setUser(user);
        this.setAmount(amount);
        cycle.activate((IPage)this);
    }

    public void pageBeginRender(PageEvent event) {
        if (this.getUser() == null) {
            throw new PageRedirectException("ExtnTouchNet");
        }
        HttpServletRequest r = this.getRequest();
        String ticketId = this.getTouchNetPlugin().createTicket(this.getUser(), this.getAmount(), r.getScheme(), r.getServerName(), r.getServerPort());
        if (StringUtils.isBlank((String)ticketId)) {
            this.addErrorMessage(GatewayConfig.getInstance().getUserErrorMessage());
            throw new PageRedirectException("ExtnTouchNet");
        }
        this.setTicketId(ticketId);
    }

    public String getTicketName() {
        return this.getUser().getUserName();
    }

    public String getUPaySiteId() {
        return this.getTouchNetPlugin().getUPaySiteId(this.getUser());
    }

    public String getUPaySiteURL() {
        return this.getTouchNetPlugin().getUPaySiteURL();
    }

    private TouchNetPlugin getTouchNetPlugin() {
        return (TouchNetPlugin)PluginManager.getInstance().getPluginByClass(TouchNetPlugin.class);
    }
}

