/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.touchnetOnecard;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.domain.access.AccessRight;
import biz.papercut.pcng.domain.access.AccessRightList;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.touchnetOnecard.TouchnetOnecardPlugin;
import biz.papercut.pcng.ext.paymentgateway.touchnetOnecard.TouchnetOnecardResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.service.AccountManager;
import biz.papercut.pcng.service.CreditSourceManager;
import biz.papercut.pcng.service.UserManager;
import biz.papercut.pcng.web.pages.BasePaperCutPage;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.ValidationDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtnTouchnetOnecard
extends BasePaperCutPage
implements PageRenderListener {
    protected static final Logger logger = LoggerFactory.getLogger(ExtnTouchnetOnecard.class);

    public abstract User getUser();

    public abstract void setUser(User var1);

    public abstract Double getTouchnetOnecardBalance();

    public abstract void setTouchnetOnecardBalance(Double var1);

    public abstract Double getAmount();

    public abstract void setAmount(Double var1);

    @Nullable
    public abstract IPropertySelectionModel getAmountsModel();

    public abstract void setAmountsModel(IPropertySelectionModel var1);

    public abstract AccountManager getAccountManager();

    public abstract CreditSourceManager getCreditSourceManager();

    public abstract UserManager getUserManager();

    public AccessRightList getPageAccessRights() {
        return new AccessRightList(AccessRight.RegisteredUser);
    }

    public String getPageTitle() {
        String title = ExtnTouchnetOnecard.getTouchnetOnecardPlugin().getManualTransferPageTitle();
        return title == null ? super.getPageTitle() : title;
    }

    public String getHeading() {
        return ExtnTouchnetOnecard.getTouchnetOnecardPlugin().getManualTransferPageHeading();
    }

    public double getUserBalance() {
        User user = this.getUserManager().getUserById(this.getUser().getId());
        return GatewayUtils.getUserBalance(this.getAccountManager(), user);
    }

    public void pageBeginRender(PageEvent event) {
        this.setUser(this.getUserManager().getUser(this.getPaperCutVisit().getUserName()));
        if (this.getAmountsModel() == null) {
            this.setAmountsModel(GatewayUtils.createAllowedAmountsModel("touchnet-onecard.manual-transfer.allowed-amounts", (BasePaperCutPage)this));
        }
        if (!this.getRequestCycle().isRewinding()) {
            String configError;
            if (!ExtnTouchnetOnecard.getTouchnetOnecardPlugin().isLicensed()) {
                this.addWarningMessage(GatewayUtils.getNotLicensedUserMessage());
            }
            if ((configError = ExtnTouchnetOnecard.getTouchnetOnecardPlugin().getIsConfigured()) != null) {
                this.addWarningMessage(configError);
                logger.error(configError);
                return;
            }
            try {
                TouchnetOnecardResponse response = ExtnTouchnetOnecard.getTouchnetOnecardPlugin().getBalance(this.getUser());
                if (response.isSuccess()) {
                    this.setTouchnetOnecardBalance(response.getBalance());
                } else {
                    if (this.getErrorMessages().isEmpty()) {
                        this.addErrorMessage(ExtnTouchnetOnecard.getTouchnetOnecardPlugin().getManualTransferUserErrorMessage() + " (Error retrieving Touchnet Onecard balance: " + response.getMessage() + ")");
                    }
                    this.setTouchnetOnecardBalance(null);
                }
            }
            catch (IOException e) {
                logger.error("Unexpected error performing Touchnet Onecard balance inquiry for user: {}", (Object)this.getUser().getUserName(), (Object)e);
            }
        }
    }

    public void doTransaction(IRequestCycle cycle) {
        double totalUserBalance;
        ValidationDelegate delegate = (ValidationDelegate)this.getBeans().getBean("delegate");
        if (delegate.getHasErrors()) {
            this.addErrorMessage(delegate.getFirstError().toString());
            return;
        }
        if (!this.isAccessibleByUser()) {
            this.addErrorMessage("You do not have permission to access this feature.");
            return;
        }
        if (this.getAmount() == null || this.getAmount() <= 0.0) {
            this.addErrorMessage("Please select the amount to transfer to your account.");
            return;
        }
        double amount = this.getAmount();
        User user = this.getUser();
        boolean success = false;
        Object errorSuffix = "";
        Double accumulationLimit = ExtnTouchnetOnecard.getTouchnetOnecardPlugin().getOnlyAllowAccumulationUpTo();
        if (accumulationLimit != null && (totalUserBalance = GatewayUtils.getUserBalance(this.getAccountManager(), user)) + amount > accumulationLimit) {
            this.addErrorMessage(ExtnTouchnetOnecard.getTouchnetOnecardPlugin().getOnlyAllowAccumulationUpToMessage());
            return;
        }
        try {
            TouchnetOnecardResponse response = ExtnTouchnetOnecard.getTouchnetOnecardPlugin().performDebit(this.getUser(), amount);
            if (response.isSuccess()) {
                String txnComment = ExtnTouchnetOnecard.getTouchnetOnecardPlugin().getManualTransferTransactionComment();
                GatewayUtils.addCreditToUser(this.getAccountManager(), this.getCreditSourceManager(), this.getUser(), amount, txnComment);
                this.addStatusMessage(this.formatBalance(amount) + " was successfully added to your account.");
                cycle.activate("UserSummary");
                success = true;
            } else {
                logger.error("Transaction declined by Touchnet Onecard: {}", (Object)response);
                errorSuffix = (String)errorSuffix + " (Transaction declined by Touchnet Onecard: " + response.getMessage() + ")";
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error performing Touchnet Onecard debit transaction for user: {}", (Object)this.getUser().getUserName(), (Object)e);
        }
        if (!success) {
            this.addErrorMessage(ExtnTouchnetOnecard.getTouchnetOnecardPlugin().getManualTransferUserErrorMessage() + (String)errorSuffix);
        }
    }

    public boolean isAccessibleByUser() {
        return ExtnTouchnetOnecard.getTouchnetOnecardPlugin().isManualTransferAccessibleByUser(this.getPaperCutVisit().getUserName());
    }

    public String getNoAccessMsg() {
        return ExtnTouchnetOnecard.getGatewayConfig().getNoAccessMessage();
    }

    public String getUserAndFullName() {
        StringBuilder s = new StringBuilder();
        s.append(this.getUser().getUserName());
        if (StringUtils.isNotBlank((String)this.getUser().getFullName())) {
            s.append(" (");
            s.append(this.getUser().getFullName());
            s.append(")");
        }
        return s.toString();
    }

    public String getTouchnetOnecardBalanceLabel() {
        return ExtnTouchnetOnecard.getTouchnetOnecardPlugin().getBalanceDisplayLabel();
    }

    public String getTouchnetOnecardAvailableCreditLabel() {
        return ExtnTouchnetOnecard.getTouchnetOnecardPlugin().getBalanceDisplayAvailableCreditLabel();
    }

    private static GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public String getPageMessage() {
        return ExtnTouchnetOnecard.getGatewayConfig().getPageMessage();
    }

    public boolean getPageMessageAvailable() {
        return ExtnTouchnetOnecard.getGatewayConfig().getPageMessageAvailable();
    }

    private static TouchnetOnecardPlugin getTouchnetOnecardPlugin() {
        return (TouchnetOnecardPlugin)PluginManager.getInstance().getPluginByClass(TouchnetOnecardPlugin.class);
    }
}

