/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.touchnetOnecard;

import biz.papercut.pcng.util.ObjectUtils;
import java.io.Serializable;

public class TouchnetOnecardAccount
implements Serializable {
    private final FormatType _formatType;
    private String _track2Data;
    private final String _accountId;
    private final String _accountType;
    private final String _customerNumber;

    public TouchnetOnecardAccount(String track2Data) {
        this._formatType = FormatType.SwipeCard;
        this._track2Data = track2Data;
        this._accountId = track2Data;
        this._accountType = "RAW";
        this._customerNumber = "0";
    }

    public TouchnetOnecardAccount(String accountNumber, String accountType, String customerNumber) {
        this._formatType = FormatType.ManualCard;
        this._track2Data = null;
        this._accountId = accountNumber;
        this._accountType = accountType;
        this._customerNumber = customerNumber;
    }

    public String get_track2Data() {
        return this._track2Data;
    }

    public void set_track2Data(String _track2Data) {
        this._track2Data = _track2Data;
    }

    public String get_accountId() {
        return this._accountId;
    }

    public String get_accountType() {
        return this._accountType;
    }

    public String get_customerNumber() {
        return this._customerNumber;
    }

    public String toMessage() {
        StringBuilder str = new StringBuilder();
        str.append(this._formatType.getCode());
        if (this._formatType == FormatType.SwipeCard) {
            str.append(this._track2Data);
        } else {
            str.append(this._accountId);
            str.append(this._accountType);
            str.append(this._customerNumber);
        }
        return str.toString();
    }

    public String toString() {
        if (this._formatType == FormatType.SwipeCard) {
            return ObjectUtils.createToStringBuilder((Object)this).append("track2Data", (Object)this._track2Data).toString();
        }
        return ObjectUtils.createToStringBuilder((Object)this).append("formatType", (Object)this._formatType).append("accountNumber", (Object)this._accountId).append("accountType", (Object)this._accountType).append("customerNumber", (Object)this._customerNumber).toString();
    }

    public static enum FormatType {
        ManualCard("1", "Manual"),
        SwipeCard("2", "Card");

        private final String _code;
        private final String _configName;

        private FormatType(String code, String configName) {
            this._code = code;
            this._configName = configName;
        }

        public String getCode() {
            return this._code;
        }

        public String getConfigName() {
            return this._configName;
        }

        public static FormatType fromString(String text) {
            if (text != null) {
                for (FormatType f : FormatType.values()) {
                    if (!text.equalsIgnoreCase(f._configName)) continue;
                    return f;
                }
            }
            return null;
        }
    }
}

