/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.touchnetOnecard;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.touchnetOnecard.TouchnetOnecardAccount;
import biz.papercut.pcng.service.ApplicationLogManager;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.papercut.server.lang.service.ApplicationLogLevelEnum;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class TouchnetOnecardCardLookup {
    private static final Logger logger = LoggerFactory.getLogger(TouchnetOnecardCardLookup.class);
    private static final String CONFIG_PREFIX = "touchnet-onecard.";
    private static final String CONFIG_CARD_ID_LOOKUP_PREFIX = "touchnet-onecard.account-id-lookup.";
    private static final String CONFIG_CARD_ID_LOOKUP_MODE = "touchnet-onecard.account-id-lookup.mode";
    private static final String CONFIG_CARD_ID_LOOKUP_DB_DRIVER = "touchnet-onecard.account-id-lookup.db-driver";
    private static final String CONFIG_CARD_ID_LOOKUP_DB_URL = "touchnet-onecard.account-id-lookup.db-url";
    private static final String CONFIG_CARD_ID_LOOKUP_DB_USERNAME = "touchnet-onecard.account-id-lookup.db-username";
    static final String CONFIG_CARD_ID_LOOKUP_DB_PASSWORD = "touchnet-onecard.account-id-lookup.db-password";
    private static final String CONFIG_CARD_ID_LOOKUP_DB_SQL = "touchnet-onecard.account-id-lookup.db-sql";
    private static final String CONFIG_ACCOUNT_TYPE = "touchnet-onecard.account-type";
    private static final String CONFIG_CUSTOMER_NUMBER = "touchnet-onecard.customer-number";
    private static final String CONFIG_ACCOUNT_FORMAT = "touchnet-onecard.account-id-format";
    private volatile ApplicationContext _ctx;
    @Nullable
    @GuardedBy(value="this")
    private ComboPooledDataSource _dataSource;

    public void checkConfiguration() throws ConfigurationException {
        TouchnetOnecardAccount.FormatType format;
        String errorPrefix = "Configuration problem: ";
        String errorSuffix = "  Please check the payment gateway config file.";
        GatewayConfig conf = GatewayConfig.getInstance();
        if (this.isDBLookupEnabled()) {
            if (StringUtils.isBlank((String)this.getGatewayConfig().getString(CONFIG_CARD_ID_LOOKUP_DB_DRIVER))) {
                throw new ConfigurationException(errorPrefix + "No database driver specified (touchnet-onecard.account-id-lookup.db-driver)." + errorSuffix);
            }
            if (StringUtils.isBlank((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_URL))) {
                throw new ConfigurationException(errorPrefix + "No database connection URL specified (touchnet-onecard.account-id-lookup.db-url)." + errorSuffix);
            }
            if (StringUtils.isBlank((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_USERNAME))) {
                throw new ConfigurationException(errorPrefix + "No database username specified (touchnet-onecard.account-id-lookup.db-username)." + errorSuffix);
            }
            if (StringUtils.isBlank((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_SQL))) {
                throw new ConfigurationException(errorPrefix + "No database lookup SQL specified (touchnet-onecard.account-id-lookup.db-sql)." + errorSuffix);
            }
        }
        if ((format = this.getFormatType()) == null) {
            throw new ConfigurationException(errorPrefix + "Account format has incorrect value (touchnet-onecard.account-id-format)." + errorSuffix);
        }
        if (format == TouchnetOnecardAccount.FormatType.ManualCard) {
            Integer accountType = this.getGatewayConfig().getInteger(CONFIG_ACCOUNT_TYPE);
            if (accountType == null) {
                throw new ConfigurationException(errorPrefix + "No account type specified (touchnet-onecard.account-type)." + errorSuffix);
            }
            if (accountType < 0 || accountType > 4) {
                throw new ConfigurationException(errorPrefix + "Account type specified (touchnet-onecard.account-type) is invalid." + errorSuffix);
            }
            Integer customerNumber = this.getGatewayConfig().getInteger(CONFIG_CUSTOMER_NUMBER);
            if (customerNumber == null) {
                throw new ConfigurationException(errorPrefix + "No account customer number specified (touchnet-onecard.customer-number)." + errorSuffix);
            }
            if (customerNumber < 0 || customerNumber > 9999) {
                throw new ConfigurationException(errorPrefix + "Customer number(touchnet-onecard.customer-number) is invalid." + errorSuffix);
            }
        }
    }

    private TouchnetOnecardAccount.FormatType getFormatType() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String acctFormatStr = conf.getString(CONFIG_ACCOUNT_FORMAT);
        if (StringUtils.isBlank((String)acctFormatStr)) {
            return TouchnetOnecardAccount.FormatType.ManualCard;
        }
        return TouchnetOnecardAccount.FormatType.fromString(acctFormatStr);
    }

    @CheckForNull
    public TouchnetOnecardAccount getAccount(User user) {
        String accountNumber = this.getTouchnetOnecardAccountNumber(user);
        if (accountNumber == null) {
            return null;
        }
        TouchnetOnecardAccount.FormatType format = this.getFormatType();
        if (format == TouchnetOnecardAccount.FormatType.ManualCard) {
            GatewayConfig conf = GatewayConfig.getInstance();
            String accountType = conf.getString(CONFIG_ACCOUNT_TYPE);
            String customerNumber = conf.getString(CONFIG_CUSTOMER_NUMBER);
            return new TouchnetOnecardAccount(accountNumber, accountType, customerNumber);
        }
        return new TouchnetOnecardAccount(accountNumber);
    }

    @CheckForNull
    public String getTouchnetOnecardAccountNumber(User user) {
        String cardId;
        if (this.isDBLookupEnabled()) {
            cardId = this.lookUpTouchnetOnecardAccountNumberInDatabase(user);
            if (StringUtils.isBlank((String)cardId) && StringUtils.isNotBlank((String)user.getCardNumber())) {
                cardId = user.getCardNumber();
                logger.debug("Unable to determine account number for user '{}' in external database. Using internal card/id number: {}", (Object)user.getUserName(), (Object)cardId);
            }
        } else {
            cardId = user.getCardNumber();
            logger.debug("Using internal card/id number: {}", (Object)cardId);
        }
        if (StringUtils.isBlank((String)cardId)) {
            this.getEventLog().logEvent("Cannot determine Touchnet Onecard account number for user: " + user.getUserName());
            return null;
        }
        return cardId;
    }

    public String getPin(User user) {
        return "";
    }

    private boolean isDBLookupEnabled() {
        GatewayConfig conf = GatewayConfig.getInstance();
        String s = StringUtils.trimToEmpty((String)conf.getString(CONFIG_CARD_ID_LOOKUP_MODE)).toUpperCase(Locale.US);
        return s.equals("EXTERNAL_DATABASE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private String lookUpTouchnetOnecardAccountNumberInDatabase(User user) {
        PreparedStatement stmt;
        ResultSet rs;
        Connection conn;
        block6: {
            String nextId;
            logger.debug("Looking up Touchnet Onecard account number in database.");
            conn = null;
            rs = null;
            stmt = null;
            try {
                conn = this.openDBConnection();
                stmt = this.createLookupSQLStatement(conn, user);
                rs = stmt.executeQuery();
                if (!rs.next()) break block6;
                String card = rs.getString(1);
                if (logger.isDebugEnabled() && rs.next()) {
                    nextId = rs.getString(1);
                    logger.debug("Touchnet Onecard account id lookup returned more than one result for user: {}. Match 1: {} Match 2: {} More matches: {}. Using first match.", new Object[]{user.getUserName(), card, nextId, rs.next()});
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Found Touchnet Onecard account id: {} for user: {} in lookup DB.", (Object)card, (Object)user.getUserName());
                }
                nextId = card;
            }
            catch (Exception e) {
                try {
                    String msg = "Error occurred looking up Touchnet Onecard account number in external database for user: " + user.getUserName() + ". " + e.getMessage();
                    EventLog.getInstance().logEvent(msg);
                    logger.error(msg, (Throwable)e);
                    this.getApplicationLogManager().logRaw("", ApplicationLogLevelEnum.ERROR, msg);
                }
                catch (Throwable throwable) {
                    DbUtils.closeQuietly(rs);
                    DbUtils.closeQuietly(stmt);
                    DbUtils.closeQuietly((Connection)conn);
                    throw throwable;
                }
                DbUtils.closeQuietly((ResultSet)rs);
                DbUtils.closeQuietly((Statement)stmt);
                DbUtils.closeQuietly((Connection)conn);
            }
            DbUtils.closeQuietly((ResultSet)rs);
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((Connection)conn);
            return nextId;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        DbUtils.closeQuietly((Statement)stmt);
        DbUtils.closeQuietly((Connection)conn);
        return null;
    }

    private PreparedStatement createLookupSQLStatement(Connection conn, User user) throws SQLException {
        PreparedStatement stmt;
        String sqlTemplate = this.getGatewayConfig().getString(CONFIG_CARD_ID_LOOKUP_DB_SQL);
        Matcher m = Pattern.compile("\\{\\s*(\\p{Alpha}+)\\s*\\}").matcher(sqlTemplate);
        if (logger.isDebugEnabled()) {
            logger.debug("SQL template: {}", (Object)sqlTemplate);
        }
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        while (m.find()) {
            String key;
            switch (key = m.group(1).trim().toLowerCase()) {
                case "username": {
                    params.add(user.getUserName());
                    break;
                }
                case "idnumber": {
                    params.add(user.getCardNumber());
                    break;
                }
                case "fullname": {
                    params.add(user.getFullName());
                    break;
                }
                default: {
                    throw new RuntimeException("Configuration error - unexpected replacement in SQL: " + key);
                }
            }
            m.appendReplacement(sql, "?");
        }
        m.appendTail(sql);
        if (params.isEmpty()) {
            throw new RuntimeException("Configuration error - Touchnet Onecard lookup SQL does not contain any parameters/replacements. SQL: " + sqlTemplate);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Parsed SQL: \"{}\", params: {}", (Object)sql, params);
        }
        if ((stmt = conn.prepareStatement(sql.toString())).getParameterMetaData().getParameterCount() != params.size()) {
            throw new SQLException("Problem with replacements in card lookup SQL (touchnet-onecard.account-id-lookup.db-sql). Ensure replacements are not quoted.");
        }
        for (int i = 0; i < params.size(); ++i) {
            stmt.setString(i + 1, (String)params.get(i));
        }
        return stmt;
    }

    private synchronized Connection openDBConnection() throws SQLException {
        if (this._dataSource == null) {
            this._dataSource = this.createDataSource();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Getting DB connection from: {}", (Object)this._dataSource);
        }
        try {
            return this._dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new SQLException(StringUtils.trimToEmpty((String)e.getMessage()) + " - Please check database is available and Touchnet Onecard payment gateway account lookup database settings are correct.");
        }
    }

    private synchronized ComboPooledDataSource createDataSource() {
        GatewayConfig conf = this.getGatewayConfig();
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        try {
            dataSource.setDriverClass(StringUtils.trimToEmpty((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_DRIVER)));
        }
        catch (PropertyVetoException ve) {
            throw new RuntimeException("Unable to configure database driver: " + conf.getString(CONFIG_CARD_ID_LOOKUP_DB_DRIVER) + ". " + ve.getMessage(), ve);
        }
        dataSource.setJdbcUrl(StringUtils.trimToEmpty((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_URL)));
        dataSource.setUser(StringUtils.trimToEmpty((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_USERNAME)));
        dataSource.setPassword(StringUtils.trimToEmpty((String)conf.getString(CONFIG_CARD_ID_LOOKUP_DB_PASSWORD)));
        dataSource.setInitialPoolSize(0);
        dataSource.setMinPoolSize(1);
        dataSource.setMaxPoolSize(50);
        dataSource.setMaxIdleTime(300);
        dataSource.setCheckoutTimeout(10000);
        dataSource.setAcquireIncrement(1);
        dataSource.setAcquireRetryAttempts(2);
        dataSource.setAcquireRetryDelay(500);
        return dataSource;
    }

    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public synchronized void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private ApplicationLogManager getApplicationLogManager() {
        return (ApplicationLogManager)this.getApplicationContext().getBean("applicationLogManager", ApplicationLogManager.class);
    }

    private EventLog getEventLog() {
        return EventLog.getInstance();
    }

    private GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }
}

