/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.touchnetOnecard;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.AESProperty;
import biz.papercut.pcng.ext.paymentgateway.ConfigurationException;
import biz.papercut.pcng.ext.paymentgateway.CreditCardGatewayPlugin;
import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.touchnetOnecard.TouchnetOnecardAccount;
import biz.papercut.pcng.ext.paymentgateway.touchnetOnecard.TouchnetOnecardCardLookup;
import biz.papercut.pcng.ext.paymentgateway.touchnetOnecard.TouchnetOnecardRESTcalls;
import biz.papercut.pcng.ext.paymentgateway.touchnetOnecard.TouchnetOnecardResponse;
import biz.papercut.pcng.plugin.EnableablePlugin;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.UserLinkPlugin;
import biz.papercut.pcng.plugin.WebServerPlugin;
import biz.papercut.pcng.service.ApplicationLogManager;
import biz.papercut.pcng.service.ConfigManager;
import biz.papercut.pcng.service.LicenseManager;
import biz.papercut.pcng.service.UserManager;
import com.papercut.server.lang.service.ServiceException;
import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class TouchnetOnecardPlugin
implements EnableablePlugin,
WebServerPlugin,
SpringContextPlugin,
UserLinkPlugin {
    private static final Logger logger = LoggerFactory.getLogger(TouchnetOnecardPlugin.class);
    public static final String CONFIG_PREFIX = "touchnet-onecard.";
    public static final String CONFIG_ALLOWED_GROUPS = "touchnet-onecard.allowed-groups";
    public static final String CONFIG_ALLOWED_AMOUNTS = "touchnet-onecard.allowed-amounts";
    public static final String CONFIG_ENABLED = "touchnet-onecard.enabled";
    public static final String CONFIG_OPERATOR_ID = "touchnet-onecard.operator-id";
    @AESProperty
    public static final String CONFIG_OPERATOR_PASSWORD = "touchnet-onecard.operator-password";
    public static final String CONFIG_TERMINAL_ID = "touchnet-onecard.terminal-id";
    public static final String CONFIG_TERMINAL_TYPE = "touchnet-onecard.terminal-type";
    public static final String CONFIG_ORIGIN_ID = "565";
    public static final String CONFIG_VEND_MONEY_URL = "touchnet-onecard.vend-money-url";
    public static final String CONFIG_BALANCE_INQUIRY_URL = "touchnet-onecard.balance-inquiry-url";
    private static final String CONFIG_BALANCE_DISPLAY_PREFIX = "touchnet-onecard.balance-display.";
    private static final String CONFIG_BALANCE_DISPLAY_ENABLED = "touchnet-onecard.balance-display.enabled";
    private static final String CONFIG_BALANCE_DISPLAY_LABEL = "touchnet-onecard.balance-display.label";
    private static final String CONFIG_BALANCE_DISPLAY_AVAILABLE_CREDIT_PREFIX = "touchnet-onecard.balance-display.available-credit.";
    private static final String CONFIG_BALANCE_DISPLAY_AVAILABLE_CREDIT_LABEL = "touchnet-onecard.balance-display.available-credit.label";
    private static final String CONFIG_MANUAL_PREFIX = "touchnet-onecard.manual-transfer.";
    private static final String CONFIG_MANUAL_TRANSFER_ENABLED = "touchnet-onecard.manual-transfer.enabled";
    private static final String CONFIG_MANUAL_TRANSFER_PAGE_TITLE = "touchnet-onecard.manual-transfer.page.title";
    private static final String CONFIG_MANUAL_TRANSFER_PAGE_HEADING = "touchnet-onecard.manual-transfer.page.heading";
    private static final String CONFIG_MANUAL_TRANSFER_TRANSACTION_COMMENT = "touchnet-onecard.manual-transfer.transaction-comment";
    protected static final String CONFIG_MANUAL_TRANSFER_ALLOWED_AMOUNTS = "touchnet-onecard.manual-transfer.allowed-amounts";
    private static final String CONFIG_MANUAL_TRANSFER_ALLOWED_GROUPS = "touchnet-onecard.manual-transfer.allowed-groups";
    private static final String CONFIG_MANUAL_TRANSFER_USER_ERROR_MESSAGE = "touchnet-onecard.manual-transfer.user-error-message";
    private static final String CONFIG_ON_DEMAND_PREFIX = "touchnet-onecard.on-demand-transfer.";
    private static final String CONFIG_ON_DEMAND_TRANSFER_ENABLED = "touchnet-onecard.on-demand-transfer.enabled";
    private static final String CONFIG_ON_DEMAND_TRANSFER_DEFAULT_TRANSFER_AMOUNT = "touchnet-onecard.on-demand-transfer.default-transfer-amount";
    private static final String CONFIG_ON_DEMAND_TRANSFER_MAX_TRANSFER_AMOUNT = "touchnet-onecard.on-demand-transfer.max-transfer-amount";
    private static final String CONFIG_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT = "touchnet-onecard.on-demand-transfer.transaction-comment";
    private static final String CONFIG_ON_DEMAND_TRANSFER_ENABLED_GROUPS = "touchnet-onecard.on-demand-transfer.enabled-groups";
    private static final String CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO = "touchnet-onecard.only-allow-accumulation-up-to";
    private static final String CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO_MESSAGE = "touchnet-onecard.only-allow-accumulation-up-to-message";
    private static final String DEFAULT_MANUAL_TRANSFER_TRANSACTION_COMMENT = "Funds added from TouchNet Onecard";
    private static final String DEFAULT_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT = "Automatic transfer from TouchNet Onecard";
    public static final String VEND_MONEY_TRANSACTION_TYPE = "4";
    public static final String BALANCE_INQUIRY_TRANSACTION_TYPE = "12";
    public static final int DEFAULT_BILLING_TYPE = 0;
    public static final String PROCESSING_TYPE = "OneCardOnly";
    public static final byte SPACIAL_FIELD_QUERY_NUMBER = Byte.parseByte("11");
    public static final String DEVELOPER_KEY = "19506aa1a09c8a4664a883ea6bf93b94";
    private static final double ROUNDING_TOLERANCE = 1.0E-5;
    private static final List<String> ADDITIONAL_PAGES = List.of("ExtnTouchnetOnecard");
    @AESProperty
    public static final String NOT_USE_CONFIG_CARD_ID_LOOKUP_DB_PASSWORD = "touchnet-onecard.account-id-lookup.db-password";
    private ApplicationContext _applicationContext;
    @Nullable
    private final TouchnetOnecardCardLookup _cardLookup = new TouchnetOnecardCardLookup();

    public boolean isPluginEnabled() {
        Boolean enabled = this.getGatewayConfig().getBoolean(CONFIG_ENABLED);
        return enabled != null && enabled != false;
    }

    public boolean isAccessibleByUser(String username) {
        return GatewayUtils.isAccessibleByUser(username, CONFIG_ALLOWED_GROUPS, this.getUserManager());
    }

    public boolean isLicensed() {
        return GatewayUtils.isLicensed(this.getLicenseManager(), "payment-gateways-touchnet-onecard");
    }

    public ApplicationContext getApplicationContext() {
        return this._applicationContext;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this._applicationContext = ctx;
    }

    public List<String> additionalPages(String username) {
        if (this.isPluginEnabled() && this.isManualTransferEnabled() && this.isManualTransferAccessibleByUser(username)) {
            return ADDITIONAL_PAGES;
        }
        return null;
    }

    @CheckForNull
    public String getPageTitle() {
        return this.getManualTransferPageTitle();
    }

    @CheckForNull
    public String getIsConfigured() {
        String errorPrefix = "Configuration problem: ";
        String errorSuffix = "  Please check the payment gateway config file.";
        try {
            this.getManualTransferAllowedAmounts();
        }
        catch (Exception e) {
            String errorMsg = "Allowed amounts setting uses the wrong format.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        if (this.getManualTransferAllowedAmounts().isEmpty()) {
            String errorMsg = "Must specify at least one allowed payment amount.";
            EventLog.getInstance().logEvent(errorMsg);
            return errorPrefix + errorMsg + errorSuffix;
        }
        if (this.isOnDemandTransferEnabled()) {
            if (this.getOnDemandTransferDefaultTransferAmount() == null) {
                String errorMsg = "If on-demand transfers is enabled a default transfer amount must be specified.";
                EventLog.getInstance().logEvent(errorMsg);
                return errorPrefix + errorMsg + errorSuffix;
            }
            if (this.getOnDemandTransferMaxTransferAmount() == null) {
                String errorMsg = "If on-demand transfers is enabled a max transfer amount must be specified.";
                EventLog.getInstance().logEvent(errorMsg);
                return errorPrefix + errorMsg + errorSuffix;
            }
        }
        try {
            this._cardLookup.checkConfiguration();
        }
        catch (ConfigurationException ce) {
            logger.error(ce.getMessage());
            EventLog.getInstance().logEvent(ce.getMessage());
            return ce.getMessage();
        }
        return null;
    }

    public void preStartupHook(WebServerPlugin.WebServer webserver) {
        if (!this.isPluginEnabled()) {
            // empty if block
        }
    }

    protected ApplicationLogManager getApplicationLogManager() {
        return (ApplicationLogManager)this.getApplicationContext().getBean("applicationLogManager", ApplicationLogManager.class);
    }

    protected CreditCardGatewayPlugin getCreditCardGatewayPlugin() {
        return (CreditCardGatewayPlugin)PluginManager.getInstance().getPluginByClass(CreditCardGatewayPlugin.class);
    }

    protected GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    protected LicenseManager getLicenseManager() {
        return (LicenseManager)this.getApplicationContext().getBean("licenseManager", LicenseManager.class);
    }

    protected UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }

    protected ConfigManager getConfigManager() {
        return (ConfigManager)this.getApplicationContext().getBean("configManager", ConfigManager.class);
    }

    public List<Double> getManualTransferAllowedAmounts() {
        return this.getGatewayConfig().getDoubleList(CONFIG_MANUAL_TRANSFER_ALLOWED_AMOUNTS);
    }

    public TouchnetOnecardResponse getBalance(User user) throws IOException {
        TouchnetOnecardAccount account = this.getCardLookup().getAccount(user);
        if (account == null) {
            TouchnetOnecardResponse.ResponseStatus responseStatus = new TouchnetOnecardResponse.ResponseStatus(null, "Touchnet Onecard Account number is not present", null, null);
            return new TouchnetOnecardResponse("error", responseStatus, "false", null, null, null, null, null, null);
        }
        String pin = this.getCardLookup().getPin(user);
        TouchnetOnecardResponse response = this.getRESTInstance().getBalance(account, pin);
        String msg = "Balance inquiry for user " + user.getUserName() + " account " + String.valueOf(account) + ": " + String.valueOf(response);
        if (response.isSuccess()) {
            logger.debug(msg);
        } else {
            logger.error(msg);
        }
        EventLog.getInstance().logEvent(msg);
        return response;
    }

    public TouchnetOnecardResponse performDebit(User user, double amount) throws IOException {
        TouchnetOnecardAccount account = this.getCardLookup().getAccount(user);
        if (account == null) {
            TouchnetOnecardResponse.ResponseStatus responseStatus = new TouchnetOnecardResponse.ResponseStatus(null, "Touchnet Onecard Account number is not present", null, null);
            return new TouchnetOnecardResponse("error", responseStatus, "false", null, null, null, null, null, null);
        }
        String pin = this.getCardLookup().getPin(user);
        TouchnetOnecardResponse response = this.getRESTInstance().vendMoneyProcess(account, pin, amount);
        String msg = "Perform debit for user " + user.getUserName() + " amount " + amount + ": " + String.valueOf(response);
        if (response.isSuccess()) {
            logger.debug(msg);
            EventLog.getInstance().logTransaction(user.getUserName(), response.getOneCardTransID(), amount, "TouchNet OneCard");
        } else {
            logger.error(msg);
        }
        EventLog.getInstance().logEvent(msg);
        return response;
    }

    public TouchnetOnecardRESTcalls getRESTInstance() {
        return new TouchnetOnecardRESTcalls();
    }

    private TouchnetOnecardCardLookup getCardLookup() {
        if (this._cardLookup == null) {
            throw new ServiceException("Touchnet Onecard payment gateway not fully configured");
        }
        return this._cardLookup;
    }

    public boolean isBalanceDisplayEnabled() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean(CONFIG_BALANCE_DISPLAY_ENABLED));
    }

    public String getBalanceDisplayLabel() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_BALANCE_DISPLAY_LABEL));
    }

    public String getBalanceDisplayAvailableCreditLabel() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_BALANCE_DISPLAY_AVAILABLE_CREDIT_LABEL));
    }

    public Double getOnlyAllowAccumulationUpTo() {
        Double amount = null;
        try {
            amount = this.getGatewayConfig().getDouble(CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO);
        }
        catch (Exception e) {
            logger.error("Invalid accumulation up to amount.", (Throwable)e);
        }
        return amount;
    }

    public String getOnlyAllowAccumulationUpToMessage() {
        return this.getGatewayConfig().getString(CONFIG_ONLY_ALLOW_ACCUMULATION_UP_TO_MESSAGE);
    }

    public String getManualTransferTransactionComment() {
        Object txnComment = StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_TRANSACTION_COMMENT));
        if (txnComment == null) {
            txnComment = DEFAULT_MANUAL_TRANSFER_TRANSACTION_COMMENT;
        }
        if (!this.isLicensed()) {
            txnComment = (String)txnComment + " (" + GatewayUtils.getNotLicensedUserMessage() + ")";
        }
        return txnComment;
    }

    public String getManualTransferUserErrorMessage() {
        String userError = StringUtils.trimToNull((String)GatewayConfig.getInstance().getString(CONFIG_MANUAL_TRANSFER_USER_ERROR_MESSAGE));
        if (userError == null) {
            userError = "An error has occurred, please try again. If you continue to receive this error please contact a network administrator for assistance.";
        }
        return userError;
    }

    public boolean isManualTransferAccessibleByUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, CONFIG_MANUAL_TRANSFER_ALLOWED_GROUPS, this.getUserManager());
    }

    @CheckForNull
    public String getManualTransferPageTitle() {
        return this.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_PAGE_TITLE);
    }

    public String getManualTransferPageHeading() {
        return StringUtils.trimToEmpty((String)this.getGatewayConfig().getString(CONFIG_MANUAL_TRANSFER_PAGE_HEADING));
    }

    public boolean isManualTransferEnabled() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean(CONFIG_MANUAL_TRANSFER_ENABLED));
    }

    public boolean isOnDemandTransferEnabled() {
        return BooleanUtils.isTrue((Boolean)this.getGatewayConfig().getBoolean(CONFIG_ON_DEMAND_TRANSFER_ENABLED));
    }

    @Nullable
    public Double getOnDemandTransferDefaultTransferAmount() {
        Double amount = null;
        try {
            amount = this.getGatewayConfig().getDouble(CONFIG_ON_DEMAND_TRANSFER_DEFAULT_TRANSFER_AMOUNT);
        }
        catch (Exception e) {
            logger.error("Invalid on-demand transfer default transfer amount.", (Throwable)e);
        }
        return amount;
    }

    @Nullable
    public Double getOnDemandTransferMaxTransferAmount() {
        Double amount = null;
        try {
            amount = this.getGatewayConfig().getDouble(CONFIG_ON_DEMAND_TRANSFER_MAX_TRANSFER_AMOUNT);
        }
        catch (Exception e) {
            logger.error("Invalid on-demand transfer max transfer amount.", (Throwable)e);
        }
        return amount;
    }

    public String getOnDemandTransferTransactionComment() {
        Object txnComment = StringUtils.trimToNull((String)this.getGatewayConfig().getString(CONFIG_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT));
        if (txnComment == null) {
            txnComment = DEFAULT_ON_DEMAND_TRANSFER_TRANSACTION_COMMENT;
        }
        if (!this.isLicensed()) {
            txnComment = (String)txnComment + " (" + GatewayUtils.getNotLicensedUserMessage() + ")";
        }
        return txnComment;
    }

    public boolean isOnDemandTransferEnabledForUser(String username) {
        if (!this.isPluginEnabled()) {
            return false;
        }
        if (!this.isOnDemandTransferEnabled()) {
            return false;
        }
        return GatewayUtils.isAccessibleByUser(username, CONFIG_ON_DEMAND_TRANSFER_ENABLED_GROUPS, this.getUserManager());
    }

    public static int roundDoubleDollarsToCents(double dollars) {
        double dollarsToRound = dollars - 1.0E-5;
        return (int)Math.ceil(dollarsToRound * 100.0);
    }
}

