/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.touchnetOnecard;

import biz.papercut.pcng.ext.paymentgateway.EventLog;
import biz.papercut.pcng.ext.paymentgateway.GatewayConfig;
import biz.papercut.pcng.ext.paymentgateway.touchnetOnecard.TouchnetOnecardAccount;
import biz.papercut.pcng.ext.paymentgateway.touchnetOnecard.TouchnetOnecardBalanceInquiryRequest;
import biz.papercut.pcng.ext.paymentgateway.touchnetOnecard.TouchnetOnecardResponse;
import biz.papercut.pcng.ext.paymentgateway.touchnetOnecard.TouchnetOnecardVendMoneyRequest;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class TouchnetOnecardRESTcalls {
    private static final Logger logger = LoggerFactory.getLogger(TouchnetOnecardRESTcalls.class);

    protected TouchnetOnecardResponse getBalance(TouchnetOnecardAccount account, String pin) throws IOException {
        String msg = "Attempting balance inquiry for account: " + String.valueOf(account) + ", pin: " + pin;
        logger.debug(msg);
        TouchnetOnecardRESTcalls.getEventLog().logEvent(msg);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String transDate = formatter.format(new Date());
        TouchnetOnecardBalanceInquiryRequest touchnetOnecardBalanceInquiryRequest = TouchnetOnecardBalanceInquiryRequest.getTouchnetOnecardBalanceInquiryRequest(account, pin, transDate, this.getGatewayConfig().getString("touchnet-onecard.terminal-id"), this.getGatewayConfig().getString("touchnet-onecard.terminal-type"), this.getGatewayConfig().getString("touchnet-onecard.operator-id"), this.getGatewayConfig().getString("touchnet-onecard.operator-password"));
        logger.debug("Balance Inquiry Request :{}", (Object)touchnetOnecardBalanceInquiryRequest);
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Accept", (Object)"application/json");
        headers.add((Object)"Content-Type", (Object)"application/json");
        headers.add((Object)"DevKey", (Object)"19506aa1a09c8a4664a883ea6bf93b94");
        String balanceInquiryURL = this.getGatewayConfig().getString("touchnet-onecard.balance-inquiry-url");
        HttpEntity request = new HttpEntity((Object)touchnetOnecardBalanceInquiryRequest, (MultiValueMap)headers);
        ResponseEntity responseEntityForBalanceInquiry = this.getRestTemplate().postForEntity(balanceInquiryURL, (Object)request, String.class, new Object[0]);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        TouchnetOnecardResponse touchnetOnecardResponse = (TouchnetOnecardResponse)objectMapper.readValue((String)responseEntityForBalanceInquiry.getBody(), TouchnetOnecardResponse.class);
        logger.debug("Balance Inquiry response object :{}", (Object)touchnetOnecardResponse);
        return touchnetOnecardResponse;
    }

    public TouchnetOnecardResponse vendMoneyProcess(TouchnetOnecardAccount account, String pin, double amount) throws IOException {
        String msg = "Attempting transaction for account: " + String.valueOf(account) + ", pin: " + pin + ", amount" + amount;
        logger.debug(msg);
        TouchnetOnecardRESTcalls.getEventLog().logEvent(msg);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String transDate = formatter.format(new Date());
        TouchnetOnecardVendMoneyRequest touchnetOnecardVendMoneyRequest = TouchnetOnecardVendMoneyRequest.getTouchnetOnecardVendMoneyRequest(account, pin, amount, transDate, this.getGatewayConfig().getString("touchnet-onecard.terminal-id"), this.getGatewayConfig().getString("touchnet-onecard.terminal-type"), this.getGatewayConfig().getString("touchnet-onecard.operator-id"), this.getGatewayConfig().getString("touchnet-onecard.operator-password"));
        logger.debug("Vend Money Request :{}", (Object)touchnetOnecardVendMoneyRequest);
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Accept", (Object)"application/json");
        headers.add((Object)"Content-Type", (Object)"application/json");
        headers.add((Object)"DevKey", (Object)"19506aa1a09c8a4664a883ea6bf93b94");
        String vendMoneyURL = this.getGatewayConfig().getString("touchnet-onecard.vend-money-url");
        HttpEntity request = new HttpEntity((Object)touchnetOnecardVendMoneyRequest, (MultiValueMap)headers);
        ResponseEntity responseEntityForVendMoney = this.getRestTemplate().postForEntity(vendMoneyURL, (Object)request, String.class, new Object[0]);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        TouchnetOnecardResponse touchnetOnecardResponse = (TouchnetOnecardResponse)objectMapper.readValue((String)responseEntityForVendMoney.getBody(), TouchnetOnecardResponse.class);
        logger.debug("Vend Money Response object :{}", (Object)touchnetOnecardResponse);
        return touchnetOnecardResponse;
    }

    protected GatewayConfig getGatewayConfig() {
        return GatewayConfig.getInstance();
    }

    public RestTemplate getRestTemplate() {
        return new RestTemplate();
    }

    private static EventLog getEventLog() {
        return EventLog.getInstance();
    }
}

