/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.touchnetOnecard;

import biz.papercut.pcng.util.ObjectUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TouchnetOnecardResponse
implements Serializable {
    private String Status;
    private ResponseStatus ResponseStatus;
    private String IsCompleted;
    private Result Result;
    private String OneCardTransID;
    private String StandardAccountID;
    private String DisplayAccountID;
    private String DisplayAccountType;
    private String AccountFullName;

    public TouchnetOnecardResponse(String status, ResponseStatus responseStatus, String isCompleted, Result result, String oneCardTransID, String standardAccountID, String displayAccountID, String displayAccountType, String accountFullName) {
        this.Status = status;
        this.ResponseStatus = responseStatus;
        this.IsCompleted = isCompleted;
        this.Result = result;
        this.OneCardTransID = oneCardTransID;
        this.StandardAccountID = standardAccountID;
        this.DisplayAccountID = displayAccountID;
        this.DisplayAccountType = displayAccountType;
        this.AccountFullName = accountFullName;
    }

    public TouchnetOnecardResponse(String status, ResponseStatus responseStatus, String isCompleted) {
        this.Status = status;
        this.ResponseStatus = responseStatus;
        this.IsCompleted = isCompleted;
    }

    public TouchnetOnecardResponse() {
    }

    public String getStatus() {
        return this.Status;
    }

    public ResponseStatus getResponseStatus() {
        return this.ResponseStatus;
    }

    public String getIsCompleted() {
        return this.IsCompleted;
    }

    public Result getResult() {
        return this.Result;
    }

    public String getOneCardTransID() {
        return this.OneCardTransID;
    }

    public String getStandardAccountID() {
        return this.StandardAccountID;
    }

    public String getDisplayAccountID() {
        return this.DisplayAccountID;
    }

    public String getDisplayAccountType() {
        return this.DisplayAccountType;
    }

    public String getAccountFullName() {
        return this.AccountFullName;
    }

    public void setStatus(String status) {
        this.Status = status;
    }

    public void setResponseStatus(ResponseStatus responseStatus) {
        this.ResponseStatus = responseStatus;
    }

    public void setIsCompleted(String isCompleted) {
        this.IsCompleted = isCompleted;
    }

    public void setResult(Result result) {
        this.Result = result;
    }

    public void setOneCardTransID(String oneCardTransID) {
        this.OneCardTransID = oneCardTransID;
    }

    public void setStandardAccountID(String standardAccountID) {
        this.StandardAccountID = standardAccountID;
    }

    public void setDisplayAccountID(String displayAccountID) {
        this.DisplayAccountID = displayAccountID;
    }

    public void setDisplayAccountType(String displayAccountType) {
        this.DisplayAccountType = displayAccountType;
    }

    public void setAccountFullName(String accountFullName) {
        this.AccountFullName = accountFullName;
    }

    public boolean isSuccess() {
        if (this.getStatus().equals("OK")) {
            return this.getResult() != null && this.getResult().isTransactionPass();
        }
        return false;
    }

    public double getBalance() {
        return this.getResult().getBalancePlusCredit();
    }

    public String getMessage() {
        Result r;
        Object message = "";
        ResponseStatus rs = this.getResponseStatus();
        if (rs != null && rs.getMessage() != null && !rs.getMessage().isEmpty()) {
            message = (String)message + rs.getMessage();
        }
        if ((r = this.getResult()) != null && !r.isTransactionPass()) {
            message = (String)message + r.getStatusMessage();
        }
        return message;
    }

    public String toString() {
        return ObjectUtils.createToStringBuilder((Object)this).append("status", (Object)this.Status).append("responseStatus", (Object)(this.ResponseStatus != null ? this.ResponseStatus.toString() : "")).append("isCompleted", (Object)this.IsCompleted).append("result", (Object)(this.Result != null ? this.Result.toString() : "")).append("oneCardTransID", (Object)this.OneCardTransID).append("standardAccountID", (Object)this.StandardAccountID).append("displayAccountID", (Object)this.DisplayAccountID).append("displayAccountType", (Object)this.DisplayAccountType).append("accountFullName", (Object)this.AccountFullName).toString();
    }

    public static class ResponseStatus {
        private String ErrorCode;
        private String Message;
        private String StackTrace;
        private List<String> Errors;

        public ResponseStatus(String errorcode, String message, String stackTrace, List<String> errors) {
            this.ErrorCode = errorcode;
            this.Message = message;
            this.StackTrace = stackTrace;
            this.Errors = errors;
        }

        public ResponseStatus() {
        }

        public String getErrorCode() {
            return this.ErrorCode;
        }

        public String getMessage() {
            return this.Message;
        }

        public String getStackTrace() {
            return this.StackTrace;
        }

        public List<String> getErrors() {
            return this.Errors;
        }

        public void setErrorCode(String errorcode) {
            this.ErrorCode = errorcode;
        }

        public void setMessage(String message) {
            this.Message = message;
        }

        public void setStackTrace(String stackTrace) {
            this.StackTrace = stackTrace;
        }

        public void setErrors(List<String> errors) {
            this.Errors = errors;
        }

        public String toString() {
            return "ResponseStatus{Errorcode='" + this.ErrorCode + "', Message='" + this.Message + "', StackTrace='" + this.StackTrace + "', Errors=" + String.valueOf(this.Errors) + "}";
        }
    }

    public static class Result {
        private boolean TransactionPass;
        private int Status;
        private String StatusMessage;
        private double BalancePlusCredit;
        private double BalanceNoCredit;
        private double Units;
        private String Receipt;
        private boolean SpecialFieldIsDescriptionValueMoneyAmount;

        public Result(boolean transactionPass, int status, String statusMessage, double balancePlusCredit, double balanceNoCredit, double units, String receipt, boolean specialFieldIsDescriptionValueMoneyAmount) {
            this.TransactionPass = transactionPass;
            this.Status = status;
            this.StatusMessage = statusMessage;
            this.BalancePlusCredit = balancePlusCredit;
            this.BalanceNoCredit = balanceNoCredit;
            this.Units = units;
            this.Receipt = receipt;
            this.SpecialFieldIsDescriptionValueMoneyAmount = specialFieldIsDescriptionValueMoneyAmount;
        }

        public Result() {
        }

        public boolean isTransactionPass() {
            return this.TransactionPass;
        }

        public void setTransactionPass(boolean transactionPass) {
            this.TransactionPass = transactionPass;
        }

        public int getStatus() {
            return this.Status;
        }

        public void setStatus(int status) {
            this.Status = status;
        }

        public String getStatusMessage() {
            return this.StatusMessage;
        }

        public void setStatusMessage(String statusMessage) {
            this.StatusMessage = statusMessage;
        }

        public double getBalancePlusCredit() {
            return this.BalancePlusCredit;
        }

        public String getReceipt() {
            return this.Receipt;
        }

        public boolean getSpecialFieldIsDescriptionValueMoneyAmount() {
            return this.SpecialFieldIsDescriptionValueMoneyAmount;
        }

        public void setBalancePlusCredit(double balancePlusCredit) {
            this.BalancePlusCredit = balancePlusCredit;
        }

        public double getBalanceNoCredit() {
            return this.BalanceNoCredit;
        }

        public void setBalanceNoCredit(double balanceNoCredit) {
            this.BalanceNoCredit = balanceNoCredit;
        }

        public double getUnits() {
            return this.Units;
        }

        public void setUnits(double units) {
            this.Units = units;
        }

        public void setReceipt(String receipt) {
            this.Receipt = receipt;
        }

        public void setSpecialFieldIsDescriptionValueMoneyAmount(boolean specialFieldIsDescriptionValueMoneyAmount) {
            this.SpecialFieldIsDescriptionValueMoneyAmount = specialFieldIsDescriptionValueMoneyAmount;
        }

        public String toString() {
            return "Result{TransactionPass=" + this.TransactionPass + ", Status=" + this.Status + ", StatusMessage='" + this.StatusMessage + "', BalancePlusCredit=" + this.BalancePlusCredit + ", BalanceNoCredit=" + this.BalanceNoCredit + ", Units=" + this.Units + ", SpecialFieldIsDescriptionValueMoneyAmount=" + this.SpecialFieldIsDescriptionValueMoneyAmount + "}";
        }
    }
}

