/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.touchnetOnecard;

import biz.papercut.pcng.domain.User;
import biz.papercut.pcng.ext.paymentgateway.GatewayUtils;
import biz.papercut.pcng.ext.paymentgateway.touchnetOnecard.TouchnetOnecardPlugin;
import biz.papercut.pcng.ext.paymentgateway.touchnetOnecard.TouchnetOnecardResponse;
import biz.papercut.pcng.plugin.PluginManager;
import biz.papercut.pcng.plugin.SpringContextPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin3;
import biz.papercut.pcng.plugin.TopupAccountOnDemandPlugin4;
import biz.papercut.pcng.service.UserManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class TouchnetOnecardTopupAccountOnDemandPlugin
implements TopupAccountOnDemandPlugin4,
SpringContextPlugin {
    private static final Logger logger = LoggerFactory.getLogger(TouchnetOnecardTopupAccountOnDemandPlugin.class);
    @Nullable
    @GuardedBy(value="this")
    private ApplicationContext _ctx;

    public Map<String, Double> getBalance(Map<String, String> userDetails) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        TouchnetOnecardPlugin cp = TouchnetOnecardTopupAccountOnDemandPlugin.getTouchnetOnecardPlugin();
        if (!cp.isBalanceDisplayEnabled()) {
            logger.debug("Touchnet Onecard balance display disabled.");
            return null;
        }
        String username = userDetails.get("username");
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            logger.error("Unknown user: {}", (Object)username);
            return null;
        }
        try {
            TouchnetOnecardResponse tr = cp.getBalance(user);
            if (!tr.isSuccess()) {
                String msg = "Unable to retrieve Touchnet Onecard balance for user \" + username + \": \"  + tr.getMessage()";
                logger.error(msg);
                logger.debug("{}{}", (Object)msg, (Object)tr);
                return null;
            }
            HashMap<String, Double> balances = new HashMap<String, Double>();
            balances.put(cp.getBalanceDisplayLabel(), tr.getBalance());
            return balances;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public TopupAccountOnDemandPlugin3.AvailableCredit getAvailableCreditForTopUp(String username, @Nullable String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            return null;
        }
        TouchnetOnecardPlugin cp = TouchnetOnecardTopupAccountOnDemandPlugin.getTouchnetOnecardPlugin();
        if (!cp.isOnDemandTransferEnabledForUser(username)) {
            logger.debug("Touchnet Onecard top-up on demand plugin not enabled for user '{}'.", (Object)username);
            return null;
        }
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            logger.error("Unknown user: {}", (Object)username);
            return null;
        }
        try {
            TouchnetOnecardResponse response = cp.getBalance(user);
            if (!response.isSuccess()) {
                logger.error("Error retrieving available credit for user '{}', response: {}", (Object)username, (Object)response);
                return null;
            }
            return new TopupAccountOnDemandPlugin3.AvailableCredit(false, response.getBalance());
        }
        catch (IOException e) {
            return null;
        }
    }

    public TopupAccountOnDemandPlugin.TopupResponse getTopup(double amountRequired, String username, String sharedAccount, TopupAccountOnDemandPlugin.AccountType accountCharged, Map<String, String> usageDetails) {
        if (!this.isPluginEnabled()) {
            return null;
        }
        if (accountCharged == TopupAccountOnDemandPlugin.AccountType.SharedAccount) {
            logger.debug("Touchnet Onecard top-up on demand plugin not enabled for shared accounts.");
            return null;
        }
        double topupAmount = TouchnetOnecardTopupAccountOnDemandPlugin.calcTopUpAmount(amountRequired);
        if (topupAmount <= 0.0) {
            return null;
        }
        User user = this.getUserManager().getUser(username);
        if (user == null) {
            logger.debug("Unknown user: {}", (Object)username);
            return null;
        }
        TouchnetOnecardPlugin cp = TouchnetOnecardTopupAccountOnDemandPlugin.getTouchnetOnecardPlugin();
        if (!cp.isOnDemandTransferEnabledForUser(username)) {
            logger.debug("Touchnet Onecard top-up on demand plugin not enabled for user '{}'.", (Object)username);
            return null;
        }
        String txnComment = cp.getOnDemandTransferTransactionComment();
        return GatewayUtils.performTopupDebit((TopupAccountOnDemandPlugin3)this, amount -> {
            try {
                TouchnetOnecardResponse r = cp.performDebit(user, amount);
                logger.debug("Result: {}", (Object)r);
                return r.isSuccess() ? Double.valueOf(amount) : null;
            }
            catch (IOException e) {
                return null;
            }
        }, topupAmount, amountRequired, username, sharedAccount, accountCharged, usageDetails, txnComment);
    }

    private static double calcTopUpAmount(double amountRequired) {
        if (amountRequired <= 0.0) {
            return 0.0;
        }
        TouchnetOnecardPlugin cp = TouchnetOnecardTopupAccountOnDemandPlugin.getTouchnetOnecardPlugin();
        Double defaultAmount = cp.getOnDemandTransferDefaultTransferAmount();
        Double maxAmount = cp.getOnDemandTransferMaxTransferAmount();
        if (defaultAmount == null || maxAmount == null) {
            return 0.0;
        }
        int cents = TouchnetOnecardPlugin.roundDoubleDollarsToCents(amountRequired);
        double topupAmount = (double)cents / 100.0;
        if (defaultAmount > 0.0 && maxAmount > 0.0 && defaultAmount > maxAmount) {
            logger.warn("Touchnet Onecard default transfer amount is greater than the max transfer amount.  Using default transfer amount as max amount.");
            maxAmount = defaultAmount;
        }
        if (defaultAmount > 0.0 && amountRequired < defaultAmount) {
            logger.debug("Using default transfer amount of {}", (Object)defaultAmount);
            topupAmount = defaultAmount;
        }
        if (maxAmount > 0.0 && topupAmount > maxAmount) {
            logger.debug("Transfer amount of {} exceeds maximum of {}", (Object)topupAmount, (Object)maxAmount);
            topupAmount = 0.0;
        }
        return topupAmount;
    }

    public boolean isPluginEnabled() {
        TouchnetOnecardPlugin cp = TouchnetOnecardTopupAccountOnDemandPlugin.getTouchnetOnecardPlugin();
        return cp.isPluginEnabled() && cp.isOnDemandTransferEnabled();
    }

    public synchronized ApplicationContext getApplicationContext() {
        return this._ctx;
    }

    public synchronized void setApplicationContext(ApplicationContext ctx) {
        this._ctx = ctx;
    }

    private static TouchnetOnecardPlugin getTouchnetOnecardPlugin() {
        return (TouchnetOnecardPlugin)PluginManager.getInstance().getPluginByClass(TouchnetOnecardPlugin.class);
    }

    private UserManager getUserManager() {
        return (UserManager)this.getApplicationContext().getBean("userManager", UserManager.class);
    }
}

