/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.ext.paymentgateway.util;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import jakarta.xml.soap.SOAPPart;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class SOAPLogMessageHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger logger = LoggerFactory.getLogger(SOAPLogMessageHandler.class);
    final boolean logPayload;
    final boolean indentPayload;
    @Nullable
    final SOAPMessageObserver messageObserver;
    @Nullable
    private Transformer transformer;

    private SOAPLogMessageHandler(Builder builder) {
        this.indentPayload = builder.indentPayload;
        this.logPayload = builder.logPayload;
        this.messageObserver = builder.messageObserver;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.transformer = builder.stylesheet != null ? transformerFactory.newTransformer(builder.stylesheet) : transformerFactory.newTransformer();
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
            this.transformer.setOutputProperty("indent", BooleanUtils.toStringYesNo((boolean)this.indentPayload));
        }
        catch (TransformerConfigurationException e) {
            logger.error("Error creating / configuring logging XML transformer", (Throwable)e);
        }
    }

    public static SOAPLogMessageHandler payloadLogger() {
        return SOAPLogMessageHandler.builder().withPayload(true).build();
    }

    public static SOAPLogMessageHandler payloadLogger(InputStream stylesheet) {
        return SOAPLogMessageHandler.builder().withPayload(true).withStylesheet(new StreamSource(stylesheet)).build();
    }

    public static <T extends Service> T attachPayloadLogger(T svc, Class<T> clazz) {
        svc.setHandlerResolver(portInfo -> Collections.singletonList(SOAPLogMessageHandler.payloadLogger()));
        return svc;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void close(MessageContext ctx) {
    }

    public boolean handleFault(SOAPMessageContext ctx) {
        return true;
    }

    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    public boolean handleMessage(SOAPMessageContext context) {
        if (logger.isDebugEnabled()) {
            String loggablePayload;
            String soapAction = (String)context.get((Object)"jakarta.xml.ws.soap.http.soapaction.uri");
            Boolean isOutbound = (Boolean)context.get((Object)"jakarta.xml.ws.handler.message.outbound");
            String endpointURI = (String)context.get((Object)"jakarta.xml.ws.service.endpoint.address");
            Supplier payLoad = Suppliers.memoize(() -> this.extractMessagePayload(context));
            String string = loggablePayload = this.logPayload ? (String)payLoad.get() : "";
            if (isOutbound.booleanValue()) {
                logger.debug(">>> REQUEST: {} {} {}", new Object[]{endpointURI, StringUtils.trimToEmpty((String)soapAction), loggablePayload});
            } else {
                logger.debug("<<< RESPONSE: {} HTTP {} {}", new Object[]{endpointURI, context.get((Object)"jakarta.xml.ws.http.response.code"), loggablePayload});
            }
            if (this.messageObserver != null) {
                try {
                    this.messageObserver.handleMessage(isOutbound, endpointURI, (String)payLoad.get());
                }
                catch (Exception ex) {
                    logger.error("Problem calling observer: {}", (Object)this.messageObserver, (Object)ex);
                }
            }
        }
        return true;
    }

    String extractMessagePayload(SOAPMessageContext context) {
        try {
            SOAPPart payload = context.getMessage().getSOAPPart();
            return this.nodeToString((Node)payload);
        }
        catch (Throwable e) {
            logger.debug("Error parsing soap message payload for logging");
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        if (this.transformer != null) {
            try {
                SOAPLogMessageHandler sOAPLogMessageHandler = this;
                synchronized (sOAPLogMessageHandler) {
                    this.transformer.transform(new DOMSource(node), new StreamResult(sw));
                }
            }
            catch (TransformerException ex) {
                logger.error("Transform failed: {}", (Object)String.valueOf(ex));
            }
        }
        return sw.toString();
    }

    public static final class Builder {
        private boolean indentPayload;
        private boolean logPayload;
        @Nullable
        private SOAPMessageObserver messageObserver;
        @Nullable
        private Source stylesheet;

        private Builder() {
        }

        public Builder withIndenting(boolean val) {
            this.indentPayload = val;
            return this;
        }

        public Builder withPayload(boolean val) {
            this.logPayload = val;
            return this;
        }

        public Builder withMessageObserver(@Nullable SOAPMessageObserver observer) {
            this.messageObserver = observer;
            return this;
        }

        public Builder withStylesheet(Source stylesheet) {
            this.stylesheet = stylesheet;
            return this;
        }

        public SOAPLogMessageHandler build() {
            return new SOAPLogMessageHandler(this);
        }
    }

    public static interface SOAPMessageObserver {
        public void handleMessage(boolean var1, String var2, String var3);
    }
}

