// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_AUTOFILL_CORE_BROWSER_SUGGESTION_H_
#define COMPONENTS_AUTOFILL_CORE_BROWSER_SUGGESTION_H_

#include <string>

#include "base/memory/scoped_ptr.h"
#include "base/strings/string16.h"

namespace autofill {

class AutofillProfile;
class CreditCard;

// Represents a single FormGroup and a specific data variant. This is assigned
// by the storage layer to uniquely identify the profile this came from.
struct SuggestionBackendID {
  SuggestionBackendID();
  SuggestionBackendID(const std::string& guid, size_t variant);
  ~SuggestionBackendID();

  std::string guid;
  size_t variant;

  // For using as a key in a map.
  bool operator<(const SuggestionBackendID& other) const;
};

struct Suggestion {
 public:
  Suggestion();

  // Copy constructor for STL containers.
  Suggestion(const Suggestion& other);

  explicit Suggestion(const base::string16& value);

  // Constructor for unit tests. It will convert the strings from UTF-8 to
  // UTF-16.
  Suggestion(const std::string& value,
             const std::string& label,
             const std::string& icon,
             int frontend_id);

  ~Suggestion();

  // ID generated by the backend layer. This identifies the exact autofill
  // profile that generated this suggestion.
  SuggestionBackendID backend_id;

  // ID for the frontend to use in identifying the particular result. Positive
  // values are sent over IPC to identify the item selected. Negative values
  // (see popup_item_ids.h) have special built-in meanings. Default initialized
  // to 0.
  int frontend_id;

  base::string16 value;
  base::string16 label;
  base::string16 icon;
};

}  // namespace autofill

#endif  // COMPONENTS_AUTOFILL_CORE_BROWSER_SUGGESTION_H_
