// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/browser/warning_service_factory.h"

#include "components/keyed_service/content/browser_context_dependency_manager.h"
#include "extensions/browser/extension_registry_factory.h"
#include "extensions/browser/extensions_browser_client.h"
#include "extensions/browser/warning_service.h"

using content::BrowserContext;

namespace extensions {

// static
WarningService* WarningServiceFactory::GetForBrowserContext(
    BrowserContext* context) {
  return static_cast<WarningService*>(
      GetInstance()->GetServiceForBrowserContext(context, true));
}

// static
WarningServiceFactory* WarningServiceFactory::GetInstance() {
  return Singleton<WarningServiceFactory>::get();
}

WarningServiceFactory::WarningServiceFactory()
    : BrowserContextKeyedServiceFactory(
          "WarningService",
          BrowserContextDependencyManager::GetInstance()) {
  DependsOn(ExtensionRegistryFactory::GetInstance());
}

WarningServiceFactory::~WarningServiceFactory() {
}

KeyedService* WarningServiceFactory::BuildServiceInstanceFor(
    BrowserContext* context) const {
  return new WarningService(context);
}

BrowserContext* WarningServiceFactory::GetBrowserContextToUse(
    BrowserContext* context) const {
  // Redirected in incognito.
  return ExtensionsBrowserClient::Get()->GetOriginalContext(context);
}

}  // namespace extensions
