// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_COCOA_APPS_TITLEBAR_BACKGROUND_VIEW_H_
#define CHROME_BROWSER_UI_COCOA_APPS_TITLEBAR_BACKGROUND_VIEW_H_

#import <Cocoa/Cocoa.h>

#import "base/mac/scoped_nsobject.h"
#include "third_party/skia/include/core/SkColor.h"

// A view that paints a solid color. Used to change the title bar background.
@interface TitlebarBackgroundView : NSView {
 @private
  base::scoped_nsobject<NSColor> color_;
  base::scoped_nsobject<NSColor> inactiveColor_;
}

// Adds a TitlebarBackgroundView to the [[window contentView] superView].
+ (void)addToNSWindow:(NSWindow*)window
          activeColor:(SkColor)activeColor
        inactiveColor:(SkColor)inactiveColor;
@end

#endif  // CHROME_BROWSER_UI_COCOA_APPS_TITLEBAR_BACKGROUND_VIEW_H_
