// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROMEOS_DBUS_FAKE_BLUETOOTH_LE_ADVERTISEMENT_SERVICE_PROVIDER_H_
#define CHROMEOS_DBUS_FAKE_BLUETOOTH_LE_ADVERTISEMENT_SERVICE_PROVIDER_H_

#include "base/bind.h"
#include "base/callback.h"
#include "base/memory/scoped_ptr.h"
#include "chromeos/chromeos_export.h"
#include "chromeos/dbus/bluetooth_le_advertisement_service_provider.h"
#include "dbus/file_descriptor.h"
#include "dbus/object_path.h"

namespace chromeos {

// FakeBluetoothAdvertisementServiceProvider simulates the behavior of a local
// Bluetooth agent object and is used both in test cases in place of a
// mock and on the Linux desktop.
class CHROMEOS_EXPORT FakeBluetoothLEAdvertisementServiceProvider
    : public BluetoothLEAdvertisementServiceProvider {
 public:
  FakeBluetoothLEAdvertisementServiceProvider(
      const dbus::ObjectPath& object_path,
      Delegate* delegate);
  ~FakeBluetoothLEAdvertisementServiceProvider() override;

  // Each of these calls the equivalent
  // BluetoothAdvertisementServiceProvider::Delegate method on the object passed
  // on construction.
  void Release();

  const dbus::ObjectPath& object_path() { return object_path_; }

 private:
  friend class FakeBluetoothLEAdvertisingManagerClient;

  // All incoming method calls are passed on to the Delegate and a callback
  // passed to generate the reply. |delegate_| is generally the object that
  // owns this one, and must outlive it.
  Delegate* delegate_;

  DISALLOW_COPY_AND_ASSIGN(FakeBluetoothLEAdvertisementServiceProvider);
};

}  // namespace chromeos

#endif  // CHROMEOS_DBUS_FAKE_BLUETOOTH_LE_ADVERTISEMENT_SERVICE_PROVIDER_H_
