// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * Test whether given line is valid.
 * @param {Object} line
 * @param {number} length Length of line data.
 * @return {boolean} Line is valid or not.
 */
var lineIsValid = function(line, length) {
  if (!('id' in line))
    return false;
  if (!('label' in line))
    return false;
  if (!('data' in line) ||
      'data' in line && line.data.length !== length)
    return false;

  return true;
};

// Test title format is file-name:function-name.
test('graph-view:generateLines_', function() {
  stop();
  $.getJSON('../data/sample.json', function(data) {
    start();
    var profiler = new Profiler(data);
    var models = profiler.parseTemplate_();
    var length = models.length;
    var lines = GraphView.prototype.generateLines_(models);
    lines.forEach(function(line) {
      ok(lineIsValid(line, length));
    });
    inspect(lines, 'lines generated by graph view:\n');
  });
});
