// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

package org.chromium.chrome.browser.webapps;

import android.content.Intent;
import android.test.InstrumentationTestCase;
import android.test.suitebuilder.annotation.SmallTest;

import org.chromium.base.test.util.Feature;
import org.chromium.chrome.browser.ShortcutHelper;
import org.chromium.content_public.common.ScreenOrientationValues;

/**
 * Tests the WebappInfo class's ability to parse various URLs.
 */
public class WebappInfoTest extends InstrumentationTestCase {
    @SmallTest
    @Feature({"Webapps"})
    public void testAbout() {
        String id = "webapp id";
        String title = "webapp title";
        String url = "about:blank";

        WebappInfo info = WebappInfo.create(id, url,
                null, title, ScreenOrientationValues.DEFAULT, ShortcutHelper.SOURCE_UNKNOWN);
        assertNotNull(info);
    }

    @SmallTest
    @Feature({"Webapps"})
    public void testRandomUrl() {
        String id = "webapp id";
        String title = "webapp title";
        String url = "http://google.com";

        WebappInfo info = WebappInfo.create(id, url,
                null, title, ScreenOrientationValues.DEFAULT, ShortcutHelper.SOURCE_UNKNOWN);
        assertNotNull(info);
    }

    @SmallTest
    @Feature({"Webapps"})
    public void testSpacesInUrl() {
        String id = "webapp id";
        String title = "webapp title";
        String bustedUrl = "http://money.cnn.com/?category=Latest News";

        Intent intent = new Intent();
        intent.putExtra(ShortcutHelper.EXTRA_ID, id);
        intent.putExtra(ShortcutHelper.EXTRA_TITLE, title);
        intent.putExtra(ShortcutHelper.EXTRA_URL, bustedUrl);

        WebappInfo info = WebappInfo.create(intent);
        assertNotNull(info);
    }

    @SmallTest
    @Feature({"Webapps"})
    public void testOrientationAndSource() {
        String id = "webapp id";
        String title = "webapp title";
        String url = "http://money.cnn.com";

        WebappInfo info = WebappInfo.create(id, url,
                null, title, ScreenOrientationValues.DEFAULT, ShortcutHelper.SOURCE_UNKNOWN);
        assertNotNull(info);
        assertEquals(info.orientation(), ScreenOrientationValues.DEFAULT);
        assertEquals(info.source(), ShortcutHelper.SOURCE_UNKNOWN);
    }
}
