# Copyright (c) 2012 The Chromium Authors. All rights reserved.
#
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    # These files lists are shared with the GN build.
    'browser_chromeos_sources': [
        # All .cc, .h, .m, and .mm files under browser/chromeos, except for tests
        # and mocks.
        'browser/chromeos/accessibility/accessibility_manager.cc',
        'browser/chromeos/accessibility/accessibility_manager.h',
        'browser/chromeos/accessibility/accessibility_util.cc',
        'browser/chromeos/accessibility/accessibility_util.h',
        'browser/chromeos/accessibility/magnification_manager.cc',
        'browser/chromeos/accessibility/magnification_manager.h',
        'browser/chromeos/accessibility/spoken_feedback_event_rewriter.cc',
        'browser/chromeos/accessibility/spoken_feedback_event_rewriter.h',
        'browser/chromeos/app_mode/app_launch_utils.cc',
        'browser/chromeos/app_mode/app_launch_utils.h',
        'browser/chromeos/app_mode/app_session_lifetime.cc',
        'browser/chromeos/app_mode/app_session_lifetime.h',
        'browser/chromeos/app_mode/certificate_manager_dialog.cc',
        'browser/chromeos/app_mode/certificate_manager_dialog.h',
        'browser/chromeos/app_mode/kiosk_app_data.cc',
        'browser/chromeos/app_mode/kiosk_app_data.h',
        'browser/chromeos/app_mode/kiosk_app_data_delegate.h',
        'browser/chromeos/app_mode/kiosk_app_external_loader.cc',
        'browser/chromeos/app_mode/kiosk_app_external_loader.h',
        'browser/chromeos/app_mode/kiosk_app_launch_error.cc',
        'browser/chromeos/app_mode/kiosk_app_launch_error.h',
        'browser/chromeos/app_mode/kiosk_app_manager.cc',
        'browser/chromeos/app_mode/kiosk_app_manager.h',
        'browser/chromeos/app_mode/kiosk_app_manager_observer.h',
        'browser/chromeos/app_mode/kiosk_app_update_service.cc',
        'browser/chromeos/app_mode/kiosk_app_update_service.h',
        'browser/chromeos/app_mode/kiosk_diagnosis_runner.cc',
        'browser/chromeos/app_mode/kiosk_diagnosis_runner.h',
        'browser/chromeos/app_mode/kiosk_external_update_validator.cc',
        'browser/chromeos/app_mode/kiosk_external_update_validator.h',
        'browser/chromeos/app_mode/kiosk_external_updater.cc',
        'browser/chromeos/app_mode/kiosk_external_updater.h',
        'browser/chromeos/app_mode/kiosk_mode_idle_app_name_notification.cc',
        'browser/chromeos/app_mode/kiosk_mode_idle_app_name_notification.h',
        'browser/chromeos/app_mode/kiosk_profile_loader.cc',
        'browser/chromeos/app_mode/kiosk_profile_loader.h',
        'browser/chromeos/app_mode/startup_app_launcher.cc',
        'browser/chromeos/app_mode/startup_app_launcher.h',
        'browser/chromeos/attestation/attestation_ca_client.cc',
        'browser/chromeos/attestation/attestation_ca_client.h',
        'browser/chromeos/attestation/attestation_policy_observer.cc',
        'browser/chromeos/attestation/attestation_policy_observer.h',
        'browser/chromeos/attestation/platform_verification_dialog.cc',
        'browser/chromeos/attestation/platform_verification_dialog.h',
        'browser/chromeos/attestation/platform_verification_flow.cc',
        'browser/chromeos/attestation/platform_verification_flow.h',
        'browser/chromeos/attestation/platform_verification_impl.cc',
        'browser/chromeos/attestation/platform_verification_impl.h',
        'browser/chromeos/background/ash_user_wallpaper_delegate.cc',
        'browser/chromeos/background/ash_user_wallpaper_delegate.h',
        'browser/chromeos/base/locale_util.cc',
        'browser/chromeos/base/locale_util.h',
        'browser/chromeos/bluetooth/bluetooth_pairing_dialog.cc',
        'browser/chromeos/bluetooth/bluetooth_pairing_dialog.h',
        'browser/chromeos/boot_times_recorder.cc',
        'browser/chromeos/boot_times_recorder.h',
        'browser/chromeos/camera_detector.cc',
        'browser/chromeos/camera_detector.h',
        'browser/chromeos/camera_presence_notifier.cc',
        'browser/chromeos/camera_presence_notifier.h',
        'browser/chromeos/chrome_browser_main_chromeos.cc',
        'browser/chromeos/chrome_browser_main_chromeos.h',
        'browser/chromeos/customization/customization_document.cc',
        'browser/chromeos/customization/customization_document.h',
        'browser/chromeos/customization/customization_wallpaper_downloader.cc',
        'browser/chromeos/customization/customization_wallpaper_downloader.h',
        'browser/chromeos/dbus/chrome_console_service_provider_delegate.cc',
        'browser/chromeos/dbus/chrome_console_service_provider_delegate.h',
        'browser/chromeos/dbus/chrome_display_power_service_provider_delegate.cc',
        'browser/chromeos/dbus/chrome_display_power_service_provider_delegate.h',
        'browser/chromeos/dbus/chrome_proxy_resolver_delegate.cc',
        'browser/chromeos/dbus/chrome_proxy_resolver_delegate.h',
        'browser/chromeos/dbus/screen_lock_service_provider.cc',
        'browser/chromeos/dbus/screen_lock_service_provider.h',
        'browser/chromeos/device/input_service_proxy.cc',
        'browser/chromeos/device/input_service_proxy.h',
        'browser/chromeos/device_uma.cc',
        'browser/chromeos/device_uma.h',
        'browser/chromeos/display/display_configuration_observer.cc',
        'browser/chromeos/display/display_configuration_observer.h',
        'browser/chromeos/display/display_preferences.cc',
        'browser/chromeos/display/display_preferences.h',
        'browser/chromeos/display/output_protection_delegate.cc',
        'browser/chromeos/display/output_protection_delegate.h',
        'browser/chromeos/display/overscan_calibrator.cc',
        'browser/chromeos/display/overscan_calibrator.h',
        'browser/chromeos/drive/change_list_loader.cc',
        'browser/chromeos/drive/change_list_loader.h',
        'browser/chromeos/drive/change_list_loader_observer.h',
        'browser/chromeos/drive/change_list_processor.cc',
        'browser/chromeos/drive/change_list_processor.h',
        'browser/chromeos/drive/debug_info_collector.cc',
        'browser/chromeos/drive/debug_info_collector.h',
        'browser/chromeos/drive/directory_loader.cc',
        'browser/chromeos/drive/directory_loader.h',
        'browser/chromeos/drive/download_handler.cc',
        'browser/chromeos/drive/download_handler.h',
        'browser/chromeos/drive/drive_file_stream_reader.cc',
        'browser/chromeos/drive/drive_file_stream_reader.h',
        'browser/chromeos/drive/drive_integration_service.cc',
        'browser/chromeos/drive/drive_integration_service.h',
        'browser/chromeos/drive/file_cache.cc',
        'browser/chromeos/drive/file_cache.h',
        'browser/chromeos/drive/file_system.cc',
        'browser/chromeos/drive/file_system.h',
        'browser/chromeos/drive/file_system/copy_operation.cc',
        'browser/chromeos/drive/file_system/copy_operation.h',
        'browser/chromeos/drive/file_system/create_directory_operation.cc',
        'browser/chromeos/drive/file_system/create_directory_operation.h',
        'browser/chromeos/drive/file_system/create_file_operation.cc',
        'browser/chromeos/drive/file_system/create_file_operation.h',
        'browser/chromeos/drive/file_system/download_operation.cc',
        'browser/chromeos/drive/file_system/download_operation.h',
        'browser/chromeos/drive/file_system/get_file_for_saving_operation.cc',
        'browser/chromeos/drive/file_system/get_file_for_saving_operation.h',
        'browser/chromeos/drive/file_system/move_operation.cc',
        'browser/chromeos/drive/file_system/move_operation.h',
        'browser/chromeos/drive/file_system/open_file_operation.cc',
        'browser/chromeos/drive/file_system/open_file_operation.h',
        'browser/chromeos/drive/file_system/operation_delegate.cc',
        'browser/chromeos/drive/file_system/operation_delegate.h',
        'browser/chromeos/drive/file_system/remove_operation.cc',
        'browser/chromeos/drive/file_system/remove_operation.h',
        'browser/chromeos/drive/file_system/search_operation.cc',
        'browser/chromeos/drive/file_system/search_operation.h',
        'browser/chromeos/drive/file_system/set_property_operation.cc',
        'browser/chromeos/drive/file_system/set_property_operation.h',
        'browser/chromeos/drive/file_system/touch_operation.cc',
        'browser/chromeos/drive/file_system/touch_operation.h',
        'browser/chromeos/drive/file_system/truncate_operation.cc',
        'browser/chromeos/drive/file_system/truncate_operation.h',
        'browser/chromeos/drive/file_system_core_util.cc',
        'browser/chromeos/drive/file_system_core_util.h',
        'browser/chromeos/drive/file_system_interface.cc',
        'browser/chromeos/drive/file_system_interface.h',
        'browser/chromeos/drive/file_system_metadata.cc',
        'browser/chromeos/drive/file_system_metadata.h',
        'browser/chromeos/drive/file_system_observer.h',
        'browser/chromeos/drive/file_system_util.cc',
        'browser/chromeos/drive/file_system_util.h',
        'browser/chromeos/drive/file_task_executor.cc',
        'browser/chromeos/drive/file_task_executor.h',
        'browser/chromeos/drive/file_write_watcher.cc',
        'browser/chromeos/drive/file_write_watcher.h',
        'browser/chromeos/drive/fileapi/async_file_util.cc',
        'browser/chromeos/drive/fileapi/async_file_util.h',
        'browser/chromeos/drive/fileapi/file_system_backend_delegate.cc',
        'browser/chromeos/drive/fileapi/file_system_backend_delegate.h',
        'browser/chromeos/drive/fileapi/fileapi_worker.cc',
        'browser/chromeos/drive/fileapi/fileapi_worker.h',
        'browser/chromeos/drive/fileapi/webkit_file_stream_reader_impl.cc',
        'browser/chromeos/drive/fileapi/webkit_file_stream_reader_impl.h',
        'browser/chromeos/drive/fileapi/webkit_file_stream_writer_impl.cc',
        'browser/chromeos/drive/fileapi/webkit_file_stream_writer_impl.h',
        'browser/chromeos/drive/remove_stale_cache_files.cc',
        'browser/chromeos/drive/remove_stale_cache_files.h',
        'browser/chromeos/drive/resource_entry_conversion.cc',
        'browser/chromeos/drive/resource_entry_conversion.h',
        'browser/chromeos/drive/resource_metadata.cc',
        'browser/chromeos/drive/resource_metadata.h',
        'browser/chromeos/drive/resource_metadata_storage.cc',
        'browser/chromeos/drive/resource_metadata_storage.h',
        'browser/chromeos/drive/search_metadata.cc',
        'browser/chromeos/drive/search_metadata.h',
        'browser/chromeos/drive/sync/entry_revert_performer.cc',
        'browser/chromeos/drive/sync/entry_revert_performer.h',
        'browser/chromeos/drive/sync/entry_update_performer.cc',
        'browser/chromeos/drive/sync/entry_update_performer.h',
        'browser/chromeos/drive/sync/remove_performer.cc',
        'browser/chromeos/drive/sync/remove_performer.h',
        'browser/chromeos/drive/sync_client.cc',
        'browser/chromeos/drive/sync_client.h',
        'browser/chromeos/drive/write_on_cache_file.cc',
        'browser/chromeos/drive/write_on_cache_file.h',
        'browser/chromeos/enrollment_dialog_view.cc',
        'browser/chromeos/enrollment_dialog_view.h',
        'browser/chromeos/events/event_rewriter.cc',
        'browser/chromeos/events/event_rewriter.h',
        'browser/chromeos/events/event_rewriter_controller.cc',
        'browser/chromeos/events/event_rewriter_controller.h',
        'browser/chromeos/events/keyboard_driven_event_rewriter.cc',
        'browser/chromeos/events/keyboard_driven_event_rewriter.h',
        'browser/chromeos/events/system_key_event_listener.cc',
        'browser/chromeos/events/system_key_event_listener.h',
        'browser/chromeos/events/xinput_hierarchy_changed_event_listener.cc',
        'browser/chromeos/events/xinput_hierarchy_changed_event_listener.h',
        'browser/chromeos/extensions/default_app_order.cc',
        'browser/chromeos/extensions/default_app_order.h',
        'browser/chromeos/extensions/device_local_account_external_policy_loader.cc',
        'browser/chromeos/extensions/device_local_account_external_policy_loader.h',
        'browser/chromeos/extensions/device_local_account_management_policy_provider.cc',
        'browser/chromeos/extensions/device_local_account_management_policy_provider.h',
        'browser/chromeos/extensions/dictionary_event_router.cc',
        'browser/chromeos/extensions/dictionary_event_router.h',
        'browser/chromeos/extensions/extension_system_event_observer.cc',
        'browser/chromeos/extensions/extension_system_event_observer.h',
        'browser/chromeos/extensions/external_cache.cc',
        'browser/chromeos/extensions/external_cache.h',
        'browser/chromeos/extensions/info_private_api.cc',
        'browser/chromeos/extensions/info_private_api.h',
        'browser/chromeos/extensions/input_method_event_router.cc',
        'browser/chromeos/extensions/input_method_event_router.h',
        'browser/chromeos/extensions/install_limiter.cc',
        'browser/chromeos/extensions/install_limiter.h',
        'browser/chromeos/extensions/install_limiter_factory.cc',
        'browser/chromeos/extensions/install_limiter_factory.h',
        'browser/chromeos/extensions/launcher_search_provider.cc',
        'browser/chromeos/extensions/launcher_search_provider.h',
        'browser/chromeos/extensions/media_player_event_router.cc',
        'browser/chromeos/extensions/media_player_event_router.h',
        'browser/chromeos/external_metrics.cc',
        'browser/chromeos/external_metrics.h',
        'browser/chromeos/external_protocol_dialog.cc',
        'browser/chromeos/external_protocol_dialog.h',
        'browser/chromeos/file_manager/app_id.h',
        'browser/chromeos/file_manager/file_browser_handlers.cc',
        'browser/chromeos/file_manager/file_browser_handlers.h',
        'browser/chromeos/file_manager/file_tasks.cc',
        'browser/chromeos/file_manager/file_tasks.h',
        'browser/chromeos/file_manager/file_watcher.cc',
        'browser/chromeos/file_manager/file_watcher.h',
        'browser/chromeos/file_manager/fileapi_util.cc',
        'browser/chromeos/file_manager/fileapi_util.h',
        'browser/chromeos/file_manager/filesystem_api_util.cc',
        'browser/chromeos/file_manager/filesystem_api_util.h',
        'browser/chromeos/file_manager/open_util.cc',
        'browser/chromeos/file_manager/open_util.h',
        'browser/chromeos/file_manager/open_with_browser.cc',
        'browser/chromeos/file_manager/open_with_browser.h',
        'browser/chromeos/file_manager/path_util.cc',
        'browser/chromeos/file_manager/path_util.h',
        'browser/chromeos/file_manager/select_file_dialog_util.cc',
        'browser/chromeos/file_manager/select_file_dialog_util.h',
        'browser/chromeos/file_manager/snapshot_manager.cc',
        'browser/chromeos/file_manager/snapshot_manager.h',
        'browser/chromeos/file_manager/url_util.cc',
        'browser/chromeos/file_manager/url_util.h',
        'browser/chromeos/file_manager/volume_manager.cc',
        'browser/chromeos/file_manager/volume_manager.h',
        'browser/chromeos/file_manager/volume_manager_factory.cc',
        'browser/chromeos/file_manager/volume_manager_factory.h',
        'browser/chromeos/file_manager/volume_manager_observer.h',
        'browser/chromeos/file_manager/zip_file_creator.cc',
        'browser/chromeos/file_manager/zip_file_creator.h',
        'browser/chromeos/file_system_provider/abort_callback.h',
        'browser/chromeos/file_system_provider/fileapi/backend_delegate.cc',
        'browser/chromeos/file_system_provider/fileapi/backend_delegate.h',
        'browser/chromeos/file_system_provider/fileapi/buffering_file_stream_reader.cc',
        'browser/chromeos/file_system_provider/fileapi/buffering_file_stream_reader.h',
        'browser/chromeos/file_system_provider/fileapi/buffering_file_stream_writer.cc',
        'browser/chromeos/file_system_provider/fileapi/buffering_file_stream_writer.h',
        'browser/chromeos/file_system_provider/fileapi/file_stream_reader.cc',
        'browser/chromeos/file_system_provider/fileapi/file_stream_reader.h',
        'browser/chromeos/file_system_provider/fileapi/file_stream_writer.cc',
        'browser/chromeos/file_system_provider/fileapi/file_stream_writer.h',
        'browser/chromeos/file_system_provider/fileapi/provider_async_file_util.cc',
        'browser/chromeos/file_system_provider/fileapi/provider_async_file_util.h',
        'browser/chromeos/file_system_provider/fileapi/watcher_manager.cc',
        'browser/chromeos/file_system_provider/fileapi/watcher_manager.h',
        'browser/chromeos/file_system_provider/mount_path_util.cc',
        'browser/chromeos/file_system_provider/mount_path_util.h',
        'browser/chromeos/file_system_provider/notification_manager.cc',
        'browser/chromeos/file_system_provider/notification_manager.h',
        'browser/chromeos/file_system_provider/notification_manager_interface.h',
        'browser/chromeos/file_system_provider/observer.h',
        'browser/chromeos/file_system_provider/operations/abort.cc',
        'browser/chromeos/file_system_provider/operations/abort.h',
        'browser/chromeos/file_system_provider/operations/add_watcher.cc',
        'browser/chromeos/file_system_provider/operations/add_watcher.h',
        'browser/chromeos/file_system_provider/operations/close_file.cc',
        'browser/chromeos/file_system_provider/operations/close_file.h',
        'browser/chromeos/file_system_provider/operations/configure.cc',
        'browser/chromeos/file_system_provider/operations/configure.h',
        'browser/chromeos/file_system_provider/operations/copy_entry.cc',
        'browser/chromeos/file_system_provider/operations/copy_entry.h',
        'browser/chromeos/file_system_provider/operations/create_directory.cc',
        'browser/chromeos/file_system_provider/operations/create_directory.h',
        'browser/chromeos/file_system_provider/operations/create_file.cc',
        'browser/chromeos/file_system_provider/operations/create_file.h',
        'browser/chromeos/file_system_provider/operations/delete_entry.cc',
        'browser/chromeos/file_system_provider/operations/delete_entry.h',
        'browser/chromeos/file_system_provider/operations/execute_action.cc',
        'browser/chromeos/file_system_provider/operations/execute_action.h',
        'browser/chromeos/file_system_provider/operations/get_actions.cc',
        'browser/chromeos/file_system_provider/operations/get_actions.h',
        'browser/chromeos/file_system_provider/operations/get_metadata.cc',
        'browser/chromeos/file_system_provider/operations/get_metadata.h',
        'browser/chromeos/file_system_provider/operations/move_entry.cc',
        'browser/chromeos/file_system_provider/operations/move_entry.h',
        'browser/chromeos/file_system_provider/operations/open_file.cc',
        'browser/chromeos/file_system_provider/operations/open_file.h',
        'browser/chromeos/file_system_provider/operations/operation.cc',
        'browser/chromeos/file_system_provider/operations/operation.h',
        'browser/chromeos/file_system_provider/operations/read_directory.cc',
        'browser/chromeos/file_system_provider/operations/read_directory.h',
        'browser/chromeos/file_system_provider/operations/read_file.cc',
        'browser/chromeos/file_system_provider/operations/read_file.h',
        'browser/chromeos/file_system_provider/operations/remove_watcher.cc',
        'browser/chromeos/file_system_provider/operations/remove_watcher.h',
        'browser/chromeos/file_system_provider/operations/truncate.cc',
        'browser/chromeos/file_system_provider/operations/truncate.h',
        'browser/chromeos/file_system_provider/operations/unmount.cc',
        'browser/chromeos/file_system_provider/operations/unmount.h',
        'browser/chromeos/file_system_provider/operations/write_file.cc',
        'browser/chromeos/file_system_provider/operations/write_file.h',
        'browser/chromeos/file_system_provider/provided_file_system.cc',
        'browser/chromeos/file_system_provider/provided_file_system.h',
        'browser/chromeos/file_system_provider/provided_file_system_info.cc',
        'browser/chromeos/file_system_provider/provided_file_system_info.h',
        'browser/chromeos/file_system_provider/provided_file_system_interface.cc',
        'browser/chromeos/file_system_provider/provided_file_system_interface.h',
        'browser/chromeos/file_system_provider/provided_file_system_observer.cc',
        'browser/chromeos/file_system_provider/provided_file_system_observer.h',
        'browser/chromeos/file_system_provider/queue.cc',
        'browser/chromeos/file_system_provider/queue.h',
        'browser/chromeos/file_system_provider/registry.cc',
        'browser/chromeos/file_system_provider/registry.h',
        'browser/chromeos/file_system_provider/registry_interface.cc',
        'browser/chromeos/file_system_provider/registry_interface.h',
        'browser/chromeos/file_system_provider/request_manager.cc',
        'browser/chromeos/file_system_provider/request_manager.h',
        'browser/chromeos/file_system_provider/request_value.cc',
        'browser/chromeos/file_system_provider/request_value.h',
        'browser/chromeos/file_system_provider/service.cc',
        'browser/chromeos/file_system_provider/service.h',
        'browser/chromeos/file_system_provider/service_factory.cc',
        'browser/chromeos/file_system_provider/service_factory.h',
        'browser/chromeos/file_system_provider/scoped_file_opener.cc',
        'browser/chromeos/file_system_provider/scoped_file_opener.h',
        'browser/chromeos/file_system_provider/throttled_file_system.cc',
        'browser/chromeos/file_system_provider/throttled_file_system.h',
        'browser/chromeos/file_system_provider/watcher.cc',
        'browser/chromeos/file_system_provider/watcher.h',
        'browser/chromeos/fileapi/external_file_protocol_handler.cc',
        'browser/chromeos/fileapi/external_file_protocol_handler.h',
        'browser/chromeos/fileapi/external_file_url_request_job.cc',
        'browser/chromeos/fileapi/external_file_url_request_job.h',
        'browser/chromeos/fileapi/external_file_url_util.cc',
        'browser/chromeos/fileapi/external_file_url_util.h',
        'browser/chromeos/fileapi/file_access_permissions.cc',
        'browser/chromeos/fileapi/file_access_permissions.h',
        'browser/chromeos/fileapi/file_system_backend.cc',
        'browser/chromeos/fileapi/file_system_backend.h',
        'browser/chromeos/fileapi/file_system_backend_delegate.h',
        'browser/chromeos/fileapi/mtp_file_system_backend_delegate.cc',
        'browser/chromeos/fileapi/mtp_file_system_backend_delegate.h',
        'browser/chromeos/fileapi/mtp_watcher_manager.cc',
        'browser/chromeos/fileapi/mtp_watcher_manager.h',
        'browser/chromeos/first_run/drive_first_run_controller.cc',
        'browser/chromeos/first_run/drive_first_run_controller.h',
        'browser/chromeos/first_run/first_run.cc',
        'browser/chromeos/first_run/first_run.h',
        'browser/chromeos/first_run/first_run_controller.cc',
        'browser/chromeos/first_run/first_run_controller.h',
        'browser/chromeos/first_run/first_run_view.cc',
        'browser/chromeos/first_run/first_run_view.h',
        'browser/chromeos/first_run/step.cc',
        'browser/chromeos/first_run/step.h',
        'browser/chromeos/first_run/step_names.cc',
        'browser/chromeos/first_run/step_names.h',
        'browser/chromeos/first_run/steps/app_list_step.cc',
        'browser/chromeos/first_run/steps/app_list_step.h',
        'browser/chromeos/first_run/steps/help_step.cc',
        'browser/chromeos/first_run/steps/help_step.h',
        'browser/chromeos/first_run/steps/tray_step.cc',
        'browser/chromeos/first_run/steps/tray_step.h',
        'browser/chromeos/genius_app/app_id.h',
        'browser/chromeos/idle_detector.cc',
        'browser/chromeos/idle_detector.h',
        'browser/chromeos/input_method/accessibility.cc',
        'browser/chromeos/input_method/accessibility.h',
        'browser/chromeos/input_method/browser_state_monitor.cc',
        'browser/chromeos/input_method/browser_state_monitor.h',
        'browser/chromeos/input_method/candidate_window_controller.cc',
        'browser/chromeos/input_method/candidate_window_controller.h',
        'browser/chromeos/input_method/candidate_window_controller_impl.cc',
        'browser/chromeos/input_method/candidate_window_controller_impl.h',
        'browser/chromeos/input_method/component_extension_ime_manager_impl.cc',
        'browser/chromeos/input_method/component_extension_ime_manager_impl.h',
        'browser/chromeos/input_method/input_method_configuration.cc',
        'browser/chromeos/input_method/input_method_configuration.h',
        'browser/chromeos/input_method/input_method_delegate_impl.cc',
        'browser/chromeos/input_method/input_method_delegate_impl.h',
        'browser/chromeos/input_method/input_method_engine.cc',
        'browser/chromeos/input_method/input_method_engine.h',
        'browser/chromeos/input_method/input_method_engine_interface.cc',
        'browser/chromeos/input_method/input_method_engine_interface.h',
        'browser/chromeos/input_method/input_method_manager_impl.cc',
        'browser/chromeos/input_method/input_method_manager_impl.h',
        'browser/chromeos/input_method/input_method_persistence.cc',
        'browser/chromeos/input_method/input_method_persistence.h',
        'browser/chromeos/input_method/input_method_switch_recorder.cc',
        'browser/chromeos/input_method/input_method_switch_recorder.h',
        'browser/chromeos/input_method/input_method_syncer.cc',
        'browser/chromeos/input_method/input_method_syncer.h',
        'browser/chromeos/input_method/input_method_util.cc',
        'browser/chromeos/input_method/input_method_util.h',
        'browser/chromeos/input_method/mode_indicator_controller.cc',
        'browser/chromeos/input_method/mode_indicator_controller.h',
        'browser/chromeos/language_preferences.cc',
        'browser/chromeos/language_preferences.h',
        'browser/chromeos/launcher_search_provider/error_reporter.cc',
        'browser/chromeos/launcher_search_provider/error_reporter.h',
        'browser/chromeos/launcher_search_provider/launcher_search_provider_service.cc',
        'browser/chromeos/launcher_search_provider/launcher_search_provider_service.h',
        'browser/chromeos/launcher_search_provider/launcher_search_provider_service_factory.cc',
        'browser/chromeos/launcher_search_provider/launcher_search_provider_service_factory.h',
        'browser/chromeos/locale_change_guard.cc',
        'browser/chromeos/locale_change_guard.h',
        'browser/chromeos/login/app_launch_controller.cc',
        'browser/chromeos/login/app_launch_controller.h',
        'browser/chromeos/login/app_launch_signin_screen.cc',
        'browser/chromeos/login/app_launch_signin_screen.h',
        'browser/chromeos/login/auth/auth_prewarmer.cc',
        'browser/chromeos/login/auth/auth_prewarmer.h',
        'browser/chromeos/login/auth/chrome_cryptohome_authenticator.cc',
        'browser/chromeos/login/auth/chrome_cryptohome_authenticator.h',
        'browser/chromeos/login/auth/chrome_login_performer.cc',
        'browser/chromeos/login/auth/chrome_login_performer.h',
        'browser/chromeos/login/chrome_restart_request.cc',
        'browser/chromeos/login/chrome_restart_request.h',
        'browser/chromeos/login/demo_mode/demo_app_launcher.cc',
        'browser/chromeos/login/demo_mode/demo_app_launcher.h',
        'browser/chromeos/login/easy_unlock/bootstrap_manager.cc',
        'browser/chromeos/login/easy_unlock/bootstrap_manager.h',
        'browser/chromeos/login/easy_unlock/bootstrap_user_context_initializer.cc',
        'browser/chromeos/login/easy_unlock/bootstrap_user_context_initializer.h',
        'browser/chromeos/login/easy_unlock/bootstrap_user_flow.cc',
        'browser/chromeos/login/easy_unlock/bootstrap_user_flow.h',
        'browser/chromeos/login/easy_unlock/easy_unlock_create_keys_operation.cc',
        'browser/chromeos/login/easy_unlock/easy_unlock_create_keys_operation.h',
        'browser/chromeos/login/easy_unlock/easy_unlock_get_keys_operation.cc',
        'browser/chromeos/login/easy_unlock/easy_unlock_get_keys_operation.h',
        'browser/chromeos/login/easy_unlock/easy_unlock_key_manager.cc',
        'browser/chromeos/login/easy_unlock/easy_unlock_key_manager.h',
        'browser/chromeos/login/easy_unlock/easy_unlock_reauth.cc',
        'browser/chromeos/login/easy_unlock/easy_unlock_reauth.h',
        'browser/chromeos/login/easy_unlock/easy_unlock_refresh_keys_operation.cc',
        'browser/chromeos/login/easy_unlock/easy_unlock_refresh_keys_operation.h',
        'browser/chromeos/login/easy_unlock/easy_unlock_remove_keys_operation.cc',
        'browser/chromeos/login/easy_unlock/easy_unlock_remove_keys_operation.h',
        'browser/chromeos/login/easy_unlock/easy_unlock_tpm_key_manager.cc',
        'browser/chromeos/login/easy_unlock/easy_unlock_tpm_key_manager.h',
        'browser/chromeos/login/easy_unlock/easy_unlock_tpm_key_manager_factory.cc',
        'browser/chromeos/login/easy_unlock/easy_unlock_tpm_key_manager_factory.h',
        'browser/chromeos/login/easy_unlock/easy_unlock_types.cc',
        'browser/chromeos/login/easy_unlock/easy_unlock_types.h',
        'browser/chromeos/login/easy_unlock/easy_unlock_user_login_flow.cc',
        'browser/chromeos/login/easy_unlock/easy_unlock_user_login_flow.h',
        'browser/chromeos/login/easy_unlock/secure_message_delegate_chromeos.cc',
        'browser/chromeos/login/easy_unlock/secure_message_delegate_chromeos.h',
        'browser/chromeos/login/easy_unlock/short_lived_user_context.cc',
        'browser/chromeos/login/easy_unlock/short_lived_user_context.h',
        'browser/chromeos/login/enrollment/auto_enrollment_check_screen.cc',
        'browser/chromeos/login/enrollment/auto_enrollment_check_screen.h',
        'browser/chromeos/login/enrollment/auto_enrollment_check_screen_actor.h',
        'browser/chromeos/login/enrollment/auto_enrollment_controller.cc',
        'browser/chromeos/login/enrollment/auto_enrollment_controller.h',
        'browser/chromeos/login/enrollment/enrollment_screen.cc',
        'browser/chromeos/login/enrollment/enrollment_screen.h',
        'browser/chromeos/login/enrollment/enrollment_screen_actor.h',
        'browser/chromeos/login/enrollment/enrollment_uma.cc',
        'browser/chromeos/login/enrollment/enrollment_uma.h',
        'browser/chromeos/login/enrollment/enterprise_enrollment_helper.cc',
        'browser/chromeos/login/enrollment/enterprise_enrollment_helper.h',
        'browser/chromeos/login/enrollment/enterprise_enrollment_helper_impl.cc',
        'browser/chromeos/login/enrollment/enterprise_enrollment_helper_impl.h',
        'browser/chromeos/login/error_screens_histogram_helper.cc',
        'browser/chromeos/login/error_screens_histogram_helper.h',
        'browser/chromeos/login/existing_user_controller.cc',
        'browser/chromeos/login/existing_user_controller.h',
        'browser/chromeos/login/help_app_launcher.cc',
        'browser/chromeos/login/help_app_launcher.h',
        'browser/chromeos/login/helper.cc',
        'browser/chromeos/login/helper.h',
        'browser/chromeos/login/hwid_checker.cc',
        'browser/chromeos/login/hwid_checker.h',
        'browser/chromeos/login/language_list.cc',
        'browser/chromeos/login/language_list.h',
        'browser/chromeos/login/lock/screen_locker.cc',
        'browser/chromeos/login/lock/screen_locker.h',
        'browser/chromeos/login/lock/screen_locker_delegate.cc',
        'browser/chromeos/login/lock/screen_locker_delegate.h',
        'browser/chromeos/login/lock/webui_screen_locker.cc',
        'browser/chromeos/login/lock/webui_screen_locker.h',
        'browser/chromeos/login/login_wizard.h',
        'browser/chromeos/login/profile_auth_data.cc',
        'browser/chromeos/login/profile_auth_data.h',
        'browser/chromeos/login/proxy_settings_dialog.h',
        'browser/chromeos/login/reauth_stats.cc',
        'browser/chromeos/login/reauth_stats.h',
        'browser/chromeos/login/saml/saml_offline_signin_limiter.cc',
        'browser/chromeos/login/saml/saml_offline_signin_limiter.h',
        'browser/chromeos/login/saml/saml_offline_signin_limiter_factory.cc',
        'browser/chromeos/login/saml/saml_offline_signin_limiter_factory.h',
        'browser/chromeos/login/screen_manager.cc',
        'browser/chromeos/login/screen_manager.h',
        'browser/chromeos/login/screens/base_screen.cc',
        'browser/chromeos/login/screens/base_screen.h',
        'browser/chromeos/login/screens/base_screen_delegate.h',
        'browser/chromeos/login/screens/chrome_user_selection_screen.cc',
        'browser/chromeos/login/screens/chrome_user_selection_screen.h',
        'browser/chromeos/login/screens/controller_pairing_screen.cc',
        'browser/chromeos/login/screens/controller_pairing_screen.h',
        'browser/chromeos/login/screens/controller_pairing_screen_actor.cc',
        'browser/chromeos/login/screens/controller_pairing_screen_actor.h',
        'browser/chromeos/login/screens/core_oobe_actor.h',
        'browser/chromeos/login/screens/device_disabled_screen.cc',
        'browser/chromeos/login/screens/device_disabled_screen.h',
        'browser/chromeos/login/screens/device_disabled_screen_actor.h',
        'browser/chromeos/login/screens/enable_debugging_screen.cc',
        'browser/chromeos/login/screens/enable_debugging_screen.h',
        'browser/chromeos/login/screens/enable_debugging_screen_actor.h',
        'browser/chromeos/login/screens/error_screen.cc',
        'browser/chromeos/login/screens/error_screen.h',
        'browser/chromeos/login/screens/error_screen_actor_delegate.h',
        'browser/chromeos/login/screens/eula_model.cc',
        'browser/chromeos/login/screens/eula_model.h',
        'browser/chromeos/login/screens/eula_screen.cc',
        'browser/chromeos/login/screens/eula_screen.h',
        'browser/chromeos/login/screens/eula_view.h',
        'browser/chromeos/login/screens/gaia_screen.cc',
        'browser/chromeos/login/screens/gaia_screen.h',
        'browser/chromeos/login/screens/hid_detection_model.cc',
        'browser/chromeos/login/screens/hid_detection_model.h',
        'browser/chromeos/login/screens/hid_detection_screen.cc',
        'browser/chromeos/login/screens/hid_detection_screen.h',
        'browser/chromeos/login/screens/hid_detection_view.h',
        'browser/chromeos/login/screens/host_pairing_screen.cc',
        'browser/chromeos/login/screens/host_pairing_screen.h',
        'browser/chromeos/login/screens/host_pairing_screen_actor.cc',
        'browser/chromeos/login/screens/host_pairing_screen_actor.h',
        'browser/chromeos/login/screens/kiosk_autolaunch_screen.cc',
        'browser/chromeos/login/screens/kiosk_autolaunch_screen.h',
        'browser/chromeos/login/screens/kiosk_autolaunch_screen_actor.h',
        'browser/chromeos/login/screens/kiosk_enable_screen.cc',
        'browser/chromeos/login/screens/kiosk_enable_screen.h',
        'browser/chromeos/login/screens/kiosk_enable_screen_actor.h',
        'browser/chromeos/login/screens/model_view_channel.h',
        'browser/chromeos/login/screens/network_error.cc',
        'browser/chromeos/login/screens/network_error.h',
        'browser/chromeos/login/screens/network_error_model.cc',
        'browser/chromeos/login/screens/network_error_model.h',
        'browser/chromeos/login/screens/network_error_view.h',
        'browser/chromeos/login/screens/network_model.cc',
        'browser/chromeos/login/screens/network_model.h',
        'browser/chromeos/login/screens/network_screen.cc',
        'browser/chromeos/login/screens/network_screen.h',
        'browser/chromeos/login/screens/network_view.h',
        'browser/chromeos/login/screens/reset_model.cc',
        'browser/chromeos/login/screens/reset_model.h',
        'browser/chromeos/login/screens/reset_screen.cc',
        'browser/chromeos/login/screens/reset_screen.h',
        'browser/chromeos/login/screens/reset_view.h',
        'browser/chromeos/login/screens/screen_flow.h',
        'browser/chromeos/login/screens/terms_of_service_screen.cc',
        'browser/chromeos/login/screens/terms_of_service_screen.h',
        'browser/chromeos/login/screens/terms_of_service_screen_actor.h',
        'browser/chromeos/login/screens/update_model.cc',
        'browser/chromeos/login/screens/update_model.h',
        'browser/chromeos/login/screens/update_screen.cc',
        'browser/chromeos/login/screens/update_screen.h',
        'browser/chromeos/login/screens/update_view.h',
        'browser/chromeos/login/screens/user_image_model.cc',
        'browser/chromeos/login/screens/user_image_model.h',
        'browser/chromeos/login/screens/user_image_screen.cc',
        'browser/chromeos/login/screens/user_image_screen.h',
        'browser/chromeos/login/screens/user_selection_screen.cc',
        'browser/chromeos/login/screens/user_selection_screen.h',
        'browser/chromeos/login/screens/wrong_hwid_screen.cc',
        'browser/chromeos/login/screens/wrong_hwid_screen.h',
        'browser/chromeos/login/screens/wrong_hwid_screen_actor.h',
        'browser/chromeos/login/session/chrome_session_manager.cc',
        'browser/chromeos/login/session/chrome_session_manager.h',
        'browser/chromeos/login/session/kiosk_auto_launcher_session_manager_delegate.cc',
        'browser/chromeos/login/session/kiosk_auto_launcher_session_manager_delegate.h',
        'browser/chromeos/login/session/login_oobe_session_manager_delegate.cc',
        'browser/chromeos/login/session/login_oobe_session_manager_delegate.h',
        'browser/chromeos/login/session/restore_after_crash_session_manager_delegate.cc',
        'browser/chromeos/login/session/restore_after_crash_session_manager_delegate.h',
        'browser/chromeos/login/session/stub_login_session_manager_delegate.cc',
        'browser/chromeos/login/session/stub_login_session_manager_delegate.h',
        'browser/chromeos/login/session/user_session_manager.cc',
        'browser/chromeos/login/session/user_session_manager.h',
        'browser/chromeos/login/signin/auth_sync_observer.cc',
        'browser/chromeos/login/signin/auth_sync_observer.h',
        'browser/chromeos/login/signin/auth_sync_observer_factory.cc',
        'browser/chromeos/login/signin/auth_sync_observer_factory.h',
        'browser/chromeos/login/signin/merge_session_load_page.cc',
        'browser/chromeos/login/signin/merge_session_load_page.h',
        'browser/chromeos/login/signin/merge_session_throttle.cc',
        'browser/chromeos/login/signin/merge_session_throttle.h',
        'browser/chromeos/login/signin/merge_session_xhr_request_waiter.cc',
        'browser/chromeos/login/signin/merge_session_xhr_request_waiter.h',
        'browser/chromeos/login/signin/oauth2_login_manager.cc',
        'browser/chromeos/login/signin/oauth2_login_manager.h',
        'browser/chromeos/login/signin/oauth2_login_manager_factory.cc',
        'browser/chromeos/login/signin/oauth2_login_manager_factory.h',
        'browser/chromeos/login/signin/oauth2_login_verifier.cc',
        'browser/chromeos/login/signin/oauth2_login_verifier.h',
        'browser/chromeos/login/signin/oauth2_token_fetcher.cc',
        'browser/chromeos/login/signin/oauth2_token_fetcher.h',
        'browser/chromeos/login/signin/oauth2_token_initializer.cc',
        'browser/chromeos/login/signin/oauth2_token_initializer.h',
        'browser/chromeos/login/signin/token_handle_fetcher.cc',
        'browser/chromeos/login/signin/token_handle_fetcher.h',
        'browser/chromeos/login/signin/token_handle_util.cc',
        'browser/chromeos/login/signin/token_handle_util.h',
        'browser/chromeos/login/signin_screen_controller.cc',
        'browser/chromeos/login/signin_screen_controller.h',
        'browser/chromeos/login/signin_specifics.cc',
        'browser/chromeos/login/signin_specifics.h',
        'browser/chromeos/login/startup_utils.cc',
        'browser/chromeos/login/startup_utils.h',
        'browser/chromeos/login/supervised/supervised_user_authentication.cc',
        'browser/chromeos/login/supervised/supervised_user_authentication.h',
        'browser/chromeos/login/supervised/supervised_user_authenticator.cc',
        'browser/chromeos/login/supervised/supervised_user_authenticator.h',
        'browser/chromeos/login/supervised/supervised_user_constants.cc',
        'browser/chromeos/login/supervised/supervised_user_constants.h',
        'browser/chromeos/login/supervised/supervised_user_creation_controller.cc',
        'browser/chromeos/login/supervised/supervised_user_creation_controller.h',
        'browser/chromeos/login/supervised/supervised_user_creation_controller_new.cc',
        'browser/chromeos/login/supervised/supervised_user_creation_controller_new.h',
        'browser/chromeos/login/supervised/supervised_user_creation_flow.cc',
        'browser/chromeos/login/supervised/supervised_user_creation_flow.h',
        'browser/chromeos/login/supervised/supervised_user_creation_screen.cc',
        'browser/chromeos/login/supervised/supervised_user_creation_screen.h',
        'browser/chromeos/login/supervised/supervised_user_login_flow.cc',
        'browser/chromeos/login/supervised/supervised_user_login_flow.h',
        'browser/chromeos/login/ui/captive_portal_view.cc',
        'browser/chromeos/login/ui/captive_portal_view.h',
        'browser/chromeos/login/ui/captive_portal_window_proxy.cc',
        'browser/chromeos/login/ui/captive_portal_window_proxy.h',
        'browser/chromeos/login/ui/input_events_blocker.cc',
        'browser/chromeos/login/ui/input_events_blocker.h',
        'browser/chromeos/login/ui/keyboard_driven_oobe_key_handler.cc',
        'browser/chromeos/login/ui/keyboard_driven_oobe_key_handler.h',
        'browser/chromeos/login/ui/lock_window.cc',
        'browser/chromeos/login/ui/lock_window.h',
        'browser/chromeos/login/ui/lock_window_aura.cc',
        'browser/chromeos/login/ui/lock_window_aura.h',
        'browser/chromeos/login/ui/login_display.cc',
        'browser/chromeos/login/ui/login_display.h',
        'browser/chromeos/login/ui/login_display_host.h',
        'browser/chromeos/login/ui/login_display_host_impl.cc',
        'browser/chromeos/login/ui/login_display_host_impl.h',
        'browser/chromeos/login/ui/login_web_dialog.cc',
        'browser/chromeos/login/ui/login_web_dialog.h',
        'browser/chromeos/login/ui/models/user_board_model.cc',
        'browser/chromeos/login/ui/models/user_board_model.h',
        'browser/chromeos/login/ui/oobe_display.h',
        'browser/chromeos/login/ui/proxy_settings_dialog.cc',
        'browser/chromeos/login/ui/simple_web_view_dialog.cc',
        'browser/chromeos/login/ui/simple_web_view_dialog.h',
        'browser/chromeos/login/ui/user_adding_screen.cc',
        'browser/chromeos/login/ui/user_adding_screen.h',
        'browser/chromeos/login/ui/user_adding_screen_input_methods_controller.cc',
        'browser/chromeos/login/ui/user_adding_screen_input_methods_controller.h',
        'browser/chromeos/login/ui/webui_login_display.cc',
        'browser/chromeos/login/ui/webui_login_display.h',
        'browser/chromeos/login/ui/webui_login_view.cc',
        'browser/chromeos/login/ui/webui_login_view.h',
        'browser/chromeos/login/user_flow.cc',
        'browser/chromeos/login/user_flow.h',
        'browser/chromeos/login/users/affiliation.cc',
        'browser/chromeos/login/users/affiliation.h',
        'browser/chromeos/login/users/avatar/user_image_loader.cc',
        'browser/chromeos/login/users/avatar/user_image_loader.h',
        'browser/chromeos/login/users/avatar/user_image_manager.cc',
        'browser/chromeos/login/users/avatar/user_image_manager.h',
        'browser/chromeos/login/users/avatar/user_image_manager_impl.cc',
        'browser/chromeos/login/users/avatar/user_image_manager_impl.h',
        'browser/chromeos/login/users/avatar/user_image_sync_observer.cc',
        'browser/chromeos/login/users/avatar/user_image_sync_observer.h',
        'browser/chromeos/login/users/chrome_user_manager.cc',
        'browser/chromeos/login/users/chrome_user_manager.h',
        'browser/chromeos/login/users/chrome_user_manager_impl.cc',
        'browser/chromeos/login/users/chrome_user_manager_impl.h',
        'browser/chromeos/login/users/multi_profile_user_controller.cc',
        'browser/chromeos/login/users/multi_profile_user_controller.h',
        'browser/chromeos/login/users/multi_profile_user_controller_delegate.h',
        'browser/chromeos/login/users/scoped_test_user_manager.cc',
        'browser/chromeos/login/users/scoped_test_user_manager.h',
        'browser/chromeos/login/users/scoped_user_manager_enabler.cc',
        'browser/chromeos/login/users/scoped_user_manager_enabler.h',
        'browser/chromeos/login/users/supervised_user_manager.h',
        'browser/chromeos/login/users/supervised_user_manager_impl.cc',
        'browser/chromeos/login/users/supervised_user_manager_impl.h',
        'browser/chromeos/login/users/user_manager_interface.h',
        'browser/chromeos/login/users/wallpaper/wallpaper_manager.cc',
        'browser/chromeos/login/users/wallpaper/wallpaper_manager.h',
        'browser/chromeos/login/version_info_updater.cc',
        'browser/chromeos/login/version_info_updater.h',
        'browser/chromeos/login/views/user_board_view.h',
        'browser/chromeos/login/wizard_controller.cc',
        'browser/chromeos/login/wizard_controller.h',
        'browser/chromeos/mobile/mobile_activator.cc',
        'browser/chromeos/mobile/mobile_activator.h',
        'browser/chromeos/mobile_config.cc',
        'browser/chromeos/mobile_config.h',
        'browser/chromeos/net/cert_verify_proc_chromeos.cc',
        'browser/chromeos/net/cert_verify_proc_chromeos.h',
        "browser/chromeos/net/client_cert_store_chromeos.cc",
        "browser/chromeos/net/client_cert_store_chromeos.h",
        'browser/chromeos/net/client_cert_filter_chromeos.cc',
        'browser/chromeos/net/client_cert_filter_chromeos.h',
        'browser/chromeos/net/delay_network_call.cc',
        'browser/chromeos/net/delay_network_call.h',
        'browser/chromeos/net/network_portal_detector_impl.cc',
        'browser/chromeos/net/network_portal_detector_impl.h',
        'browser/chromeos/net/network_portal_detector_test_impl.cc',
        'browser/chromeos/net/network_portal_detector_test_impl.h',
        'browser/chromeos/net/network_portal_notification_controller.cc',
        'browser/chromeos/net/network_portal_notification_controller.h',
        'browser/chromeos/net/network_portal_web_dialog.cc',
        'browser/chromeos/net/network_portal_web_dialog.h',
        'browser/chromeos/net/onc_utils.cc',
        'browser/chromeos/net/onc_utils.h',
        'browser/chromeos/net/proxy_config_handler.cc',
        'browser/chromeos/net/proxy_config_handler.h',
        'browser/chromeos/net/wake_on_wifi_manager.cc',
        'browser/chromeos/net/wake_on_wifi_manager.h',
        'browser/chromeos/options/cert_library.cc',
        'browser/chromeos/options/cert_library.h',
        'browser/chromeos/options/network_config_view.cc',
        'browser/chromeos/options/network_config_view.h',
        'browser/chromeos/options/network_property_ui_data.cc',
        'browser/chromeos/options/network_property_ui_data.h',
        'browser/chromeos/options/passphrase_textfield.cc',
        'browser/chromeos/options/passphrase_textfield.h',
        'browser/chromeos/options/vpn_config_view.cc',
        'browser/chromeos/options/vpn_config_view.h',
        'browser/chromeos/options/wifi_config_view.cc',
        'browser/chromeos/options/wifi_config_view.h',
        'browser/chromeos/options/wimax_config_view.cc',
        'browser/chromeos/options/wimax_config_view.h',
        'browser/chromeos/ownership/owner_settings_service_chromeos.cc',
        'browser/chromeos/ownership/owner_settings_service_chromeos.h',
        'browser/chromeos/ownership/owner_settings_service_chromeos_factory.cc',
        'browser/chromeos/ownership/owner_settings_service_chromeos_factory.h',
        'browser/chromeos/platform_keys/key_permissions.cc',
        'browser/chromeos/platform_keys/key_permissions.h',
        'browser/chromeos/platform_keys/key_permissions_policy_handler.cc',
        'browser/chromeos/platform_keys/key_permissions_policy_handler.h',
        'browser/chromeos/platform_keys/platform_keys.cc',
        'browser/chromeos/platform_keys/platform_keys.h',
        'browser/chromeos/platform_keys/platform_keys_nss.cc',
        'browser/chromeos/platform_keys/platform_keys_service.cc',
        'browser/chromeos/platform_keys/platform_keys_service.h',
        'browser/chromeos/platform_keys/platform_keys_service_factory.cc',
        'browser/chromeos/platform_keys/platform_keys_service_factory.h',
        'browser/chromeos/policy/affiliated_cloud_policy_invalidator.cc',
        'browser/chromeos/policy/affiliated_cloud_policy_invalidator.h',
        'browser/chromeos/policy/affiliated_invalidation_service_provider.cc',
        'browser/chromeos/policy/affiliated_invalidation_service_provider.h',
        'browser/chromeos/policy/affiliated_invalidation_service_provider_impl.cc',
        'browser/chromeos/policy/affiliated_invalidation_service_provider_impl.h',
        'browser/chromeos/policy/auto_enrollment_client.cc',
        'browser/chromeos/policy/auto_enrollment_client.h',
        'browser/chromeos/policy/browser_policy_connector_chromeos.cc',
        'browser/chromeos/policy/browser_policy_connector_chromeos.h',
        'browser/chromeos/policy/cloud_external_data_manager_base.cc',
        'browser/chromeos/policy/cloud_external_data_manager_base.h',
        'browser/chromeos/policy/cloud_external_data_policy_observer.cc',
        'browser/chromeos/policy/cloud_external_data_policy_observer.h',
        'browser/chromeos/policy/cloud_external_data_store.cc',
        'browser/chromeos/policy/cloud_external_data_store.h',
        'browser/chromeos/policy/configuration_policy_handler_chromeos.cc',
        'browser/chromeos/policy/configuration_policy_handler_chromeos.h',
        'browser/chromeos/policy/consumer_enrollment_handler.cc',
        'browser/chromeos/policy/consumer_enrollment_handler.h',
        'browser/chromeos/policy/consumer_enrollment_handler_factory.cc',
        'browser/chromeos/policy/consumer_enrollment_handler_factory.h',
        'browser/chromeos/policy/consumer_management_notifier.cc',
        'browser/chromeos/policy/consumer_management_notifier.h',
        'browser/chromeos/policy/consumer_management_notifier_factory.cc',
        'browser/chromeos/policy/consumer_management_notifier_factory.h',
        'browser/chromeos/policy/consumer_management_service.cc',
        'browser/chromeos/policy/consumer_management_service.h',
        'browser/chromeos/policy/consumer_management_stage.cc',
        'browser/chromeos/policy/consumer_management_stage.h',
        'browser/chromeos/policy/consumer_unenrollment_handler.cc',
        'browser/chromeos/policy/consumer_unenrollment_handler.h',
        'browser/chromeos/policy/consumer_unenrollment_handler_factory.cc',
        'browser/chromeos/policy/consumer_unenrollment_handler_factory.h',
        'browser/chromeos/policy/device_cloud_policy_initializer.cc',
        'browser/chromeos/policy/device_cloud_policy_initializer.h',
        'browser/chromeos/policy/device_cloud_policy_manager_chromeos.cc',
        'browser/chromeos/policy/device_cloud_policy_manager_chromeos.h',
        'browser/chromeos/policy/device_cloud_policy_store_chromeos.cc',
        'browser/chromeos/policy/device_cloud_policy_store_chromeos.h',
        'browser/chromeos/policy/device_cloud_policy_validator.cc',
        'browser/chromeos/policy/device_cloud_policy_validator.h',
        'browser/chromeos/policy/device_local_account.cc',
        'browser/chromeos/policy/device_local_account.h',
        'browser/chromeos/policy/device_local_account_extension_tracker.cc',
        'browser/chromeos/policy/device_local_account_extension_tracker.h',
        'browser/chromeos/policy/device_local_account_external_data_manager.cc',
        'browser/chromeos/policy/device_local_account_external_data_manager.h',
        'browser/chromeos/policy/device_local_account_external_data_service.cc',
        'browser/chromeos/policy/device_local_account_external_data_service.h',
        'browser/chromeos/policy/device_local_account_policy_provider.cc',
        'browser/chromeos/policy/device_local_account_policy_provider.h',
        'browser/chromeos/policy/device_local_account_policy_service.cc',
        'browser/chromeos/policy/device_local_account_policy_service.h',
        'browser/chromeos/policy/device_local_account_policy_store.cc',
        'browser/chromeos/policy/device_local_account_policy_store.h',
        'browser/chromeos/policy/device_network_configuration_updater.cc',
        'browser/chromeos/policy/device_network_configuration_updater.h',
        'browser/chromeos/policy/device_policy_decoder_chromeos.cc',
        'browser/chromeos/policy/device_policy_decoder_chromeos.h',
        'browser/chromeos/policy/device_status_collector.cc',
        'browser/chromeos/policy/device_status_collector.h',
        'browser/chromeos/policy/enrollment_config.cc',
        'browser/chromeos/policy/enrollment_config.h',
        'browser/chromeos/policy/enrollment_handler_chromeos.cc',
        'browser/chromeos/policy/enrollment_handler_chromeos.h',
        'browser/chromeos/policy/enrollment_status_chromeos.cc',
        'browser/chromeos/policy/enrollment_status_chromeos.h',
        'browser/chromeos/policy/enterprise_install_attributes.cc',
        'browser/chromeos/policy/enterprise_install_attributes.h',
        'browser/chromeos/policy/heartbeat_scheduler.cc',
        'browser/chromeos/policy/heartbeat_scheduler.h',
        'browser/chromeos/policy/login_profile_policy_provider.cc',
        'browser/chromeos/policy/login_profile_policy_provider.h',
        'browser/chromeos/policy/network_configuration_updater.cc',
        'browser/chromeos/policy/network_configuration_updater.h',
        'browser/chromeos/policy/policy_cert_service.cc',
        'browser/chromeos/policy/policy_cert_service.h',
        'browser/chromeos/policy/policy_cert_service_factory.cc',
        'browser/chromeos/policy/policy_cert_service_factory.h',
        'browser/chromeos/policy/policy_cert_verifier.cc',
        'browser/chromeos/policy/policy_cert_verifier.h',
        'browser/chromeos/policy/policy_oauth2_token_fetcher.cc',
        'browser/chromeos/policy/policy_oauth2_token_fetcher.h',
        'browser/chromeos/policy/recommendation_restorer.cc',
        'browser/chromeos/policy/recommendation_restorer.h',
        'browser/chromeos/policy/recommendation_restorer_factory.cc',
        'browser/chromeos/policy/recommendation_restorer_factory.h',
        'browser/chromeos/policy/remote_commands/affiliated_remote_commands_invalidator.cc',
        'browser/chromeos/policy/remote_commands/affiliated_remote_commands_invalidator.h',
        'browser/chromeos/policy/remote_commands/device_command_reboot_job.cc',
        'browser/chromeos/policy/remote_commands/device_command_reboot_job.h',
        'browser/chromeos/policy/remote_commands/device_command_screenshot_job.cc',
        'browser/chromeos/policy/remote_commands/device_command_screenshot_job.h',
        'browser/chromeos/policy/remote_commands/device_commands_factory_chromeos.cc',
        'browser/chromeos/policy/remote_commands/device_commands_factory_chromeos.h',
        'browser/chromeos/policy/remote_commands/screenshot_delegate.cc',
        'browser/chromeos/policy/remote_commands/screenshot_delegate.h',
        'browser/chromeos/policy/server_backed_device_state.cc',
        'browser/chromeos/policy/server_backed_device_state.h',
        'browser/chromeos/policy/server_backed_state_keys_broker.cc',
        'browser/chromeos/policy/server_backed_state_keys_broker.h',
        'browser/chromeos/policy/status_uploader.cc',
        'browser/chromeos/policy/status_uploader.h',
        'browser/chromeos/policy/system_log_uploader.cc',
        'browser/chromeos/policy/system_log_uploader.h',
        'browser/chromeos/policy/ticl_device_settings_provider.cc',
        'browser/chromeos/policy/ticl_device_settings_provider.h',
        'browser/chromeos/policy/upload_job.h',
        'browser/chromeos/policy/upload_job_impl.cc',
        'browser/chromeos/policy/upload_job_impl.h',
        'browser/chromeos/policy/user_cloud_external_data_manager.cc',
        'browser/chromeos/policy/user_cloud_external_data_manager.h',
        'browser/chromeos/policy/user_cloud_policy_manager_chromeos.cc',
        'browser/chromeos/policy/user_cloud_policy_manager_chromeos.h',
        'browser/chromeos/policy/user_cloud_policy_manager_factory_chromeos.cc',
        'browser/chromeos/policy/user_cloud_policy_manager_factory_chromeos.h',
        'browser/chromeos/policy/user_cloud_policy_store_chromeos.cc',
        'browser/chromeos/policy/user_cloud_policy_store_chromeos.h',
        'browser/chromeos/policy/user_cloud_policy_token_forwarder.cc',
        'browser/chromeos/policy/user_cloud_policy_token_forwarder.h',
        'browser/chromeos/policy/user_cloud_policy_token_forwarder_factory.cc',
        'browser/chromeos/policy/user_cloud_policy_token_forwarder_factory.h',
        'browser/chromeos/policy/user_network_configuration_updater.cc',
        'browser/chromeos/policy/user_network_configuration_updater.h',
        'browser/chromeos/policy/user_network_configuration_updater_factory.cc',
        'browser/chromeos/policy/user_network_configuration_updater_factory.h',
        'browser/chromeos/policy/user_policy_disk_cache.cc',
        'browser/chromeos/policy/user_policy_disk_cache.h',
        'browser/chromeos/policy/user_policy_token_loader.cc',
        'browser/chromeos/policy/user_policy_token_loader.h',
        'browser/chromeos/policy/wildcard_login_checker.cc',
        'browser/chromeos/policy/wildcard_login_checker.h',
        'browser/chromeos/power/cpu_data_collector.cc',
        'browser/chromeos/power/cpu_data_collector.h',
        'browser/chromeos/power/extension_event_observer.cc',
        'browser/chromeos/power/extension_event_observer.h',
        'browser/chromeos/power/freezer_cgroup_process_manager.cc',
        'browser/chromeos/power/freezer_cgroup_process_manager.h',
        'browser/chromeos/power/idle_action_warning_dialog_view.cc',
        'browser/chromeos/power/idle_action_warning_dialog_view.h',
        'browser/chromeos/power/idle_action_warning_observer.cc',
        'browser/chromeos/power/idle_action_warning_observer.h',
        'browser/chromeos/power/peripheral_battery_observer.cc',
        'browser/chromeos/power/peripheral_battery_observer.h',
        'browser/chromeos/power/power_button_observer.cc',
        'browser/chromeos/power/power_button_observer.h',
        'browser/chromeos/power/power_data_collector.cc',
        'browser/chromeos/power/power_data_collector.h',
        'browser/chromeos/power/power_prefs.cc',
        'browser/chromeos/power/power_prefs.h',
        'browser/chromeos/power/renderer_freezer.cc',
        'browser/chromeos/power/renderer_freezer.h',
        'browser/chromeos/power/session_state_controller_delegate_chromeos.cc',
        'browser/chromeos/power/session_state_controller_delegate_chromeos.h',
        'browser/chromeos/preferences.cc',
        'browser/chromeos/preferences.h',
        'browser/chromeos/printer_detector/printer_detector.cc',
        'browser/chromeos/printer_detector/printer_detector.h',
        'browser/chromeos/printer_detector/printer_detector_factory.cc',
        'browser/chromeos/printer_detector/printer_detector_factory.h',
        'browser/chromeos/profiles/avatar_menu_actions_chromeos.cc',
        'browser/chromeos/profiles/avatar_menu_actions_chromeos.h',
        'browser/chromeos/profiles/avatar_menu_chromeos.cc',
        'browser/chromeos/profiles/multiprofiles_intro_dialog.cc',
        'browser/chromeos/profiles/multiprofiles_intro_dialog.h',
        'browser/chromeos/profiles/multiprofiles_session_aborted_dialog.cc',
        'browser/chromeos/profiles/multiprofiles_session_aborted_dialog.h',
        'browser/chromeos/profiles/profile_helper.cc',
        'browser/chromeos/profiles/profile_helper.h',
        'browser/chromeos/profiles/profile_list_chromeos.cc',
        'browser/chromeos/profiles/profile_list_chromeos.h',
        'browser/chromeos/profiles/profile_util.cc',
        'browser/chromeos/profiles/profile_util.h',
        'browser/chromeos/proxy_config_service_impl.cc',
        'browser/chromeos/proxy_config_service_impl.h',
        'browser/chromeos/proxy_cros_settings_parser.cc',
        'browser/chromeos/proxy_cros_settings_parser.h',
        'browser/chromeos/reset/metrics.h',
        'browser/chromeos/session_length_limiter.cc',
        'browser/chromeos/session_length_limiter.h',
        'browser/chromeos/set_time_dialog.cc',
        'browser/chromeos/set_time_dialog.h',
        'browser/chromeos/settings/cros_settings.cc',
        'browser/chromeos/settings/cros_settings.h',
        'browser/chromeos/settings/device_identity_provider.cc',
        'browser/chromeos/settings/device_identity_provider.h',
        'browser/chromeos/settings/device_oauth2_token_service.cc',
        'browser/chromeos/settings/device_oauth2_token_service.h',
        'browser/chromeos/settings/device_oauth2_token_service_delegate.cc',
        'browser/chromeos/settings/device_oauth2_token_service_delegate.h',
        'browser/chromeos/settings/device_oauth2_token_service_factory.cc',
        'browser/chromeos/settings/device_oauth2_token_service_factory.h',
        'browser/chromeos/settings/device_settings_cache.cc',
        'browser/chromeos/settings/device_settings_cache.h',
        'browser/chromeos/settings/device_settings_provider.cc',
        'browser/chromeos/settings/device_settings_provider.h',
        'browser/chromeos/settings/device_settings_service.cc',
        'browser/chromeos/settings/device_settings_service.h',
        'browser/chromeos/settings/owner_flags_storage.cc',
        'browser/chromeos/settings/owner_flags_storage.h',
        'browser/chromeos/settings/session_manager_operation.cc',
        'browser/chromeos/settings/session_manager_operation.h',
        'browser/chromeos/settings/shutdown_policy_handler.cc',
        'browser/chromeos/settings/shutdown_policy_handler.h',
        'browser/chromeos/settings/stub_cros_settings_provider.cc',
        'browser/chromeos/settings/stub_cros_settings_provider.h',
        'browser/chromeos/settings/system_settings_provider.cc',
        'browser/chromeos/settings/system_settings_provider.h',
        'browser/chromeos/settings/token_encryptor.cc',
        'browser/chromeos/settings/token_encryptor.h',
        'browser/chromeos/sim_dialog_delegate.cc',
        'browser/chromeos/sim_dialog_delegate.h',
        'browser/chromeos/status/data_promo_notification.cc',
        'browser/chromeos/status/data_promo_notification.h',
        'browser/chromeos/status/network_menu.cc',
        'browser/chromeos/status/network_menu.h',
        'browser/chromeos/system/automatic_reboot_manager.cc',
        'browser/chromeos/system/automatic_reboot_manager.h',
        'browser/chromeos/system/automatic_reboot_manager_observer.h',
        'browser/chromeos/system/device_change_handler.cc',
        'browser/chromeos/system/device_change_handler.h',
        'browser/chromeos/system/device_disabling_manager.cc',
        'browser/chromeos/system/device_disabling_manager.h',
        'browser/chromeos/system/device_disabling_manager_default_delegate.cc',
        'browser/chromeos/system/device_disabling_manager_default_delegate.h',
        'browser/chromeos/system/input_device_settings.cc',
        'browser/chromeos/system/input_device_settings.h',
        'browser/chromeos/system/input_device_settings_impl_ozone.cc',
        'browser/chromeos/system/input_device_settings_impl_x11.cc',
        'browser/chromeos/system/pointer_device_observer.cc',
        'browser/chromeos/system/pointer_device_observer.h',
        'browser/chromeos/system/system_clock.cc',
        'browser/chromeos/system/system_clock.h',
        'browser/chromeos/system/system_clock_observer.cc',
        'browser/chromeos/system/system_clock_observer.h',
        'browser/chromeos/system/timezone_util.cc',
        'browser/chromeos/system/timezone_util.h',
        'browser/chromeos/system_logs/command_line_log_source.cc',
        'browser/chromeos/system_logs/command_line_log_source.h',
        'browser/chromeos/system_logs/dbus_log_source.cc',
        'browser/chromeos/system_logs/dbus_log_source.h',
        'browser/chromeos/system_logs/debug_daemon_log_source.cc',
        'browser/chromeos/system_logs/debug_daemon_log_source.h',
        'browser/chromeos/system_logs/debug_log_writer.cc',
        'browser/chromeos/system_logs/debug_log_writer.h',
        'browser/chromeos/system_logs/device_event_log_source.cc',
        'browser/chromeos/system_logs/device_event_log_source.h',
        'browser/chromeos/system_logs/lsb_release_log_source.cc',
        'browser/chromeos/system_logs/lsb_release_log_source.h',
        'browser/chromeos/system_logs/touch_log_source.h',
        'browser/chromeos/system_logs/touch_log_source_ozone.cc',
        'browser/chromeos/system_logs/touch_log_source_x11.cc',
        'browser/chromeos/ui/accessibility_focus_ring.cc',
        'browser/chromeos/ui/accessibility_focus_ring.h',
        'browser/chromeos/ui/accessibility_focus_ring_controller.cc',
        'browser/chromeos/ui/accessibility_focus_ring_controller.h',
        'browser/chromeos/ui/accessibility_focus_ring_layer.cc',
        'browser/chromeos/ui/accessibility_focus_ring_layer.h',
        'browser/chromeos/ui/choose_mobile_network_dialog.cc',
        'browser/chromeos/ui/choose_mobile_network_dialog.h',
        'browser/chromeos/ui/echo_dialog_listener.h',
        'browser/chromeos/ui/echo_dialog_view.cc',
        'browser/chromeos/ui/echo_dialog_view.h',
        'browser/chromeos/ui/focus_ring_controller.cc',
        'browser/chromeos/ui/focus_ring_controller.h',
        'browser/chromeos/ui/focus_ring_layer.cc',
        'browser/chromeos/ui/focus_ring_layer.h',
        'browser/chromeos/ui/idle_app_name_notification_view.cc',
        'browser/chromeos/ui/idle_app_name_notification_view.h',
        'browser/chromeos/ui/inline_login_dialog.cc',
        'browser/chromeos/ui/inline_login_dialog.h',
        'browser/chromeos/ui/kiosk_external_update_notification.cc',
        'browser/chromeos/ui/kiosk_external_update_notification.h',
        'browser/chromeos/ui/mobile_config_ui.cc',
        'browser/chromeos/ui/mobile_config_ui.h',
        'browser/chromeos/ui/screen_capture_notification_ui_chromeos.cc',
        'browser/chromeos/ui/screen_capture_notification_ui_chromeos.h',
        'browser/chromeos/ui_proxy_config.cc',
        'browser/chromeos/ui_proxy_config.h',
        'browser/chromeos/ui_proxy_config_service.cc',
        'browser/chromeos/ui_proxy_config_service.h',
        'browser/chromeos/upgrade_detector_chromeos.cc',
        'browser/chromeos/upgrade_detector_chromeos.h',
        'browser/supervised_user/chromeos/manager_password_service.cc',
        'browser/supervised_user/chromeos/manager_password_service.h',
        'browser/supervised_user/chromeos/manager_password_service_factory.cc',
        'browser/supervised_user/chromeos/manager_password_service_factory.h',
        'browser/supervised_user/chromeos/supervised_user_password_service.cc',
        'browser/supervised_user/chromeos/supervised_user_password_service.h',
        'browser/supervised_user/chromeos/supervised_user_password_service_factory.cc',
        'browser/supervised_user/chromeos/supervised_user_password_service_factory.h',
    ],
    # These files lists are shared with the GN build.
    'browser_chromeos_extension_sources': [
        # Only extension API implementations should go here.
        'browser/chromeos/extensions/echo_private_api.cc',
        'browser/chromeos/extensions/echo_private_api.h',
        'browser/chromeos/extensions/file_manager/device_event_router.cc',
        'browser/chromeos/extensions/file_manager/device_event_router.h',
        'browser/chromeos/extensions/file_manager/event_router.cc',
        'browser/chromeos/extensions/file_manager/event_router.h',
        'browser/chromeos/extensions/file_manager/event_router_factory.cc',
        'browser/chromeos/extensions/file_manager/event_router_factory.h',
        'browser/chromeos/extensions/file_manager/file_browser_handler_api.cc',
        'browser/chromeos/extensions/file_manager/file_browser_handler_api.h',
        'browser/chromeos/extensions/file_manager/file_manager_private_api_functions.h',
        'browser/chromeos/extensions/file_manager/file_stream_md5_digester.cc',
        'browser/chromeos/extensions/file_manager/file_stream_md5_digester.h',
        'browser/chromeos/extensions/file_manager/job_event_router.cc',
        'browser/chromeos/extensions/file_manager/job_event_router.h',
        'browser/chromeos/extensions/file_manager/private_api_base.cc',
        'browser/chromeos/extensions/file_manager/private_api_base.h',
        'browser/chromeos/extensions/file_manager/private_api_dialog.cc',
        'browser/chromeos/extensions/file_manager/private_api_dialog.h',
        'browser/chromeos/extensions/file_manager/private_api_drive.cc',
        'browser/chromeos/extensions/file_manager/private_api_drive.h',
        'browser/chromeos/extensions/file_manager/private_api_file_system.cc',
        'browser/chromeos/extensions/file_manager/private_api_file_system.h',
        'browser/chromeos/extensions/file_manager/private_api_misc.cc',
        'browser/chromeos/extensions/file_manager/private_api_misc.h',
        'browser/chromeos/extensions/file_manager/private_api_mount.cc',
        'browser/chromeos/extensions/file_manager/private_api_mount.h',
        'browser/chromeos/extensions/file_manager/private_api_strings.cc',
        'browser/chromeos/extensions/file_manager/private_api_strings.h',
        'browser/chromeos/extensions/file_manager/private_api_tasks.cc',
        'browser/chromeos/extensions/file_manager/private_api_tasks.h',
        'browser/chromeos/extensions/file_manager/private_api_util.cc',
        'browser/chromeos/extensions/file_manager/private_api_util.h',
        'browser/chromeos/extensions/file_system_provider/file_system_provider_api.cc',
        'browser/chromeos/extensions/file_system_provider/file_system_provider_api.h',
        'browser/chromeos/extensions/file_system_provider/provider_function.cc',
        'browser/chromeos/extensions/file_system_provider/provider_function.h',
        'browser/chromeos/extensions/first_run_private_api.cc',
        'browser/chromeos/extensions/first_run_private_api.h',
        'browser/chromeos/extensions/input_method_api.cc',
        'browser/chromeos/extensions/input_method_api.h',
        'browser/chromeos/extensions/media_player_api.cc',
        'browser/chromeos/extensions/media_player_api.h',
        'browser/chromeos/extensions/users_private/users_private_api.cc',
        'browser/chromeos/extensions/users_private/users_private_api.h',
        'browser/chromeos/extensions/users_private/users_private_delegate.cc',
        'browser/chromeos/extensions/users_private/users_private_delegate.h',
        'browser/chromeos/extensions/users_private/users_private_delegate_factory.cc',
        'browser/chromeos/extensions/users_private/users_private_delegate_factory.h',
        'browser/chromeos/extensions/wallpaper_api.cc',
        'browser/chromeos/extensions/wallpaper_api.h',
        'browser/chromeos/extensions/wallpaper_function_base.cc',
        'browser/chromeos/extensions/wallpaper_function_base.h',
        'browser/chromeos/extensions/wallpaper_manager_util.cc',
        'browser/chromeos/extensions/wallpaper_manager_util.h',
        'browser/chromeos/extensions/wallpaper_private_api.cc',
        'browser/chromeos/extensions/wallpaper_private_api.h',
    ],
  },
  'targets': [
    {
      # GN version: //chrome/browser/chromeos
      'target_name': 'browser_chromeos',
      'type': 'static_library',
      'variables': {
        # Override to dynamically link the cras (ChromeOS audio) library.
        'use_cras%': 0,
        'enable_wexit_time_destructors': 1,
      },
      'dependencies': [
        # TODO(tbarzic): Cleanup this list.
        'attestation_proto',
        'browser/extensions/api/api_registration.gyp:chrome_api_registration',
        'browser_extensions',
        'cert_logger_proto',
        'chrome_resources.gyp:chrome_extra_resources',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:platform_locale_settings',
        'chrome_resources.gyp:theme_resources',
        'common',
        'common/extensions/api/api.gyp:chrome_api',
        'common_net',
        'debugger',
        'device_policy_proto',
        'encrypted_cert_logger_proto',
        'installer_util',
        'safe_browsing_chunk_proto',
        'safe_browsing_proto',
        'safe_browsing_report_proto',
        '../build/linux/system.gyp:dbus',
        '../chromeos/chromeos.gyp:chromeos',
        '../chromeos/chromeos.gyp:chromeos_test_support',
        '../chromeos/chromeos.gyp:cryptohome_proto',
        # browser_chromeos #includes signed_secret.pb.h directly.
        '../chromeos/chromeos.gyp:cryptohome_signkey_proto',
        # browser_chromeos #includes power_supply_properties.pb.h directly.
        '../chromeos/chromeos.gyp:power_manager_proto',
        '../chromeos/ime/input_method.gyp:gencode',
        '../components/components.gyp:cloud_policy_proto',
        '../components/components.gyp:drive',
        '../components/components.gyp:login',
        '../components/components.gyp:onc_component',
        '../components/components.gyp:ownership',
        '../components/components.gyp:pairing',
        '../components/components.gyp:policy',
        '../components/components.gyp:user_manager',
        # This depends directly on the variations target, rather than just
        # transitively via the common target because the proto sources need to
        # be generated before code in this target can start building.
        '../components/components.gyp:variations',
        '../components/components.gyp:variations_http_provider',
        '../components/components.gyp:wallpaper',
        '../components/components.gyp:wifi_sync',
        '../components/components_strings.gyp:components_strings',
        '../content/app/resources/content_resources.gyp:content_resources',
        '../content/content.gyp:content_browser',
        '../content/content.gyp:content_common',
        '../crypto/crypto.gyp:crypto',
        '../dbus/dbus.gyp:dbus',
        '../device/bluetooth/bluetooth.gyp:device_bluetooth',
        '../device/hid/hid.gyp:device_hid',
        '../media/media.gyp:media',
        '../media/mojo/interfaces/mojo_bindings.gyp:platform_verification_api',
        '../net/net.gyp:net',
        '../ppapi/ppapi_internal.gyp:ppapi_ipc',  # For PpapiMsg_LoadPlugin
        '../skia/skia.gyp:skia',
        '../storage/storage_browser.gyp:storage',
        '../storage/storage_common.gyp:storage_common',
        '../sync/sync.gyp:sync',
        '../third_party/adobe/flash/flash_player.gyp:flapper_version_h',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation_proto_cpp',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
        '../third_party/libevent/libevent.gyp:libevent',
        '../third_party/libusb/libusb.gyp:libusb',
        '../third_party/protobuf/protobuf.gyp:protobuf_lite',
        '../third_party/protobuf/protobuf.gyp:protoc#host',
        '../third_party/re2/re2.gyp:re2',
        '../third_party/zlib/zlib.gyp:zlib',
        '../ui/base/ime/ui_base_ime.gyp:ui_base_ime',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/display/display.gyp:display',
        '../ui/events/devices/events_devices.gyp:events_devices',
        '../ui/events/events.gyp:dom_keycode_converter',
        '../ui/events/platform/events_platform.gyp:events_platform',
        '../ui/chromeos/ui_chromeos.gyp:ui_chromeos_resources',
        '../ui/chromeos/ui_chromeos.gyp:ui_chromeos_strings',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/strings/ui_strings.gyp:ui_strings',
        '../ui/surface/surface.gyp:surface',
        '../ui/views/controls/webview/webview.gyp:webview',
        '../ui/views/controls/webview/webview.gyp:webview',
        '../ui/web_dialogs/web_dialogs.gyp:web_dialogs',
        '../url/url.gyp:url_lib',
        '../v8/tools/gyp/v8.gyp:v8',
        'chrome_resources.gyp:chrome_strings',
      ],
      'export_dependent_settings': [
        'browser/extensions/api/api_registration.gyp:chrome_api_registration',
        'common/extensions/api/api.gyp:chrome_api',
        '../sync/sync.gyp:sync',
      ],
      'include_dirs': [
        # breakpad_linux.cc uses generated file_version_info_linux.h.
        '<(SHARED_INTERMEDIATE_DIR)',
        '../breakpad/src',
      ],
      'sources': [ '<@(browser_chromeos_sources)' ],
      'conditions': [
        ['enable_extensions==1', {
          'dependencies': [
            '../ui/file_manager/file_manager.gyp:file_manager',
          ],
          'sources': [ '<@(browser_chromeos_extension_sources)' ],
        }],
        ['use_x11==0', {
          'sources!': [
            'browser/chromeos/device_uma.cc',
            'browser/chromeos/device_uma.h',
            'browser/chromeos/events/system_key_event_listener.cc',
            'browser/chromeos/events/system_key_event_listener.h',
            'browser/chromeos/events/xinput_hierarchy_changed_event_listener.cc',
            'browser/chromeos/events/xinput_hierarchy_changed_event_listener.h',
          ],
        }],
        ['use_cras==1', {
          'defines': [
            'USE_CRAS',
          ],
        }],
        ['use_ash==1', {
          'dependencies': [
            '../ash/ash.gyp:ash',
            '../ash/ash.gyp:ash_with_content',
            '../ash/ash_resources.gyp:ash_resources',
            '../ash/ash_strings.gyp:ash_strings',
            '../components/components.gyp:session_manager_component',
            '../components/components.gyp:user_manager',
            '../ui/app_list/app_list.gyp:app_list',
            '../ui/message_center/message_center.gyp:message_center',
          ],
        }],
        ['use_aura==1', {
          'dependencies': [
            '../ui/aura/aura.gyp:aura',
            '../ui/compositor/compositor.gyp:compositor',
          ],
        }],
        ['ui_compositor_image_transport==1', {
          'dependencies': [
            '../ui/gl/gl.gyp:gl',
          ],
        }],
        ['use_aura==1',{
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../build/linux/system.gyp:fontconfig',
            '../ui/views/views.gyp:views',
          ],
          'include_dirs': [
            '<(INTERMEDIATE_DIR)',
            '<(INTERMEDIATE_DIR)/chrome',
          ],
          'sources/': [
            ['include', '^browser/chromeos/status/memory_menu_button.cc'],
            ['include', '^browser/chromeos/status/memory_menu_button.h'],
          ],
        }],
        ['use_aura==1 and use_x11==1', {
          'dependencies': [
            '../build/linux/system.gyp:x11',
            '../ui/events/platform/x11/x11_events_platform.gyp:x11_events_platform',
            '../ui/gfx/x/gfx_x11.gyp:gfx_x11',
          ],
        }],
        ['enable_basic_printing==1 or enable_print_preview==1', {
          'dependencies': [
            '../printing/printing.gyp:printing',
          ],
        }],
        ['use_ozone == 1', {
          'dependencies': [
            '../ui/ozone/ozone.gyp:ozone',
          ],
        }],
      ],
    },
    {
      # GN version: //chrome/browser/chromeos:device_policy_proto
      # Protobuf compiler / generator for device settings protocol buffers.
      'target_name': 'device_policy_proto',
      'type': 'static_library',
      'sources': [
        'browser/chromeos/policy/proto/chrome_device_policy.proto',
        'browser/chromeos/policy/proto/install_attributes.proto',
      ],
      'variables': {
        'proto_in_dir': 'browser/chromeos/policy/proto',
        'proto_out_dir': 'chrome/browser/chromeos/policy/proto',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # GN version: //chrome/browser/chromeos:attestation_proto
      # Protobuf compiler / generator for attestation protocol buffers.
      'target_name': 'attestation_proto',
      'type': 'static_library',
      'sources': [
        'browser/chromeos/attestation/attestation_key_payload.proto',
        'browser/chromeos/attestation/attestation_signed_data.proto',
      ],
      'variables': {
        'proto_in_dir': 'browser/chromeos/attestation',
        'proto_out_dir': 'chrome/browser/chromeos/attestation',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
  ],
}
