# Copyright 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    # All .cc, .h, .m, and .mm files under browser except for:
    # * tests and mocks.
    # * code below browser/chromeos
    # * code below browser/extensions
    # These variables are so the file lists can be shared with the GN build.
    # There are two sections of sources:
    # * "Platform"-based sources (OS, toolkit, etc.)
    # * Feature/directory-based sources (e.g., history, printing)

    ### Platform-based sources ###

    # The set of sources used on all platforms but iOS that aren't listed in
    # more specific variables below.
    'chrome_browser_non_ios_sources': [
      'browser/about_flags.cc',
      'browser/about_flags.h',
      'browser/after_startup_task_utils.cc',
      'browser/after_startup_task_utils.h',
      'browser/after_startup_task_utils_android.cc',
      'browser/after_startup_task_utils_android.h',
      'browser/android/accessibility/font_size_prefs_android.cc',
      'browser/android/accessibility/font_size_prefs_android.h',
      'browser/android/accessibility_util.cc',
      'browser/android/accessibility_util.h',
      'browser/android/activity_type_ids.cc',
      'browser/android/activity_type_ids.h',
      'browser/android/appmenu/app_menu_drag_helper.cc',
      'browser/android/appmenu/app_menu_drag_helper.h',
      'browser/android/banners/app_banner_data_fetcher_android.cc',
      'browser/android/banners/app_banner_data_fetcher_android.h',
      'browser/android/banners/app_banner_infobar_delegate_android.cc',
      'browser/android/banners/app_banner_infobar_delegate_android.h',
      'browser/android/banners/app_banner_manager_android.cc',
      'browser/android/banners/app_banner_manager_android.h',
      'browser/android/bookmarks/bookmarks_bridge.cc',
      'browser/android/bookmarks/bookmarks_bridge.h',
      'browser/android/bookmarks/edit_bookmark_helper.cc',
      'browser/android/bookmarks/edit_bookmark_helper.h',
      'browser/android/bookmarks/partner_bookmarks_reader.cc',
      'browser/android/bookmarks/partner_bookmarks_reader.h',
      'browser/android/bookmarks/partner_bookmarks_shim.cc',
      'browser/android/bookmarks/partner_bookmarks_shim.h',
      'browser/android/bottombar/contextualsearch/contextual_search_panel.cc',
      'browser/android/bottombar/contextualsearch/contextual_search_panel.h',
      'browser/android/chrome_application.cc',
      'browser/android/chrome_application.h',
      'browser/android/chrome_jni_registrar.cc',
      'browser/android/chrome_jni_registrar.h',
      'browser/android/chrome_media_client_android.cc',
      'browser/android/chrome_media_client_android.h',
      'browser/android/chrome_startup_flags.cc',
      'browser/android/chrome_startup_flags.h',
      'browser/android/chrome_web_contents_delegate_android.cc',
      'browser/android/chrome_web_contents_delegate_android.h',
      'browser/android/compositor/compositor_view.cc',
      'browser/android/compositor/compositor_view.h',
      'browser/android/compositor/decoration_title.cc',
      'browser/android/compositor/decoration_title.h',
      'browser/android/compositor/layer/content_layer.cc',
      'browser/android/compositor/layer/content_layer.h',
      'browser/android/compositor/layer/contextual_search_layer.cc',
      'browser/android/compositor/layer/contextual_search_layer.h',
      'browser/android/compositor/layer/layer.h',
      'browser/android/compositor/layer/reader_mode_layer.cc',
      'browser/android/compositor/layer/reader_mode_layer.h',
      'browser/android/compositor/layer/tab_handle_layer.cc',
      'browser/android/compositor/layer/tab_handle_layer.h',
      'browser/android/compositor/layer/tab_layer.cc',
      'browser/android/compositor/layer/tab_layer.h',
      'browser/android/compositor/layer/thumbnail_layer.cc',
      'browser/android/compositor/layer/thumbnail_layer.h',
      'browser/android/compositor/layer/toolbar_layer.cc',
      'browser/android/compositor/layer/toolbar_layer.h',
      'browser/android/compositor/layer_title_cache.cc',
      'browser/android/compositor/layer_title_cache.h',
      'browser/android/compositor/scene_layer/contextual_search_scene_layer.cc',
      'browser/android/compositor/scene_layer/contextual_search_scene_layer.h',
      'browser/android/compositor/scene_layer/reader_mode_scene_layer.cc',
      'browser/android/compositor/scene_layer/reader_mode_scene_layer.h',
      'browser/android/compositor/scene_layer/scene_layer.cc',
      'browser/android/compositor/scene_layer/scene_layer.h',
      'browser/android/compositor/scene_layer/static_tab_scene_layer.cc',
      'browser/android/compositor/scene_layer/static_tab_scene_layer.h',
      'browser/android/compositor/scene_layer/tab_list_scene_layer.cc',
      'browser/android/compositor/scene_layer/tab_list_scene_layer.h',
      'browser/android/compositor/scene_layer/tab_strip_scene_layer.cc',
      'browser/android/compositor/scene_layer/tab_strip_scene_layer.h',
      'browser/android/compositor/tab_content_manager.cc',
      'browser/android/compositor/tab_content_manager.h',
      'browser/android/contextualsearch/contextual_search_context.cc',
      'browser/android/contextualsearch/contextual_search_context.h',
      'browser/android/contextualsearch/contextual_search_delegate.cc',
      'browser/android/contextualsearch/contextual_search_delegate.h',
      'browser/android/contextualsearch/contextual_search_manager.cc',
      'browser/android/contextualsearch/contextual_search_manager.h',
      'browser/android/contextualsearch/contextual_search_tab_helper.cc',
      'browser/android/contextualsearch/contextual_search_tab_helper.h',
      'browser/android/cookies/cookies_fetcher.cc',
      'browser/android/cookies/cookies_fetcher.h',
      'browser/android/dev_tools_discovery_provider_android.cc',
      'browser/android/dev_tools_discovery_provider_android.h',
      'browser/android/dev_tools_server.cc',
      'browser/android/dev_tools_server.h',
      'browser/android/document/document_web_contents_delegate.cc',
      'browser/android/dom_distiller/external_feedback_reporter_android.cc',
      'browser/android/dom_distiller/external_feedback_reporter_android.h',
      'browser/android/download/android_download_manager_overwrite_infobar_delegate.cc',
      'browser/android/download/android_download_manager_overwrite_infobar_delegate.h',
      'browser/android/download/chrome_download_delegate.cc',
      'browser/android/download/chrome_download_delegate.h',
      'browser/android/download/chrome_download_manager_overwrite_infobar_delegate.cc',
      'browser/android/download/chrome_download_manager_overwrite_infobar_delegate.h',
      'browser/android/download/download_overwrite_infobar_delegate.cc',
      'browser/android/download/download_overwrite_infobar_delegate.h',
      'browser/android/download/mock_download_controller_android.cc',
      'browser/android/download/mock_download_controller_android.h',
      'browser/android/favicon_helper.cc',
      'browser/android/favicon_helper.h',
      'browser/android/feature_utilities.cc',
      'browser/android/feature_utilities.h',
      'browser/android/feedback/connectivity_checker.cc',
      'browser/android/feedback/connectivity_checker.h',
      'browser/android/find_in_page/find_in_page_bridge.cc',
      'browser/android/find_in_page/find_in_page_bridge.h',
      'browser/android/foreign_session_helper.cc',
      'browser/android/foreign_session_helper.h',
      'browser/android/fullscreen/fullscreen_infobar_delegate.cc',
      'browser/android/fullscreen/fullscreen_infobar_delegate.h',
      'browser/android/history_report/data_observer.cc',
      'browser/android/history_report/data_observer.h',
      'browser/android/history_report/data_provider.cc',
      'browser/android/history_report/data_provider.h',
      'browser/android/history_report/delta_file_backend_leveldb.cc',
      'browser/android/history_report/delta_file_backend_leveldb.h',
      'browser/android/history_report/delta_file_commons.cc',
      'browser/android/history_report/delta_file_commons.h',
      'browser/android/history_report/delta_file_service.cc',
      'browser/android/history_report/delta_file_service.h',
      'browser/android/history_report/get_all_urls_from_history_task.cc',
      'browser/android/history_report/get_all_urls_from_history_task.h',
      'browser/android/history_report/historic_visits_migration_task.cc',
      'browser/android/history_report/historic_visits_migration_task.h',
      'browser/android/history_report/history_report_jni_bridge.cc',
      'browser/android/history_report/history_report_jni_bridge.h',
      'browser/android/history_report/usage_report_util.cc',
      'browser/android/history_report/usage_report_util.h',
      'browser/android/history_report/usage_reports_buffer_backend.cc',
      'browser/android/history_report/usage_reports_buffer_backend.h',
      'browser/android/history_report/usage_reports_buffer_service.cc',
      'browser/android/history_report/usage_reports_buffer_service.h',
      'browser/android/hung_renderer_infobar_delegate.cc',
      'browser/android/hung_renderer_infobar_delegate.h',
      'browser/android/intent_helper.cc',
      'browser/android/intent_helper.h',
      'browser/android/intercept_download_resource_throttle.cc',
      'browser/android/intercept_download_resource_throttle.h',
      'browser/android/java_exception_reporter.cc',
      'browser/android/java_exception_reporter.h',
      'browser/android/large_icon_bridge.cc',
      'browser/android/large_icon_bridge.h',
      'browser/android/location_settings.h',
      'browser/android/location_settings_impl.cc',
      'browser/android/location_settings_impl.h',
      'browser/android/logo_bridge.cc',
      'browser/android/logo_bridge.h',
      'browser/android/logo_service.cc',
      'browser/android/logo_service.h',
      'browser/android/metrics/launch_metrics.cc',
      'browser/android/metrics/launch_metrics.h',
      'browser/android/metrics/uma_session_stats.cc',
      'browser/android/metrics/uma_session_stats.h',
      'browser/android/metrics/uma_utils.cc',
      'browser/android/metrics/uma_utils.h',
      'browser/android/metrics/variations_session.cc',
      'browser/android/metrics/variations_session.h',
      'browser/android/most_visited_sites.cc',
      'browser/android/most_visited_sites.h',
      'browser/android/net/external_estimate_provider_android.cc',
      'browser/android/net/external_estimate_provider_android.h',
      'browser/android/new_tab_page_prefs.cc',
      'browser/android/new_tab_page_prefs.h',
      'browser/android/new_tab_page_url_handler.cc',
      'browser/android/new_tab_page_url_handler.h',
      'browser/android/omnibox/answers_image_bridge.cc',
      'browser/android/omnibox/answers_image_bridge.h',
      'browser/android/omnibox/autocomplete_controller_android.cc',
      'browser/android/omnibox/autocomplete_controller_android.h',
      'browser/android/omnibox/omnibox_prerender.cc',
      'browser/android/omnibox/omnibox_prerender.h',
      'browser/android/password_ui_view_android.cc',
      'browser/android/password_ui_view_android.h',
      'browser/android/popular_sites.cc',
      'browser/android/popular_sites.h',
      'browser/android/precache/precache_launcher.cc',
      'browser/android/precache/precache_launcher.h',
      'browser/android/preferences/autofill/autofill_profile_bridge.cc',
      'browser/android/preferences/autofill/autofill_profile_bridge.h',
      'browser/android/preferences/pref_service_bridge.cc',
      'browser/android/preferences/pref_service_bridge.h',
      'browser/android/preferences/website_preference_bridge.cc',
      'browser/android/preferences/website_preference_bridge.h',
      'browser/android/profiles/profile_downloader_android.cc',
      'browser/android/profiles/profile_downloader_android.h',
      'browser/android/provider/blocking_ui_thread_async_request.cc',
      'browser/android/provider/blocking_ui_thread_async_request.h',
      'browser/android/provider/bookmark_model_observer_task.cc',
      'browser/android/provider/bookmark_model_observer_task.h',
      'browser/android/provider/chrome_browser_provider.cc',
      'browser/android/provider/chrome_browser_provider.h',
      'browser/android/provider/run_on_ui_thread_blocking.h',
      'browser/android/rappor/rappor_service_bridge.cc',
      'browser/android/rappor/rappor_service_bridge.h',
      'browser/android/recently_closed_tabs_bridge.cc',
      'browser/android/recently_closed_tabs_bridge.h',
      'browser/android/resource_id.h',
      'browser/android/resource_mapper.cc',
      'browser/android/resource_mapper.h',
      'browser/android/rlz/revenue_stats.cc',
      'browser/android/rlz/revenue_stats.h',
      'browser/android/seccomp_support_detector.cc',
      'browser/android/seccomp_support_detector.h',
      'browser/android/shortcut_helper.cc',
      'browser/android/shortcut_helper.h',
      'browser/android/shortcut_info.cc',
      'browser/android/shortcut_info.h',
      'browser/android/signin/account_management_screen_helper.cc',
      'browser/android/signin/account_management_screen_helper.h',
      'browser/android/signin/account_tracker_service_android.cc',
      'browser/android/signin/account_tracker_service_android.h',
      'browser/android/signin/signin_manager_android.cc',
      'browser/android/signin/signin_manager_android.h',
      'browser/android/tab/thumbnail_tab_helper_android.cc',
      'browser/android/tab/thumbnail_tab_helper_android.h',
      'browser/android/tab_android.cc',
      'browser/android/tab_android.h',
      'browser/android/tab_state.cc',
      'browser/android/tab_state.h',
      'browser/android/thumbnail/thumbnail.cc',
      'browser/android/thumbnail/thumbnail.h',
      'browser/android/thumbnail/thumbnail_cache.cc',
      'browser/android/thumbnail/thumbnail_cache.h',
      'browser/android/url_utilities.cc',
      'browser/android/url_utilities.h',
      'browser/android/voice_search_tab_helper.cc',
      'browser/android/voice_search_tab_helper.h',
      'browser/android/warmup_manager.cc',
      'browser/android/warmup_manager.h',
      'browser/android/web_contents_factory.cc',
      'browser/android/web_contents_factory.h',
      'browser/android/webapps/add_to_homescreen_data_fetcher.cc',
      'browser/android/webapps/add_to_homescreen_data_fetcher.h',
      'browser/android/webapps/add_to_homescreen_dialog_helper.cc',
      'browser/android/webapps/add_to_homescreen_dialog_helper.h',
      'browser/android/webapps/single_tab_mode_tab_helper.cc',
      'browser/android/webapps/single_tab_mode_tab_helper.h',
      'browser/android/webapps/webapp_registry.cc',
      'browser/android/webapps/webapp_registry.h',
      'browser/app_controller_mac.h',
      'browser/app_controller_mac.mm',
      'browser/app_icon_win.cc',
      'browser/app_icon_win.h',
      'browser/app_mode/app_mode_utils.cc',
      'browser/app_mode/app_mode_utils.h',
      'browser/autofill/android/personal_data_manager_android.cc',
      'browser/autofill/android/personal_data_manager_android.h',
      'browser/autofill/options_util.cc',
      'browser/autofill/options_util.h',
      'browser/autofill/personal_data_manager_factory.cc',
      'browser/autofill/personal_data_manager_factory.h',
      'browser/autofill/risk_util.cc',
      'browser/autofill/risk_util.h',
      'browser/autofill/validation_rules_storage_factory.cc',
      'browser/autofill/validation_rules_storage_factory.h',
      'browser/bad_message.cc',
      'browser/bad_message.h',
      'browser/banners/app_banner_data_fetcher.cc',
      'browser/banners/app_banner_data_fetcher.h',
      'browser/banners/app_banner_debug_log.cc',
      'browser/banners/app_banner_debug_log.h',
      'browser/banners/app_banner_manager.cc',
      'browser/banners/app_banner_manager.h',
      'browser/banners/app_banner_metrics.cc',
      'browser/banners/app_banner_metrics.h',
      'browser/banners/app_banner_settings_helper.cc',
      'browser/banners/app_banner_settings_helper.h',
      'browser/bitmap_fetcher/bitmap_fetcher.cc',
      'browser/bitmap_fetcher/bitmap_fetcher.h',
      'browser/bitmap_fetcher/bitmap_fetcher_delegate.h',
      'browser/bitmap_fetcher/bitmap_fetcher_service.cc',
      'browser/bitmap_fetcher/bitmap_fetcher_service.h',
      'browser/bitmap_fetcher/bitmap_fetcher_service_factory.cc',
      'browser/bitmap_fetcher/bitmap_fetcher_service_factory.h',
      'browser/browser_about_handler.cc',
      'browser/browser_about_handler.h',
      'browser/browser_shutdown.cc',
      'browser/browser_shutdown.h',
      'browser/browser_util_win.cc',
      'browser/browser_util_win.h',
      'browser/browsing_data/browsing_data_appcache_helper.cc',
      'browser/browsing_data/browsing_data_appcache_helper.h',
      'browser/browsing_data/browsing_data_cache_storage_helper.cc',
      'browser/browsing_data/browsing_data_cache_storage_helper.h',
      'browser/browsing_data/browsing_data_channel_id_helper.cc',
      'browser/browsing_data/browsing_data_channel_id_helper.h',
      'browser/browsing_data/browsing_data_cookie_helper.cc',
      'browser/browsing_data/browsing_data_cookie_helper.h',
      'browser/browsing_data/browsing_data_counter.cc',
      'browser/browsing_data/browsing_data_counter.h',
      'browser/browsing_data/browsing_data_database_helper.cc',
      'browser/browsing_data/browsing_data_database_helper.h',
      'browser/browsing_data/browsing_data_file_system_helper.cc',
      'browser/browsing_data/browsing_data_file_system_helper.h',
      'browser/browsing_data/browsing_data_helper.cc',
      'browser/browsing_data/browsing_data_helper.h',
      'browser/browsing_data/browsing_data_indexed_db_helper.cc',
      'browser/browsing_data/browsing_data_indexed_db_helper.h',
      'browser/browsing_data/browsing_data_local_storage_helper.cc',
      'browser/browsing_data/browsing_data_local_storage_helper.h',
      'browser/browsing_data/browsing_data_quota_helper.cc',
      'browser/browsing_data/browsing_data_quota_helper.h',
      'browser/browsing_data/browsing_data_quota_helper_impl.cc',
      'browser/browsing_data/browsing_data_quota_helper_impl.h',
      'browser/browsing_data/browsing_data_remover.cc',
      'browser/browsing_data/browsing_data_remover.h',
      'browser/browsing_data/browsing_data_service_worker_helper.cc',
      'browser/browsing_data/browsing_data_service_worker_helper.h',
      'browser/browsing_data/canonical_cookie_hash.cc',
      'browser/browsing_data/canonical_cookie_hash.h',
      'browser/browsing_data/cookies_tree_model.cc',
      'browser/browsing_data/cookies_tree_model.h',
      'browser/browsing_data/local_data_container.cc',
      'browser/browsing_data/local_data_container.h',
      'browser/browsing_data/passwords_counter.cc',
      'browser/browsing_data/passwords_counter.h',
      'browser/character_encoding.cc',
      'browser/character_encoding.h',
      'browser/chrome_browser_application_mac.h',
      'browser/chrome_browser_application_mac.mm',
      'browser/chrome_browser_field_trials.cc',
      'browser/chrome_browser_field_trials.h',
      'browser/chrome_browser_main.cc',
      'browser/chrome_browser_main.h',
      'browser/chrome_browser_main_android.cc',
      'browser/chrome_browser_main_android.h',
      'browser/chrome_browser_main_extra_parts.h',
      'browser/chrome_browser_main_linux.cc',
      'browser/chrome_browser_main_linux.h',
      'browser/chrome_browser_main_mac.h',
      'browser/chrome_browser_main_mac.mm',
      'browser/chrome_browser_main_win.cc',
      'browser/chrome_browser_main_win.h',
      'browser/chrome_child_process_watcher.cc',
      'browser/chrome_child_process_watcher.h',
      'browser/chrome_content_browser_client.cc',
      'browser/chrome_content_browser_client.h',
      'browser/chrome_content_browser_client_parts.h',
      'browser/chrome_elf_init_win.cc',
      'browser/chrome_elf_init_win.h',
      'browser/chrome_net_benchmarking_message_filter.cc',
      'browser/chrome_net_benchmarking_message_filter.h',
      'browser/chrome_notification_types.h',
      'browser/chrome_quota_permission_context.cc',
      'browser/chrome_quota_permission_context.h',
      'browser/chrome_select_file_dialog_factory_win.cc',
      'browser/chrome_select_file_dialog_factory_win.h',
      'browser/command_observer.h',
      'browser/command_updater.cc',
      'browser/command_updater.h',
      'browser/command_updater_delegate.h',
      'browser/component_updater/caps_installer_win.cc',
      'browser/component_updater/caps_installer_win.h',
      'browser/component_updater/chrome_component_updater_configurator.cc',
      'browser/component_updater/chrome_component_updater_configurator.h',
      'browser/component_updater/cld_component_installer.cc',
      'browser/component_updater/cld_component_installer.h',
      'browser/component_updater/component_patcher_operation_out_of_process.cc',
      'browser/component_updater/component_patcher_operation_out_of_process.h',
      'browser/component_updater/component_updater_resource_throttle.cc',
      'browser/component_updater/component_updater_resource_throttle.h',
      'browser/component_updater/ev_whitelist_component_installer.cc',
      'browser/component_updater/ev_whitelist_component_installer.h',
      'browser/component_updater/pnacl_component_installer.cc',
      'browser/component_updater/pnacl_component_installer.h',
      'browser/component_updater/recovery_component_installer.cc',
      'browser/component_updater/recovery_component_installer.h',
      'browser/component_updater/supervised_user_whitelist_installer.cc',
      'browser/component_updater/supervised_user_whitelist_installer.h',
      'browser/component_updater/sw_reporter_installer_win.cc',
      'browser/component_updater/sw_reporter_installer_win.h',
      'browser/component_updater/swiftshader_component_installer.cc',
      'browser/component_updater/swiftshader_component_installer.h',
      'browser/crash_upload_list.cc',
      'browser/crash_upload_list.h',
      'browser/crash_upload_list_mac.cc',
      'browser/crash_upload_list_mac.h',
      'browser/crash_upload_list_win.cc',
      'browser/crash_upload_list_win.h',
      'browser/custom_handlers/protocol_handler_registry.cc',
      'browser/custom_handlers/protocol_handler_registry.h',
      'browser/custom_handlers/protocol_handler_registry_factory.cc',
      'browser/custom_handlers/protocol_handler_registry_factory.h',
      'browser/custom_handlers/register_protocol_handler_infobar_delegate.cc',
      'browser/custom_handlers/register_protocol_handler_infobar_delegate.h',
      'browser/custom_handlers/register_protocol_handler_permission_request.cc',
      'browser/custom_handlers/register_protocol_handler_permission_request.h',
      'browser/defaults.cc',
      'browser/defaults.h',
      'browser/dom_distiller/dom_distiller_service_factory.cc',
      'browser/dom_distiller/dom_distiller_service_factory.h',
      'browser/dom_distiller/dom_distiller_service_factory_android.cc',
      'browser/dom_distiller/dom_distiller_service_factory_android.h',
      'browser/dom_distiller/lazy_dom_distiller_service.cc',
      'browser/dom_distiller/lazy_dom_distiller_service.h',
      'browser/dom_distiller/profile_utils.cc',
      'browser/dom_distiller/profile_utils.h',
      'browser/dom_distiller/tab_utils.cc',
      'browser/dom_distiller/tab_utils.h',
      'browser/dom_distiller/tab_utils_android.cc',
      'browser/dom_distiller/tab_utils_android.h',
      'browser/domain_reliability/service_factory.cc',
      'browser/domain_reliability/service_factory.h',
      'browser/download/all_download_item_notifier.cc',
      'browser/download/all_download_item_notifier.h',
      'browser/download/chrome_download_manager_delegate.cc',
      'browser/download/chrome_download_manager_delegate.h',
      'browser/download/download_crx_util_android.cc',
      'browser/download/download_extensions.cc',
      'browser/download/download_extensions.h',
      'browser/download/download_file_picker.cc',
      'browser/download/download_file_picker.h',
      'browser/download/download_history.cc',
      'browser/download/download_history.h',
      'browser/download/download_item_model.cc',
      'browser/download/download_item_model.h',
      'browser/download/download_path_reservation_tracker.cc',
      'browser/download/download_path_reservation_tracker.h',
      'browser/download/download_permission_request.cc',
      'browser/download/download_permission_request.h',
      'browser/download/download_prefs.cc',
      'browser/download/download_prefs.h',
      'browser/download/download_query.cc',
      'browser/download/download_query.h',
      'browser/download/download_request_limiter.cc',
      'browser/download/download_request_limiter.h',
      'browser/download/download_resource_throttle.cc',
      'browser/download/download_resource_throttle.h',
      'browser/download/download_service.cc',
      'browser/download/download_service.h',
      'browser/download/download_service_factory.cc',
      'browser/download/download_service_factory.h',
      'browser/download/download_service_impl.cc',
      'browser/download/download_service_impl.h',
      'browser/download/download_started_animation.h',
      'browser/download/download_stats.cc',
      'browser/download/download_stats.h',
      'browser/download/download_status_updater.cc',
      'browser/download/download_status_updater.h',
      'browser/download/download_status_updater_mac.mm',
      'browser/download/download_status_updater_win.cc',
      'browser/download/download_target_determiner.cc',
      'browser/download/download_target_determiner.h',
      'browser/download/download_target_determiner_delegate.h',
      'browser/download/download_target_info.h',
      'browser/download/download_ui_controller.cc',
      'browser/download/download_ui_controller.h',
      'browser/download/drag_download_item.h',
      'browser/download/save_package_file_picker.cc',
      'browser/download/save_package_file_picker.h',
      'browser/enumerate_modules_model_win.cc',
      'browser/enumerate_modules_model_win.h',
      # Oh hey, all the cool browser/extensions files are hanging out in
      # chrome/chrome_browser_extensions.gypi.
      'browser/external_protocol/external_protocol_handler.cc',
      'browser/external_protocol/external_protocol_handler.h',
      'browser/external_protocol/external_protocol_observer.cc',
      'browser/external_protocol/external_protocol_observer.h',
      'browser/file_select_helper.cc',
      'browser/file_select_helper.h',
      'browser/file_select_helper_mac.mm',
      'browser/flags_storage.h',
      'browser/fullscreen.h',
      'browser/fullscreen_chromeos.cc',
      'browser/fullscreen_mac.mm',
      'browser/fullscreen_win.cc',
      'browser/geolocation/chrome_access_token_store.cc',
      'browser/geolocation/chrome_access_token_store.h',
      'browser/geolocation/geolocation_infobar_delegate.cc',
      'browser/geolocation/geolocation_infobar_delegate.h',
      'browser/geolocation/geolocation_permission_context.cc',
      'browser/geolocation/geolocation_permission_context.h',
      'browser/geolocation/geolocation_permission_context_android.cc',
      'browser/geolocation/geolocation_permission_context_android.h',
      'browser/geolocation/geolocation_permission_context_extensions.cc',
      'browser/geolocation/geolocation_permission_context_extensions.h',
      'browser/geolocation/geolocation_permission_context_factory.cc',
      'browser/geolocation/geolocation_permission_context_factory.h',
      'browser/geolocation/geolocation_prefs.cc',
      'browser/geolocation/geolocation_prefs.h',
      'browser/global_keyboard_shortcuts_mac.h',
      'browser/global_keyboard_shortcuts_mac.mm',
      'browser/gpu/gl_string_manager.cc',
      'browser/gpu/gl_string_manager.h',
      'browser/gpu/gpu_feature_checker.cc',
      'browser/gpu/gpu_feature_checker.h',
      'browser/gpu/gpu_mode_manager.cc',
      'browser/gpu/gpu_mode_manager.h',
      'browser/gpu/three_d_api_observer.cc',
      'browser/gpu/three_d_api_observer.h',
      'browser/icon_loader.cc',
      'browser/icon_loader.h',
      'browser/icon_loader_android.cc',
      'browser/icon_loader_chromeos.cc',
      'browser/icon_loader_mac.mm',
      'browser/icon_loader_win.cc',
      'browser/icon_manager.cc',
      'browser/icon_manager.h',
      'browser/image_decoder.cc',
      'browser/image_decoder.h',
      'browser/image_holder.cc',
      'browser/image_holder.h',
      'browser/infobars/infobar_responder.cc',
      'browser/infobars/infobar_responder.h',
      'browser/infobars/infobar_service.cc',
      'browser/infobars/infobar_service.h',
      'browser/infobars/insecure_content_infobar_delegate.cc',
      'browser/infobars/insecure_content_infobar_delegate.h',
      'browser/install_verification/win/imported_module_verification.cc',
      'browser/install_verification/win/imported_module_verification.h',
      'browser/install_verification/win/install_verification.cc',
      'browser/install_verification/win/install_verification.h',
      'browser/install_verification/win/loaded_module_verification.cc',
      'browser/install_verification/win/loaded_module_verification.h',
      'browser/install_verification/win/loaded_modules_snapshot.cc',
      'browser/install_verification/win/loaded_modules_snapshot.h',
      'browser/install_verification/win/module_ids.cc',
      'browser/install_verification/win/module_ids.h',
      'browser/install_verification/win/module_info.h',
      'browser/install_verification/win/module_list.cc',
      'browser/install_verification/win/module_list.h',
      'browser/install_verification/win/module_verification_common.cc',
      'browser/install_verification/win/module_verification_common.h',
      'browser/internal_auth.cc',
      'browser/internal_auth.h',
      'browser/interstitials/chrome_metrics_helper.cc',
      'browser/interstitials/chrome_metrics_helper.h',
      'browser/interstitials/security_interstitial_page.cc',
      'browser/interstitials/security_interstitial_page.h',
      'browser/intranet_redirect_detector.cc',
      'browser/intranet_redirect_detector.h',
      'browser/invalidation/invalidation_service_factory_android.cc',
      'browser/invalidation/invalidation_service_factory_android.h',
      'browser/invalidation/profile_invalidation_provider_factory.cc',
      'browser/invalidation/profile_invalidation_provider_factory.h',
      'browser/io_thread.cc',
      'browser/io_thread.h',
      'browser/jumplist_updater_win.cc',
      'browser/jumplist_updater_win.h',
      'browser/jumplist_win.cc',
      'browser/jumplist_win.h',
      'browser/lifetime/application_lifetime.cc',
      'browser/lifetime/application_lifetime.h',
      'browser/lifetime/application_lifetime_android.cc',
      'browser/lifetime/application_lifetime_android.h',
      'browser/lifetime/application_lifetime_mac.mm',
      'browser/lifetime/application_lifetime_win.cc',
      'browser/mac/bluetooth_utility.h',
      'browser/mac/bluetooth_utility.mm',
      'browser/mac/dock.h',
      'browser/mac/dock.mm',
      'browser/mac/install_from_dmg.h',
      'browser/mac/install_from_dmg.mm',
      'browser/mac/keystone_glue.h',
      'browser/mac/keystone_glue.mm',
      'browser/mac/keystone_registration.h',
      'browser/mac/keystone_registration.mm',
      'browser/mac/mac_startup_profiler.cc',
      'browser/mac/mac_startup_profiler.h',
      'browser/mac/master_prefs.h',
      'browser/mac/master_prefs.mm',
      'browser/mac/obsolete_system.cc',
      'browser/mac/obsolete_system.h',
      'browser/mac/relauncher.cc',
      'browser/mac/relauncher.h',
      'browser/mac/security_wrappers.cc',
      'browser/mac/security_wrappers.h',
      'browser/manifest/manifest_icon_downloader.cc',
      'browser/manifest/manifest_icon_downloader.h',
      'browser/manifest/manifest_icon_selector.cc',
      'browser/manifest/manifest_icon_selector.h',
      'browser/media/android/remote/record_cast_action.cc',
      'browser/media/android/remote/record_cast_action.h',
      'browser/media/android/remote/remote_media_player_bridge.cc',
      'browser/media/android/remote/remote_media_player_bridge.h',
      'browser/media/android/remote/remote_media_player_manager.cc',
      'browser/media/android/remote/remote_media_player_manager.h',
      'browser/media/android/router/media_router_android.cc',
      'browser/media/android/router/media_router_android.h',
      'browser/media/android/router/media_router_dialog_controller_android.cc',
      'browser/media/android/router/media_router_dialog_controller_android.h',
      'browser/media/desktop_media_list.h',
      'browser/media/desktop_media_picker.h',
      'browser/media/desktop_streams_registry.cc',
      'browser/media/desktop_streams_registry.h',
      'browser/media/media_access_handler.h',
      'browser/media/media_capture_devices_dispatcher.cc',
      'browser/media/media_capture_devices_dispatcher.h',
      'browser/media/media_device_id_salt.cc',
      'browser/media/media_device_id_salt.h',
      'browser/media/media_permission.cc',
      'browser/media/media_permission.h',
      'browser/media/media_stream_camera_permission_context_factory.cc',
      'browser/media/media_stream_camera_permission_context_factory.h',
      'browser/media/media_stream_capture_indicator.cc',
      'browser/media/media_stream_capture_indicator.h',
      'browser/media/media_stream_device_permission_context.cc',
      'browser/media/media_stream_device_permission_context.h',
      'browser/media/media_stream_device_permissions.cc',
      'browser/media/media_stream_device_permissions.h',
      'browser/media/media_stream_devices_controller.cc',
      'browser/media/media_stream_devices_controller.h',
      'browser/media/media_stream_infobar_delegate.cc',
      'browser/media/media_stream_infobar_delegate.h',
      'browser/media/media_stream_mic_permission_context_factory.cc',
      'browser/media/media_stream_mic_permission_context_factory.h',
      'browser/media/media_url_constants.cc',
      'browser/media/media_url_constants.h',
      'browser/media/midi_permission_context.cc',
      'browser/media/midi_permission_context.h',
      'browser/media/midi_permission_context_factory.cc',
      'browser/media/midi_permission_context_factory.h',
      'browser/media/midi_permission_infobar_delegate.cc',
      'browser/media/midi_permission_infobar_delegate.h',
      'browser/media/native_desktop_media_list.cc',
      'browser/media/native_desktop_media_list.h',
      'browser/media/permission_bubble_media_access_handler.cc',
      'browser/media/permission_bubble_media_access_handler.h',
      # TODO(brettw) should this go with the webrtc sources?
      'browser/media/webrtc_log_list.cc',
      'browser/media/webrtc_log_list.h',
      'browser/memory/oom_memory_details.cc',
      'browser/memory/oom_memory_details.h',
      'browser/memory/oom_priority_manager.cc',
      'browser/memory/oom_priority_manager.h',
      'browser/memory/oom_priority_manager_delegate_chromeos.cc',
      'browser/memory/oom_priority_manager_delegate_chromeos.h',
      'browser/memory/system_memory_stats_recorder.h',
      'browser/memory/system_memory_stats_recorder_linux.cc',
      'browser/memory/system_memory_stats_recorder_win.cc',
      'browser/memory/tab_stats.cc',
      'browser/memory/tab_stats.h',
      'browser/memory_details.cc',
      'browser/memory_details.h',
      'browser/memory_details_android.cc',
      'browser/memory_details_linux.cc',
      'browser/memory_details_mac.cc',
      'browser/memory_details_win.cc',
      'browser/mod_pagespeed/mod_pagespeed_metrics.cc',
      'browser/mod_pagespeed/mod_pagespeed_metrics.h',
      'browser/native_window_notification_source.h',
      'browser/net/predictor_tab_helper.cc',
      'browser/net/predictor_tab_helper.h',
      'browser/performance_monitor/performance_monitor.cc',
      'browser/performance_monitor/performance_monitor.h',
      'browser/performance_monitor/process_metrics_history.cc',
      'browser/performance_monitor/process_metrics_history.h',
      'browser/platform_util.h',
      'browser/platform_util_android.cc',
      'browser/platform_util_chromeos.cc',
      'browser/platform_util_internal.h',
      'browser/platform_util_mac.mm',
      'browser/platform_util_win.cc',
      'browser/pref_service_flags_storage.cc',
      'browser/pref_service_flags_storage.h',
      'browser/prefetch/prefetch.cc',
      'browser/prefetch/prefetch.h',
      'browser/prefetch/prefetch_field_trial.cc',
      'browser/prefetch/prefetch_field_trial.h',
      'browser/prerender/external_prerender_handler_android.cc',
      'browser/prerender/external_prerender_handler_android.h',
      'browser/prerender/prerender_config.cc',
      'browser/prerender/prerender_config.h',
      'browser/prerender/prerender_contents.cc',
      'browser/prerender/prerender_contents.h',
      'browser/prerender/prerender_field_trial.cc',
      'browser/prerender/prerender_field_trial.h',
      'browser/prerender/prerender_final_status.cc',
      'browser/prerender/prerender_final_status.h',
      'browser/prerender/prerender_handle.cc',
      'browser/prerender/prerender_handle.h',
      'browser/prerender/prerender_histograms.cc',
      'browser/prerender/prerender_histograms.h',
      'browser/prerender/prerender_history.cc',
      'browser/prerender/prerender_history.h',
      'browser/prerender/prerender_link_manager.cc',
      'browser/prerender/prerender_link_manager.h',
      'browser/prerender/prerender_link_manager_factory.cc',
      'browser/prerender/prerender_link_manager_factory.h',
      'browser/prerender/prerender_manager.cc',
      'browser/prerender/prerender_manager.h',
      'browser/prerender/prerender_manager_factory.cc',
      'browser/prerender/prerender_manager_factory.h',
      'browser/prerender/prerender_message_filter.cc',
      'browser/prerender/prerender_message_filter.h',
      'browser/prerender/prerender_origin.cc',
      'browser/prerender/prerender_origin.h',
      'browser/prerender/prerender_resource_throttle.cc',
      'browser/prerender/prerender_resource_throttle.h',
      'browser/prerender/prerender_tab_helper.cc',
      'browser/prerender/prerender_tab_helper.h',
      'browser/prerender/prerender_util.cc',
      'browser/prerender/prerender_util.h',
      'browser/private_working_set_snapshot.h',
      'browser/private_working_set_snapshot_win.cc',
      'browser/process_info_snapshot.h',
      'browser/process_info_snapshot_mac.cc',
      'browser/process_resource_usage.cc',
      'browser/process_resource_usage.h',
      'browser/process_singleton.h',
      'browser/process_singleton_win.cc',
      'browser/push_messaging/push_messaging_app_identifier.cc',
      'browser/push_messaging/push_messaging_app_identifier.h',
      'browser/push_messaging/push_messaging_constants.cc',
      'browser/push_messaging/push_messaging_constants.h',
      'browser/push_messaging/push_messaging_permission_context.cc',
      'browser/push_messaging/push_messaging_permission_context.h',
      'browser/push_messaging/push_messaging_permission_context_factory.cc',
      'browser/push_messaging/push_messaging_permission_context_factory.h',
      'browser/push_messaging/push_messaging_service_factory.cc',
      'browser/push_messaging/push_messaging_service_factory.h',
      'browser/push_messaging/push_messaging_service_impl.cc',
      'browser/push_messaging/push_messaging_service_impl.h',
      'browser/renderer_context_menu/context_menu_content_type_factory.cc',
      'browser/renderer_context_menu/context_menu_content_type_factory.h',
      'browser/renderer_context_menu/context_menu_content_type_panel.cc',
      'browser/renderer_context_menu/context_menu_content_type_panel.h',
      'browser/renderer_context_menu/spellchecker_submenu_observer.h',
      'browser/renderer_context_menu/spellchecker_submenu_observer_mac.cc',
      'browser/renderer_host/chrome_render_message_filter.cc',
      'browser/renderer_host/chrome_render_message_filter.h',
      'browser/renderer_host/chrome_render_widget_host_view_mac_delegate.h',
      'browser/renderer_host/chrome_render_widget_host_view_mac_delegate.mm',
      'browser/renderer_host/chrome_render_widget_host_view_mac_history_swiper.h',
      'browser/renderer_host/chrome_render_widget_host_view_mac_history_swiper.mm',
      'browser/renderer_host/chrome_resource_dispatcher_host_delegate.cc',
      'browser/renderer_host/chrome_resource_dispatcher_host_delegate.h',
      'browser/renderer_preferences_util.cc',
      'browser/renderer_preferences_util.h',
      'browser/resources_util.cc',
      'browser/resources_util.h',
      'browser/safe_browsing/safe_browsing_tab_observer.cc',
      'browser/safe_browsing/safe_browsing_tab_observer.h',
      'browser/safe_browsing/srt_fetcher_win.cc',
      'browser/safe_browsing/srt_fetcher_win.h',
      'browser/safe_browsing/srt_field_trial_win.cc',
      'browser/safe_browsing/srt_field_trial_win.h',
      'browser/safe_browsing/srt_global_error_win.cc',
      'browser/safe_browsing/srt_global_error_win.h',
      'browser/search/contextual_search_policy_handler_android.cc',
      'browser/search/contextual_search_policy_handler_android.h',
      'browser/search/iframe_source.cc',
      'browser/search/iframe_source.h',
      'browser/search/instant_io_context.cc',
      'browser/search/instant_io_context.h',
      'browser/search/instant_service.cc',
      'browser/search/instant_service.h',
      'browser/search/instant_service_factory.cc',
      'browser/search/instant_service_factory.h',
      'browser/search/instant_service_observer.cc',
      'browser/search/instant_service_observer.h',
      'browser/search/most_visited_iframe_source.cc',
      'browser/search/most_visited_iframe_source.h',
      'browser/search/search.cc',
      'browser/search/search.h',
      'browser/search/suggestions/image_fetcher_impl.cc',
      'browser/search/suggestions/image_fetcher_impl.h',
      'browser/search/suggestions/suggestions_service_factory.cc',
      'browser/search/suggestions/suggestions_service_factory.h',
      'browser/search/suggestions/suggestions_source.cc',
      'browser/search/suggestions/suggestions_source.h',
      'browser/search/thumbnail_source.cc',
      'browser/search/thumbnail_source.h',
      'browser/shell_integration.cc',
      'browser/shell_integration.h',
      'browser/shell_integration_android.cc',
      'browser/shell_integration_chromeos.cc',
      'browser/shell_integration_mac.mm',
      'browser/shell_integration_win.cc',
      'browser/site_details.cc',
      'browser/site_details.h',
      'browser/speech/chrome_speech_recognition_manager_delegate.cc',
      'browser/speech/chrome_speech_recognition_manager_delegate.h',
      'browser/speech/tts_android.cc',
      'browser/speech/tts_android.h',
      'browser/speech/tts_chromeos.cc',
      'browser/speech/tts_controller.h',
      'browser/speech/tts_controller_impl.cc',
      'browser/speech/tts_controller_impl.h',
      'browser/speech/tts_mac.mm',
      'browser/speech/tts_message_filter.cc',
      'browser/speech/tts_message_filter.h',
      'browser/speech/tts_platform.cc',
      'browser/speech/tts_platform.h',
      'browser/speech/tts_win.cc',
      'browser/stack_sampling_configuration.cc',
      'browser/stack_sampling_configuration.h',
      'browser/status_icons/status_icon.cc',
      'browser/status_icons/status_icon.h',
      'browser/status_icons/status_icon_menu_model.cc',
      'browser/status_icons/status_icon_menu_model.h',
      'browser/status_icons/status_icon_observer.h',
      'browser/status_icons/status_tray.cc',
      'browser/status_icons/status_tray.h',
      'browser/storage/durable_storage_permission_context.cc',
      'browser/storage/durable_storage_permission_context.h',
      'browser/storage/durable_storage_permission_context_factory.cc',
      'browser/storage/durable_storage_permission_context_factory.h',
      'browser/storage/durable_storage_permission_infobar_delegate.cc',
      'browser/storage/durable_storage_permission_infobar_delegate.h',
      'browser/tab_contents/navigation_metrics_recorder.cc',
      'browser/tab_contents/navigation_metrics_recorder.h',
      'browser/tab_contents/retargeting_details.h',
      'browser/tab_contents/tab_util.cc',
      'browser/tab_contents/tab_util.h',
      'browser/task_management/web_contents_tags.cc',
      'browser/task_management/web_contents_tags.h',
      'browser/task_profiler/task_profiler_data_serializer.cc',
      'browser/task_profiler/task_profiler_data_serializer.h',
      'browser/thumbnails/content_analysis.cc',
      'browser/thumbnails/content_analysis.h',
      'browser/thumbnails/content_based_thumbnailing_algorithm.cc',
      'browser/thumbnails/content_based_thumbnailing_algorithm.h',
      'browser/thumbnails/simple_thumbnail_crop.cc',
      'browser/thumbnails/simple_thumbnail_crop.h',
      'browser/thumbnails/thumbnail_list_source.cc',
      'browser/thumbnails/thumbnail_list_source.h',
      'browser/thumbnails/thumbnail_service.h',
      'browser/thumbnails/thumbnail_service_factory.cc',
      'browser/thumbnails/thumbnail_service_factory.h',
      'browser/thumbnails/thumbnail_service_impl.cc',
      'browser/thumbnails/thumbnail_service_impl.h',
      'browser/thumbnails/thumbnail_tab_helper.cc',
      'browser/thumbnails/thumbnail_tab_helper.h',
      'browser/thumbnails/thumbnailing_algorithm.h',
      'browser/thumbnails/thumbnailing_context.cc',
      'browser/thumbnails/thumbnailing_context.h',
      'browser/tracing/background_tracing_field_trial.cc',
      'browser/tracing/background_tracing_field_trial.h',
      'browser/tracing/crash_service_uploader.cc',
      'browser/tracing/crash_service_uploader.h',
      'browser/tracing/navigation_tracing.cc',
      'browser/tracing/navigation_tracing.h',
      'browser/translate/chrome_translate_client.cc',
      'browser/translate/chrome_translate_client.h',
      'browser/translate/translate_accept_languages_factory.cc',
      'browser/translate/translate_accept_languages_factory.h',
      'browser/translate/translate_service.cc',
      'browser/translate/translate_service.h',
      'browser/update_client/chrome_update_query_params_delegate.cc',
      'browser/update_client/chrome_update_query_params_delegate.h',
      'browser/upgrade_detector.cc',
      'browser/upgrade_detector.h',
      'browser/web_data_service_factory.cc',
      'browser/web_data_service_factory.h',
    ],
    'chrome_browser_android_sources': [
      'browser/download/download_request_infobar_delegate.cc',
      'browser/download/download_request_infobar_delegate.h',
      'browser/media/protected_media_identifier_infobar_delegate.cc',
      'browser/media/protected_media_identifier_infobar_delegate.h',
      'browser/media/protected_media_identifier_permission_context.cc',
      'browser/media/protected_media_identifier_permission_context.h',
      'browser/media/protected_media_identifier_permission_context_factory.cc',
      'browser/media/protected_media_identifier_permission_context_factory.h',
      'browser/metrics/android_metrics_provider.cc',
      'browser/metrics/android_metrics_provider.h',
      'browser/password_manager/account_chooser_infobar_delegate_android.cc',
      'browser/password_manager/account_chooser_infobar_delegate_android.h',
      'browser/password_manager/credential_android.cc',
      'browser/password_manager/credential_android.h',
      'browser/password_manager/generated_password_saved_infobar_delegate_android.cc',
      'browser/password_manager/generated_password_saved_infobar_delegate_android.h',
      'browser/precache/precache_manager_factory.cc',
      'browser/precache/precache_manager_factory.h',
      'browser/signin/oauth2_token_service_delegate_android.cc',
      'browser/signin/oauth2_token_service_delegate_android.h',
      'browser/ssl/ssl_add_certificate_android.cc',
    ],
    # Cross-platform Ash sources.
    'chrome_browser_ash_sources': [
      'browser/media/desktop_media_list_ash.cc',
      'browser/media/desktop_media_list_ash.h',
      'browser/signin/signin_error_notifier_ash.cc',
      'browser/signin/signin_error_notifier_ash.h',
      'browser/signin/signin_error_notifier_factory_ash.cc',
      'browser/signin/signin_error_notifier_factory_ash.h',
      'browser/sync/sync_error_notifier_ash.cc',
      'browser/sync/sync_error_notifier_ash.h',
      'browser/sync/sync_error_notifier_factory_ash.cc',
      'browser/sync/sync_error_notifier_factory_ash.h',
    ],
    # Cross-platform Aura files.
    'chrome_browser_aura_sources': [
      # This file is called _views but has aura calls in it.
      'browser/download/drag_download_item_views.cc',
      'browser/lifetime/application_lifetime_aura.cc',
      'browser/platform_util_aura.cc',
    ],
    # ChromeOS-sources not ending in _chromeos (which would be included in
    # other sections and filtered out for non-ChromeOS platforms.
    'chrome_browser_chromeos_sources': [
      'browser/media/protected_media_identifier_infobar_delegate.cc',
      'browser/media/protected_media_identifier_infobar_delegate.h',
      'browser/media/protected_media_identifier_permission_context.cc',
      'browser/media/protected_media_identifier_permission_context.h',
      'browser/media/protected_media_identifier_permission_context_factory.cc',
      'browser/media/protected_media_identifier_permission_context_factory.h',
      'browser/metrics/chromeos_metrics_provider.cc',
      'browser/metrics/chromeos_metrics_provider.h',
      'browser/metrics/perf/random_selector.cc',
      'browser/metrics/perf/random_selector.h',
      'browser/metrics/perf/windowed_incognito_observer.cc',
      'browser/metrics/perf/windowed_incognito_observer.h',
      # This is technically also dependent on enable_plugins but we don't
      # support ChromeOS with enable_plugins==0.
      'browser/renderer_host/pepper/pepper_platform_verification_message_filter.cc',
      'browser/renderer_host/pepper/pepper_platform_verification_message_filter.h',
    ],
    # Everything but Android, iOS, and CrOS.
    'chrome_browser_desktop_sources': [
      'browser/platform_util.cc',
      'browser/profiles/avatar_menu_actions_desktop.cc',
      'browser/profiles/avatar_menu_actions_desktop.h',
      'browser/profiles/avatar_menu_desktop.cc',
      'browser/profiles/avatar_menu_observer.h',
      'browser/profiles/profile_list_desktop.cc',
      'browser/profiles/profile_list_desktop.h',
      'browser/signin/cross_device_promo.cc',
      'browser/signin/cross_device_promo.h',
      'browser/signin/cross_device_promo_factory.cc',
      'browser/signin/cross_device_promo_factory.h',
      'browser/signin/signin_global_error.cc',
      'browser/signin/signin_global_error.h',
      'browser/signin/signin_global_error_factory.cc',
      'browser/signin/signin_global_error_factory.h',
    ],
    # Miscellaneous files that were brought up on iOS before the decision not
    # to use chrome/ for iOS. These, plus a few of the directory-specific
    # source lists below, are all that are built on iOS. These are built
    # despite the change in direction in order to prevent iOS regressions while
    # componentization is in progress.
    # TODO(stuartmorgan): Remove this once enough has been componentized that
    # there's no value in building any of chrome/ for iOS.
    'chrome_browser_ios_sources': [
      'browser/browser_process.cc',
      'browser/browser_process.h',
      'browser/browser_process_platform_part_base.cc',
      'browser/browser_process_platform_part_base.h',
    ],
    # Desktop Linux and ChromeOS.
    'chrome_browser_linux_sources': [
      'browser/renderer_context_menu/spellchecker_submenu_observer_hunspell.cc',
    ],
    # Desktop linux, doesn't count ChromeOS.
    'chrome_browser_linux_desktop_sources': [
      'browser/first_run/upgrade_util.cc',
      'browser/first_run/upgrade_util_linux.cc',
      'browser/first_run/upgrade_util_linux.h',
      'browser/fullscreen_aurax11.cc',
      'browser/icon_loader_auralinux.cc',
      'browser/password_manager/native_backend_kwallet_x.cc',
      'browser/password_manager/native_backend_kwallet_x.h',
      'browser/platform_util_linux.cc',
      'browser/shell_integration_linux.cc',
      'browser/shell_integration_linux.h',
      'browser/speech/tts_linux.cc',
      'browser/sxs_linux.cc',
      'browser/sxs_linux.h',
      'browser/themes/theme_service_aurax11.cc',
      'browser/themes/theme_service_aurax11.h',
      'browser/web_applications/web_app_linux.cc',
    ],
    'chrome_browser_mac_sources': [
      'browser/media_galleries/fileapi/iphoto_data_provider.cc',
      'browser/media_galleries/fileapi/iphoto_data_provider.h',
      'browser/media_galleries/fileapi/iphoto_file_util.cc',
      'browser/media_galleries/fileapi/iphoto_file_util.h',
      'browser/password_manager/password_manager_util_mac.h',
      'browser/password_manager/password_manager_util_mac.mm',
    ],
    # Android and iOS, not CrOS.
    'chrome_browser_mobile_sources': [
      'browser/chrome_browser_field_trials_mobile.cc',
      'browser/chrome_browser_field_trials_mobile.h',
    ],
    # Everything but Android and iOS.
    'chrome_browser_non_mobile_sources': [
      'browser/accessibility/invert_bubble_prefs.cc',
      'browser/accessibility/invert_bubble_prefs.h',
      'browser/auto_launch_trial.cc',
      'browser/auto_launch_trial.h',
      'browser/background/background_contents.cc',
      'browser/background/background_contents.h',
      'browser/banners/app_banner_data_fetcher_desktop.cc',
      'browser/banners/app_banner_data_fetcher_desktop.h',
      'browser/banners/app_banner_infobar_delegate_desktop.cc',
      'browser/banners/app_banner_infobar_delegate_desktop.h',
      'browser/banners/app_banner_manager_desktop.cc',
      'browser/banners/app_banner_manager_desktop.h',
      'browser/bookmarks/bookmark_html_writer.cc',
      'browser/bookmarks/bookmark_html_writer.h',
      'browser/certificate_viewer.cc',
      'browser/certificate_viewer.h',
      'browser/chrome_browser_field_trials_desktop.cc',
      'browser/chrome_browser_field_trials_desktop.h',
      'browser/chrome_browser_main_posix.cc',
      'browser/chrome_browser_main_posix.h',
      'browser/chrome_device_client.cc',
      'browser/chrome_device_client.h',
      'browser/chrome_process_singleton.cc',
      'browser/chrome_process_singleton.h',
      'browser/chrome_webusb_browser_client.cc',
      'browser/chrome_webusb_browser_client.h',
      'browser/component_updater/widevine_cdm_component_installer.cc',
      'browser/component_updater/widevine_cdm_component_installer.h',
      'browser/custom_home_pages_table_model.cc',
      'browser/custom_home_pages_table_model.h',
      'browser/diagnostics/diagnostics_controller.cc',
      'browser/diagnostics/diagnostics_controller.h',
      'browser/diagnostics/diagnostics_metrics.cc',
      'browser/diagnostics/diagnostics_metrics.h',
      'browser/diagnostics/diagnostics_model.cc',
      'browser/diagnostics/diagnostics_model.h',
      'browser/diagnostics/diagnostics_test.cc',
      'browser/diagnostics/diagnostics_test.h',
      'browser/diagnostics/diagnostics_writer.cc',
      'browser/diagnostics/diagnostics_writer.h',
      'browser/diagnostics/recon_diagnostics.cc',
      'browser/diagnostics/recon_diagnostics.h',
      'browser/diagnostics/sqlite_diagnostics.cc',
      'browser/diagnostics/sqlite_diagnostics.h',
      'browser/download/download_commands.cc',
      'browser/download/download_commands.h',
      'browser/download/download_crx_util.cc',
      'browser/download/download_crx_util.h',
      'browser/download/download_danger_prompt.cc',
      'browser/download/download_danger_prompt.h',
      'browser/download/download_shelf.cc',
      'browser/download/download_shelf.h',
      'browser/download/download_shelf_context_menu.cc',
      'browser/download/download_shelf_context_menu.h',
      'browser/download/notification/download_item_notification.cc',
      'browser/download/notification/download_item_notification.h',
      'browser/download/notification/download_notification.cc',
      'browser/download/notification/download_notification.h',
      'browser/download/notification/download_notification_manager.cc',
      'browser/download/notification/download_notification_manager.h',
      'browser/feedback/feedback_profile_observer.cc',
      'browser/feedback/feedback_profile_observer.h',
      'browser/feedback/show_feedback_page.cc',
      'browser/feedback/system_logs/about_system_logs_fetcher.cc',
      'browser/feedback/system_logs/about_system_logs_fetcher.h',
      'browser/feedback/system_logs/log_sources/chrome_internal_log_source.cc',
      'browser/feedback/system_logs/log_sources/chrome_internal_log_source.h',
      'browser/feedback/system_logs/log_sources/memory_details_log_source.cc',
      'browser/feedback/system_logs/log_sources/memory_details_log_source.h',
      'browser/feedback/system_logs/scrubbed_system_logs_fetcher.cc',
      'browser/feedback/system_logs/scrubbed_system_logs_fetcher.h',
      'browser/feedback/system_logs/system_logs_fetcher_base.cc',
      'browser/feedback/system_logs/system_logs_fetcher_base.h',
      'browser/first_run/first_run.cc',
      'browser/first_run/first_run.h',
      'browser/first_run/first_run_dialog.h',
      'browser/first_run/first_run_internal.h',
      'browser/first_run/first_run_internal_linux.cc',
      'browser/first_run/first_run_internal_mac.mm',
      'browser/first_run/first_run_internal_posix.cc',
      'browser/first_run/first_run_internal_win.cc',
      'browser/first_run/upgrade_util.h',
      'browser/first_run/upgrade_util_mac.cc',
      'browser/first_run/upgrade_util_win.cc',
      'browser/first_run/upgrade_util_win.h',
      'browser/font_family_cache.cc',
      'browser/font_family_cache.h',
      'browser/importer/external_process_importer_client.cc',
      'browser/importer/external_process_importer_client.h',
      'browser/importer/external_process_importer_host.cc',
      'browser/importer/external_process_importer_host.h',
      'browser/importer/firefox_profile_lock.cc',
      'browser/importer/firefox_profile_lock.h',
      'browser/importer/firefox_profile_lock_posix.cc',
      'browser/importer/firefox_profile_lock_win.cc',
      'browser/importer/importer_list.cc',
      'browser/importer/importer_list.h',
      'browser/importer/importer_lock_dialog.h',
      'browser/importer/importer_progress_observer.h',
      'browser/importer/importer_uma.cc',
      'browser/importer/importer_uma.h',
      'browser/importer/in_process_importer_bridge.cc',
      'browser/importer/in_process_importer_bridge.h',
      'browser/importer/profile_writer.cc',
      'browser/importer/profile_writer.h',
      'browser/invalidation/ticl_profile_settings_provider.cc',
      'browser/invalidation/ticl_profile_settings_provider.h',
      'browser/lifetime/browser_close_manager.cc',
      'browser/lifetime/browser_close_manager.h',
      'browser/media_galleries/fileapi/av_scanning_file_validator.cc',
      'browser/media_galleries/fileapi/av_scanning_file_validator.h',
      'browser/media_galleries/fileapi/device_media_async_file_util.cc',
      'browser/media_galleries/fileapi/device_media_async_file_util.h',
      'browser/media_galleries/fileapi/iapps_finder.h',
      'browser/media_galleries/fileapi/iapps_finder_impl.cc',
      'browser/media_galleries/fileapi/iapps_finder_impl.h',
      'browser/media_galleries/fileapi/iapps_finder_impl_mac.mm',
      'browser/media_galleries/fileapi/iapps_finder_impl_win.cc',
      'browser/media_galleries/fileapi/media_file_system_backend.cc',
      'browser/media_galleries/fileapi/media_file_system_backend.h',
      'browser/media_galleries/fileapi/media_file_validator_factory.cc',
      'browser/media_galleries/fileapi/media_file_validator_factory.h',
      'browser/media_galleries/fileapi/media_path_filter.cc',
      'browser/media_galleries/fileapi/media_path_filter.h',
      'browser/media_galleries/fileapi/mtp_device_async_delegate.cc',
      'browser/media_galleries/fileapi/mtp_device_async_delegate.h',
      'browser/media_galleries/fileapi/mtp_device_map_service.cc',
      'browser/media_galleries/fileapi/mtp_device_map_service.h',
      'browser/media_galleries/fileapi/mtp_file_stream_reader.cc',
      'browser/media_galleries/fileapi/mtp_file_stream_reader.h',
      'browser/media_galleries/fileapi/native_media_file_util.cc',
      'browser/media_galleries/fileapi/native_media_file_util.h',
      'browser/media_galleries/fileapi/picasa_finder.cc',
      'browser/media_galleries/fileapi/picasa_finder.h',
      'browser/media_galleries/fileapi/picasa_finder_mac.mm',
      'browser/media_galleries/fileapi/readahead_file_stream_reader.cc',
      'browser/media_galleries/fileapi/readahead_file_stream_reader.h',
      'browser/media_galleries/fileapi/safe_audio_video_checker.cc',
      'browser/media_galleries/fileapi/safe_audio_video_checker.h',
      'browser/media_galleries/fileapi/safe_media_metadata_parser.cc',
      'browser/media_galleries/fileapi/safe_media_metadata_parser.h',
      'browser/media_galleries/fileapi/supported_audio_video_checker.cc',
      'browser/media_galleries/fileapi/supported_audio_video_checker.h',
      'browser/media_galleries/fileapi/supported_image_type_validator.cc',
      'browser/media_galleries/fileapi/supported_image_type_validator.h',
      'browser/media_galleries/gallery_watch_manager.cc',
      'browser/media_galleries/gallery_watch_manager.h',
      'browser/media_galleries/gallery_watch_manager_observer.h',
      'browser/media_galleries/imported_media_gallery_registry.cc',
      'browser/media_galleries/imported_media_gallery_registry.h',
      'browser/media_galleries/linux/mtp_device_delegate_impl_linux.cc',
      'browser/media_galleries/linux/mtp_device_delegate_impl_linux.h',
      'browser/media_galleries/linux/mtp_device_object_enumerator.cc',
      'browser/media_galleries/linux/mtp_device_object_enumerator.h',
      'browser/media_galleries/linux/mtp_device_task_helper.cc',
      'browser/media_galleries/linux/mtp_device_task_helper.h',
      'browser/media_galleries/linux/mtp_device_task_helper_map_service.cc',
      'browser/media_galleries/linux/mtp_device_task_helper_map_service.h',
      'browser/media_galleries/linux/mtp_read_file_worker.cc',
      'browser/media_galleries/linux/mtp_read_file_worker.h',
      'browser/media_galleries/linux/snapshot_file_details.cc',
      'browser/media_galleries/linux/snapshot_file_details.h',
      'browser/media_galleries/mac/mtp_device_delegate_impl_mac.h',
      'browser/media_galleries/mac/mtp_device_delegate_impl_mac.mm',
      'browser/media_galleries/media_file_system_registry.cc',
      'browser/media_galleries/media_file_system_registry.h',
      'browser/media_galleries/media_folder_finder.cc',
      'browser/media_galleries/media_folder_finder.h',
      'browser/media_galleries/media_galleries_dialog_controller.cc',
      'browser/media_galleries/media_galleries_dialog_controller.h',
      'browser/media_galleries/media_galleries_histograms.cc',
      'browser/media_galleries/media_galleries_histograms.h',
      'browser/media_galleries/media_galleries_permission_controller.cc',
      'browser/media_galleries/media_galleries_permission_controller.h',
      'browser/media_galleries/media_galleries_preferences.cc',
      'browser/media_galleries/media_galleries_preferences.h',
      'browser/media_galleries/media_galleries_preferences_factory.cc',
      'browser/media_galleries/media_galleries_preferences_factory.h',
      'browser/media_galleries/media_galleries_scan_result_controller.cc',
      'browser/media_galleries/media_galleries_scan_result_controller.h',
      'browser/media_galleries/media_gallery_context_menu.cc',
      'browser/media_galleries/media_gallery_context_menu.h',
      'browser/media_galleries/media_scan_manager.cc',
      'browser/media_galleries/media_scan_manager.h',
      'browser/media_galleries/media_scan_manager_observer.h',
      'browser/media_galleries/media_scan_types.cc',
      'browser/media_galleries/media_scan_types.h',
      'browser/media_galleries/win/mtp_device_delegate_impl_win.cc',
      'browser/media_galleries/win/mtp_device_delegate_impl_win.h',
      'browser/media_galleries/win/mtp_device_object_entry.cc',
      'browser/media_galleries/win/mtp_device_object_entry.h',
      'browser/media_galleries/win/mtp_device_object_enumerator.cc',
      'browser/media_galleries/win/mtp_device_object_enumerator.h',
      'browser/media_galleries/win/mtp_device_operations_util.cc',
      'browser/media_galleries/win/mtp_device_operations_util.h',
      'browser/media_galleries/win/portable_device_map_service.cc',
      'browser/media_galleries/win/portable_device_map_service.h',
      'browser/media_galleries/win/snapshot_file_details.cc',
      'browser/media_galleries/win/snapshot_file_details.h',
      'browser/net/firefox_proxy_settings.cc',
      'browser/net/firefox_proxy_settings.h',
      'browser/net/utility_process_mojo_proxy_resolver_factory.cc',
      'browser/net/utility_process_mojo_proxy_resolver_factory.h',
      'browser/pdf/pdf_extension_util.cc',
      'browser/pdf/pdf_extension_util.h',
      'browser/power/process_power_collector.cc',
      'browser/power/process_power_collector.h',
      'browser/process_singleton_modal_dialog_lock.cc',
      'browser/process_singleton_modal_dialog_lock.h',
      'browser/process_singleton_posix.cc',
      'browser/process_singleton_startup_lock.cc',
      'browser/process_singleton_startup_lock.h',
      'browser/profile_resetter/automatic_profile_resetter.cc',
      'browser/profile_resetter/automatic_profile_resetter.h',
      'browser/profile_resetter/automatic_profile_resetter_delegate.cc',
      'browser/profile_resetter/automatic_profile_resetter_delegate.h',
      'browser/profile_resetter/automatic_profile_resetter_factory.cc',
      'browser/profile_resetter/automatic_profile_resetter_factory.h',
      'browser/profile_resetter/automatic_profile_resetter_mementos.cc',
      'browser/profile_resetter/automatic_profile_resetter_mementos.h',
      'browser/profile_resetter/brandcode_config_fetcher.cc',
      'browser/profile_resetter/brandcode_config_fetcher.h',
      'browser/profile_resetter/brandcoded_default_settings.cc',
      'browser/profile_resetter/brandcoded_default_settings.h',
      'browser/profile_resetter/jtl_foundation.cc',
      'browser/profile_resetter/jtl_foundation.h',
      'browser/profile_resetter/jtl_instructions.h',
      'browser/profile_resetter/jtl_interpreter.cc',
      'browser/profile_resetter/jtl_interpreter.h',
      'browser/profile_resetter/profile_reset_global_error.cc',
      'browser/profile_resetter/profile_reset_global_error.h',
      'browser/profile_resetter/profile_resetter.cc',
      'browser/profile_resetter/profile_resetter.h',
      'browser/profile_resetter/resettable_settings_snapshot.cc',
      'browser/profile_resetter/resettable_settings_snapshot.h',
      'browser/profiles/avatar_menu.cc',
      'browser/profiles/avatar_menu.h',
      'browser/profiles/profile_shortcut_manager.cc',
      'browser/profiles/profile_shortcut_manager.h',
      'browser/profiles/profile_window.cc',
      'browser/profiles/profile_window.h',
      'browser/renderer_context_menu/render_view_context_menu.cc',
      'browser/renderer_context_menu/render_view_context_menu.h',
      'browser/renderer_context_menu/spelling_bubble_model.cc',
      'browser/renderer_context_menu/spelling_bubble_model.h',
      'browser/renderer_context_menu/spelling_menu_observer.cc',
      'browser/renderer_context_menu/spelling_menu_observer.h',
      'browser/repost_form_warning_controller.cc',
      'browser/repost_form_warning_controller.h',
      'browser/search/local_ntp_source.cc',
      'browser/search/local_ntp_source.h',
      'browser/search/search_terms_tracker.cc',
      'browser/search/search_terms_tracker.h',
      'browser/services/gcm/gcm_desktop_utils.cc',
      'browser/services/gcm/gcm_desktop_utils.h',
      'browser/signin/signin_promo.cc',
      'browser/signin/signin_promo.h',
      'browser/signin/signin_ui_util.cc',
      'browser/signin/signin_ui_util.h',
      'browser/speech/extension_api/tts_extension_api_constants.cc',  # Should be moved to extensions section?
      'browser/speech/extension_api/tts_extension_api_constants.h',
      'browser/ssl/ssl_add_certificate.cc',
      'browser/ssl/ssl_add_certificate.h',
      'browser/ssl/ssl_client_auth_observer.cc',
      'browser/ssl/ssl_client_auth_observer.h',
      'browser/status_icons/desktop_notification_balloon.cc',
      'browser/status_icons/desktop_notification_balloon.h',
      'browser/sync/glue/extension_data_type_controller.cc',
      'browser/sync/glue/extension_data_type_controller.h',
      'browser/sync/glue/extension_setting_data_type_controller.cc',
      'browser/sync/glue/extension_setting_data_type_controller.h',
      'browser/sync/glue/synced_tab_delegate_desktop.cc',
      'browser/sync/sync_ui_util.cc',
      'browser/sync/sync_ui_util.h',
      'browser/tracing/chrome_tracing_delegate.cc',
      'browser/tracing/chrome_tracing_delegate.h',
      'browser/usb/web_usb_permission_provider.cc',
      'browser/usb/web_usb_permission_provider.h',
    ],
    'chrome_browser_win_sources': [
      'browser/browser_process_platform_part_aurawin.cc',
      'browser/browser_process_platform_part_aurawin.h',
      'browser/first_run/try_chrome_dialog_view.cc',
      'browser/first_run/try_chrome_dialog_view.h',
      'browser/first_run/upgrade_util.cc',
      'browser/google/did_run_updater_win.cc',
      'browser/google/did_run_updater_win.h',
      'browser/hang_monitor/hang_crash_dump_win.cc',
      'browser/hang_monitor/hang_crash_dump_win.h',
      'browser/hang_monitor/hung_plugin_action.cc',
      'browser/hang_monitor/hung_plugin_action.h',
      'browser/hang_monitor/hung_window_detector.cc',
      'browser/hang_monitor/hung_window_detector.h',
      'browser/metro_viewer/chrome_metro_viewer_process_host_aurawin.cc',
      'browser/metro_viewer/chrome_metro_viewer_process_host_aurawin.h',
      'browser/password_manager/password_manager_util_win.cc',
      'browser/password_manager/password_manager_util_win.h',
      'browser/renderer_context_menu/spellchecker_submenu_observer_hunspell.cc',
    ],
    'chrome_browser_non_win_sources': [
      'browser/profiles/profile_shortcut_manager_stub.cc',
    ],
    # Sources (generally "desktop OS importers") used only on Mac & Windows.
    'chrome_browser_win_mac_sources': [
      'browser/media_galleries/fileapi/file_path_watcher_util.cc',
      'browser/media_galleries/fileapi/file_path_watcher_util.h',
      'browser/media_galleries/fileapi/iapps_data_provider.cc',
      'browser/media_galleries/fileapi/iapps_data_provider.h',
      'browser/media_galleries/fileapi/itunes_data_provider.cc',
      'browser/media_galleries/fileapi/itunes_data_provider.h',
      'browser/media_galleries/fileapi/itunes_file_util.cc',
      'browser/media_galleries/fileapi/itunes_file_util.h',
      'browser/media_galleries/fileapi/picasa_data_provider.cc',
      'browser/media_galleries/fileapi/picasa_data_provider.h',
      'browser/media_galleries/fileapi/picasa_file_util.cc',
      'browser/media_galleries/fileapi/picasa_file_util.h',
      'browser/media_galleries/fileapi/safe_iapps_library_parser.cc',
      'browser/media_galleries/fileapi/safe_iapps_library_parser.h',
      'browser/media_galleries/fileapi/safe_itunes_pref_parser_win.cc',
      'browser/media_galleries/fileapi/safe_itunes_pref_parser_win.h',
      'browser/media_galleries/fileapi/safe_picasa_album_table_reader.cc',
      'browser/media_galleries/fileapi/safe_picasa_album_table_reader.h',
      'browser/media_galleries/fileapi/safe_picasa_albums_indexer.cc',
      'browser/media_galleries/fileapi/safe_picasa_albums_indexer.h',
      'browser/recovery/recovery_install_global_error.cc',
      'browser/recovery/recovery_install_global_error.h',
      'browser/recovery/recovery_install_global_error_factory.cc',
      'browser/recovery/recovery_install_global_error_factory.h',
    ],
    # X11 sources, coveres desktop Linux and ChromeOS.
    'chrome_browser_x11_sources': [
      'browser/chrome_browser_main_extra_parts_x11.cc',
      'browser/chrome_browser_main_extra_parts_x11.h',
    ],

    ### Feature-based sources ###
    # Variables should generally be alphabetical within this section.

    'chrome_browser_autocomplete_sources': [
      'browser/autocomplete/autocomplete_classifier_factory.cc',
      'browser/autocomplete/autocomplete_classifier_factory.h',
      'browser/autocomplete/chrome_autocomplete_provider_client.cc',
      'browser/autocomplete/chrome_autocomplete_provider_client.h',
      'browser/autocomplete/chrome_autocomplete_scheme_classifier.cc',
      'browser/autocomplete/chrome_autocomplete_scheme_classifier.h',
      'browser/autocomplete/in_memory_url_index_factory.cc',
      'browser/autocomplete/in_memory_url_index_factory.h',
      'browser/autocomplete/shortcuts_backend_factory.cc',
      'browser/autocomplete/shortcuts_backend_factory.h',
      'browser/autocomplete/shortcuts_extensions_manager.cc',
      'browser/autocomplete/shortcuts_extensions_manager.h',
    ],
    'chrome_browser_background_sources': [
      'browser/background/background_application_list_model.cc',
      'browser/background/background_application_list_model.h',
      'browser/background/background_contents_service.cc',
      'browser/background/background_contents_service.h',
      'browser/background/background_contents_service_factory.cc',
      'browser/background/background_contents_service_factory.h',
      'browser/background/background_mode_manager.cc',
      'browser/background/background_mode_manager.h',
      'browser/background/background_mode_manager_aura.cc',
      'browser/background/background_mode_manager_chromeos.cc',
      'browser/background/background_mode_manager_mac.mm',
      'browser/background/background_mode_manager_win.cc',
      'browser/background/background_trigger.h',
    ],
    'chrome_browser_bookmark_sources': [
      'browser/bookmarks/bookmark_model_factory.cc',
      'browser/bookmarks/bookmark_model_factory.h',
      'browser/bookmarks/bookmark_stats.cc',
      'browser/bookmarks/bookmark_stats.h',
      'browser/bookmarks/chrome_bookmark_client.cc',
      'browser/bookmarks/chrome_bookmark_client.h',
      'browser/bookmarks/chrome_bookmark_client_factory.cc',
      'browser/bookmarks/chrome_bookmark_client_factory.h',
      'browser/bookmarks/managed_bookmark_service_factory.cc',
      'browser/bookmarks/managed_bookmark_service_factory.h',
      'browser/bookmarks/startup_task_runner_service_factory.cc',
      'browser/bookmarks/startup_task_runner_service_factory.h',
      'browser/enhanced_bookmarks/bookmark_server_cluster_service_factory.cc',
      'browser/enhanced_bookmarks/bookmark_server_cluster_service_factory.h',
      'browser/enhanced_bookmarks/enhanced_bookmark_model_factory.cc',
      'browser/enhanced_bookmarks/enhanced_bookmark_model_factory.h',
    ],
    'chrome_browser_bookmark_android_sources': [
      'browser/android/offline_pages/offline_page_bridge.cc',
      'browser/android/offline_pages/offline_page_bridge.h',
      'browser/android/offline_pages/offline_page_mhtml_archiver.cc',
      'browser/android/offline_pages/offline_page_mhtml_archiver.h',
      'browser/android/offline_pages/offline_page_model_factory.cc',
      'browser/android/offline_pages/offline_page_model_factory.h',
    ],
    'chrome_browser_browser_process_sources': [
      'browser/browser_process.cc',
      'browser/browser_process.h',
      'browser/browser_process_impl.cc',
      'browser/browser_process_impl.h',
      'browser/browser_process_platform_part.h',
      'browser/browser_process_platform_part_android.cc',
      'browser/browser_process_platform_part_android.h',
      'browser/browser_process_platform_part_base.cc',
      'browser/browser_process_platform_part_base.h',
      'browser/browser_process_platform_part_chromeos.cc',
      'browser/browser_process_platform_part_chromeos.h',
      'browser/browser_process_platform_part_mac.h',
      'browser/browser_process_platform_part_mac.mm',
    ],
    'chrome_browser_captive_portal_sources': [
      'browser/captive_portal/captive_portal_login_detector.cc',
      'browser/captive_portal/captive_portal_login_detector.h',
      'browser/captive_portal/captive_portal_service.cc',
      'browser/captive_portal/captive_portal_service.h',
      'browser/captive_portal/captive_portal_service_factory.cc',
      'browser/captive_portal/captive_portal_service_factory.h',
      'browser/captive_portal/captive_portal_tab_helper.cc',
      'browser/captive_portal/captive_portal_tab_helper.h',
      'browser/captive_portal/captive_portal_tab_reloader.cc',
      'browser/captive_portal/captive_portal_tab_reloader.h',
      'browser/ssl/captive_portal_blocking_page.cc',
      'browser/ssl/captive_portal_blocking_page.h',
    ],
    'chrome_browser_content_settings_sources': [
      'browser/content_settings/chrome_content_settings_client.cc',
      'browser/content_settings/chrome_content_settings_client.h',
      'browser/content_settings/chrome_content_settings_utils.cc',
      'browser/content_settings/chrome_content_settings_utils.h',
      'browser/content_settings/cookie_settings_factory.cc',
      'browser/content_settings/cookie_settings_factory.h',
      'browser/content_settings/host_content_settings_map_factory.cc',
      'browser/content_settings/host_content_settings_map_factory.h',
      'browser/content_settings/local_shared_objects_container.cc',
      'browser/content_settings/local_shared_objects_container.h',
      'browser/content_settings/tab_specific_content_settings.cc',
      'browser/content_settings/tab_specific_content_settings.h',
      'browser/content_settings/web_site_settings_uma_util.cc',
      'browser/content_settings/web_site_settings_uma_util.h',
    ],
    'chrome_browser_engagement_sources': [
      'browser/engagement/site_engagement_eviction_policy.cc',
      'browser/engagement/site_engagement_eviction_policy.h',
      'browser/engagement/site_engagement_helper.cc',
      'browser/engagement/site_engagement_helper.h',
      'browser/engagement/site_engagement_service.cc',
      'browser/engagement/site_engagement_service.h',
      'browser/engagement/site_engagement_service_factory.cc',
      'browser/engagement/site_engagement_service_factory.h',
    ],
    'chrome_browser_extensions_sources': [
      'browser/accessibility/accessibility_extension_api.cc',
      'browser/accessibility/accessibility_extension_api.h',
      'browser/accessibility/animation_policy_prefs.cc',
      'browser/accessibility/animation_policy_prefs.h',
      'browser/autocomplete/keyword_extensions_delegate_impl.cc',
      'browser/autocomplete/keyword_extensions_delegate_impl.h',
      'browser/content_settings/content_settings_internal_extension_provider.cc',
      'browser/content_settings/content_settings_internal_extension_provider.h',
      'browser/drive/drive_notification_manager_factory.cc',
      'browser/drive/drive_notification_manager_factory.h',
      'browser/guest_view/app_view/chrome_app_view_guest_delegate.cc',
      'browser/guest_view/app_view/chrome_app_view_guest_delegate.h',
      'browser/guest_view/chrome_guest_view_manager_delegate.cc',
      'browser/guest_view/chrome_guest_view_manager_delegate.h',
      'browser/guest_view/extension_options/chrome_extension_options_guest_delegate.cc',
      'browser/guest_view/extension_options/chrome_extension_options_guest_delegate.h',
      'browser/guest_view/mime_handler_view/chrome_mime_handler_view_guest_delegate.cc',
      'browser/guest_view/mime_handler_view/chrome_mime_handler_view_guest_delegate.h',
      'browser/guest_view/web_view/chrome_web_view_guest_delegate.cc',
      'browser/guest_view/web_view/chrome_web_view_guest_delegate.h',
      'browser/guest_view/web_view/chrome_web_view_permission_helper_delegate.cc',
      'browser/guest_view/web_view/chrome_web_view_permission_helper_delegate.h',
      'browser/guest_view/web_view/context_menu_content_type_web_view.cc',
      'browser/guest_view/web_view/context_menu_content_type_web_view.h',
      'browser/media/cast_transport_host_filter.cc',
      'browser/media/cast_transport_host_filter.h',
      'browser/media/desktop_capture_access_handler.cc',
      'browser/media/desktop_capture_access_handler.h',
      'browser/media/extension_media_access_handler.cc',
      'browser/media/extension_media_access_handler.h',
      'browser/media/tab_capture_access_handler.cc',
      'browser/media/tab_capture_access_handler.h',
      'browser/metrics/extensions_metrics_provider.cc',
      'browser/metrics/extensions_metrics_provider.h',
      'browser/renderer_context_menu/context_menu_content_type_app_mode.cc',
      'browser/renderer_context_menu/context_menu_content_type_app_mode.h',
      'browser/renderer_context_menu/context_menu_content_type_extension_popup.cc',
      'browser/renderer_context_menu/context_menu_content_type_extension_popup.h',
      'browser/renderer_context_menu/context_menu_content_type_platform_app.cc',
      'browser/renderer_context_menu/context_menu_content_type_platform_app.h',
      'browser/renderer_host/chrome_extension_message_filter.cc',
      'browser/renderer_host/chrome_extension_message_filter.h',
      'browser/search/hotword_audio_history_handler.cc',
      'browser/search/hotword_audio_history_handler.h',
      'browser/search/hotword_client.h',
      'browser/search/hotword_service.cc',
      'browser/search/hotword_service.h',
      'browser/search/hotword_service_factory.cc',
      'browser/search/hotword_service_factory.h',
      'browser/signin/chrome_proximity_auth_client.cc',
      'browser/signin/chrome_proximity_auth_client.h',
      'browser/signin/easy_unlock_app_manager.cc',
      'browser/signin/easy_unlock_app_manager.h',
      'browser/signin/easy_unlock_auth_attempt.cc',
      'browser/signin/easy_unlock_auth_attempt.h',
      'browser/signin/easy_unlock_metrics.cc',
      'browser/signin/easy_unlock_metrics.h',
      'browser/signin/easy_unlock_screenlock_state_handler.cc',
      'browser/signin/easy_unlock_screenlock_state_handler.h',
      'browser/signin/easy_unlock_service.cc',
      'browser/signin/easy_unlock_service.h',
      'browser/signin/easy_unlock_service_factory.cc',
      'browser/signin/easy_unlock_service_factory.h',
      'browser/signin/easy_unlock_service_regular.cc',
      'browser/signin/easy_unlock_service_regular.h',
      'browser/signin/easy_unlock_service_signin_chromeos.cc',
      'browser/signin/easy_unlock_service_signin_chromeos.h',
      'browser/speech/extension_api/tts_engine_extension_api.cc',
      'browser/speech/extension_api/tts_engine_extension_api.h',
      'browser/speech/extension_api/tts_engine_extension_observer.cc',
      'browser/speech/extension_api/tts_engine_extension_observer.h',
      'browser/speech/extension_api/tts_extension_api.cc',
      'browser/speech/extension_api/tts_extension_api.h',
      'browser/sync_file_system/conflict_resolution_policy.h',
      'browser/sync_file_system/drive_backend/callback_helper.h',
      'browser/sync_file_system/drive_backend/callback_tracker.cc',
      'browser/sync_file_system/drive_backend/callback_tracker.h',
      'browser/sync_file_system/drive_backend/callback_tracker_internal.cc',
      'browser/sync_file_system/drive_backend/callback_tracker_internal.h',
      'browser/sync_file_system/drive_backend/conflict_resolver.cc',
      'browser/sync_file_system/drive_backend/conflict_resolver.h',
      'browser/sync_file_system/drive_backend/drive_backend_constants.cc',
      'browser/sync_file_system/drive_backend/drive_backend_constants.h',
      'browser/sync_file_system/drive_backend/drive_backend_util.cc',
      'browser/sync_file_system/drive_backend/drive_backend_util.h',
      'browser/sync_file_system/drive_backend/drive_service_on_worker.cc',
      'browser/sync_file_system/drive_backend/drive_service_on_worker.h',
      'browser/sync_file_system/drive_backend/drive_service_wrapper.cc',
      'browser/sync_file_system/drive_backend/drive_service_wrapper.h',
      'browser/sync_file_system/drive_backend/drive_uploader_on_worker.cc',
      'browser/sync_file_system/drive_backend/drive_uploader_on_worker.h',
      'browser/sync_file_system/drive_backend/drive_uploader_wrapper.cc',
      'browser/sync_file_system/drive_backend/drive_uploader_wrapper.h',
      'browser/sync_file_system/drive_backend/folder_creator.cc',
      'browser/sync_file_system/drive_backend/folder_creator.h',
      'browser/sync_file_system/drive_backend/leveldb_wrapper.cc',
      'browser/sync_file_system/drive_backend/leveldb_wrapper.h',
      'browser/sync_file_system/drive_backend/list_changes_task.cc',
      'browser/sync_file_system/drive_backend/list_changes_task.h',
      'browser/sync_file_system/drive_backend/local_to_remote_syncer.cc',
      'browser/sync_file_system/drive_backend/local_to_remote_syncer.h',
      'browser/sync_file_system/drive_backend/metadata_database.cc',
      'browser/sync_file_system/drive_backend/metadata_database.h',
      'browser/sync_file_system/drive_backend/metadata_database_index.cc',
      'browser/sync_file_system/drive_backend/metadata_database_index.h',
      'browser/sync_file_system/drive_backend/metadata_database_index_interface.h',
      'browser/sync_file_system/drive_backend/metadata_database_index_on_disk.cc',
      'browser/sync_file_system/drive_backend/metadata_database_index_on_disk.h',
      'browser/sync_file_system/drive_backend/metadata_db_migration_util.cc',
      'browser/sync_file_system/drive_backend/metadata_db_migration_util.h',
      'browser/sync_file_system/drive_backend/register_app_task.cc',
      'browser/sync_file_system/drive_backend/register_app_task.h',
      'browser/sync_file_system/drive_backend/remote_change_processor_on_worker.cc',
      'browser/sync_file_system/drive_backend/remote_change_processor_on_worker.h',
      'browser/sync_file_system/drive_backend/remote_change_processor_wrapper.cc',
      'browser/sync_file_system/drive_backend/remote_change_processor_wrapper.h',
      'browser/sync_file_system/drive_backend/remote_to_local_syncer.cc',
      'browser/sync_file_system/drive_backend/remote_to_local_syncer.h',
      'browser/sync_file_system/drive_backend/sync_engine.cc',
      'browser/sync_file_system/drive_backend/sync_engine.h',
      'browser/sync_file_system/drive_backend/sync_engine_context.cc',
      'browser/sync_file_system/drive_backend/sync_engine_context.h',
      'browser/sync_file_system/drive_backend/sync_engine_initializer.cc',
      'browser/sync_file_system/drive_backend/sync_engine_initializer.h',
      'browser/sync_file_system/drive_backend/sync_task.cc',
      'browser/sync_file_system/drive_backend/sync_task.h',
      'browser/sync_file_system/drive_backend/sync_task_manager.cc',
      'browser/sync_file_system/drive_backend/sync_task_manager.h',
      'browser/sync_file_system/drive_backend/sync_task_token.cc',
      'browser/sync_file_system/drive_backend/sync_task_token.h',
      'browser/sync_file_system/drive_backend/sync_worker.cc',
      'browser/sync_file_system/drive_backend/sync_worker.h',
      'browser/sync_file_system/drive_backend/sync_worker_interface.h',
      'browser/sync_file_system/drive_backend/task_dependency_manager.cc',
      'browser/sync_file_system/drive_backend/task_dependency_manager.h',
      'browser/sync_file_system/drive_backend/tracker_id_set.cc',
      'browser/sync_file_system/drive_backend/tracker_id_set.h',
      'browser/sync_file_system/drive_backend/uninstall_app_task.cc',
      'browser/sync_file_system/drive_backend/uninstall_app_task.h',
      'browser/sync_file_system/file_change.cc',
      'browser/sync_file_system/file_change.h',
      'browser/sync_file_system/file_status_observer.h',
      'browser/sync_file_system/local/local_file_change_tracker.cc',
      'browser/sync_file_system/local/local_file_change_tracker.h',
      'browser/sync_file_system/local/local_file_sync_context.cc',
      'browser/sync_file_system/local/local_file_sync_context.h',
      'browser/sync_file_system/local/local_file_sync_service.cc',
      'browser/sync_file_system/local/local_file_sync_service.h',
      'browser/sync_file_system/local/local_file_sync_status.cc',
      'browser/sync_file_system/local/local_file_sync_status.h',
      'browser/sync_file_system/local/local_origin_change_observer.h',
      'browser/sync_file_system/local/root_delete_helper.cc',
      'browser/sync_file_system/local/root_delete_helper.h',
      'browser/sync_file_system/local/sync_file_system_backend.cc',
      'browser/sync_file_system/local/sync_file_system_backend.h',
      'browser/sync_file_system/local/syncable_file_operation_runner.cc',
      'browser/sync_file_system/local/syncable_file_operation_runner.h',
      'browser/sync_file_system/local/syncable_file_system_operation.cc',
      'browser/sync_file_system/local/syncable_file_system_operation.h',
      'browser/sync_file_system/local_change_processor.h',
      'browser/sync_file_system/logger.cc',
      'browser/sync_file_system/logger.h',
      'browser/sync_file_system/remote_change_processor.h',
      'browser/sync_file_system/remote_file_sync_service.cc',
      'browser/sync_file_system/remote_file_sync_service.h',
      'browser/sync_file_system/subtree_set.cc',
      'browser/sync_file_system/subtree_set.h',
      'browser/sync_file_system/sync_action.cc',
      'browser/sync_file_system/sync_action.h',
      'browser/sync_file_system/sync_callbacks.h',
      'browser/sync_file_system/sync_direction.h',
      'browser/sync_file_system/sync_event_observer.h',
      'browser/sync_file_system/sync_file_metadata.cc',
      'browser/sync_file_system/sync_file_metadata.h',
      'browser/sync_file_system/sync_file_status.h',
      'browser/sync_file_system/sync_file_system_service.cc',
      'browser/sync_file_system/sync_file_system_service.h',
      'browser/sync_file_system/sync_file_system_service_factory.cc',
      'browser/sync_file_system/sync_file_system_service_factory.h',
      'browser/sync_file_system/sync_file_type.h',
      'browser/sync_file_system/sync_operation_type.cc',
      'browser/sync_file_system/sync_operation_type.h',
      'browser/sync_file_system/sync_process_runner.cc',
      'browser/sync_file_system/sync_process_runner.h',
      'browser/sync_file_system/sync_service_state.h',
      'browser/sync_file_system/sync_status_code.cc',
      'browser/sync_file_system/sync_status_code.h',
      'browser/sync_file_system/syncable_file_system_util.cc',
      'browser/sync_file_system/syncable_file_system_util.h',
      'browser/sync_file_system/task_logger.cc',
      'browser/sync_file_system/task_logger.h',
    ],
    'chrome_browser_favicon_sources': [
      'browser/favicon/chrome_fallback_icon_client.cc',
      'browser/favicon/chrome_fallback_icon_client.h',
      'browser/favicon/chrome_fallback_icon_client_factory.cc',
      'browser/favicon/chrome_fallback_icon_client_factory.h',
      'browser/favicon/chrome_favicon_client.cc',
      'browser/favicon/chrome_favicon_client.h',
      'browser/favicon/fallback_icon_service_factory.cc',
      'browser/favicon/fallback_icon_service_factory.h',
      'browser/favicon/favicon_service_factory.cc',
      'browser/favicon/favicon_service_factory.h',
      'browser/favicon/favicon_utils.cc',
      'browser/favicon/favicon_utils.h',
      'browser/favicon/large_icon_service_factory.cc',
      'browser/favicon/large_icon_service_factory.h',
    ],
    'chrome_browser_gnome_keyring_sources': [
      'browser/password_manager/native_backend_gnome_x.cc',
      'browser/password_manager/native_backend_gnome_x.h',
    ],
    'chrome_browser_libsecret_sources': [
       'browser/password_manager/native_backend_libsecret.cc',
       'browser/password_manager/native_backend_libsecret.h',
    ],
    'chrome_browser_google_sources': [
      'browser/google/chrome_google_url_tracker_client.cc',
      'browser/google/chrome_google_url_tracker_client.h',
      'browser/google/google_brand.cc',
      'browser/google/google_brand.h',
      'browser/google/google_brand_chromeos.cc',
      'browser/google/google_brand_chromeos.h',
      'browser/google/google_update_settings_posix.cc',
      'browser/google/google_update_win.cc',
      'browser/google/google_update_win.h',
      'browser/google/google_url_tracker_factory.cc',
      'browser/google/google_url_tracker_factory.h',
    ],
    'chrome_browser_history_sources': [
      'browser/history/android/android_history_provider_service.cc',
      'browser/history/android/android_history_provider_service.h',
      'browser/history/android/android_provider_backend.cc',
      'browser/history/android/android_provider_backend.h',
      'browser/history/android/bookmark_model_sql_handler.cc',
      'browser/history/android/bookmark_model_sql_handler.h',
      'browser/history/android/sqlite_cursor.cc',
      'browser/history/android/sqlite_cursor.h',
      'browser/history/chrome_history_backend_client.cc',
      'browser/history/chrome_history_backend_client.h',
      'browser/history/chrome_history_client.cc',
      'browser/history/chrome_history_client.h',
      'browser/history/history_service_factory.cc',
      'browser/history/history_service_factory.h',
      'browser/history/history_tab_helper.cc',
      'browser/history/history_tab_helper.h',
      'browser/history/history_utils.cc',
      'browser/history/history_utils.h',
      'browser/history/top_sites_factory.cc',
      'browser/history/top_sites_factory.h',
      'browser/history/web_history_service_factory.cc',
      'browser/history/web_history_service_factory.h',
    ],
    'chrome_browser_jni_sources': [
      'android/java/src/org/chromium/chrome/browser/AccessibilityUtil.java',
      'android/java/src/org/chromium/chrome/browser/AfterStartupTaskUtils.java',
      'android/java/src/org/chromium/chrome/browser/ApplicationLifetime.java',
      'android/java/src/org/chromium/chrome/browser/accessibility/FontSizePrefs.java',
      'android/java/src/org/chromium/chrome/browser/appmenu/AppMenuDragHelper.java',
      'android/java/src/org/chromium/chrome/browser/autofill/AutofillDialogControllerAndroid.java',
      'android/java/src/org/chromium/chrome/browser/autofill/AutofillDialogResult.java',
      'android/java/src/org/chromium/chrome/browser/autofill/AutofillKeyboardAccessoryBridge.java',
      'android/java/src/org/chromium/chrome/browser/autofill/AutofillLogger.java',
      'android/java/src/org/chromium/chrome/browser/autofill/AutofillPopupBridge.java',
      'android/java/src/org/chromium/chrome/browser/autofill/CardUnmaskBridge.java',
      'android/java/src/org/chromium/chrome/browser/autofill/CreditCardScanner.java',
      'android/java/src/org/chromium/chrome/browser/autofill/PasswordGenerationPopupBridge.java',
      'android/java/src/org/chromium/chrome/browser/autofill/PersonalDataManager.java',
      'android/java/src/org/chromium/chrome/browser/BluetoothChooserDialog.java',
      'android/java/src/org/chromium/chrome/browser/BookmarksBridge.java',
      'android/java/src/org/chromium/chrome/browser/bookmark/EditBookmarkHelper.java',
      'android/java/src/org/chromium/chrome/browser/banners/AppBannerManager.java',
      'android/java/src/org/chromium/chrome/browser/CertificateViewer.java',
      'android/java/src/org/chromium/chrome/browser/childaccounts/ChildAccountService.java',
      'android/java/src/org/chromium/chrome/browser/childaccounts/ChildAccountFeedbackReporter.java',
      'android/java/src/org/chromium/chrome/browser/ChromeApplication.java',
      'android/java/src/org/chromium/chrome/browser/ChromeBrowserProvider.java',
      'android/java/src/org/chromium/chrome/browser/ChromeHttpAuthHandler.java',
      'android/java/src/org/chromium/chrome/browser/ChromeWebContentsDelegateAndroid.java',
      'android/java/src/org/chromium/chrome/browser/compositor/bottombar/contextualsearch/ContextualSearchPanel.java',
      'android/java/src/org/chromium/chrome/browser/compositor/CompositorView.java',
      'android/java/src/org/chromium/chrome/browser/compositor/LayerTitleCache.java',
      'android/java/src/org/chromium/chrome/browser/compositor/layouts/content/TabContentManager.java',
      'android/java/src/org/chromium/chrome/browser/compositor/scene_layer/ContextualSearchSceneLayer.java',
      'android/java/src/org/chromium/chrome/browser/compositor/scene_layer/ReaderModeSceneLayer.java',
      'android/java/src/org/chromium/chrome/browser/compositor/scene_layer/SceneLayer.java',
      'android/java/src/org/chromium/chrome/browser/compositor/scene_layer/StaticTabSceneLayer.java',
      'android/java/src/org/chromium/chrome/browser/compositor/scene_layer/TabListSceneLayer.java',
      'android/java/src/org/chromium/chrome/browser/compositor/scene_layer/TabStripSceneLayer.java',
      'android/java/src/org/chromium/chrome/browser/ConnectionInfoPopup.java',
      'android/java/src/org/chromium/chrome/browser/contextmenu/ContextMenuHelper.java',
      'android/java/src/org/chromium/chrome/browser/contextmenu/ContextMenuParams.java',
      'android/java/src/org/chromium/chrome/browser/contextualsearch/ContextualSearchManager.java',
      'android/java/src/org/chromium/chrome/browser/contextualsearch/ContextualSearchTabHelper.java',
      'android/java/src/org/chromium/chrome/browser/cookies/CookiesFetcher.java',
      'android/java/src/org/chromium/chrome/browser/DevToolsServer.java',
      'android/java/src/org/chromium/chrome/browser/database/SQLiteCursor.java',
      'android/java/src/org/chromium/chrome/browser/document/DocumentWebContentsDelegate.java',
      'android/java/src/org/chromium/chrome/browser/dom_distiller/DomDistillerFeedbackReporter.java',
      'android/java/src/org/chromium/chrome/browser/dom_distiller/DomDistillerServiceFactory.java',
      'android/java/src/org/chromium/chrome/browser/dom_distiller/DomDistillerTabUtils.java',
      'android/java/src/org/chromium/chrome/browser/download/ChromeDownloadDelegate.java',
      'android/java/src/org/chromium/chrome/browser/favicon/FaviconHelper.java',
      'android/java/src/org/chromium/chrome/browser/favicon/LargeIconBridge.java',
      'android/java/src/org/chromium/chrome/browser/feedback/ConnectivityChecker.java',
      'android/java/src/org/chromium/chrome/browser/findinpage/FindInPageBridge.java',
      'android/java/src/org/chromium/chrome/browser/fullscreen/FullscreenInfoBarDelegate.java',
      'android/java/src/org/chromium/chrome/browser/historyreport/HistoryReportJniBridge.java',
      'android/java/src/org/chromium/chrome/browser/JavaExceptionReporter.java',
      'android/java/src/org/chromium/chrome/browser/IntentHelper.java',
      'android/java/src/org/chromium/chrome/browser/JavascriptAppModalDialog.java',
      'android/java/src/org/chromium/chrome/browser/media/remote/RecordCastAction.java',
      'android/java/src/org/chromium/chrome/browser/media/remote/RemoteMediaPlayerBridge.java',
      'android/java/src/org/chromium/chrome/browser/media/router/ChromeMediaRouter.java',
      'android/java/src/org/chromium/chrome/browser/media/router/ChromeMediaRouterDialogController.java',
      'android/java/src/org/chromium/chrome/browser/metrics/UmaSessionStats.java',
      'android/java/src/org/chromium/chrome/browser/metrics/UmaUtils.java',
      'android/java/src/org/chromium/chrome/browser/metrics/VariationsSession.java',
      'android/java/src/org/chromium/chrome/browser/net/spdyproxy/DataReductionProxySettings.java',
      'android/java/src/org/chromium/chrome/browser/ntp/ForeignSessionHelper.java',
      'android/java/src/org/chromium/chrome/browser/ntp/LogoBridge.java',
      'android/java/src/org/chromium/chrome/browser/ntp/NewTabPagePrefs.java',
      'android/java/src/org/chromium/chrome/browser/ntp/RecentlyClosedBridge.java',
      'android/java/src/org/chromium/chrome/browser/infobar/DownloadOverwriteInfoBar.java',
      'android/java/src/org/chromium/chrome/browser/infobar/TranslateInfoBar.java',
      'android/java/src/org/chromium/chrome/browser/net/qualityprovider/ExternalEstimateProviderAndroid.java',
      'android/java/src/org/chromium/chrome/browser/notifications/NotificationUIManager.java',
      'android/java/src/org/chromium/chrome/browser/offlinepages/OfflinePageBridge.java',
      'android/java/src/org/chromium/chrome/browser/omnibox/AnswersImage.java',
      'android/java/src/org/chromium/chrome/browser/omnibox/AutocompleteController.java',
      'android/java/src/org/chromium/chrome/browser/omnibox/OmniboxPrerender.java',
      'android/java/src/org/chromium/chrome/browser/omnibox/OmniboxUrlEmphasizer.java',
      'android/java/src/org/chromium/chrome/browser/omnibox/OmniboxViewUtil.java',
      'android/java/src/org/chromium/chrome/browser/PlatformUtil.java',
      'android/java/src/org/chromium/chrome/browser/partnerbookmarks/PartnerBookmarksReader.java',
      'android/java/src/org/chromium/chrome/browser/password_manager/Credential.java',
      'android/java/src/org/chromium/chrome/browser/PasswordUIView.java',
      'android/java/src/org/chromium/chrome/browser/precache/PrecacheLauncher.java',
      'android/java/src/org/chromium/chrome/browser/preferences/autofill/AutofillProfileBridge.java',
      'android/java/src/org/chromium/chrome/browser/preferences/LocationSettings.java',
      'android/java/src/org/chromium/chrome/browser/preferences/PrefServiceBridge.java',
      'android/java/src/org/chromium/chrome/browser/preferences/website/WebsitePreferenceBridge.java',
      'android/java/src/org/chromium/chrome/browser/profiles/MostVisitedSites.java',
      'android/java/src/org/chromium/chrome/browser/profiles/Profile.java',
      'android/java/src/org/chromium/chrome/browser/profiles/ProfileDownloader.java',
      'android/java/src/org/chromium/chrome/browser/prerender/ExternalPrerenderHandler.java',
      'android/java/src/org/chromium/chrome/browser/rappor/RapporServiceBridge.java',
      'android/java/src/org/chromium/chrome/browser/rlz/RevenueStats.java',
      'android/java/src/org/chromium/chrome/browser/ShortcutHelper.java',
      'android/java/src/org/chromium/chrome/browser/SSLClientCertificateRequest.java',
      'android/java/src/org/chromium/chrome/browser/search_engines/TemplateUrlService.java',
      'android/java/src/org/chromium/chrome/browser/signin/AccountManagementScreenHelper.java',
      'android/java/src/org/chromium/chrome/browser/signin/AccountTrackerService.java',
      'android/java/src/org/chromium/chrome/browser/signin/OAuth2TokenService.java',
      'android/java/src/org/chromium/chrome/browser/signin/SigninManager.java',
      'android/java/src/org/chromium/chrome/browser/snackbar/smartlockautosignin/AutoSigninSnackbarController.java',
      'android/java/src/org/chromium/chrome/browser/spellchecker/SpellCheckerSessionBridge.java',
      'android/java/src/org/chromium/chrome/browser/sync/ProfileSyncService.java',
      'android/java/src/org/chromium/chrome/browser/tab/Tab.java',
      'android/java/src/org/chromium/chrome/browser/tab/ThumbnailTabHelper.java',
      'android/java/src/org/chromium/chrome/browser/tabmodel/SingleTabModel.java',
      'android/java/src/org/chromium/chrome/browser/tabmodel/TabModelJniBridge.java',
      'android/java/src/org/chromium/chrome/browser/TabState.java',
      'android/java/src/org/chromium/chrome/browser/TtsPlatformImpl.java',
      'android/java/src/org/chromium/chrome/browser/UrlUtilities.java',
      'android/java/src/org/chromium/chrome/browser/WarmupManager.java',
      'android/java/src/org/chromium/chrome/browser/util/FeatureUtilities.java',
      'android/java/src/org/chromium/chrome/browser/WebContentsFactory.java',
      'android/java/src/org/chromium/chrome/browser/WebsiteSettingsPopup.java',
      'android/java/src/org/chromium/chrome/browser/infobar/AppBannerInfoBarAndroid.java',
      'android/java/src/org/chromium/chrome/browser/infobar/AccountChooserInfoBar.java',
      'android/java/src/org/chromium/chrome/browser/infobar/AppBannerInfoBarDelegateAndroid.java',
      'android/java/src/org/chromium/chrome/browser/infobar/ConfirmInfoBarDelegate.java',
      'android/java/src/org/chromium/chrome/browser/infobar/DataReductionProxyInfoBarDelegate.java',
      'android/java/src/org/chromium/chrome/browser/infobar/GeneratedPasswordSavedInfoBarDelegate.java',
      'android/java/src/org/chromium/chrome/browser/infobar/InfoBar.java',
      'android/java/src/org/chromium/chrome/browser/infobar/InfoBarContainer.java',
      'android/java/src/org/chromium/chrome/browser/infobar/PermissionUpdateInfoBarDelegate.java',
      'android/java/src/org/chromium/chrome/browser/infobar/SavePasswordInfoBar.java',
      'android/java/src/org/chromium/chrome/browser/invalidation/InvalidationServiceFactory.java',
      'android/java/src/org/chromium/chrome/browser/metrics/LaunchMetrics.java',
      'android/java/src/org/chromium/chrome/browser/ssl/SecurityStateModel.java',
      'android/java/src/org/chromium/chrome/browser/toolbar/ToolbarModel.java',
      'android/java/src/org/chromium/chrome/browser/webapps/AddToHomescreenDialogHelper.java',
      'android/java/src/org/chromium/chrome/browser/webapps/WebappRegistry.java',
    ],
    'chrome_browser_mdns_sources': [
      'browser/local_discovery/privet_traffic_detector.cc',
      'browser/local_discovery/privet_traffic_detector.h',
      'browser/local_discovery/service_discovery_client_mdns.cc',
      'browser/local_discovery/service_discovery_client_mdns.h',
      'browser/local_discovery/service_discovery_client_utility.cc',
      'browser/local_discovery/service_discovery_client_utility.h',
      'browser/local_discovery/service_discovery_host_client.cc',
      'browser/local_discovery/service_discovery_host_client.h',
    ],
    'chrome_browser_metrics_sources': [
      'browser/metrics/chrome_browser_main_extra_parts_metrics.cc',
      'browser/metrics/chrome_browser_main_extra_parts_metrics.h',
      'browser/metrics/chrome_browser_main_extra_parts_metrics_mac.mm',
      'browser/metrics/chrome_metrics_service_accessor.cc',
      'browser/metrics/chrome_metrics_service_accessor.h',
      'browser/metrics/chrome_metrics_service_client.cc',
      'browser/metrics/chrome_metrics_service_client.h',
      'browser/metrics/chrome_stability_metrics_provider.cc',
      'browser/metrics/chrome_stability_metrics_provider.h',
      'browser/metrics/field_trial_synchronizer.cc',
      'browser/metrics/field_trial_synchronizer.h',
      'browser/metrics/first_web_contents_profiler.cc',
      'browser/metrics/first_web_contents_profiler.h',
      'browser/metrics/google_update_metrics_provider_win.cc',
      'browser/metrics/google_update_metrics_provider_win.h',
      'browser/metrics/jumplist_metrics_win.cc',
      'browser/metrics/jumplist_metrics_win.h',
      'browser/metrics/metrics_memory_details.cc',
      'browser/metrics/metrics_memory_details.h',
      'browser/metrics/metrics_reporting_state.cc',
      'browser/metrics/metrics_reporting_state.h',
      'browser/metrics/metrics_services_manager.cc',
      'browser/metrics/metrics_services_manager.h',
      'browser/metrics/perf/perf_provider_chromeos.cc',
      'browser/metrics/perf/perf_provider_chromeos.h',
      'browser/metrics/signin_status_metrics_provider.cc',
      'browser/metrics/signin_status_metrics_provider.h',
      'browser/metrics/signin_status_metrics_provider_base.cc',
      'browser/metrics/signin_status_metrics_provider_base.h',
      'browser/metrics/signin_status_metrics_provider_chromeos.cc',
      'browser/metrics/signin_status_metrics_provider_chromeos.h',
      'browser/metrics/thread_watcher.cc',
      'browser/metrics/thread_watcher.h',
      'browser/metrics/thread_watcher_android.cc',
      'browser/metrics/thread_watcher_android.h',
      'browser/metrics/thread_watcher_report_hang.cc',
      'browser/metrics/thread_watcher_report_hang.h',
      'browser/metrics/time_ticks_experiment_win.cc',
      'browser/metrics/time_ticks_experiment_win.h',
      'browser/metrics/variations/chrome_variations_service_client.cc',
      'browser/metrics/variations/chrome_variations_service_client.h',
      'browser/metrics/variations/generated_resources_map.h',
      'browser/metrics/variations/generated_resources_map_lookup.cc',
      'browser/metrics/variations/variations_registry_syncer_win.cc',
      'browser/metrics/variations/variations_registry_syncer_win.h',
    ],
    'chrome_browser_nacl_sources': [
      'browser/nacl_host/nacl_browser_delegate_impl.cc',
      'browser/nacl_host/nacl_browser_delegate_impl.h',
      'browser/nacl_host/nacl_infobar_delegate.cc',
      'browser/nacl_host/nacl_infobar_delegate.h',
    ],
    'chrome_browser_net_sources': [
      'browser/net/async_dns_field_trial.cc',
      'browser/net/async_dns_field_trial.h',
      'browser/net/chrome_cookie_notification_details.h',
      'browser/net/chrome_extensions_network_delegate.cc',
      'browser/net/chrome_extensions_network_delegate.h',
      'browser/net/chrome_http_user_agent_settings.cc',
      'browser/net/chrome_http_user_agent_settings.h',
      'browser/net/chrome_net_log_helper.cc',
      'browser/net/chrome_net_log_helper.h',
      'browser/net/chrome_network_delegate.cc',
      'browser/net/chrome_network_delegate.h',
      'browser/net/chrome_url_request_context_getter.cc',
      'browser/net/chrome_url_request_context_getter.h',
      'browser/net/connect_interceptor.cc',
      'browser/net/connect_interceptor.h',
      'browser/net/cookie_store_util.cc',
      'browser/net/cookie_store_util.h',
      'browser/net/crl_set_fetcher.cc',
      'browser/net/crl_set_fetcher.h',
      'browser/net/dns_probe_runner.cc',
      'browser/net/dns_probe_runner.h',
      'browser/net/dns_probe_service.cc',
      'browser/net/dns_probe_service.h',
      'browser/net/file_downloader.cc',
      'browser/net/file_downloader.h',
      'browser/net/http_server_properties_manager_factory.cc',
      'browser/net/http_server_properties_manager_factory.h',
      'browser/net/net_error_diagnostics_dialog.h',
      'browser/net/net_error_diagnostics_dialog_mac.cc',
      'browser/net/net_error_diagnostics_dialog_win.cc',
      'browser/net/net_error_tab_helper.cc',
      'browser/net/net_error_tab_helper.h',
      'browser/net/net_pref_observer.cc',
      'browser/net/net_pref_observer.h',
      'browser/net/preconnect.cc',
      'browser/net/preconnect.h',
      'browser/net/prediction_options.cc',
      'browser/net/prediction_options.h',
      'browser/net/predictor.cc',
      'browser/net/predictor.h',
      'browser/net/probe_message.cc',
      'browser/net/probe_message.h',
      'browser/net/proxy_service_factory.cc',
      'browser/net/proxy_service_factory.h',
      'browser/net/quota_policy_channel_id_store.cc',
      'browser/net/quota_policy_channel_id_store.h',
      'browser/net/referrer.cc',
      'browser/net/referrer.h',
      'browser/net/request_source_bandwidth_histograms.cc',
      'browser/net/request_source_bandwidth_histograms.h',
      'browser/net/resource_prefetch_predictor_observer.cc',
      'browser/net/resource_prefetch_predictor_observer.h',
      'browser/net/safe_search_util.cc',
      'browser/net/safe_search_util.h',
      'browser/net/service_providers_win.cc',
      'browser/net/service_providers_win.h',
      'browser/net/spdyproxy/data_reduction_proxy_chrome_io_data.cc',
      'browser/net/spdyproxy/data_reduction_proxy_chrome_io_data.h',
      'browser/net/spdyproxy/data_reduction_proxy_chrome_settings.cc',
      'browser/net/spdyproxy/data_reduction_proxy_chrome_settings.h',
      'browser/net/spdyproxy/data_reduction_proxy_chrome_settings_factory.cc',
      'browser/net/spdyproxy/data_reduction_proxy_chrome_settings_factory.h',
      'browser/net/spdyproxy/data_reduction_proxy_infobar_delegate.cc',
      'browser/net/spdyproxy/data_reduction_proxy_infobar_delegate.h',
      'browser/net/spdyproxy/data_reduction_proxy_settings_android.cc',
      'browser/net/spdyproxy/data_reduction_proxy_settings_android.h',
      'browser/net/ssl_config_service_manager.h',
      'browser/net/ssl_config_service_manager_pref.cc',
      'browser/net/timed_cache.cc',
      'browser/net/timed_cache.h',
      'browser/net/url_info.cc',
      'browser/net/url_info.h',
    ],
    # Used on all platforms when notifications are enabled.
    'chrome_browser_notifications_sources': [
      'browser/notifications/desktop_notification_profile_util.cc',
      'browser/notifications/desktop_notification_profile_util.h',
      'browser/notifications/login_state_notification_blocker_chromeos.cc',
      'browser/notifications/login_state_notification_blocker_chromeos.h',
      'browser/notifications/notification.cc',
      'browser/notifications/notification.h',
      'browser/notifications/notification_delegate.h',
      'browser/notifications/notification_object_proxy.cc',
      'browser/notifications/notification_object_proxy.h',
      'browser/notifications/notification_permission_context.cc',
      'browser/notifications/notification_permission_context.h',
      'browser/notifications/notification_permission_context_factory.cc',
      'browser/notifications/notification_permission_context_factory.h',
      'browser/notifications/notification_permission_infobar_delegate.cc',
      'browser/notifications/notification_permission_infobar_delegate.h',
      'browser/notifications/notification_ui_manager.h',
      'browser/notifications/notification_ui_manager_android.cc',
      'browser/notifications/notification_ui_manager_android.h',
      'browser/notifications/notifier_state_tracker.cc',
      'browser/notifications/notifier_state_tracker.h',
      'browser/notifications/notifier_state_tracker_factory.cc',
      'browser/notifications/notifier_state_tracker_factory.h',
      'browser/notifications/persistent_notification_delegate.cc',
      'browser/notifications/persistent_notification_delegate.h',
      'browser/notifications/platform_notification_service_impl.cc',
      'browser/notifications/platform_notification_service_impl.h',
      'browser/notifications/profile_notification.cc',
      'browser/notifications/profile_notification.h',
      'browser/push_messaging/push_messaging_notification_manager.cc',
      'browser/push_messaging/push_messaging_notification_manager.h',
    ],
    # Used on non-Android platforms when notifications are enabled.
    'chrome_browser_notifications_non_android_sources': [
      'browser/notifications/extension_welcome_notification.cc',
      'browser/notifications/extension_welcome_notification.h',
      'browser/notifications/extension_welcome_notification_factory.cc',
      'browser/notifications/extension_welcome_notification_factory.h',
      'browser/notifications/fullscreen_notification_blocker.cc',
      'browser/notifications/fullscreen_notification_blocker.h',
      'browser/notifications/google_now_notification_stats_collector.cc',
      'browser/notifications/google_now_notification_stats_collector.h',
      'browser/notifications/message_center_notification_manager.cc',
      'browser/notifications/message_center_notification_manager.h',
      'browser/notifications/message_center_settings_controller.cc',
      'browser/notifications/message_center_settings_controller.h',
      'browser/notifications/message_center_stats_collector.cc',
      'browser/notifications/message_center_stats_collector.h',
      'browser/notifications/notification_conversion_helper.cc',
      'browser/notifications/notification_conversion_helper.h',
      'browser/notifications/notification_system_observer.cc',
      'browser/notifications/notification_system_observer.h',
      'browser/notifications/notification_ui_manager_desktop.cc',
      'browser/notifications/screen_lock_notification_blocker.cc',
      'browser/notifications/screen_lock_notification_blocker.h',
    ],
    'chrome_browser_nss_sources': [
      'browser/certificate_manager_model.cc',
      'browser/certificate_manager_model.h',
      'browser/net/nss_context.cc',
      'browser/net/nss_context.h',
      'browser/net/nss_context_chromeos.cc',
      'browser/net/nss_context_linux.cc',
      'third_party/mozilla_security_manager/nsNSSCertHelper.cpp',
      'third_party/mozilla_security_manager/nsNSSCertHelper.h',
      'third_party/mozilla_security_manager/nsNSSCertificate.cpp',
      'third_party/mozilla_security_manager/nsNSSCertificate.h',
      'third_party/mozilla_security_manager/nsUsageArrayHelper.cpp',
      'third_party/mozilla_security_manager/nsUsageArrayHelper.h',
    ],
    'chrome_browser_password_manager_sources': [
      'browser/password_manager/chrome_password_manager_client.cc',
      'browser/password_manager/chrome_password_manager_client.h',
      'browser/password_manager/password_store_factory.cc',
      'browser/password_manager/password_store_factory.h',
      'browser/password_manager/password_store_mac.cc',
      'browser/password_manager/password_store_mac.h',
      'browser/password_manager/password_store_mac_internal.h',
      'browser/password_manager/password_store_proxy_mac.cc',
      'browser/password_manager/password_store_proxy_mac.h',
      'browser/password_manager/password_store_win.cc',
      'browser/password_manager/password_store_win.h',
      'browser/password_manager/password_store_x.cc',
      'browser/password_manager/password_store_x.h',
      'browser/password_manager/simple_password_store_mac.cc',
      'browser/password_manager/simple_password_store_mac.h',
    ],
    # Used on Mac and Android platforms.
    'chrome_browser_password_manager_mac_android_sources': [
      'browser/password_manager/save_password_infobar_delegate.cc',
      'browser/password_manager/save_password_infobar_delegate.h',
    ],
    'chrome_browser_permissions_sources': [
      'browser/permissions/permission_bubble_request_impl.cc',
      'browser/permissions/permission_bubble_request_impl.h',
      'browser/permissions/permission_context.cc',
      'browser/permissions/permission_context.h',
      'browser/permissions/permission_context_base.cc',
      'browser/permissions/permission_context_base.h',
      'browser/permissions/permission_context_factory_base.cc',
      'browser/permissions/permission_context_factory_base.h',
      'browser/permissions/permission_context_uma_util.cc',
      'browser/permissions/permission_context_uma_util.h',
      'browser/permissions/permission_infobar_delegate.cc',
      'browser/permissions/permission_infobar_delegate.h',
      'browser/permissions/permission_manager.cc',
      'browser/permissions/permission_manager.h',
      'browser/permissions/permission_manager_factory.cc',
      'browser/permissions/permission_manager_factory.h',
      'browser/permissions/permission_queue_controller.cc',
      'browser/permissions/permission_queue_controller.h',
      'browser/permissions/permission_request_id.cc',
      'browser/permissions/permission_request_id.h',
      'browser/permissions/permission_update_infobar_delegate_android.cc',
      'browser/permissions/permission_update_infobar_delegate_android.h',
    ],
    # See also the plugin_installation_sources list below.
    'chrome_browser_plugins_sources': [
      'browser/browsing_data/browsing_data_flash_lso_helper.cc',
      'browser/browsing_data/browsing_data_flash_lso_helper.h',
      'browser/component_updater/flash_component_installer.h',
      'browser/component_updater/pepper_flash_component_installer.cc',
      'browser/metrics/plugin_metrics_provider.cc',
      'browser/metrics/plugin_metrics_provider.h',
      'browser/pepper_broker_infobar_delegate.cc',
      'browser/pepper_broker_infobar_delegate.h',
      'browser/pepper_flash_settings_manager.cc',
      'browser/pepper_flash_settings_manager.h',
      'browser/plugins/chrome_content_browser_client_plugins_part.cc',
      'browser/plugins/chrome_content_browser_client_plugins_part.h',
      'browser/plugins/chrome_plugin_service_filter.cc',
      'browser/plugins/chrome_plugin_service_filter.h',
      'browser/plugins/plugin_data_remover_helper.cc',
      'browser/plugins/plugin_data_remover_helper.h',
      'browser/plugins/plugin_finder.cc',
      'browser/plugins/plugin_finder.h',
      'browser/plugins/plugin_info_message_filter.cc',
      'browser/plugins/plugin_info_message_filter.h',
      'browser/plugins/plugin_infobar_delegates.cc',
      'browser/plugins/plugin_infobar_delegates.h',
      'browser/plugins/plugin_metadata.cc',
      'browser/plugins/plugin_metadata.h',
      'browser/plugins/plugin_observer.cc',
      'browser/plugins/plugin_observer.h',
      'browser/plugins/plugin_prefs.cc',
      'browser/plugins/plugin_prefs.h',
      'browser/plugins/plugin_prefs_factory.cc',
      'browser/plugins/plugin_prefs_factory.h',
      'browser/plugins/plugin_status_pref_setter.cc',
      'browser/plugins/plugin_status_pref_setter.h',
      'browser/renderer_host/pepper/chrome_browser_pepper_host_factory.cc',
      'browser/renderer_host/pepper/chrome_browser_pepper_host_factory.h',
      'browser/renderer_host/pepper/device_id_fetcher.cc',
      'browser/renderer_host/pepper/device_id_fetcher.h',
      'browser/renderer_host/pepper/monitor_finder_mac.h',
      'browser/renderer_host/pepper/monitor_finder_mac.mm',
      'browser/renderer_host/pepper/pepper_broker_message_filter.cc',
      'browser/renderer_host/pepper/pepper_broker_message_filter.h',
      'browser/renderer_host/pepper/pepper_flash_browser_host.cc',
      'browser/renderer_host/pepper/pepper_flash_browser_host.h',
      'browser/renderer_host/pepper/pepper_flash_clipboard_message_filter.cc',
      'browser/renderer_host/pepper/pepper_flash_clipboard_message_filter.h',
      'browser/renderer_host/pepper/pepper_flash_drm_host.cc',
      'browser/renderer_host/pepper/pepper_flash_drm_host.h',
      'browser/renderer_host/pepper/pepper_isolated_file_system_message_filter.cc',
      'browser/renderer_host/pepper/pepper_isolated_file_system_message_filter.h',
      'browser/renderer_host/pepper/pepper_output_protection_message_filter.cc',
      'browser/renderer_host/pepper/pepper_output_protection_message_filter.h',
    ],
    'chrome_browser_plugin_installation_sources': [
      'browser/plugins/plugin_installer.cc',
      'browser/plugins/plugin_installer.h',
      'browser/plugins/plugin_installer_observer.cc',
      'browser/plugins/plugin_installer_observer.h',
      'browser/plugins/plugins_resource_service.cc',
      'browser/plugins/plugins_resource_service.h',
    ],
    # Files to compile when configuration policy is disabled. Note that the
    # connector factory is also used when policy is enabled.
    'chrome_browser_policy_disabled_sources': [
      'browser/policy/profile_policy_connector.h',
      'browser/policy/profile_policy_connector_factory.cc',
      'browser/policy/profile_policy_connector_factory.h',
      'browser/policy/profile_policy_connector_stub.cc',
    ],
    # Files to use when configuration policy is enabled that are also shared
    # with iOS. Non-iOS policy files are below.
    'chrome_browser_policy_shared_with_ios_sources': [
      'browser/net/proxy_policy_handler.cc',
      'browser/net/proxy_policy_handler.h',
      'browser/policy/cloud/cloud_policy_invalidator.cc',
      'browser/policy/cloud/cloud_policy_invalidator.h',
      'browser/policy/cloud/policy_header_service_factory.cc',
      'browser/policy/cloud/policy_header_service_factory.h',
      'browser/policy/cloud/user_cloud_policy_invalidator.cc',
      'browser/policy/cloud/user_cloud_policy_invalidator.h',
      'browser/policy/cloud/user_cloud_policy_invalidator_factory.cc',
      'browser/policy/cloud/user_cloud_policy_invalidator_factory.h',
      'browser/policy/configuration_policy_handler_list_factory.cc',
      'browser/policy/configuration_policy_handler_list_factory.h',
      'browser/policy/managed_bookmarks_policy_handler.cc',
      'browser/policy/managed_bookmarks_policy_handler.h',
      'browser/policy/policy_helpers.cc',
      'browser/policy/policy_helpers.h',
      'browser/policy/profile_policy_connector.cc',
      'browser/policy/profile_policy_connector.h',
      'browser/policy/profile_policy_connector_factory.cc',
      'browser/policy/profile_policy_connector_factory.h',
      'browser/policy/schema_registry_service.cc',
      'browser/policy/schema_registry_service.h',
      'browser/policy/schema_registry_service_factory.cc',
      'browser/policy/schema_registry_service_factory.h',
      'browser/profiles/incognito_mode_policy_handler.cc',
      'browser/profiles/incognito_mode_policy_handler.h',
    ],
    # Same as the "policy shared with ios" section above, but these files are
    # not used on ChromeOS.
    'chrome_browser_policy_shared_with_ios_not_chromeos_sources': [
      'browser/policy/cloud/user_cloud_policy_manager_factory.cc',
      'browser/policy/cloud/user_cloud_policy_manager_factory.h',
      'browser/policy/cloud/user_policy_signin_service_base.cc',
      'browser/policy/cloud/user_policy_signin_service_base.h',
      'browser/policy/cloud/user_policy_signin_service_factory.cc',
      'browser/policy/cloud/user_policy_signin_service_factory.h',
    ],
    # Files to use when configuration policy is enabled that are not shared
    # with iOS.
    'chrome_browser_policy_non_ios_sources': [
      'browser/policy/chrome_browser_policy_connector.cc',
      'browser/policy/chrome_browser_policy_connector.h',
      'browser/policy/cloud/remote_commands_invalidator.cc',
      'browser/policy/cloud/remote_commands_invalidator.h',
      'browser/policy/cloud/remote_commands_invalidator_impl.cc',
      'browser/policy/cloud/remote_commands_invalidator_impl.h',
      'browser/policy/device_management_service_configuration.cc',
      'browser/policy/device_management_service_configuration.h',
      'browser/policy/file_selection_dialogs_policy_handler.cc',
      'browser/policy/file_selection_dialogs_policy_handler.h',
      'browser/policy/javascript_policy_handler.cc',
      'browser/policy/javascript_policy_handler.h',
      'browser/policy/network_prediction_policy_handler.cc',
      'browser/policy/network_prediction_policy_handler.h',
      'browser/sessions/restore_on_startup_policy_handler.cc',
      'browser/sessions/restore_on_startup_policy_handler.h',
    ],
    # Policy sources used only on Android and iOS (CrOS not counted).
    'chrome_browser_policy_mobile_sources': [
      'browser/policy/cloud/user_policy_signin_service_mobile.cc',
      'browser/policy/cloud/user_policy_signin_service_mobile.h',
    ],
    # Policy sources used only on desktop OS's (CrOS not counted).
    'chrome_browser_policy_desktop_sources': [
      'browser/policy/cloud/user_policy_signin_service.cc',
      'browser/policy/cloud/user_policy_signin_service.h',
      'browser/sync/sync_global_error.cc',
      'browser/sync/sync_global_error.h',
      'browser/sync/sync_global_error_factory.cc',
      'browser/sync/sync_global_error_factory.h',
      'browser/upgrade_detector_impl.cc',
      'browser/upgrade_detector_impl.h',
    ],
    'chrome_browser_predictor_sources': [
      'browser/predictors/autocomplete_action_predictor.cc',
      'browser/predictors/autocomplete_action_predictor.h',
      'browser/predictors/autocomplete_action_predictor_factory.cc',
      'browser/predictors/autocomplete_action_predictor_factory.h',
      'browser/predictors/autocomplete_action_predictor_table.cc',
      'browser/predictors/autocomplete_action_predictor_table.h',
      'browser/predictors/predictor_database.cc',
      'browser/predictors/predictor_database.h',
      'browser/predictors/predictor_database_factory.cc',
      'browser/predictors/predictor_database_factory.h',
      'browser/predictors/predictor_table_base.cc',
      'browser/predictors/predictor_table_base.h',
      'browser/predictors/resource_prefetch_common.cc',
      'browser/predictors/resource_prefetch_common.h',
      'browser/predictors/resource_prefetch_predictor.cc',
      'browser/predictors/resource_prefetch_predictor.h',
      'browser/predictors/resource_prefetch_predictor_factory.cc',
      'browser/predictors/resource_prefetch_predictor_factory.h',
      'browser/predictors/resource_prefetch_predictor_tab_helper.cc',
      'browser/predictors/resource_prefetch_predictor_tab_helper.h',
      'browser/predictors/resource_prefetch_predictor_tables.cc',
      'browser/predictors/resource_prefetch_predictor_tables.h',
      'browser/predictors/resource_prefetcher.cc',
      'browser/predictors/resource_prefetcher.h',
      'browser/predictors/resource_prefetcher_manager.cc',
      'browser/predictors/resource_prefetcher_manager.h',
    ],
    'chrome_browser_pref_sources': [
      'browser/prefs/browser_prefs.cc',
      'browser/prefs/browser_prefs.h',
      'browser/prefs/chrome_pref_model_associator_client.cc',
      'browser/prefs/chrome_pref_model_associator_client.h',
      'browser/prefs/chrome_pref_service_factory.cc',
      'browser/prefs/chrome_pref_service_factory.h',
      'browser/prefs/command_line_pref_store.cc',
      'browser/prefs/command_line_pref_store.h',
      'browser/prefs/incognito_mode_prefs.cc',
      'browser/prefs/incognito_mode_prefs.h',
      'browser/prefs/pref_metrics_service.cc',
      'browser/prefs/pref_metrics_service.h',
      'browser/prefs/pref_service_syncable_util.cc',
      'browser/prefs/pref_service_syncable_util.h',
      'browser/prefs/profile_pref_store_manager.cc',
      'browser/prefs/profile_pref_store_manager.h',
      'browser/prefs/session_startup_pref.cc',
      'browser/prefs/session_startup_pref.h',
    ],
    # Used both when (enable_basic_printing==1 or enable_print_preview==1).
    'chrome_browser_printing_basic_sources': [
      'browser/printing/print_job.cc',
      'browser/printing/print_job.h',
      'browser/printing/print_job_manager.cc',
      'browser/printing/print_job_manager.h',
      'browser/printing/print_job_worker.cc',
      'browser/printing/print_job_worker.h',
      'browser/printing/print_job_worker_owner.cc',
      'browser/printing/print_job_worker_owner.h',
      'browser/printing/print_view_manager_base.cc',
      'browser/printing/print_view_manager_base.h',
      'browser/printing/print_view_manager_common.cc',
      'browser/printing/print_view_manager_common.h',
      'browser/printing/printer_query.cc',
      'browser/printing/printer_query.h',
      'browser/printing/printing_message_filter.cc',
      'browser/printing/printing_message_filter.h',
    ],
    # Used only in (enable_basic_printing==1 and enable_print_preview==0) mode.
    'chrome_browser_printing_basic_only_sources': [
      'browser/printing/print_view_manager_basic.cc',
      'browser/printing/print_view_manager_basic.h',
    ],
    'chrome_browser_printing_emf_sources': [
      'browser/printing/pdf_to_emf_converter.cc',
      'browser/printing/pdf_to_emf_converter.h',
    ],
    # Used on top of the "basic" sources when enable_print_preview==1.
    'chrome_browser_printing_full_sources': [
      'browser/local_discovery/pwg_raster_converter.cc',
      'browser/local_discovery/pwg_raster_converter.h',
      'browser/printing/background_printing_manager.cc',
      'browser/printing/background_printing_manager.h',
      'browser/printing/cloud_print/cloud_print_proxy_service.cc',
      'browser/printing/cloud_print/cloud_print_proxy_service.h',
      'browser/printing/cloud_print/cloud_print_proxy_service_factory.cc',
      'browser/printing/cloud_print/cloud_print_proxy_service_factory.h',
      'browser/printing/print_dialog_cloud.cc',
      'browser/printing/print_dialog_cloud.h',
      'browser/printing/print_dialog_cloud_posix.cc',
      'browser/printing/print_dialog_cloud_win.cc',
      'browser/printing/print_error_dialog.cc',
      'browser/printing/print_error_dialog.h',
      'browser/printing/print_preview_context_menu_observer.cc',
      'browser/printing/print_preview_context_menu_observer.h',
      'browser/printing/print_preview_data_service.cc',
      'browser/printing/print_preview_data_service.h',
      'browser/printing/print_preview_dialog_controller.cc',
      'browser/printing/print_preview_dialog_controller.h',
      'browser/printing/print_preview_message_handler.cc',
      'browser/printing/print_preview_message_handler.h',
      'browser/printing/print_view_manager.cc',
      'browser/printing/print_view_manager.h',
      'browser/printing/print_view_manager_observer.h',
      'browser/printing/printer_manager_dialog.h',
      'browser/printing/printer_manager_dialog_linux.cc',
      'browser/printing/printer_manager_dialog_mac.mm',
      'browser/printing/printer_manager_dialog_win.cc',
      'browser/service_process/service_process_control.cc',
      'browser/service_process/service_process_control.h',
      'browser/service_process/service_process_control_mac.mm',
      'browser/task_manager/printing_information.cc',
      'browser/task_manager/printing_information.h',
    ],
    'chrome_browser_profiles_sources': [
      'browser/profiles/avatar_menu_actions.h',
      'browser/profiles/bookmark_model_loaded_observer.cc',
      'browser/profiles/bookmark_model_loaded_observer.h',
      'browser/profiles/chrome_browser_main_extra_parts_profiles.cc',
      'browser/profiles/chrome_browser_main_extra_parts_profiles.h',
      'browser/profiles/chrome_version_service.cc',
      'browser/profiles/chrome_version_service.h',
      'browser/profiles/file_path_verifier_win.cc',
      'browser/profiles/file_path_verifier_win.h',
      'browser/profiles/gaia_info_update_service.cc',
      'browser/profiles/gaia_info_update_service.h',
      'browser/profiles/gaia_info_update_service_factory.cc',
      'browser/profiles/gaia_info_update_service_factory.h',
      'browser/profiles/incognito_helpers.cc',
      'browser/profiles/incognito_helpers.h',
      'browser/profiles/off_the_record_profile_impl.cc',
      'browser/profiles/off_the_record_profile_impl.h',
      'browser/profiles/off_the_record_profile_io_data.cc',
      'browser/profiles/off_the_record_profile_io_data.h',
      'browser/profiles/profile.cc',
      'browser/profiles/profile.h',
      'browser/profiles/profile_android.cc',
      'browser/profiles/profile_android.h',
      'browser/profiles/profile_attributes_entry.cc',
      'browser/profiles/profile_attributes_entry.h',
      'browser/profiles/profile_attributes_storage.h',
      'browser/profiles/profile_avatar_downloader.cc',
      'browser/profiles/profile_avatar_downloader.h',
      'browser/profiles/profile_avatar_icon_util.cc',
      'browser/profiles/profile_avatar_icon_util.h',
      'browser/profiles/profile_destroyer.cc',
      'browser/profiles/profile_destroyer.h',
      'browser/profiles/profile_downloader.cc',
      'browser/profiles/profile_downloader.h',
      'browser/profiles/profile_downloader_delegate.h',
      'browser/profiles/profile_impl.cc',
      'browser/profiles/profile_impl.h',
      'browser/profiles/profile_impl_io_data.cc',
      'browser/profiles/profile_impl_io_data.h',
      'browser/profiles/profile_info_cache.cc',
      'browser/profiles/profile_info_cache.h',
      'browser/profiles/profile_info_cache_observer.h',
      'browser/profiles/profile_info_interface.h',
      'browser/profiles/profile_io_data.cc',
      'browser/profiles/profile_io_data.h',
      'browser/profiles/profile_list.h',
      'browser/profiles/profile_manager.cc',
      'browser/profiles/profile_manager.h',
      'browser/profiles/profile_metrics.cc',
      'browser/profiles/profile_metrics.h',
      'browser/profiles/profile_metrics_mac.mm',
      'browser/profiles/profile_shortcut_manager_win.cc',
      'browser/profiles/profile_shortcut_manager_win.h',
      'browser/profiles/profiles_state.cc',
      'browser/profiles/profiles_state.h',
      'browser/profiles/storage_partition_descriptor.h',
    ],
    'chrome_browser_rlz_sources': [
      'browser/rlz/chrome_rlz_tracker_delegate.cc',
      'browser/rlz/chrome_rlz_tracker_delegate.h',
    ],
    # "Safe Browsing Basic" files used for safe browsing in full mode
    # (safe_browsing=1), mobile (=2), and mobile-extended (=3).
    'chrome_browser_safe_browsing_basic_sources': [
      'browser/renderer_host/data_reduction_proxy_resource_throttle_android.cc',
      'browser/renderer_host/data_reduction_proxy_resource_throttle_android.h',
      'browser/safe_browsing/malware_details.cc',
      'browser/safe_browsing/malware_details.h',
      'browser/safe_browsing/malware_details_cache.cc',
      'browser/safe_browsing/malware_details_cache.h',
      'browser/safe_browsing/malware_details_history.cc',
      'browser/safe_browsing/malware_details_history.h',
      'browser/safe_browsing/ping_manager.cc',
      'browser/safe_browsing/ping_manager.h',
      'browser/safe_browsing/protocol_manager_helper.cc',
      'browser/safe_browsing/protocol_manager_helper.h',
      'browser/safe_browsing/safe_browsing_blocking_page.cc',
      'browser/safe_browsing/safe_browsing_blocking_page.h',
      'browser/safe_browsing/safe_browsing_service.cc',
      'browser/safe_browsing/safe_browsing_service.h',
      'browser/safe_browsing/safe_browsing_util.cc',
      'browser/safe_browsing/safe_browsing_util.h',
      'browser/safe_browsing/ui_manager.cc',
      'browser/safe_browsing/ui_manager.h',
    ],
    # "Safe Browsing Extended Mobile" files in addition to the "basic" ones
    # to use for mobile_extended mode. This has some in common with "full."
    'chrome_browser_safe_browsing_mobile_extended_sources': [
      'browser/renderer_host/safe_browsing_resource_throttle.cc',
      'browser/renderer_host/safe_browsing_resource_throttle.h',
      'browser/safe_browsing/database_manager.h',
      'browser/safe_browsing/remote_database_manager.cc',
      'browser/safe_browsing/remote_database_manager.h',
      'browser/safe_browsing/safe_browsing_api_handler.cc',
      'browser/safe_browsing/safe_browsing_api_handler.h',
      'browser/safe_browsing/safe_browsing_api_handler_util.cc',
      'browser/safe_browsing/safe_browsing_api_handler_util.h',
    ],
    # "Safe Browsing Full" files in addition to the "basic" ones to use for
    # full safe browsing. This has some in common with "mobile_extended."
    'chrome_browser_safe_browsing_full_sources': [
      'browser/download/download_completion_blocker.cc',
      'browser/download/download_completion_blocker.h',
      'browser/renderer_host/safe_browsing_resource_throttle.cc',
      'browser/renderer_host/safe_browsing_resource_throttle.h',
      'browser/safe_browsing/browser_feature_extractor.cc',
      'browser/safe_browsing/browser_feature_extractor.h',
      'browser/safe_browsing/browser_features.cc',
      'browser/safe_browsing/browser_features.h',
      'browser/safe_browsing/chunk_range.cc',
      'browser/safe_browsing/chunk_range.h',
      'browser/safe_browsing/client_side_detection_host.cc',
      'browser/safe_browsing/client_side_detection_host.h',
      'browser/safe_browsing/client_side_detection_service.cc',
      'browser/safe_browsing/client_side_detection_service.h',
      'browser/safe_browsing/client_side_model_loader.cc',
      'browser/safe_browsing/client_side_model_loader.h',
      'browser/safe_browsing/database_manager.h',
      'browser/safe_browsing/download_feedback.cc',
      'browser/safe_browsing/download_feedback.h',
      'browser/safe_browsing/download_feedback_service.cc',
      'browser/safe_browsing/download_feedback_service.h',
      'browser/safe_browsing/download_protection_service.cc',
      'browser/safe_browsing/download_protection_service.h',
      'browser/safe_browsing/incident_reporting/binary_integrity_analyzer.cc',
      'browser/safe_browsing/incident_reporting/binary_integrity_analyzer.h',
      'browser/safe_browsing/incident_reporting/binary_integrity_analyzer_win.cc',
      'browser/safe_browsing/incident_reporting/binary_integrity_incident.cc',
      'browser/safe_browsing/incident_reporting/binary_integrity_incident.h',
      'browser/safe_browsing/incident_reporting/blacklist_load_analyzer.cc',
      'browser/safe_browsing/incident_reporting/blacklist_load_analyzer.h',
      'browser/safe_browsing/incident_reporting/blacklist_load_analyzer_win.cc',
      'browser/safe_browsing/incident_reporting/blacklist_load_incident.cc',
      'browser/safe_browsing/incident_reporting/blacklist_load_incident.h',
      'browser/safe_browsing/incident_reporting/delayed_analysis_callback.h',
      'browser/safe_browsing/incident_reporting/delayed_callback_runner.cc',
      'browser/safe_browsing/incident_reporting/delayed_callback_runner.h',
      'browser/safe_browsing/incident_reporting/download_metadata_manager.cc',
      'browser/safe_browsing/incident_reporting/download_metadata_manager.h',
      'browser/safe_browsing/incident_reporting/environment_data_collection.cc',
      'browser/safe_browsing/incident_reporting/environment_data_collection.h',
      'browser/safe_browsing/incident_reporting/environment_data_collection_win.cc',
      'browser/safe_browsing/incident_reporting/environment_data_collection_win.h',
      'browser/safe_browsing/incident_reporting/incident.cc',
      'browser/safe_browsing/incident_reporting/incident.h',
      'browser/safe_browsing/incident_reporting/incident_handler_util.cc',
      'browser/safe_browsing/incident_reporting/incident_handler_util.h',
      'browser/safe_browsing/incident_reporting/incident_receiver.h',
      'browser/safe_browsing/incident_reporting/incident_report_uploader.cc',
      'browser/safe_browsing/incident_reporting/incident_report_uploader.h',
      'browser/safe_browsing/incident_reporting/incident_report_uploader_impl.cc',
      'browser/safe_browsing/incident_reporting/incident_report_uploader_impl.h',
      'browser/safe_browsing/incident_reporting/incident_reporting_service.cc',
      'browser/safe_browsing/incident_reporting/incident_reporting_service.h',
      'browser/safe_browsing/incident_reporting/last_download_finder.cc',
      'browser/safe_browsing/incident_reporting/last_download_finder.h',
      'browser/safe_browsing/incident_reporting/module_integrity_verifier_win.cc',
      'browser/safe_browsing/incident_reporting/module_integrity_verifier_win.h',
      'browser/safe_browsing/incident_reporting/off_domain_inclusion_detector.cc',
      'browser/safe_browsing/incident_reporting/off_domain_inclusion_detector.h',
      'browser/safe_browsing/incident_reporting/platform_state_store.cc',
      'browser/safe_browsing/incident_reporting/platform_state_store.h',
      'browser/safe_browsing/incident_reporting/platform_state_store_win.cc',
      'browser/safe_browsing/incident_reporting/preference_validation_delegate.cc',
      'browser/safe_browsing/incident_reporting/preference_validation_delegate.h',
      'browser/safe_browsing/incident_reporting/resource_request_detector.cc',
      'browser/safe_browsing/incident_reporting/resource_request_detector.h',
      'browser/safe_browsing/incident_reporting/resource_request_incident.cc',
      'browser/safe_browsing/incident_reporting/resource_request_incident.h',
      'browser/safe_browsing/incident_reporting/state_store.cc',
      'browser/safe_browsing/incident_reporting/state_store.h',
      'browser/safe_browsing/incident_reporting/tracked_preference_incident.cc',
      'browser/safe_browsing/incident_reporting/tracked_preference_incident.h',
      'browser/safe_browsing/incident_reporting/variations_seed_signature_analyzer.cc',
      'browser/safe_browsing/incident_reporting/variations_seed_signature_analyzer.h',
      'browser/safe_browsing/incident_reporting/variations_seed_signature_incident.cc',
      'browser/safe_browsing/incident_reporting/variations_seed_signature_incident.h',
      'browser/safe_browsing/local_database_manager.cc',
      'browser/safe_browsing/local_database_manager.h',
      'browser/safe_browsing/path_sanitizer.cc',
      'browser/safe_browsing/path_sanitizer.h',
      'browser/safe_browsing/prefix_set.cc',
      'browser/safe_browsing/prefix_set.h',
      'browser/safe_browsing/protocol_manager.cc',
      'browser/safe_browsing/protocol_manager.h',
      'browser/safe_browsing/protocol_parser.cc',
      'browser/safe_browsing/protocol_parser.h',
      'browser/safe_browsing/safe_browsing_database.cc',
      'browser/safe_browsing/safe_browsing_database.h',
      'browser/safe_browsing/safe_browsing_store.cc',
      'browser/safe_browsing/safe_browsing_store.h',
      'browser/safe_browsing/safe_browsing_store_file.cc',
      'browser/safe_browsing/safe_browsing_store_file.h',
      'browser/safe_browsing/sandboxed_dmg_analyzer_mac.cc',
      'browser/safe_browsing/sandboxed_dmg_analyzer_mac.h',
      'browser/safe_browsing/sandboxed_zip_analyzer.cc',
      'browser/safe_browsing/sandboxed_zip_analyzer.h',
      'browser/safe_browsing/two_phase_uploader.cc',
      'browser/safe_browsing/two_phase_uploader.h',
    ],
    'chrome_browser_search_engines_sources': [
      'browser/search_engines/chrome_template_url_service_client.cc',
      'browser/search_engines/chrome_template_url_service_client.h',
      'browser/search_engines/search_provider_install_data.cc',
      'browser/search_engines/search_provider_install_data.h',
      'browser/search_engines/search_provider_install_state_message_filter.cc',
      'browser/search_engines/search_provider_install_state_message_filter.h',
      'browser/search_engines/template_url_fetcher_factory.cc',
      'browser/search_engines/template_url_fetcher_factory.h',
      'browser/search_engines/template_url_service_android.cc',
      'browser/search_engines/template_url_service_android.h',
      'browser/search_engines/template_url_service_factory.cc',
      'browser/search_engines/template_url_service_factory.h',
      'browser/search_engines/ui_thread_search_terms_data.cc',
      'browser/search_engines/ui_thread_search_terms_data.h',
      'browser/search_engines/ui_thread_search_terms_data_android.cc',
      'browser/search_engines/ui_thread_search_terms_data_android.h',
    ],
    'chrome_browser_service_discovery_sources': [
      'browser/local_discovery/cloud_device_list.cc',
      'browser/local_discovery/cloud_device_list.h',
      'browser/local_discovery/cloud_device_list_delegate.cc',
      'browser/local_discovery/cloud_device_list_delegate.h',
      'browser/local_discovery/cloud_print_printer_list.cc',
      'browser/local_discovery/cloud_print_printer_list.h',
      'browser/local_discovery/device_description.cc',
      'browser/local_discovery/device_description.h',
      'browser/local_discovery/gcd_api_flow.cc',
      'browser/local_discovery/gcd_api_flow.h',
      'browser/local_discovery/gcd_api_flow_impl.cc',
      'browser/local_discovery/gcd_api_flow_impl.h',
      'browser/local_discovery/gcd_constants.cc',
      'browser/local_discovery/gcd_constants.h',
      'browser/local_discovery/gcd_registration_ticket_request.cc',
      'browser/local_discovery/gcd_registration_ticket_request.h',
      'browser/local_discovery/privet_confirm_api_flow.cc',
      'browser/local_discovery/privet_confirm_api_flow.h',
      'browser/local_discovery/privet_constants.cc',
      'browser/local_discovery/privet_constants.h',
      'browser/local_discovery/privet_device_lister.cc',
      'browser/local_discovery/privet_device_lister.h',
      'browser/local_discovery/privet_device_lister_impl.cc',
      'browser/local_discovery/privet_device_lister_impl.h',
      'browser/local_discovery/privet_device_resolver.cc',
      'browser/local_discovery/privet_device_resolver.h',
      'browser/local_discovery/privet_http.cc',
      'browser/local_discovery/privet_http.h',
      'browser/local_discovery/privet_http_asynchronous_factory.cc',
      'browser/local_discovery/privet_http_asynchronous_factory.h',
      'browser/local_discovery/privet_http_asynchronous_factory_impl.cc',
      'browser/local_discovery/privet_http_asynchronous_factory_impl.h',
      'browser/local_discovery/privet_http_impl.cc',
      'browser/local_discovery/privet_http_impl.h',
      'browser/local_discovery/privet_local_printer_lister.cc',
      'browser/local_discovery/privet_local_printer_lister.h',
      'browser/local_discovery/privet_notifications.cc',
      'browser/local_discovery/privet_notifications.h',
      'browser/local_discovery/privet_notifications_factory.cc',
      'browser/local_discovery/privet_notifications_factory.h',
      'browser/local_discovery/privet_url_fetcher.cc',
      'browser/local_discovery/privet_url_fetcher.h',
      'browser/local_discovery/privetv3_session.cc',
      'browser/local_discovery/privetv3_session.h',
      'browser/local_discovery/service_discovery_client_mac.h',
      'browser/local_discovery/service_discovery_client_mac.mm',
      'browser/local_discovery/service_discovery_client_mac_factory.h',
      'browser/local_discovery/service_discovery_client_mac_factory.mm',
      'browser/local_discovery/service_discovery_device_lister.cc',
      'browser/local_discovery/service_discovery_device_lister.h',
      'browser/local_discovery/service_discovery_shared_client.cc',
      'browser/local_discovery/service_discovery_shared_client.h',
    ],
    'chrome_browser_services_sources': [
      'browser/services/gcm/gcm_profile_service.cc',
      'browser/services/gcm/gcm_profile_service.h',
      'browser/services/gcm/gcm_profile_service_factory.cc',
      'browser/services/gcm/gcm_profile_service_factory.h',
      'browser/services/gcm/instance_id/instance_id_profile_service.cc',
      'browser/services/gcm/instance_id/instance_id_profile_service.h',
      'browser/services/gcm/instance_id/instance_id_profile_service_factory.cc',
      'browser/services/gcm/instance_id/instance_id_profile_service_factory.h',
    ],
    'chrome_browser_session_sources': [
      'browser/sessions/chrome_tab_restore_service_client.cc',
      'browser/sessions/chrome_tab_restore_service_client.h',
      'browser/sessions/session_common_utils.cc',
      'browser/sessions/session_common_utils.h',
      'browser/sessions/session_data_deleter.cc',
      'browser/sessions/session_data_deleter.h',
      'browser/sessions/session_restore_android.cc',
      'browser/sessions/session_tab_helper.cc',
      'browser/sessions/session_tab_helper.h',
      'browser/sessions/tab_restore_service_factory.cc',
      'browser/sessions/tab_restore_service_factory.h',
    ],
    'chrome_browser_session_service_sources': [
      'browser/sessions/session_restore.cc',
      'browser/sessions/session_restore.h',
      'browser/sessions/session_restore_delegate.cc',
      'browser/sessions/session_restore_delegate.h',
      'browser/sessions/session_restore_stats_collector.cc',
      'browser/sessions/session_restore_stats_collector.h',
      'browser/sessions/session_service.cc',
      'browser/sessions/session_service.h',
      'browser/sessions/session_service_factory.cc',
      'browser/sessions/session_service_factory.h',
      'browser/sessions/session_service_utils.cc',
      'browser/sessions/session_service_utils.h',
      'browser/sessions/tab_loader.cc',
      'browser/sessions/tab_loader.h',
      'browser/sessions/tab_loader_delegate.cc',
      'browser/sessions/tab_loader_delegate.h',
    ],
    'chrome_browser_signin_sources': [
      'browser/signin/about_signin_internals_factory.cc',
      'browser/signin/about_signin_internals_factory.h',
      'browser/signin/account_fetcher_service_factory.cc',
      'browser/signin/account_fetcher_service_factory.h',
      'browser/signin/account_reconcilor_factory.cc',
      'browser/signin/account_reconcilor_factory.h',
      'browser/signin/account_tracker_service_factory.cc',
      'browser/signin/account_tracker_service_factory.h',
      'browser/signin/chrome_signin_client.cc',
      'browser/signin/chrome_signin_client.h',
      'browser/signin/chrome_signin_client_factory.cc',
      'browser/signin/chrome_signin_client_factory.h',
      'browser/signin/chrome_signin_helper.cc',
      'browser/signin/chrome_signin_helper.h',
      'browser/signin/gaia_cookie_manager_service_factory.cc',
      'browser/signin/gaia_cookie_manager_service_factory.h',
      'browser/signin/local_auth.cc',
      'browser/signin/local_auth.h',
      'browser/signin/mutable_profile_oauth2_token_service_delegate.cc',
      'browser/signin/mutable_profile_oauth2_token_service_delegate.h',
      'browser/signin/profile_oauth2_token_service_factory.cc',
      'browser/signin/profile_oauth2_token_service_factory.h',
      'browser/signin/signin_error_controller_factory.cc',
      'browser/signin/signin_error_controller_factory.h',
      'browser/signin/signin_manager_factory.cc',
      'browser/signin/signin_manager_factory.h',
      'browser/signin/signin_tracker_factory.cc',
      'browser/signin/signin_tracker_factory.h',
    ],
    'chrome_browser_spellchecker_sources': [
      'browser/spellchecker/feedback.cc',
      'browser/spellchecker/feedback.h',
      'browser/spellchecker/feedback_sender.cc',
      'browser/spellchecker/feedback_sender.h',
      'browser/spellchecker/misspelling.cc',
      'browser/spellchecker/misspelling.h',
      'browser/spellchecker/spellcheck_action.cc',
      'browser/spellchecker/spellcheck_action.h',
      'browser/spellchecker/spellcheck_custom_dictionary.cc',
      'browser/spellchecker/spellcheck_custom_dictionary.h',
      'browser/spellchecker/spellcheck_dictionary.h',
      'browser/spellchecker/spellcheck_factory.cc',
      'browser/spellchecker/spellcheck_factory.h',
      'browser/spellchecker/spellcheck_host_metrics.cc',
      'browser/spellchecker/spellcheck_host_metrics.h',
      'browser/spellchecker/spellcheck_hunspell_dictionary.cc',
      'browser/spellchecker/spellcheck_hunspell_dictionary.h',
      'browser/spellchecker/spellcheck_message_filter.cc',
      'browser/spellchecker/spellcheck_message_filter.h',
      'browser/spellchecker/spellcheck_message_filter_platform.h',
      'browser/spellchecker/spellcheck_message_filter_platform_android.cc',
      'browser/spellchecker/spellcheck_message_filter_platform_mac.cc',
      'browser/spellchecker/spellcheck_platform.h',
      'browser/spellchecker/spellcheck_platform_android.cc',
      'browser/spellchecker/spellcheck_platform_mac.mm',
      'browser/spellchecker/spellcheck_service.cc',
      'browser/spellchecker/spellcheck_service.h',
      'browser/spellchecker/spellchecker_session_bridge_android.cc',
      'browser/spellchecker/spellchecker_session_bridge_android.h',
      'browser/spellchecker/spelling_service_client.cc',
      'browser/spellchecker/spelling_service_client.h',
      'browser/spellchecker/word_trimmer.cc',
      'browser/spellchecker/word_trimmer.h',
    ],
    'chrome_browser_ssl_sources': [
      'browser/ssl/bad_clock_blocking_page.cc',
      'browser/ssl/bad_clock_blocking_page.h',
      'browser/ssl/cert_report_helper.cc',
      'browser/ssl/cert_report_helper.h',
      'browser/ssl/chrome_ssl_host_state_delegate.cc',
      'browser/ssl/chrome_ssl_host_state_delegate.h',
      'browser/ssl/chrome_ssl_host_state_delegate_factory.cc',
      'browser/ssl/chrome_ssl_host_state_delegate_factory.h',
      'browser/ssl/common_name_mismatch_handler.cc',
      'browser/ssl/common_name_mismatch_handler.h',
      'browser/ssl/security_state_model_android.cc',
      'browser/ssl/security_state_model_android.h',
      'browser/ssl/security_state_model.cc',
      'browser/ssl/security_state_model.h',
      'browser/ssl/ssl_blocking_page.cc',
      'browser/ssl/ssl_blocking_page.h',
      'browser/ssl/ssl_cert_reporter.h',
      'browser/ssl/ssl_client_certificate_selector.h',
      'browser/ssl/ssl_error_classification.cc',
      'browser/ssl/ssl_error_classification.h',
      'browser/ssl/ssl_error_handler.cc',
      'browser/ssl/ssl_error_handler.h'
    ],
    'chrome_browser_supervised_user_sources': [
      'browser/content_settings/content_settings_supervised_provider.cc',
      'browser/content_settings/content_settings_supervised_provider.h',
      'browser/supervised_user/child_accounts/child_account_feedback_reporter_android.cc',
      'browser/supervised_user/child_accounts/child_account_feedback_reporter_android.h',
      'browser/supervised_user/child_accounts/child_account_service.cc',
      'browser/supervised_user/child_accounts/child_account_service.h',
      'browser/supervised_user/child_accounts/child_account_service_android.cc',
      'browser/supervised_user/child_accounts/child_account_service_android.h',
      'browser/supervised_user/child_accounts/child_account_service_factory.cc',
      'browser/supervised_user/child_accounts/child_account_service_factory.h',
      'browser/supervised_user/child_accounts/family_info_fetcher.cc',
      'browser/supervised_user/child_accounts/family_info_fetcher.h',
      'browser/supervised_user/child_accounts/permission_request_creator_apiary.cc',
      'browser/supervised_user/child_accounts/permission_request_creator_apiary.h',
      'browser/supervised_user/experimental/supervised_user_async_url_checker.cc',
      'browser/supervised_user/experimental/supervised_user_async_url_checker.h',
      'browser/supervised_user/experimental/supervised_user_blacklist.cc',
      'browser/supervised_user/experimental/supervised_user_blacklist.h',
      'browser/supervised_user/experimental/supervised_user_filtering_switches.cc',
      'browser/supervised_user/experimental/supervised_user_filtering_switches.h',
      'browser/supervised_user/permission_request_creator.h',
      'browser/supervised_user/supervised_user_bookmarks_handler.cc',
      'browser/supervised_user/supervised_user_bookmarks_handler.h',
      'browser/supervised_user/supervised_user_constants.cc',
      'browser/supervised_user/supervised_user_constants.h',
      'browser/supervised_user/supervised_user_interstitial.cc',
      'browser/supervised_user/supervised_user_interstitial.h',
      'browser/supervised_user/supervised_user_navigation_observer.cc',
      'browser/supervised_user/supervised_user_navigation_observer.h',
      'browser/supervised_user/supervised_user_pref_store.cc',
      'browser/supervised_user/supervised_user_pref_store.h',
      'browser/supervised_user/supervised_user_resource_throttle.cc',
      'browser/supervised_user/supervised_user_resource_throttle.h',
      'browser/supervised_user/supervised_user_service.cc',
      'browser/supervised_user/supervised_user_service.h',
      'browser/supervised_user/supervised_user_service_factory.cc',
      'browser/supervised_user/supervised_user_service_factory.h',
      'browser/supervised_user/supervised_user_service_observer.h',
      'browser/supervised_user/supervised_user_settings_service.cc',
      'browser/supervised_user/supervised_user_settings_service.h',
      'browser/supervised_user/supervised_user_settings_service_factory.cc',
      'browser/supervised_user/supervised_user_settings_service_factory.h',
      'browser/supervised_user/supervised_user_site_list.cc',
      'browser/supervised_user/supervised_user_site_list.h',
      'browser/supervised_user/supervised_user_sync_data_type_controller.cc',
      'browser/supervised_user/supervised_user_sync_data_type_controller.h',
      'browser/supervised_user/supervised_user_url_filter.cc',
      'browser/supervised_user/supervised_user_url_filter.h',
      'browser/supervised_user/supervised_user_whitelist_service.cc',
      'browser/supervised_user/supervised_user_whitelist_service.h',
      'browser/supervised_user/supervised_users.h',
    ],
    # TODO(bauerb): This code should be removed (on desktop) once child account
    # support has launched (https://crbug.com/505443).
    'chrome_browser_supervised_user_legacy_sources': [
      'browser/supervised_user/legacy/custodian_profile_downloader_service.cc',
      'browser/supervised_user/legacy/custodian_profile_downloader_service.h',
      'browser/supervised_user/legacy/custodian_profile_downloader_service_factory.cc',
      'browser/supervised_user/legacy/custodian_profile_downloader_service_factory.h',
      'browser/supervised_user/legacy/permission_request_creator_sync.cc',
      'browser/supervised_user/legacy/permission_request_creator_sync.h',
      'browser/supervised_user/legacy/supervised_user_pref_mapping_service.cc',
      'browser/supervised_user/legacy/supervised_user_pref_mapping_service.h',
      'browser/supervised_user/legacy/supervised_user_pref_mapping_service_factory.cc',
      'browser/supervised_user/legacy/supervised_user_pref_mapping_service_factory.h',
      'browser/supervised_user/legacy/supervised_user_refresh_token_fetcher.cc',
      'browser/supervised_user/legacy/supervised_user_refresh_token_fetcher.h',
      'browser/supervised_user/legacy/supervised_user_registration_utility.cc',
      'browser/supervised_user/legacy/supervised_user_registration_utility.h',
      'browser/supervised_user/legacy/supervised_user_registration_utility_stub.cc',
      'browser/supervised_user/legacy/supervised_user_registration_utility_stub.h',
      'browser/supervised_user/legacy/supervised_user_shared_settings_service.cc',
      'browser/supervised_user/legacy/supervised_user_shared_settings_service.h',
      'browser/supervised_user/legacy/supervised_user_shared_settings_service_factory.cc',
      'browser/supervised_user/legacy/supervised_user_shared_settings_service_factory.h',
      'browser/supervised_user/legacy/supervised_user_shared_settings_update.cc',
      'browser/supervised_user/legacy/supervised_user_shared_settings_update.h',
      'browser/supervised_user/legacy/supervised_user_sync_service.cc',
      'browser/supervised_user/legacy/supervised_user_sync_service.h',
      'browser/supervised_user/legacy/supervised_user_sync_service_factory.cc',
      'browser/supervised_user/legacy/supervised_user_sync_service_factory.h',
      'browser/supervised_user/legacy/supervised_user_sync_service_observer.h',
    ],
    'chrome_browser_supervised_user_and_themes_sources': [
      'browser/supervised_user/supervised_user_theme.cc',
      'browser/supervised_user/supervised_user_theme.h',
    ],
    'chrome_browser_sync_sources': [
      'browser/sync/chrome_sync_client.cc',
      'browser/sync/chrome_sync_client.h',
      'browser/sync/glue/autofill_data_type_controller.cc',
      'browser/sync/glue/autofill_data_type_controller.h',
      'browser/sync/glue/autofill_profile_data_type_controller.cc',
      'browser/sync/glue/autofill_profile_data_type_controller.h',
      'browser/sync/glue/autofill_wallet_data_type_controller.cc',
      'browser/sync/glue/autofill_wallet_data_type_controller.h',
      'browser/sync/glue/bookmark_change_processor.cc',
      'browser/sync/glue/bookmark_change_processor.h',
      'browser/sync/glue/bookmark_data_type_controller.cc',
      'browser/sync/glue/bookmark_data_type_controller.h',
      'browser/sync/glue/bookmark_model_associator.cc',
      'browser/sync/glue/bookmark_model_associator.h',
      'browser/sync/glue/chrome_report_unrecoverable_error.cc',
      'browser/sync/glue/chrome_report_unrecoverable_error.h',
      'browser/sync/glue/extensions_activity_monitor.cc',
      'browser/sync/glue/extensions_activity_monitor.h',
      'browser/sync/glue/history_delete_directives_data_type_controller.cc',
      'browser/sync/glue/history_delete_directives_data_type_controller.h',
      'browser/sync/glue/local_device_info_provider_impl.cc',
      'browser/sync/glue/local_device_info_provider_impl.h',
      'browser/sync/glue/non_frontend_data_type_controller.cc',
      'browser/sync/glue/non_frontend_data_type_controller.h',
      'browser/sync/glue/password_data_type_controller.cc',
      'browser/sync/glue/password_data_type_controller.h',
      'browser/sync/glue/search_engine_data_type_controller.cc',
      'browser/sync/glue/search_engine_data_type_controller.h',
      'browser/sync/glue/sync_backend_host.cc',
      'browser/sync/glue/sync_backend_host.h',
      'browser/sync/glue/sync_backend_host_core.cc',
      'browser/sync/glue/sync_backend_host_core.h',
      'browser/sync/glue/sync_backend_host_impl.cc',
      'browser/sync/glue/sync_backend_host_impl.h',
      'browser/sync/glue/sync_backend_registrar.cc',
      'browser/sync/glue/sync_backend_registrar.h',
      'browser/sync/glue/sync_start_util.cc',
      'browser/sync/glue/sync_start_util.h',
      'browser/sync/glue/synced_session_tracker.cc',
      'browser/sync/glue/synced_session_tracker.h',
      'browser/sync/glue/synced_session_util.cc',
      'browser/sync/glue/synced_session_util.h',
      'browser/sync/glue/synced_tab_delegate.cc',
      'browser/sync/glue/synced_tab_delegate_android.cc',
      'browser/sync/glue/synced_tab_delegate_android.h',
      'browser/sync/glue/synced_window_delegate_android.cc',
      'browser/sync/glue/synced_window_delegate_android.h',
      'browser/sync/glue/synced_window_delegates_getter_android.cc',
      'browser/sync/glue/synced_window_delegates_getter_android.h',
      'browser/sync/glue/typed_url_change_processor.cc',
      'browser/sync/glue/typed_url_change_processor.h',
      'browser/sync/glue/typed_url_data_type_controller.cc',
      'browser/sync/glue/typed_url_data_type_controller.h',
      'browser/sync/profile_sync_components_factory_impl.cc',
      'browser/sync/profile_sync_components_factory_impl.h',
      'browser/sync/profile_sync_service.cc',
      'browser/sync/profile_sync_service.h',
      'browser/sync/profile_sync_service_android.cc',
      'browser/sync/profile_sync_service_android.h',
      'browser/sync/profile_sync_service_factory.cc',
      'browser/sync/profile_sync_service_factory.h',
      'browser/sync/sessions/notification_service_sessions_router.cc',
      'browser/sync/sessions/notification_service_sessions_router.h',
      'browser/sync/sessions/session_data_type_controller.cc',
      'browser/sync/sessions/session_data_type_controller.h',
      'browser/sync/sessions/sessions_sync_manager.cc',
      'browser/sync/sessions/sessions_sync_manager.h',
      'browser/sync/startup_controller.cc',
      'browser/sync/startup_controller.h',
      'browser/sync/supervised_user_signin_manager_wrapper.cc',
      'browser/sync/supervised_user_signin_manager_wrapper.h',
      'browser/sync/sync_startup_tracker.cc',
      'browser/sync/sync_startup_tracker.h',
      'browser/sync/sync_type_preference_provider.h',
    ],
    'chrome_browser_task_manager_sources': [
      # Stats collection for CAPS (uses old task manager):
      'browser/caps/generate_state_json.cc',
      'browser/caps/generate_state_json.h',

      # New Task Manager Sources:
      'browser/task_management/providers/browser_process_task.cc',
      'browser/task_management/providers/browser_process_task.h',
      'browser/task_management/providers/browser_process_task_provider.cc',
      'browser/task_management/providers/browser_process_task_provider.h',
      'browser/task_management/providers/child_process_task.cc',
      'browser/task_management/providers/child_process_task.h',
      'browser/task_management/providers/child_process_task_provider.cc',
      'browser/task_management/providers/child_process_task_provider.h',
      'browser/task_management/providers/task.cc',
      'browser/task_management/providers/task.h',
      'browser/task_management/providers/task_provider.cc',
      'browser/task_management/providers/task_provider.h',
      'browser/task_management/providers/task_provider_observer.h',
      'browser/task_management/providers/web_contents/background_contents_tag.cc',
      'browser/task_management/providers/web_contents/background_contents_tag.h',
      'browser/task_management/providers/web_contents/background_contents_task.cc',
      'browser/task_management/providers/web_contents/background_contents_task.h',
      'browser/task_management/providers/web_contents/devtools_tag.cc',
      'browser/task_management/providers/web_contents/devtools_tag.h',
      'browser/task_management/providers/web_contents/devtools_task.cc',
      'browser/task_management/providers/web_contents/devtools_task.h',
      'browser/task_management/providers/web_contents/extension_tag.cc',
      'browser/task_management/providers/web_contents/extension_tag.h',
      'browser/task_management/providers/web_contents/extension_task.cc',
      'browser/task_management/providers/web_contents/extension_task.h',
      'browser/task_management/providers/web_contents/guest_tag.cc',
      'browser/task_management/providers/web_contents/guest_tag.h',
      'browser/task_management/providers/web_contents/guest_task.cc',
      'browser/task_management/providers/web_contents/guest_task.h',
      'browser/task_management/providers/web_contents/panel_tag.cc',
      'browser/task_management/providers/web_contents/panel_tag.h',
      'browser/task_management/providers/web_contents/panel_task.cc',
      'browser/task_management/providers/web_contents/panel_task.h',
      'browser/task_management/providers/web_contents/prerender_tag.cc',
      'browser/task_management/providers/web_contents/prerender_tag.h',
      'browser/task_management/providers/web_contents/prerender_task.cc',
      'browser/task_management/providers/web_contents/prerender_task.h',
      'browser/task_management/providers/web_contents/printing_tag.cc',
      'browser/task_management/providers/web_contents/printing_tag.h',
      'browser/task_management/providers/web_contents/printing_task.cc',
      'browser/task_management/providers/web_contents/printing_task.h',
      'browser/task_management/providers/web_contents/renderer_task.cc',
      'browser/task_management/providers/web_contents/renderer_task.h',
      'browser/task_management/providers/web_contents/subframe_task.cc',
      'browser/task_management/providers/web_contents/subframe_task.h',
      'browser/task_management/providers/web_contents/tab_contents_tag.cc',
      'browser/task_management/providers/web_contents/tab_contents_tag.h',
      'browser/task_management/providers/web_contents/tab_contents_task.cc',
      'browser/task_management/providers/web_contents/tab_contents_task.h',
      'browser/task_management/providers/web_contents/web_contents_tag.cc',
      'browser/task_management/providers/web_contents/web_contents_tag.h',
      'browser/task_management/providers/web_contents/web_contents_tags_manager.cc',
      'browser/task_management/providers/web_contents/web_contents_tags_manager.h',
      'browser/task_management/providers/web_contents/web_contents_task_provider.cc',
      'browser/task_management/providers/web_contents/web_contents_task_provider.h',
      'browser/task_management/sampling/task_group.cc',
      'browser/task_management/sampling/task_group.h',
      'browser/task_management/sampling/task_group_sampler.cc',
      'browser/task_management/sampling/task_group_sampler.h',
      'browser/task_management/sampling/task_manager_impl.cc',
      'browser/task_management/sampling/task_manager_impl.h',
      'browser/task_management/sampling/task_manager_io_thread_helper.cc',
      'browser/task_management/sampling/task_manager_io_thread_helper.h',
      'browser/task_management/task_management_browsertest_util.cc',
      'browser/task_management/task_management_browsertest_util.h',
      'browser/task_management/task_manager_interface.cc',
      'browser/task_management/task_manager_interface.h',
      'browser/task_management/task_manager_observer.cc',
      'browser/task_management/task_manager_observer.h',

      # Old Task Manager Sources:
      'browser/task_manager/background_information.cc',
      'browser/task_manager/background_information.h',
      'browser/task_manager/browser_process_resource_provider.cc',
      'browser/task_manager/browser_process_resource_provider.h',
      'browser/task_manager/child_process_resource_provider.cc',
      'browser/task_manager/child_process_resource_provider.h',
      'browser/task_manager/extension_information.cc',
      'browser/task_manager/extension_information.h',
      'browser/task_manager/guest_information.cc',
      'browser/task_manager/guest_information.h',
      'browser/task_manager/panel_information.cc',
      'browser/task_manager/panel_information.h',
      'browser/task_manager/renderer_resource.cc',
      'browser/task_manager/renderer_resource.h',
      'browser/task_manager/resource_provider.cc',
      'browser/task_manager/resource_provider.h',
      'browser/task_manager/tab_contents_information.cc',
      'browser/task_manager/tab_contents_information.h',
      'browser/task_manager/task_manager.cc',
      'browser/task_manager/task_manager.h',
      'browser/task_manager/task_manager_util.cc',
      'browser/task_manager/task_manager_util.h',
      'browser/task_manager/web_contents_information.cc',
      'browser/task_manager/web_contents_information.h',
      'browser/task_manager/web_contents_resource_provider.cc',
      'browser/task_manager/web_contents_resource_provider.h',
    ],
    'chrome_browser_themes_sources': [
      'browser/sync/glue/theme_data_type_controller.cc',
      'browser/sync/glue/theme_data_type_controller.h',
      'browser/themes/browser_theme_pack.cc',
      'browser/themes/browser_theme_pack.h',
      'browser/themes/custom_theme_supplier.cc',
      'browser/themes/custom_theme_supplier.h',
      'browser/themes/theme_properties.cc',
      'browser/themes/theme_properties.h',
      'browser/themes/theme_service.cc',
      'browser/themes/theme_service.h',
      'browser/themes/theme_service_factory.cc',
      'browser/themes/theme_service_factory.h',
      'browser/themes/theme_service_mac.mm',
      'browser/themes/theme_syncable_service.cc',
      'browser/themes/theme_syncable_service.h',
    ],
    'chrome_browser_undo_sources': [
      'browser/undo/bookmark_undo_service_factory.cc',
      'browser/undo/bookmark_undo_service_factory.h',
    ],
    'chrome_browser_web_resource_sources': [
      'browser/web_resource/notification_promo_helper.cc',
      'browser/web_resource/notification_promo_helper.h',
    ],
    'chrome_browser_webrtc_sources': [
      # TODO(brettw) should webrtc_log_list.cc go here?
      'browser/media/webrtc_log_uploader.cc',
      'browser/media/webrtc_log_uploader.h',
      'browser/media/webrtc_log_util.cc',
      'browser/media/webrtc_log_util.h',
      'browser/media/webrtc_logging_handler_host.cc',
      'browser/media/webrtc_logging_handler_host.h',
      'browser/media/webrtc_rtp_dump_handler.cc',
      'browser/media/webrtc_rtp_dump_handler.h',
      'browser/media/webrtc_rtp_dump_writer.cc',
      'browser/media/webrtc_rtp_dump_writer.h',
    ],
    'chrome_browser_wifi_bootstrapping_sources': [
       'browser/local_discovery/wifi/credential_getter_win.cc',
       'browser/local_discovery/wifi/credential_getter_win.h',
       'browser/local_discovery/wifi/wifi_manager.cc',
       'browser/local_discovery/wifi/wifi_manager.h',
    ],
    # Parts of wifi bootstrapping (above) used everywhere except chromeos.
    'chrome_browser_wifi_bootstrapping_win_mac_sources': [
       'browser/local_discovery/wifi/wifi_manager_nonchromeos.cc',
       'browser/local_discovery/wifi/wifi_manager_nonchromeos.h',
    ],
  },
  'targets': [
    {
      'target_name': 'browser',
      'type': 'static_library',
      'variables': { 'enable_wexit_time_destructors': 1, },
      'dependencies': [
        # NOTE: New dependencies should generally be added in the OS!="ios"
        # dependencies block below, rather than here.
        'browser_ui',
        'chrome_resources.gyp:chrome_extra_resources',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:chrome_strings',
        'chrome_resources.gyp:chrome_strings_map',
        'chrome_resources.gyp:platform_locale_settings',
        'chrome_resources.gyp:theme_resources',
        'common',
        'probe_message_proto',
        '../components/components.gyp:autofill_core_browser',
        '../components/components.gyp:bookmarks_browser',
        '../components/components.gyp:bookmarks_managed',
        '../components/components.gyp:captive_portal',
        '../components/components.gyp:cloud_devices_common',
        '../components/components.gyp:component_metrics_proto',
        '../components/components.gyp:component_updater',
        '../components/components.gyp:compression',
        '../components/components.gyp:content_settings_content_common',
        '../components/components.gyp:content_settings_core_browser',
        '../components/components.gyp:content_settings_core_common',
        '../components/components.gyp:crx_file',
        '../components/components.gyp:data_reduction_proxy_core_browser',
        '../components/components.gyp:data_use_measurement_core',
        '../components/components.gyp:domain_reliability',
        '../components/components.gyp:enhanced_bookmarks',
        '../components/components.gyp:favicon_base',
        '../components/components.gyp:favicon_core',
        '../components/components.gyp:gcm_driver',
        '../components/components.gyp:google_core_browser',
        '../components/components.gyp:handoff',
        '../components/components.gyp:history_core_browser',
        '../components/components.gyp:history_core_common',
        '../components/components.gyp:infobars_core',
        '../components/components.gyp:instance_id',
        '../components/components.gyp:invalidation_impl',
        '../components/components.gyp:metrics',
        '../components/components.gyp:metrics_net',
        '../components/components.gyp:navigation_metrics',
        '../components/components.gyp:network_time',
        '../components/components.gyp:offline_pages',
        '../components/components.gyp:omnibox_browser',
        '../components/components.gyp:os_crypt',
        '../components/components.gyp:password_manager_core_browser',
        '../components/components.gyp:password_manager_core_common',
        '../components/components.gyp:policy_component',
        '../components/components.gyp:proxy_config',
        '../components/components.gyp:query_parser',
        '../components/components.gyp:rappor',
        '../components/components.gyp:renderer_context_menu',
        '../components/components.gyp:search',
        '../components/components.gyp:search_engines',
        '../components/components.gyp:search_provider_logos',
        '../components/components.gyp:security_interstitials_core',
        '../components/components.gyp:ssl_errors',
        '../components/components.gyp:suggestions',
        '../components/components.gyp:signin_core_browser',
        '../components/components.gyp:startup_metric_utils',
        '../components/components.gyp:sync_driver',
        '../components/components.gyp:translate_core_browser',
        '../components/components.gyp:translate_core_common',
        '../components/components.gyp:update_client',
        '../components/components.gyp:undo_component',
        '../components/components.gyp:user_prefs',
        '../components/components.gyp:wallpaper',
        '../components/components_strings.gyp:components_strings',
        # This depends directly on the variations target, rather than just
        # transitively via the common target because the proto sources need to
        # be generated before code in this target can start building.
        '../components/components.gyp:variations',
        '../components/components.gyp:variations_http_provider',
        '../components/components.gyp:variations_service',
        '../components/components.gyp:webdata_common',
        '../components/components.gyp:webdata_services',
        '../components/mime_util/mime_util.gyp:mime_util',
        '../components/tracing.gyp:tracing',
        '../components/url_formatter/url_formatter.gyp:url_formatter',
        '../content/content.gyp:content_browser',
        '../content/content.gyp:content_common',
        '../courgette/courgette.gyp:courgette_lib',
        '../crypto/crypto.gyp:crypto',
        '../google_apis/google_apis.gyp:google_apis',
        '../skia/skia.gyp:skia',
        '../sql/sql.gyp:sql',
        '../sync/sync.gyp:sync',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation_proto_cpp',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/libxml/libxml.gyp:libxml',
        '../third_party/widevine/cdm/widevine_cdm.gyp:widevine_cdm_version_h',
        '../third_party/zlib/google/zip.gyp:zip',
        '../third_party/zlib/zlib.gyp:minizip',
        '../third_party/zlib/zlib.gyp:zlib',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/events/events.gyp:events_base',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_geometry',
        '../ui/message_center/message_center.gyp:message_center',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/shell_dialogs/shell_dialogs.gyp:shell_dialogs',
        '../ui/strings/ui_strings.gyp:ui_strings',
      ],
      'include_dirs': [
        '..',
        '<(INTERMEDIATE_DIR)',
        # Needed by chrome_content_renderer_client.cc. &
        # plugin_info_message_filter.cc.
        '<(SHARED_INTERMEDIATE_DIR)',
      ],
      'export_dependent_settings': [
        '../components/components.gyp:autofill_core_browser',
        '../content/content.gyp:content_browser',
        '../sql/sql.gyp:sql',
        '../sync/sync.gyp:sync',
      ],
      # sources applied to all configurations
      'sources': [
        '<@(chrome_browser_undo_sources)',
      ],
      'includes': [
        # Disable LTO due to ELF section name out of range
        # crbug.com/422251
        '../build/android/disable_gcc_lto.gypi',
      ],
      'conditions': [
        ['OS != "ios"', {
          'dependencies': [
            'apps',
            'common_mojo_bindings',
            'common_net',
            'debugger',
            'installer_util',
            '../third_party/re2/re2.gyp:re2',
            '../cc/cc.gyp:cc',
            '../components/components.gyp:about_handler',
            '../components/components.gyp:autofill_content_browser',
            '../components/components.gyp:browsing_data',
            '../components/components.gyp:certificate_reporting',
            '../components/components.gyp:data_reduction_proxy_content_browser',
            '../components/components.gyp:data_use_measurement_content',
            '../components/components.gyp:devtools_discovery',
            '../components/components.gyp:devtools_http_handler',
            '../components/components.gyp:dom_distiller_content_browser',
            '../components/components.gyp:error_page_common',
            '../components/components.gyp:favicon_content',
            '../components/components.gyp:guest_view_browser',
            '../components/components.gyp:history_content_browser',
            '../components/components.gyp:keyed_service_content',
            '../components/components.gyp:navigation_interception',
            '../components/components.gyp:network_hints_common',
            '../components/components.gyp:metrics_gpu',
            '../components/components.gyp:metrics_profiler',
            '../components/components.gyp:net_log',
            '../components/components.gyp:packed_ct_ev_whitelist',
            '../components/components.gyp:password_manager_content_browser',
            '../components/components.gyp:password_manager_sync_browser',
            '../components/components.gyp:plugins_common',
            '../components/components.gyp:power',
            '../components/components.gyp:proxy_config',
            '../components/components.gyp:safe_json',
            '../components/components.gyp:sessions_content',
            '../components/components.gyp:storage_monitor',
            '../components/components.gyp:syncable_prefs',
            '../components/components.gyp:translate_content_browser',
            '../components/components.gyp:upload_list',
            '../components/components.gyp:url_matcher',
            '../components/components.gyp:user_prefs_tracked',
            '../components/components.gyp:visitedlink_browser',
            '../components/components.gyp:visitedlink_common',
            '../components/components.gyp:web_cache_browser',
            '../components/components.gyp:web_modal',
            '../components/components.gyp:web_resource',
            '../content/app/resources/content_resources.gyp:content_resources',
            '../gpu/gpu.gyp:gpu',
            '../media/media.gyp:media',
            '../media/midi/midi.gyp:midi',
            '../media/mojo/interfaces/mojo_bindings.gyp:platform_verification_api',
            '../mojo/mojo_base.gyp:mojo_application_base',
            '../mojo/mojo_base.gyp:mojo_common_lib',
            '../mojo/mojo_base.gyp:mojo_environment_chromium',
            '../mojo/mojo_base.gyp:mojo_message_pump_lib',
            '../net/net.gyp:net_extras',
            '../net/net.gyp:net_with_v8',
            '../storage/storage_browser.gyp:storage',
            '../storage/storage_common.gyp:storage_common',
            '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
            '../third_party/libaddressinput/libaddressinput.gyp:libaddressinput',
            '../third_party/libyuv/libyuv.gyp:libyuv',
            '../third_party/mojo/mojo_edk.gyp:mojo_system_impl',
            '../third_party/mojo/mojo_public.gyp:mojo_cpp_bindings',
            '../third_party/mojo/mojo_public.gyp:mojo_js_bindings',
            '../third_party/smhasher/smhasher.gyp:cityhash',
            '../third_party/webrtc/modules/modules.gyp:desktop_capture',
            '../ui/base/ime/ui_base_ime.gyp:ui_base_ime',
            '../ui/gl/gl.gyp:gl',
            '../ui/surface/surface.gyp:surface',
            '../ui/web_dialogs/web_dialogs.gyp:web_dialogs',
            '../v8/tools/gyp/v8.gyp:v8',
          ],
          'sources': [
            '<@(chrome_browser_non_ios_sources)',
            '<@(chrome_browser_autocomplete_sources)',
            '<@(chrome_browser_bookmark_sources)',
            '<@(chrome_browser_browser_process_sources)',
            '<@(chrome_browser_content_settings_sources)',
            '<@(chrome_browser_engagement_sources)',
            '<@(chrome_browser_favicon_sources)',
            '<@(chrome_browser_google_sources)',
            '<@(chrome_browser_history_sources)',
            '<@(chrome_browser_metrics_sources)',
            '<@(chrome_browser_net_sources)',
            '<@(chrome_browser_password_manager_sources)',
            '<@(chrome_browser_permissions_sources)',
            '<@(chrome_browser_predictor_sources)',
            '<@(chrome_browser_pref_sources)',
            '<@(chrome_browser_profiles_sources)',
            '<@(chrome_browser_search_engines_sources)',
            '<@(chrome_browser_services_sources)',
            '<@(chrome_browser_session_sources)',
            '<@(chrome_browser_signin_sources)',
            '<@(chrome_browser_ssl_sources)',
            '<@(chrome_browser_sync_sources)',
            '<@(chrome_browser_web_resource_sources)',

            # These files are generated by GRIT.
            '<(SHARED_INTERMEDIATE_DIR)/ui/resources/grit/ui_resources_map.cc',
            '<(grit_out_dir)/grit/component_extension_resources_map.cc',
            '<(grit_out_dir)/grit/settings_resources_map.cc',
            '<(grit_out_dir)/grit/theme_resources_map.cc',

            # This file is generated by
            # chrome/browser/metrics/variations/generate_resources_map.py
            '<(SHARED_INTERMEDIATE_DIR)/chrome/browser/metrics/variations/generated_resources_map.cc',
          ],
          'conditions': [
            ['toolkit_views==1', {
              'dependencies': [
                '../ui/gfx/gfx.gyp:gfx_vector_icons',
                '../ui/views/views.gyp:views'
              ],
            }],
          ],
        }, {  # OS == "ios"
          'dependencies': [
            '../net/net.gyp:net',
          ],
          # A few sources had been brought up for iOS before the decision not to
          # use chrome/ for iOS long-term. Keep building them to prevent iOS
          # regressions until they have been componentized.
          'sources': [
            '<@(chrome_browser_ios_sources)',
            '<@(chrome_browser_google_sources)',
          ],
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/CoreTelephony.framework',
              '$(SDKROOT)/System/Library/Frameworks/CoreText.framework',
              '$(SDKROOT)/System/Library/Frameworks/MobileCoreServices.framework',
              '$(SDKROOT)/System/Library/Frameworks/QuartzCore.framework',
            ],
            # CoreImage is iOS 5+, but iOS 4.3 is still supported.
            'xcode_settings': {'OTHER_LDFLAGS': ['-weak_framework CoreImage']},
          },
        }],
        ['OS=="win" or OS=="mac"', {
          'sources': [
            '<@(chrome_browser_win_mac_sources)',
          ],
        }],
        ['OS!="win" and OS!="mac" and OS!="ios"', {
          'sources': [
            'browser/net/net_error_diagnostics_dialog_generic.cc',
          ],
        }],
        ['OS!="android" and OS!="ios" and chromeos==0 and configuration_policy==1', {
          'sources': [
            'browser/net/disk_cache_dir_policy_handler.cc',
            'browser/net/disk_cache_dir_policy_handler.h',
          ],
        }],
        ['OS!="android" and OS!="ios" and configuration_policy==1', {
          'sources': [
            'browser/download/download_dir_policy_handler.cc',
            'browser/download/download_dir_policy_handler.h',
          ],
        }],
        ['OS=="mac"', {
          'dependencies': [
            'app_shim',
            'browser_app_shim',
          ],
          'sources': [ '<@(chrome_browser_mac_sources)' ]
        }],
        ['OS=="mac" or OS=="android"', {
          'sources': [
            '<@(chrome_browser_password_manager_mac_android_sources)',
          ],
        }],
        ['chromeos==1', {
          'sources!': [
            'browser/metrics/signin_status_metrics_provider.cc',
            'browser/metrics/signin_status_metrics_provider.h',
          ],
        }],
        ['enable_extensions==1', {
          'dependencies': [
            'browser_extensions',
            'browser/extensions/api/api_registration.gyp:chrome_api_registration',
            'common/extensions/api/api.gyp:chrome_api',
            'sync_file_system_drive_proto',
            '../components/components.gyp:cryptauth',
            '../components/components.gyp:drive',
            '../media/cast/cast.gyp:cast_net',
          ],
          'sources': [ '<@(chrome_browser_extensions_sources)' ],
        }],
        ['enable_background==1', {
          'sources': [ '<@(chrome_browser_background_sources)' ],
          'conditions': [
            ['use_aura==0 or OS=="win"', {
              'sources!': [
                'browser/background/background_mode_manager_aura.cc',
              ],
            }],
          ],
        }],
        ['enable_task_manager==1', {
          'sources': [ '<@(chrome_browser_task_manager_sources)' ],
        }],
        ['enable_media_router==1', {
          'dependencies': [
            'browser/media/router/media_router.gyp:media_router',
          ],
        }],
        ['buildtype!="Official"', {
          'sources': [
            'browser/search/local_files_ntp_source.cc',
            'browser/search/local_files_ntp_source.h',
          ],
        }],
        ['enable_spellcheck==1', {
          'sources': [ '<@(chrome_browser_spellchecker_sources)' ],
          'conditions': [
            ['OS!="android"', {
              'dependencies': [
                '../third_party/hunspell/hunspell.gyp:hunspell',
              ],
            }],
          ],
        }],
        ['disable_nacl==0', {
          'sources': [ '<@(chrome_browser_nacl_sources)' ],
          'dependencies': [
            '../components/nacl.gyp:nacl_browser',
          ],
        }],
        ['debug_devtools==1', {
          'defines': [
            'DEBUG_DEVTOOLS=1',
          ],
        }],
        ['configuration_policy==1', {
          'sources': [ '<@(chrome_browser_policy_shared_with_ios_sources)' ],
          'dependencies': [
            '../components/components.gyp:cloud_policy_proto',
            '../components/components.gyp:policy',
          ],
          'conditions': [
            ['OS!="ios"', {
              'sources': [ '<@(chrome_browser_policy_non_ios_sources)' ],
            }],
            ['chromeos==0', {
              'sources': [
                '<@(chrome_browser_policy_shared_with_ios_not_chromeos_sources)',
              ],
            }],
            ['OS=="win" or OS=="mac" or desktop_linux==1', {
              'sources': [ '<@(chrome_browser_policy_desktop_sources)' ],
            }],
            ['OS=="android" or OS=="ios"', {  # Mobile.
              'sources': [ '<@(chrome_browser_policy_mobile_sources)' ],
            }, {  # Non-mobile.
              'dependencies': [
                'policy_path_parser',
              ],
            }],
          ],
        }, {  # configuration_policy==0
          'sources': [ '<@(chrome_browser_policy_disabled_sources)' ],
        }],
        ['enable_plugins==1', {
          'dependencies': [
            '../components/components.gyp:pdf_browser',
            '../ppapi/ppapi_internal.gyp:ppapi_ipc',
            '../third_party/adobe/flash/flash_player.gyp:flapper_version_h',
          ],
          'sources': [ '<@(chrome_browser_plugins_sources)' ],
        }],
        ['safe_browsing != 0', {
          'sources': [ '<@(chrome_browser_safe_browsing_basic_sources)' ],
          'dependencies': [
            'safe_browsing_chunk_proto',
            'safe_browsing_metadata_proto',
            'safe_browsing_report_proto',
          ],
          'conditions': [
            ['safe_browsing == 1', {
              'sources': [ '<@(chrome_browser_safe_browsing_full_sources)' ],
              'dependencies': [
                'safe_browsing_proto',
              ],
              'conditions': [
                ['OS=="win"', {
                  'dependencies': [
                    'incident_reporting_state_store_data_proto',
                  ],
                }],
              ],
            }],
            ['safe_browsing == 3', {
              'sources': [ '<@(chrome_browser_safe_browsing_mobile_extended_sources)' ],
              'dependencies': [
                'safe_browsing_proto',
              ],
            }],
          ],
        }],
        ['use_udev == 1', {
          'dependencies': [
            '../device/udev_linux/udev.gyp:udev_linux',
          ],
        }],
        ['OS=="linux"', {
          'dependencies': [
            '../device/media_transfer_protocol/media_transfer_protocol.gyp:mtp_file_entry_proto',
            '../device/media_transfer_protocol/media_transfer_protocol.gyp:mtp_storage_info_proto',
            '../device/media_transfer_protocol/media_transfer_protocol.gyp:device_media_transfer_protocol',
          ],
        }],
        ['OS=="linux" and chromeos==0', {
          'dependencies': [
            '../build/linux/system.gyp:libspeechd',
          ],
        }],
        ['chromeos==1', {
          'sources': [
            '<@(chrome_browser_chromeos_sources)',

            # This file is generated by GRIT.
            '<(SHARED_INTERMEDIATE_DIR)/ui/chromeos/resources/grit/ui_chromeos_resources_map.cc',
          ],
          'dependencies': [
            'browser_chromeos',
            '../components/components.gyp:user_manager',
            '../ui/chromeos/ui_chromeos.gyp:ui_chromeos_resources',
          ],
        }],
        ['use_cups==1', {
          'dependencies': [
            '../printing/printing.gyp:cups',
          ],
        }],
        ['use_gnome_keyring==1', {
          'sources': [ '<@(chrome_browser_gnome_keyring_sources)' ],
          'dependencies': [
            '../build/linux/system.gyp:gnome_keyring',
          ],
        }],
        ['OS=="linux" and chromeos!=1', {
          'sources': [ '<@(chrome_browser_libsecret_sources)' ],
          'defines': [
            'USE_LIBSECRET',
          ],
        }],
        ['use_aura==1', {
          'sources': [ '<@(chrome_browser_aura_sources)' ],
          'dependencies': [
            '../ui/aura/aura.gyp:aura',
            '../ui/compositor/compositor.gyp:compositor',
            '../ui/keyboard/keyboard.gyp:keyboard',
          ],
        }],
        ['ui_compositor_image_transport==1', {
          'dependencies': [
            '../ui/gl/gl.gyp:gl',
          ],
        }],
        ['use_ash==1', {
          'sources': [ '<@(chrome_browser_ash_sources)' ],
        }],
        ['use_x11==1', {
          'sources': [ '<@(chrome_browser_x11_sources)' ],
        }],
        ['os_posix == 1 and OS != "mac" and OS != "ios"', {
          'sources': [
            'app/chrome_crash_reporter_client.cc',
            'app/chrome_crash_reporter_client.h',
          ],
          'dependencies': [
            '../components/components.gyp:breakpad_host',
            '../components/components.gyp:crash_component',
          ],
        }],
        ['use_nss_certs==1', {
          'sources': [ '<@(chrome_browser_nss_sources)' ],
          'conditions': [
            ['chromeos==1', {
               'sources!': [ 'browser/net/nss_context_linux.cc' ],
              }, { # chromeos==0
               'sources!': [ 'browser/net/nss_context_chromeos.cc' ],
              }],
          ],
        }],
        ['notifications==1', {
          'sources': [ '<@(chrome_browser_notifications_sources)' ],
          'conditions': [
            ['OS!="android"', {
              'sources': [
                '<@(chrome_browser_notifications_non_android_sources)',
              ],
            }],
          ],
        }],
        ['enable_themes==1', {
          'sources': [ '<@(chrome_browser_themes_sources)' ],
        }],
        # Some form of printing support.
        ['enable_basic_printing==1 or enable_print_preview==1', {
          'dependencies': [
            '../printing/printing.gyp:printing',
          ],
          'sources': [ '<@(chrome_browser_printing_basic_sources)' ],
          'conditions': [
            ['OS=="win"', {
              'sources': [ '<@(chrome_browser_printing_emf_sources)' ],
            }],
          ],
        }],
        # Full printing on top of the above.
        ['enable_print_preview==1', {
          'sources': [ '<@(chrome_browser_printing_full_sources)' ],
        }],
        # Partial-only printing support.
        ['enable_basic_printing==1 and enable_print_preview==0', {
          'sources': [ '<@(chrome_browser_printing_basic_only_sources)' ],
        }],
        ['enable_captive_portal_detection==1', {
          'sources': [ '<@(chrome_browser_captive_portal_sources)' ]
        }],
        ['enable_session_service==1', {
          'sources': [ '<@(chrome_browser_session_service_sources)' ],
        }],
        ['enable_hotwording==1', {
          'defines': [ 'ENABLE_HOTWORDING' ],
        }],
        ['OS!="android" and OS!="ios" and chromeos==0', {
          'sources': [ '<@(chrome_browser_desktop_sources)' ],
        }],
        ['OS=="android" or OS=="ios"', {
          'sources': [ '<@(chrome_browser_mobile_sources)' ],
        }, {  # OS!="android" and OS!="ios"
          'sources': [ '<@(chrome_browser_non_mobile_sources)' ],
          'dependencies': [
            '../components/components.gyp:feedback_component',
            '../components/components.gyp:webusb',
            '../device/core/core.gyp:device_core',
            '../device/devices_app/devices_app.gyp:devices_app_public_cpp',
            '../device/devices_app/devices_app.gyp:devices_app_public_cpp_factory',
            '../device/usb/usb.gyp:device_usb',
            '../net/net.gyp:net_browser_services',
          ]
        }],
        ['OS=="android"', {
          'dependencies': [
            '../build/android/ndk.gyp:cpu_features',
            '../components/components.gyp:cdm_browser',
            '../components/components.gyp:data_reduction_proxy_content',
            '../components/components.gyp:enhanced_bookmarks',
            '../components/components.gyp:offline_pages',
            '../components/components.gyp:precache_content',
            '../components/components.gyp:precache_core',
            '../components/components.gyp:service_tab_launcher',
            '../components/components.gyp:toolbar',
            '../components/components.gyp:web_contents_delegate_android',
            '../components/components_resources.gyp:components_resources',
            '../third_party/android_opengl/etc1/etc1.gyp:etc1',
            '../third_party/libaddressinput/libaddressinput.gyp:libaddressinput_util',
            'chrome_browser_jni_headers',
            'client_discourse_context_proto',
            'delta_file_proto',
          ],
          'dependencies!': [
            '../components/components.gyp:storage_monitor',
            '../components/components.gyp:web_modal',
            '../third_party/libaddressinput/libaddressinput.gyp:libaddressinput',
          ],
          'sources': [
            '<@(chrome_browser_android_sources)',
            '<@(chrome_browser_bookmark_android_sources)',
           ],
          'defines': [ 'ENABLE_DATA_REDUCTION_PROXY_DEBUGGING' ],
          'conditions': [
            ['use_seccomp_bpf==1', {
              'defines': ['USE_SECCOMP_BPF'],
              'dependencies': [
                '../sandbox/sandbox.gyp:seccomp_bpf',
              ],
            }],
          ],
        }],
        ['OS=="mac"', {
          'dependencies': [
            '../third_party/google_toolbox_for_mac/google_toolbox_for_mac.gyp:google_toolbox_for_mac',
            '../third_party/mozilla/mozilla.gyp:mozilla',
          ],
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/Accelerate.framework',
              '$(SDKROOT)/System/Library/Frameworks/AddressBook.framework',
              '$(SDKROOT)/System/Library/Frameworks/AudioUnit.framework',
              '$(SDKROOT)/System/Library/Frameworks/DiskArbitration.framework',
              '$(SDKROOT)/System/Library/Frameworks/IOKit.framework',
              '$(SDKROOT)/System/Library/Frameworks/ImageCaptureCore.framework',
              '$(SDKROOT)/System/Library/Frameworks/OpenGL.framework',
              '$(SDKROOT)/System/Library/Frameworks/QuartzCore.framework',
              '$(SDKROOT)/System/Library/Frameworks/SecurityInterface.framework',
            ],
          },
        }],
        ['enable_rlz==1', {
          'dependencies': [
            'browser_rlz',
          ],
        }],
        # Temporary fix to break the browser target into smaller chunks so it
        # will link with goma builds.
        ['OS=="win" and chromium_win_pch==0', {
          'msvs_shard': 4,
        }],
        ['OS=="win"', {
          'sources': [ '<@(chrome_browser_win_sources)' ],
          'include_dirs': [
            '<(DEPTH)/third_party/wtl/include',
          ],
          'dependencies': [
            'chrome_process_finder',
            'chrome_watcher_client',
            'installer_util_strings',
            '../chrome/chrome.gyp:chrome_version_header',
            '../chrome_elf/chrome_elf.gyp:chrome_elf',
            '../chrome_elf/chrome_elf.gyp:chrome_elf_constants',
            '../chrome_elf/chrome_elf.gyp:dll_hash',
            '../components/components.gyp:browser_watcher',
            '../components/components.gyp:browser_watcher_client',
            '../google_update/google_update.gyp:google_update',
            '../third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
            '../third_party/isimpledom/isimpledom.gyp:isimpledom',
            '../ui/metro_viewer/metro_viewer.gyp:metro_viewer_messages',
            '../ui/views/controls/webview/webview.gyp:webview',
            '../ui/views/views.gyp:views',
            '../win8/win8.gyp:metro_viewer',
          ],
          'export_dependent_settings': [
            '../ui/views/controls/webview/webview.gyp:webview',
            '../ui/views/views.gyp:views',
          ],
          'conditions': [
            ['kasko==1', {
              'dependencies': [
                'kasko_dll',
              ],
              'export_dependent_settings': [
                'kasko_dll',
              ],
            }],
            ['win_use_allocator_shim==1', {
              'dependencies': [
                '<(allocator_target)',
              ],
            }],
            ['branding!="Chrome"', {
              'dependencies!': [
                '../google_update/google_update.gyp:google_update',
              ],
              'sources!': [
                'browser/google/did_run_updater_win.cc',
                'browser/google/did_run_updater_win.h',
                'browser/google/google_update_win.cc',
                'browser/google/google_update_win.h',
              ],
            }],
          ],
          'msvs_settings': {
            'VCLinkerTool': {
              'DelayLoadDLLs': [
                # Used by browser/net/net_error_diagnostics_dialog_win.h
                'ndfapi.dll',
              ],
              'AdditionalDependencies': [
                'ndfapi.lib',
              ],
            },
          },
          'all_dependent_settings': {
            'msvs_settings': {
              'VCLinkerTool': {
                'DelayLoadDLLs': [
                  'ndfapi.dll',
                ],
                'AdditionalDependencies': [
                  'ndfapi.lib',
                ],
              },
            },
          },
        }, {  # 'OS!="win"
          'sources': [ '<@(chrome_browser_non_win_sources)' ],
          'conditions': [
            ['use_aura==1', {
              'dependencies': [
                '../ui/views/controls/webview/webview.gyp:webview',
                '../ui/views/views.gyp:views',
              ],
              'include_dirs': [
                '<(INTERMEDIATE_DIR)',
                '<(INTERMEDIATE_DIR)/chrome',
              ],
            }],
          ],
        }],
        ['OS=="linux"', {
          'sources': [ '<@(chrome_browser_linux_sources)' ],
          'conditions': [
            ['use_aura==1', {
              'dependencies': [
                '../build/linux/system.gyp:dbus',
                '../build/linux/system.gyp:fontconfig',
                '../dbus/dbus.gyp:dbus',
              ],
            }],
            # x11 build
            ['use_x11==1', {
              'dependencies': [
                '../build/linux/system.gyp:x11',
                '../ui/events/devices/events_devices.gyp:events_devices',
                '../ui/gfx/x/gfx_x11.gyp:gfx_x11',
              ],
            }],
          ],
        }],
        ['desktop_linux==1', {
          'sources': [ '<@(chrome_browser_linux_desktop_sources)' ],
        }],
        ['enable_plugin_installation==1', {
          'sources': [ '<@(chrome_browser_plugin_installation_sources)' ],
        }],
        ['enable_app_list==1', {
          'dependencies': [
            '../ui/app_list/app_list.gyp:app_list',
          ]
        }],
        ['enable_supervised_users==1', {
          'sources': [ '<@(chrome_browser_supervised_user_sources)' ],
        }],
        ['enable_supervised_users==1 and OS!="android" and OS!="ios"', {
          'sources': [ '<@(chrome_browser_supervised_user_legacy_sources)' ],
        }],
        ['enable_supervised_users==1 and enable_themes==1', {
          'sources': [ '<@(chrome_browser_supervised_user_and_themes_sources)' ],
        }],
        ['enable_webrtc==1', {
          'sources': [ '<@(chrome_browser_webrtc_sources)' ]
        }],
        ['enable_service_discovery==1', {
          'sources': [ '<@(chrome_browser_service_discovery_sources)' ]
        }],
        ['enable_mdns==1', {
          'sources' : [ '<@(chrome_browser_mdns_sources)' ]
        }],
        ['enable_autofill_dialog!=1 or OS=="android" or OS=="ios"', {
          'sources!': [
            'browser/autofill/validation_rules_storage_factory.cc',
            'browser/autofill/validation_rules_storage_factory.h',
          ],
        }],
        [ 'enable_wifi_bootstrapping==1', {
          'sources': [ '<@(chrome_browser_wifi_bootstrapping_sources)' ],
          'conditions' : [
            [ 'OS=="win" or OS=="mac"', {
              'sources': [
                '<@(chrome_browser_wifi_bootstrapping_win_mac_sources)',
              ]
            }]
          ]
        }],
        [ 'enable_basic_printing==1 or enable_print_preview==1', {
          'dependencies': [
            '../components/components.gyp:printing_browser',
          ]
        }],
      ],
    },
    {
      # Protobuf compiler / generator for Probe Message.
      # GN version: //chrome/browser/net:probe_message_proto
      'target_name': 'probe_message_proto',
      'type': 'static_library',
      'sources': [ 'browser/net/probe_message.proto' ],
      'variables': {
        'proto_in_dir': 'browser/net',
        'proto_out_dir': 'chrome/browser/net',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for the safebrowsing chunk
      # protocol buffer.
      # GN version: //chrome/browser/safe_browsing:chunk_proto
      'target_name': 'safe_browsing_chunk_proto',
      'type': 'static_library',
      'sources': [ 'browser/safe_browsing/chunk.proto' ],
      'variables': {
        'proto_in_dir': 'browser/safe_browsing',
        'proto_out_dir': 'chrome/browser/safe_browsing',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for the safebrowsing full hash metadata
      # protocol buffer.
      # GN version: //chrome/browser/safe_browsing:metadata_proto
      'target_name': 'safe_browsing_metadata_proto',
      'type': 'static_library',
      'sources': [ 'browser/safe_browsing/metadata.proto' ],
      'variables': {
        'proto_in_dir': 'browser/safe_browsing',
        'proto_out_dir': 'chrome/browser/safe_browsing',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for the safebrowsing reporting
      # protocol buffer.
      # GN version: //chrome/browser/safe_browsing:report_proto
      'target_name': 'safe_browsing_report_proto',
      'type': 'static_library',
      'sources': [ 'browser/safe_browsing/report.proto' ],
      'variables': {
        'proto_in_dir': 'browser/safe_browsing',
        'proto_out_dir': 'chrome/browser/safe_browsing',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for the safebrowsing incident reporting
      # service state store data protocol buffer.
      # GN version: //chrome/browser/safe_browsing/incident_reporting:state_store_data_proto
      'target_name': 'incident_reporting_state_store_data_proto',
      'type': 'static_library',
      'sources': [ 'browser/safe_browsing/incident_reporting/state_store_data.proto' ],
      'variables': {
        'proto_in_dir': 'browser/safe_browsing/incident_reporting',
        'proto_out_dir': 'chrome/browser/safe_browsing/incident_reporting',
      },
      'includes': [ '../build/protoc.gypi' ],
    },
  ],
  'conditions': [
    ['OS=="android"', {
      'targets': [
        {
          # GN: //chrome/browser:jni_headers
          'target_name': 'chrome_browser_jni_headers',
          'type': 'none',
          'sources': [ '<@(chrome_browser_jni_sources)' ],
          'variables': {
            'jni_gen_package': 'chrome',
          },
          'includes': [ '../build/jni_generator.gypi' ],
        },
        {
          # GN: //chrome/android:chrome_android_java_enums_srcjar
          'target_name': 'activity_type_ids_java',
          'type': 'none',
          'variables': {
            'source_file': 'browser/android/activity_type_ids.h',
          },
          'includes': [ '../build/android/java_cpp_enum.gypi' ],
        },
        {
          # GN: //chrome/android:chrome_android_java_enums_srcjar
          'target_name': 'connectivity_check_result_java',
          'type': 'none',
          'variables': {
            'source_file': 'browser/android/feedback/connectivity_checker.cc',
          },
          'includes': [ '../build/android/java_cpp_enum.gypi' ],
        },
        {
          # GN: //chrome/android:resource_id_javagen
          'target_name': 'resource_id_java',
          'type': 'none',
          'sources': [
            'android/java/ResourceId.template',
          ],
          'variables': {
            'package_name': 'org/chromium/chrome/browser',
            'template_deps': ['browser/android/resource_id.h'],
          },
          'includes': [ '../build/android/java_cpp_template.gypi' ],
        },
        {
          # GN: //chrome/android:chrome_android_java_enums_srcjar
          'target_name': 'profile_account_management_metrics_java',
          'type': 'none',
          'variables': {
            'source_file': 'browser/profiles/profile_metrics.h',
          },
          'includes': [ '../build/android/java_cpp_enum.gypi' ],
        },
        {
          # GN: //chrome/android:chrome_android_java_enums_srcjar
          'target_name': 'connection_security_levels_java',
          'type': 'none',
          'variables': {
            'source_file': 'browser/ssl/security_state_model.h',
          },
          'includes': [ '../build/android/java_cpp_enum.gypi' ],
        },
        {
          # GN: //chrome/android:chrome_android_java_enums_srcjar
          'target_name': 'tab_load_status_java',
          'type': 'none',
          'variables': {
            'source_file': 'browser/android/tab_android.h',
          },
          'includes': [ '../build/android/java_cpp_enum.gypi' ],
        },
        {
          # GN: //chrome/android:chrome_android_java_enums_srcjar
          'target_name': 'infobar_action_type_java',
          'type': 'none',
          'variables': {
            'source_file': 'browser/ui/android/infobars/infobar_android.h',
          },
          'includes': [ '../build/android/java_cpp_enum.gypi' ],
        },
        {
          # GN: //chrome/android:chrome_android_java_enums_srcjar
          'target_name': 'shortcut_source_java',
          'type': 'none',
          'variables': {
            'source_file': 'browser/android/shortcut_info.h',
          },
          'includes': [ '../build/android/java_cpp_enum.gypi' ],
        },
        {
          #GN: //chrome/browser:client_discourse_context_proto
          'target_name': 'client_discourse_context_proto',
          'type': 'static_library',
          'sources': ['browser/android/proto/client_discourse_context.proto' ],
          'variables': {
            'proto_in_dir': 'browser/android/proto',
            'proto_out_dir': 'chrome/browser/android/proto',
          },
          'includes': [ '../build/protoc.gypi', ],
        },
        {
          #GN: //chrome/browser:delta_file_proto
          'target_name': 'delta_file_proto',
          'type': 'static_library',
          'sources': [ 'browser/android/proto/delta_file.proto' ],
          'variables': {
            'proto_in_dir': 'browser/android/proto',
            'proto_out_dir': 'chrome/browser/android/proto',
          },
          'includes': [ '../build/protoc.gypi', ],
        },
        {
          # Protobuf compiler / generator for Android's DocumentTabModel
          # protocol buffer.
          # GN: //chrome/android: document_tab_model_info_proto_java
          'target_name': 'document_tab_model_info_proto_java',
          'type': 'none',
          'variables': {
            'proto_in_dir': 'android/java/src/org/chromium/chrome/browser/tabmodel/document',
          },
          'sources': [
            '<(proto_in_dir)/document_tab_model_info.proto',
          ],
          'includes': ['../build/protoc_java.gypi'],
        },
      ],
    },],
    ['enable_extensions==1', {
      'targets': [
        {
          # Protobuf compiler / generator for Sync FileSystem protocol buffer.
          # GN version: //chrome/browser/sync_file_system/drive_backend:sync_file_system_drive_proto
          'target_name': 'sync_file_system_drive_proto',
          'type': 'static_library',
          'sources': [
            'browser/sync_file_system/drive_backend/metadata_database.proto',
          ],
          'variables': {
            'proto_in_dir': 'browser/sync_file_system/drive_backend',
            'proto_out_dir': 'chrome/browser/sync_file_system/drive_backend',
          },
          'includes': [ '../build/protoc.gypi' ]
        },
      ],
    },],
    ['enable_rlz_support==1', {
      'targets': [
        {
          # GN version: // chrome/browser:rlz
          'target_name': 'browser_rlz',
          'type': 'static_library',
          'sources': [
            '<@(chrome_browser_rlz_sources)',
          ],
          'dependencies': [
            '../components/components.gyp:google_core_browser',
            '../components/components.gyp:omnibox_browser',
            '../components/components.gyp:rlz',
            '../components/components.gyp:search_engines',
            '../rlz/rlz.gyp:rlz_lib',
          ],
        },
      ],
    }],
  ],
}
