// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_SYNC_GLUE_AUTOFILL_PROFILE_DATA_TYPE_CONTROLLER_H_
#define CHROME_BROWSER_SYNC_GLUE_AUTOFILL_PROFILE_DATA_TYPE_CONTROLLER_H_

#include "base/compiler_specific.h"
#include "base/memory/ref_counted.h"
#include "base/scoped_observer.h"
#include "components/autofill/core/browser/personal_data_manager_observer.h"
#include "components/sync_driver/non_ui_data_type_controller.h"

namespace autofill {
class PersonalDataManager;
}  // namespace autofill

namespace browser_sync {

class AutofillProfileDataTypeController
    : public sync_driver::NonUIDataTypeController,
      public autofill::PersonalDataManagerObserver {
 public:
  AutofillProfileDataTypeController(
      sync_driver::SyncClient* sync_client);

  // NonUIDataTypeController implementation.
  syncer::ModelType type() const override;
  syncer::ModelSafeGroup model_safe_group() const override;

  // PersonalDataManagerObserver implementation:
  void OnPersonalDataChanged() override;

 protected:
  ~AutofillProfileDataTypeController() override;

  // NonUIDataTypeController implementation.
  bool PostTaskOnBackendThread(const tracked_objects::Location& from_here,
                               const base::Closure& task) override;
  bool StartModels() override;
  void StopModels() override;

 private:
  // Callback to notify that WebDatabase has loaded.
  void WebDatabaseLoaded();

  sync_driver::SyncClient* const sync_client_;
  autofill::PersonalDataManager* personal_data_;
  bool callback_registered_;

  DISALLOW_COPY_AND_ASSIGN(AutofillProfileDataTypeController);
};

}  // namespace browser_sync

#endif  // CHROME_BROWSER_SYNC_GLUE_AUTOFILL_PROFILE_DATA_TYPE_CONTROLLER_H_
