# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    # This turns on e.g. the filename-based detection of which
    # platforms to include source files on (e.g. files ending in
    # _mac.h or _mac.cc are only compiled on MacOSX).
    'chromium_code': 1,

    # Note: sources list duplicated in GN build. In the GN build,
    # each component has its own unit tests target defined in its
    # directory that are then linked into the final components_unittests.
    'auto_login_parser_unittest_sources': [
      'auto_login_parser/auto_login_parser_unittest.cc',
    ],
    'autofill_unittest_sources': [
      'autofill/content/browser/content_autofill_driver_unittest.cc',
      'autofill/content/browser/request_autocomplete_manager_unittest.cc',
      'autofill/content/browser/wallet/full_wallet_unittest.cc',
      'autofill/content/browser/wallet/real_pan_wallet_client_unittest.cc',
      'autofill/content/browser/wallet/wallet_address_unittest.cc',
      'autofill/content/browser/wallet/wallet_service_url_unittest.cc',
      'autofill/content/renderer/renderer_save_password_progress_logger_unittest.cc',
      'autofill/core/browser/address_field_unittest.cc',
      'autofill/core/browser/address_i18n_unittest.cc',
      'autofill/core/browser/address_unittest.cc',
      'autofill/core/browser/autocomplete_history_manager_unittest.cc',
      'autofill/core/browser/autofill_country_unittest.cc',
      'autofill/core/browser/autofill_data_model_unittest.cc',
      'autofill/core/browser/autofill_download_manager_unittest.cc',
      'autofill/core/browser/autofill_external_delegate_unittest.cc',
      'autofill/core/browser/autofill_field_unittest.cc',
      'autofill/core/browser/autofill_ie_toolbar_import_win_unittest.cc',
      'autofill/core/browser/autofill_manager_unittest.cc',
      'autofill/core/browser/autofill_merge_unittest.cc',
      'autofill/core/browser/autofill_metrics_unittest.cc',
      'autofill/core/browser/autofill_profile_unittest.cc',
      'autofill/core/browser/autofill_type_unittest.cc',
      'autofill/core/browser/autofill_xml_parser_unittest.cc',
      'autofill/core/browser/contact_info_unittest.cc',
      'autofill/core/browser/credit_card_field_unittest.cc',
      'autofill/core/browser/credit_card_unittest.cc',
      'autofill/core/browser/form_field_unittest.cc',
      'autofill/core/browser/form_structure_unittest.cc',
      'autofill/core/browser/name_field_unittest.cc',
      'autofill/core/browser/options_util_unittest.cc',
      'autofill/core/browser/password_generator_unittest.cc',
      'autofill/core/browser/personal_data_manager_unittest.cc',
      'autofill/core/browser/phone_field_unittest.cc',
      'autofill/core/browser/phone_number_i18n_unittest.cc',
      'autofill/core/browser/phone_number_unittest.cc',
      'autofill/core/browser/ui/card_unmask_prompt_controller_impl_unittest.cc',
      'autofill/core/browser/validation_unittest.cc',
      'autofill/core/browser/webdata/autofill_profile_syncable_service_unittest.cc',
      'autofill/core/browser/webdata/autofill_table_unittest.cc',
      'autofill/core/browser/webdata/autofill_wallet_metadata_syncable_service_unittest.cc',
      'autofill/core/browser/webdata/web_data_service_unittest.cc',
      'autofill/core/common/autofill_regexes_unittest.cc',
      'autofill/core/common/autofill_util_unittest.cc',
      'autofill/core/common/form_data_unittest.cc',
      'autofill/core/common/form_field_data_unittest.cc',
      'autofill/core/common/password_form_fill_data_unittest.cc',
      'autofill/core/common/save_password_progress_logger_unittest.cc',
    ],
    'bookmarks_unittest_sources': [
      'bookmarks/browser/bookmark_codec_unittest.cc',
      'bookmarks/browser/bookmark_expanded_state_tracker_unittest.cc',
      'bookmarks/browser/bookmark_index_unittest.cc',
      'bookmarks/browser/bookmark_model_unittest.cc',
      'bookmarks/browser/bookmark_utils_unittest.cc',
      'bookmarks/managed/managed_bookmarks_tracker_unittest.cc',
    ],
    'browser_watcher_unittest_sources': [
      'browser_watcher/crash_reporting_metrics_win_unittest.cc',
      'browser_watcher/endsession_watcher_window_win_unittest.cc',
      'browser_watcher/exit_code_watcher_win_unittest.cc',
      'browser_watcher/exit_funnel_win_unittest.cc',
      'browser_watcher/watcher_client_win_unittest.cc',
      'browser_watcher/watcher_metrics_provider_win_unittest.cc',
      'browser_watcher/window_hang_monitor_win_unittest.cc',
    ],
    'bubble_unittest_sources': [
      'bubble/bubble_manager_mocks.cc',
      'bubble/bubble_manager_mocks.h',
      'bubble/bubble_manager_unittest.cc',
    ],
    'captive_portal_unittest_sources': [
      'captive_portal/captive_portal_detector_unittest.cc',
    ],
    'certificate_reporting_unittest_sources': [
      'certificate_reporting/error_report_unittest.cc',
      'certificate_reporting/error_reporter_unittest.cc',
    ],
    'certificate_transparency_unittest_sources': [
      'certificate_transparency/log_proof_fetcher_unittest.cc',
    ],
    'cloud_devices_unittest_sources': [
      'cloud_devices/common/cloud_devices_urls_unittest.cc',
      'cloud_devices/common/printer_description_unittest.cc',
    ],
    'component_updater_unittest_sources': [
      'component_updater/component_updater_service_unittest.cc',
      'component_updater/timer_unittest.cc',
    ],
    'compression_unittest_sources': [
      'compression/compression_utils_unittest.cc',
    ],
    'content_settings_unittest_sources': [
      'content_settings/core/browser/content_settings_mock_provider.cc',
      'content_settings/core/browser/content_settings_mock_provider.h',
      'content_settings/core/browser/content_settings_registry_unittest.cc',
      'content_settings/core/browser/content_settings_rule_unittest.cc',
      'content_settings/core/browser/content_settings_utils_unittest.cc',
      'content_settings/core/browser/cookie_settings_unittest.cc',
      'content_settings/core/browser/website_settings_registry_unittest.cc',
      'content_settings/core/common/content_settings_pattern_parser_unittest.cc',
      'content_settings/core/common/content_settings_pattern_unittest.cc',
    ],
    'crash_unittest_sources': [
      'crash/content/app/crash_keys_win_unittest.cc',
      'crash/core/common/objc_zombie_unittest.mm',
    ],
    'crx_file_unittest_sources': [
      'crx_file/id_util_unittest.cc',
    ],
    'data_reduction_proxy_unittest_sources': [
      'data_reduction_proxy/content/browser/data_reduction_proxy_message_filter_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_bypass_protocol_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_bypass_stats_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_compression_stats_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_config_retrieval_params_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_config_service_client_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_config_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_configurator_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_experiments_stats_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_interceptor_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_io_data_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_metrics_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_mutable_config_values_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_network_delegate_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_prefs_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_request_options_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_settings_unittest.cc',
      'data_reduction_proxy/core/browser/data_reduction_proxy_tamper_detection_unittest.cc',
      'data_reduction_proxy/core/browser/data_usage_store_unittest.cc',
      'data_reduction_proxy/core/common/data_reduction_proxy_client_config_parser_unittest.cc',
      'data_reduction_proxy/core/common/data_reduction_proxy_event_store_unittest.cc',
      'data_reduction_proxy/core/common/data_reduction_proxy_headers_unittest.cc',
      'data_reduction_proxy/core/common/data_reduction_proxy_params_unittest.cc',
    ],
    'device_event_log_unittest_sources': [
      'device_event_log/device_event_log_impl_unittest.cc',
    ],
    'devtools_http_handler_unittest_sources': [
      'devtools_http_handler/devtools_http_handler_unittest.cc',
    ],
    'dom_distiller_unittest_sources': [
      'dom_distiller/content/browser/dom_distiller_viewer_source_unittest.cc',
      'dom_distiller/content/browser/web_contents_main_frame_observer_unittest.cc',
      'dom_distiller/core/article_entry_unittest.cc',
      'dom_distiller/core/distillable_page_detector_unittest.cc',
      'dom_distiller/core/distilled_content_store_unittest.cc',
      'dom_distiller/core/distilled_page_prefs_unittests.cc',
      'dom_distiller/core/distiller_unittest.cc',
      'dom_distiller/core/distiller_url_fetcher_unittest.cc',
      'dom_distiller/core/dom_distiller_model_unittest.cc',
      'dom_distiller/core/dom_distiller_request_view_base_unittest.cc',
      'dom_distiller/core/dom_distiller_service_unittest.cc',
      'dom_distiller/core/dom_distiller_store_unittest.cc',
      'dom_distiller/core/page_features_unittest.cc',
      'dom_distiller/core/task_tracker_unittest.cc',
      'dom_distiller/core/url_utils_unittest.cc',
      'dom_distiller/core/viewer_unittest.cc',
    ],
    'domain_reliability_unittest_sources': [
      'domain_reliability/config_unittest.cc',
      'domain_reliability/context_unittest.cc',
      'domain_reliability/dispatcher_unittest.cc',
      'domain_reliability/monitor_unittest.cc',
      'domain_reliability/scheduler_unittest.cc',
      'domain_reliability/test_util.cc',
      'domain_reliability/test_util.h',
      'domain_reliability/uploader_unittest.cc',
      'domain_reliability/util_unittest.cc',
    ],
    'favicon_base_unittest_sources': [
      'favicon_base/fallback_icon_url_parser_unittest.cc',
      'favicon_base/favicon_url_parser_unittest.cc',
      'favicon_base/large_icon_url_parser_unittest.cc',
      'favicon_base/select_favicon_frames_unittest.cc',
    ],
    'favicon_unittest_sources': [
      'favicon/content/content_favicon_driver_unittest.cc',
      'favicon/core/favicon_handler_unittest.cc',
      'favicon/core/large_icon_service_unittest.cc',
    ],
    'undo_unittest_sources': [
      'undo/bookmark_undo_service_test.cc',
      'undo/undo_manager_test.cc',
    ],

    'audio_modem_unittest_sources': [
      'audio_modem/audio_player_unittest.cc',
      'audio_modem/audio_recorder_unittest.cc',
      'audio_modem/modem_unittest.cc',
    ],
    'copresence_unittest_sources': [
      'copresence/copresence_state_unittest.cc',
      'copresence/handlers/audio/audio_directive_handler_unittest.cc',
      'copresence/handlers/audio/audio_directive_list_unittest.cc',
      'copresence/handlers/directive_handler_unittest.cc',
      'copresence/handlers/gcm_handler_unittest.cc',
      'copresence/rpc/http_post_unittest.cc',
      'copresence/rpc/rpc_handler_unittest.cc',
      'copresence/timed_map_unittest.cc',
    ],
    'cronet_unittest_sources': [
      'cronet/histogram_manager_unittest.cc',
    ],
    'data_use_measurement_unittest_sources': [
      'data_use_measurement/content/data_use_measurement_unittest.cc',
    ],
    'enhanced_bookmarks_unittest_sources': [
      'enhanced_bookmarks/enhanced_bookmark_model_unittest.cc',
      'enhanced_bookmarks/image_store_ios_unittest.mm',
      'enhanced_bookmarks/image_store_unittest.cc',
      'enhanced_bookmarks/item_position_unittest.cc',
    ],
    'error_page_unittest_sources': [
      'error_page/renderer/net_error_helper_core_unittest.cc',
    ],
    'feedback_unittest_sources': [
      'feedback/feedback_common_unittest.cc',
      'feedback/feedback_data_unittest.cc',
      'feedback/feedback_uploader_chrome_unittest.cc',
      'feedback/feedback_uploader_unittest.cc',
    ],
    'gcm_driver_unittest_sources': [
      'gcm_driver/gcm_account_mapper_unittest.cc',
      'gcm_driver/gcm_account_tracker_unittest.cc',
      'gcm_driver/gcm_channel_status_request_unittest.cc',
      'gcm_driver/gcm_client_impl_unittest.cc',
      'gcm_driver/gcm_delayed_task_controller_unittest.cc',
      'gcm_driver/gcm_driver_desktop_unittest.cc',
      'gcm_driver/gcm_stats_recorder_impl_unittest.cc',
    ],
    'gcm_driver_crypto_unittest_sources': [
      'gcm_driver/crypto/encryption_header_parsers_unittest.cc',
      'gcm_driver/crypto/gcm_key_store_unittest.cc',
      'gcm_driver/crypto/gcm_message_cryptographer_unittest.cc',
    ],
    'google_unittest_sources': [
      'google/core/browser/google_url_tracker_unittest.cc',
      'google/core/browser/google_util_unittest.cc',
    ],
    'guest_view_unittest_sources': [
      'guest_view/browser/guest_view_manager_unittest.cc'
    ],
    'history_unittest_sources': [
      'history/content/browser/content_history_backend_db_unittest.cc',
      'history/core/browser/android/android_history_types_unittest.cc',
      'history/core/browser/expire_history_backend_unittest.cc',
      'history/core/browser/history_backend_db_unittest.cc',
      'history/core/browser/history_backend_unittest.cc',
      'history/core/browser/history_database_unittest.cc',
      'history/core/browser/history_querying_unittest.cc',
      'history/core/browser/history_service_unittest.cc',
      'history/core/browser/history_types_unittest.cc',
      'history/core/browser/thumbnail_database_unittest.cc',
      'history/core/browser/top_sites_cache_unittest.cc',
      'history/core/browser/top_sites_database_unittest.cc',
      'history/core/browser/top_sites_impl_unittest.cc',
      'history/core/browser/typed_url_syncable_service_unittest.cc',
      'history/core/browser/url_database_unittest.cc',
      'history/core/browser/url_utils_unittest.cc',
      'history/core/browser/visit_database_unittest.cc',
      'history/core/browser/visit_filter_unittest.cc',
      'history/core/browser/visit_tracker_unittest.cc',
      'history/core/common/thumbnail_score_unittest.cc',
    ],
    'instance_id_unittest_sources': [
      'gcm_driver/instance_id/instance_id_driver_unittest.cc',
    ],
    'invalidation_unittest_sources': [
      'invalidation/impl/fake_invalidator_unittest.cc',
      'invalidation/impl/gcm_network_channel_unittest.cc',
      'invalidation/impl/invalidation_logger_unittest.cc',
      'invalidation/impl/invalidation_notifier_unittest.cc',
      'invalidation/impl/invalidator_registrar_unittest.cc',
      'invalidation/impl/non_blocking_invalidator_unittest.cc',
      'invalidation/impl/object_id_invalidation_map_unittest.cc',
      'invalidation/impl/p2p_invalidator_unittest.cc',
      'invalidation/impl/push_client_channel_unittest.cc',
      'invalidation/impl/registration_manager_unittest.cc',
      'invalidation/impl/single_object_invalidation_set_unittest.cc',
      'invalidation/impl/sync_invalidation_listener_unittest.cc',
      'invalidation/impl/sync_system_resources_unittest.cc',
      'invalidation/impl/ticl_invalidation_service_unittest.cc',
      'invalidation/impl/unacked_invalidation_set_unittest.cc',
    ],
    'json_schema_unittest_sources': [
      'json_schema/json_schema_validator_unittest.cc',
      'json_schema/json_schema_validator_unittest_base.cc',
      'json_schema/json_schema_validator_unittest_base.h',
    ],
    'keyed_service_unittest_sources': [
      'keyed_service/content/browser_context_dependency_manager_unittest.cc',
      'keyed_service/core/dependency_graph_unittest.cc',
    ],
    'language_usage_metrics_unittest_sources': [
      'language_usage_metrics/language_usage_metrics_unittest.cc',
    ],
    'leveldb_proto_unittest_sources': [
      'leveldb_proto/proto_database_impl_unittest.cc',
    ],
    'login_unittest_sources': [
      'login/screens/screen_context_unittest.cc',
    ],
    'memory_pressure_unittest_sources': [
      'memory_pressure/direct_memory_pressure_calculator_win_unittest.cc',
      'memory_pressure/filtered_memory_pressure_calculator_unittest.cc',
      'memory_pressure/memory_pressure_stats_collector_unittest.cc',
      'memory_pressure/test_memory_pressure_calculator.cc',
      'memory_pressure/test_memory_pressure_calculator.h',
    ],
    'metrics_unittest_sources': [
      'metrics/call_stack_profile_metrics_provider_unittest.cc',
      'metrics/daily_event_unittest.cc',
      'metrics/drive_metrics_provider_unittest.cc',
      'metrics/gpu/gpu_metrics_provider_unittest.cc',
      'metrics/histogram_encoder_unittest.cc',
      'metrics/machine_id_provider_win_unittest.cc',
      'metrics/metrics_hashes_unittest.cc',
      'metrics/metrics_log_manager_unittest.cc',
      'metrics/metrics_log_unittest.cc',
      'metrics/metrics_reporting_scheduler_unittest.cc',
      'metrics/metrics_service_unittest.cc',
      'metrics/metrics_state_manager_unittest.cc',
      'metrics/net/net_metrics_log_uploader_unittest.cc',
      'metrics/persisted_logs_unittest.cc',
      'metrics/profiler/profiler_metrics_provider_unittest.cc',
      'metrics/profiler/tracking_synchronizer_unittest.cc',
      'metrics/stability_metrics_helper_unittest.cc',
    ],
    'mime_util_unittest_sources': [
      'mime_util/mime_util_unittest.cc',
    ],
    'nacl_unittest_sources': [
      'nacl/browser/nacl_file_host_unittest.cc',
      'nacl/browser/nacl_process_host_unittest.cc',
      'nacl/browser/nacl_validation_cache_unittest.cc',
      'nacl/browser/pnacl_host_unittest.cc',
      'nacl/browser/pnacl_translation_cache_unittest.cc',
      'nacl/browser/test_nacl_browser_delegate.cc',
      'nacl/zygote/nacl_fork_delegate_linux_unittest.cc',
    ],
    'navigation_interception_unittest_sources': [
      'navigation_interception/intercept_navigation_throttle_unittest.cc',
    ],
    'network_hints_unittest_sources': [
      'network_hints/renderer/dns_prefetch_queue_unittest.cc',
      'network_hints/renderer/renderer_dns_prefetch_unittest.cc',
    ],
    'network_time_unittest_sources': [
      'network_time/network_time_tracker_unittest.cc',
    ],
    'offline_page_unittest_sources': [
      'offline_pages/offline_page_metadata_store_impl_unittest.cc',
      'offline_pages/offline_page_model_unittest.cc',
    ],
    'omnibox_unittest_sources': [
      'omnibox/browser/answers_cache_unittest.cc',
      'omnibox/browser/autocomplete_input_unittest.cc',
      'omnibox/browser/autocomplete_match_unittest.cc',
      'omnibox/browser/autocomplete_result_unittest.cc',
      'omnibox/browser/base_search_provider_unittest.cc',
      'omnibox/browser/clipboard_url_provider_unittest.cc',
      'omnibox/browser/in_memory_url_index_types_unittest.cc',
      'omnibox/browser/keyword_provider_unittest.cc',
      'omnibox/browser/omnibox_field_trial_unittest.cc',
      'omnibox/browser/omnibox_popup_model_unittest.cc',
      'omnibox/browser/omnibox_view_unittest.cc',
      'omnibox/browser/scored_history_match_unittest.cc',
      'omnibox/browser/suggestion_answer_unittest.cc',
    ],
    'open_from_clipboard_unittest_sources': [
      'open_from_clipboard/clipboard_recent_content_ios_unittest.mm',
    ],
    'os_crypt_unittest_sources': [
      'os_crypt/ie7_password_win_unittest.cc',
      'os_crypt/keychain_password_mac_unittest.mm',
      'os_crypt/os_crypt_unittest.cc',
    ],
    'ownership_unittest_sources': [
      'ownership/owner_key_util_impl_unittest.cc',
    ],
    'packed_ct_ev_whitelist_unittest_sources': [
      'packed_ct_ev_whitelist/bit_stream_reader_unittest.cc',
      'packed_ct_ev_whitelist/packed_ct_ev_whitelist_unittest.cc',
    ],
    'page_load_metrics_unittest_sources': [
      'page_load_metrics/browser/metrics_web_contents_observer_unittest.cc',
      'page_load_metrics/renderer/metrics_render_frame_observer_unittest.cc',
      'page_load_metrics/renderer/page_timing_metrics_sender_unittest.cc',
    ],
    'password_manager_unittest_sources': [
      'password_manager/content/browser/credential_manager_dispatcher_unittest.cc',
      'password_manager/core/browser/affiliated_match_helper_unittest.cc',
      'password_manager/core/browser/affiliation_backend_unittest.cc',
      'password_manager/core/browser/affiliation_database_unittest.cc',
      'password_manager/core/browser/affiliation_fetch_throttler_unittest.cc',
      'password_manager/core/browser/affiliation_fetcher_unittest.cc',
      'password_manager/core/browser/affiliation_service_unittest.cc',
      'password_manager/core/browser/affiliation_utils_unittest.cc',
      'password_manager/core/browser/browser_save_password_progress_logger_unittest.cc',
      'password_manager/core/browser/export/csv_writer_unittest.cc',
      'password_manager/core/browser/facet_manager_unittest.cc',
      'password_manager/core/browser/import/csv_reader_unittest.cc',
      'password_manager/core/browser/log_router_unittest.cc',
      'password_manager/core/browser/login_database_unittest.cc',
      'password_manager/core/browser/login_model_unittest.cc',
      'password_manager/core/browser/mock_affiliated_match_helper.cc',
      'password_manager/core/browser/mock_affiliated_match_helper.h',
      'password_manager/core/browser/password_autofill_manager_unittest.cc',
      'password_manager/core/browser/password_bubble_experiment_unittest.cc',
      'password_manager/core/browser/password_form_manager_unittest.cc',
      'password_manager/core/browser/password_generation_manager_unittest.cc',
      'password_manager/core/browser/password_manager_metrics_util_unittest.cc',
      'password_manager/core/browser/password_manager_settings_migration_experiment_unittest.cc',
      'password_manager/core/browser/password_manager_unittest.cc',
      'password_manager/core/browser/password_manager_util_unittest.cc',
      'password_manager/core/browser/password_store_default_unittest.cc',
      'password_manager/core/browser/password_store_unittest.cc',
      'password_manager/core/browser/password_syncable_service_unittest.cc',
      'password_manager/core/browser/psl_matching_helper_unittest.cc',
      'password_manager/core/browser/statistics_table_unittest.cc',
      'password_manager/core/common/credential_manager_types_unittest.cc',
      'password_manager/sync/browser/password_sync_util_unittest.cc',
      'password_manager/sync/browser/sync_store_result_filter_unittest.cc',
      'password_manager/sync/browser/sync_username_test_base.cc',
      'password_manager/sync/browser/sync_username_test_base.h',
    ],
    'policy_unittest_sources': [
      'policy/core/browser/android/android_combined_policy_provider_unittest.cc',
      'policy/core/browser/android/policy_converter_unittest.cc',
      'policy/core/browser/autofill_policy_handler_unittest.cc',
      'policy/core/browser/browser_policy_connector_unittest.cc',
      'policy/core/browser/configuration_policy_handler_unittest.cc',
      'policy/core/browser/configuration_policy_pref_store_unittest.cc',
      'policy/core/browser/url_blacklist_manager_unittest.cc',
      'policy/core/browser/url_blacklist_policy_handler_unittest.cc',
      'policy/core/common/async_policy_provider_unittest.cc',
      'policy/core/common/cloud/cloud_policy_client_unittest.cc',
      'policy/core/common/cloud/cloud_policy_constants_unittest.cc',
      'policy/core/common/cloud/cloud_policy_core_unittest.cc',
      'policy/core/common/cloud/cloud_policy_manager_unittest.cc',
      'policy/core/common/cloud/cloud_policy_refresh_scheduler_unittest.cc',
      'policy/core/common/cloud/cloud_policy_service_unittest.cc',
      'policy/core/common/cloud/cloud_policy_validator_unittest.cc',
      'policy/core/common/cloud/component_cloud_policy_service_unittest.cc',
      'policy/core/common/cloud/component_cloud_policy_store_unittest.cc',
      'policy/core/common/cloud/component_cloud_policy_updater_unittest.cc',
      'policy/core/common/cloud/device_management_service_unittest.cc',
      'policy/core/common/cloud/external_policy_data_fetcher_unittest.cc',
      'policy/core/common/cloud/external_policy_data_updater_unittest.cc',
      'policy/core/common/cloud/policy_header_io_helper_unittest.cc',
      'policy/core/common/cloud/policy_header_service_unittest.cc',
      'policy/core/common/cloud/resource_cache_unittest.cc',
      'policy/core/common/cloud/user_cloud_policy_manager_unittest.cc',
      'policy/core/common/cloud/user_cloud_policy_store_unittest.cc',
      'policy/core/common/cloud/user_info_fetcher_unittest.cc',
      'policy/core/common/config_dir_policy_loader_unittest.cc',
      'policy/core/common/generate_policy_source_unittest.cc',
      'policy/core/common/policy_bundle_unittest.cc',
      'policy/core/common/policy_loader_ios_unittest.mm',
      'policy/core/common/policy_loader_mac_unittest.cc',
      'policy/core/common/policy_loader_win_unittest.cc',
      'policy/core/common/policy_map_unittest.cc',
      'policy/core/common/policy_service_impl_unittest.cc',
      'policy/core/common/policy_statistics_collector_unittest.cc',
      'policy/core/common/preg_parser_win_unittest.cc',
      'policy/core/common/registry_dict_win_unittest.cc',
      'policy/core/common/remote_commands/remote_commands_queue_unittest.cc',
      'policy/core/common/remote_commands/remote_commands_service_unittest.cc',
      'policy/core/common/schema_map_unittest.cc',
      'policy/core/common/schema_registry_tracking_policy_provider_unittest.cc',
      'policy/core/common/schema_registry_unittest.cc',
      'policy/core/common/schema_unittest.cc',
    ],
    'power_unittest_sources': [
      'power/origin_power_map_unittest.cc',
    ],
    'precache_unittest_sources': [
      'precache/content/precache_manager_unittest.cc',
      'precache/core/precache_database_unittest.cc',
      'precache/core/precache_fetcher_unittest.cc',
      'precache/core/precache_url_table_unittest.cc',
    ],
    'user_prefs_unittest_sources': [
      'user_prefs/tracked/device_id_unittest.cc',
      'user_prefs/tracked/pref_hash_calculator_unittest.cc',
      'user_prefs/tracked/pref_hash_filter_unittest.cc',
      'user_prefs/tracked/pref_hash_store_impl_unittest.cc',
      'user_prefs/tracked/pref_service_hash_store_contents_unittest.cc',
      'user_prefs/tracked/segregated_pref_store_unittest.cc',
      'user_prefs/tracked/tracked_preferences_migration_unittest.cc',
    ],
    'proximity_auth_unittest_sources': [
      'proximity_auth/ble/bluetooth_low_energy_characteristics_finder_unittest.cc',
      'proximity_auth/ble/bluetooth_low_energy_connection_finder_unittest.cc',
      'proximity_auth/ble/bluetooth_low_energy_connection_unittest.cc',
      'proximity_auth/ble/bluetooth_low_energy_device_whitelist_unittest.cc',
      'proximity_auth/ble/proximity_auth_ble_system_unittest.cc',
      'proximity_auth/bluetooth_connection_finder_unittest.cc',
      'proximity_auth/bluetooth_connection_unittest.cc',
      'proximity_auth/bluetooth_throttler_impl_unittest.cc',
      'proximity_auth/connection_unittest.cc',
      'proximity_auth/cryptauth/base64url_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_access_token_fetcher_impl_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_api_call_flow_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_client_impl_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_device_manager_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_enroller_impl_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_enrollment_manager_unittest.cc',
      'proximity_auth/cryptauth/cryptauth_gcm_manager_impl_unittest.cc',
      'proximity_auth/cryptauth/fake_secure_message_delegate_unittest.cc',
      'proximity_auth/cryptauth/sync_scheduler_impl_unittest.cc',
      'proximity_auth/device_to_device_operations_unittest.cc',
      'proximity_auth/device_to_device_operations_unittest.cc',
      'proximity_auth/device_to_device_secure_context_unittest.cc',
      'proximity_auth/logging/logging_unittest.cc',
      'proximity_auth/messenger_impl_unittest.cc',
      'proximity_auth/proximity_auth_pref_manager_unittest.cc',
      'proximity_auth/proximity_auth_system_unittest.cc',
      'proximity_auth/proximity_monitor_impl_unittest.cc',
      'proximity_auth/remote_device_life_cycle_impl_unittest.cc',
      'proximity_auth/remote_device_loader_unittest.cc',
      'proximity_auth/remote_status_update_unittest.cc',
      'proximity_auth/throttled_bluetooth_connection_finder_unittest.cc',
      'proximity_auth/unlock_manager_unittest.cc',
      'proximity_auth/wire_message_unittest.cc',
    ],
    'proxy_config_unittest_sources': [
      'proxy_config/pref_proxy_config_tracker_impl_unittest.cc',
      'proxy_config/proxy_config_dictionary_unittest.cc',
      'proxy_config/proxy_prefs_unittest.cc',
    ],
    'query_parser_unittest_sources': [
      'query_parser/query_parser_unittest.cc',
      'query_parser/snippet_unittest.cc',
    ],
    'rappor_unittest_sources': [
      'rappor/bloom_filter_unittest.cc',
      'rappor/byte_vector_utils_unittest.cc',
      'rappor/log_uploader_unittest.cc',
      'rappor/rappor_metric_unittest.cc',
      'rappor/rappor_prefs_unittest.cc',
      'rappor/rappor_service_unittest.cc',
      'rappor/rappor_utils_unittest.cc',
      'rappor/sampler_unittest.cc',
    ],
    'rlz_unittest_sources': [
      'rlz/rlz_tracker_unittest.cc',
    ],
    'safe_json_unittest_sources': [
      'safe_json/json_sanitizer_unittest.cc',
    ],
    'scheduler_unittest_sources': [
      'scheduler/base/nestable_task_runner_for_test.cc',
      'scheduler/base/nestable_task_runner_for_test.h',
      'scheduler/base/task_queue_manager_unittest.cc',
      'scheduler/base/task_queue_selector_unittest.cc',
      'scheduler/base/task_queue_sets_unittest.cc',
      'scheduler/base/test_always_fail_time_source.cc',
      'scheduler/base/test_always_fail_time_source.h',
      'scheduler/base/test_time_source.cc',
      'scheduler/base/test_time_source.h',
      'scheduler/child/idle_helper_unittest.cc',
      'scheduler/child/scheduler_helper_unittest.cc',
      'scheduler/child/scheduler_task_runner_delegate_for_test.cc',
      'scheduler/child/scheduler_task_runner_delegate_for_test.h',
      'scheduler/child/scheduler_task_runner_delegate_impl_unittest.cc',
      'scheduler/child/webthread_impl_for_worker_scheduler_unittest.cc',
      'scheduler/child/worker_scheduler_impl_unittest.cc',
      'scheduler/renderer/deadline_task_runner_unittest.cc',
      'scheduler/renderer/idle_time_estimator_unittest.cc',
      'scheduler/renderer/renderer_scheduler_impl_unittest.cc',
      'scheduler/renderer/task_cost_estimator_unittest.cc',
      'scheduler/renderer/user_model_unittest.cc',
      'scheduler/renderer/webthread_impl_for_renderer_scheduler_unittest.cc',
    ],
    'search_unittest_sources': [
      'search/search_android_unittest.cc',
      'search/search_unittest.cc',
    ],
    'search_engines_unittest_sources': [
      'search_engines/default_search_manager_unittest.cc',
      'search_engines/default_search_pref_migration_unittest.cc',
      'search_engines/keyword_table_unittest.cc',
      'search_engines/search_host_to_urls_map_unittest.cc',
      'search_engines/template_url_prepopulate_data_unittest.cc',
      'search_engines/template_url_service_util_unittest.cc',
      'search_engines/template_url_unittest.cc',
    ],
    'search_provider_logos_unittest_sources': [
      'search_provider_logos/logo_cache_unittest.cc',
      'search_provider_logos/logo_tracker_unittest.cc',
    ],
    'sessions_unittest_sources': [
      'sessions/content/content_serialized_navigation_builder_unittest.cc',
      'sessions/content/content_serialized_navigation_driver_unittest.cc',
      'sessions/core/serialized_navigation_entry_unittest.cc',
      'sessions/core/session_backend_unittest.cc',
      'sessions/core/session_types_unittest.cc',
      'sessions/ios/ios_serialized_navigation_builder_unittest.cc',
      'sessions/ios/ios_serialized_navigation_driver_unittest.cc',
    ],
    'signin_unittest_sources': [
      'signin/core/browser/account_tracker_service_unittest.cc',
      'signin/core/browser/gaia_cookie_manager_service_unittest.cc',
      'signin/core/browser/refresh_token_annotation_request_unittest.cc',
      'signin/core/browser/signin_error_controller_unittest.cc',
      'signin/core/browser/webdata/token_service_table_unittest.cc',
      'signin/ios/browser/account_consistency_service_unittest.mm',
      'signin/ios/browser/profile_oauth2_token_service_ios_delegate_unittest.mm',
    ],
    'storage_monitor_unittest_sources': [
      'storage_monitor/image_capture_device_manager_unittest.mm',
      'storage_monitor/media_storage_util_unittest.cc',
      'storage_monitor/media_transfer_protocol_device_observer_linux_unittest.cc',
      'storage_monitor/storage_info_unittest.cc',
      'storage_monitor/storage_monitor_chromeos_unittest.cc',
      'storage_monitor/storage_monitor_linux_unittest.cc',
      'storage_monitor/storage_monitor_mac_unittest.mm',
      'storage_monitor/storage_monitor_unittest.cc',
      'storage_monitor/storage_monitor_win_unittest.cc',
    ],
    'suggestions_unittest_sources': [
      'suggestions/blacklist_store_unittest.cc',
      'suggestions/image_manager_unittest.cc',
      'suggestions/suggestions_service_unittest.cc',
      'suggestions/suggestions_store_unittest.cc',
    ],
    'sync_driver_unittest_sources': [
      'sync_driver/about_sync_util_unittest.cc',
      'sync_driver/backup_rollback_controller_unittest.cc',
      'sync_driver/data_type_manager_impl_unittest.cc',
      'sync_driver/device_info_data_type_controller_unittest.cc',
      'sync_driver/device_info_sync_service_unittest.cc',
      'sync_driver/favicon_cache_unittest.cc',
      'sync_driver/generic_change_processor_unittest.cc',
      'sync_driver/model_association_manager_unittest.cc',
      'sync_driver/non_blocking_data_type_controller_unittest.cc',
      'sync_driver/non_ui_data_type_controller_unittest.cc',
      'sync_driver/revisit/current_tab_matcher_unittest.cc',
      'sync_driver/revisit/offset_tab_matcher_unittest.cc',
      'sync_driver/revisit/sessions_page_revisit_observer_unittest.cc',
      'sync_driver/shared_change_processor_unittest.cc',
      'sync_driver/sync_prefs_unittest.cc',
      'sync_driver/sync_stopped_reporter_unittest.cc',
      'sync_driver/sync_util_unittest.cc',
      'sync_driver/system_encryptor_unittest.cc',
      'sync_driver/tab_node_pool_unittest.cc',
      'sync_driver/ui_data_type_controller_unittest.cc',
    ],
    'syncable_prefs_unittest_sources': [
      'syncable_prefs/pref_model_associator_unittest.cc',
      'syncable_prefs/pref_service_syncable_unittest.cc',
    ],
    'tracing_unittest_sources': [
      'tracing/trace_config_file_unittest.cc',
    ],
    'translate_unittest_sources': [
      'translate/core/browser/language_state_unittest.cc',
      'translate/core/browser/translate_browser_metrics_unittest.cc',
      'translate/core/browser/translate_language_list_unittest.cc',
      'translate/core/browser/translate_prefs_unittest.cc',
      'translate/core/browser/translate_script_unittest.cc',
      'translate/core/common/translate_metrics_unittest.cc',
      'translate/core/common/translate_util_unittest.cc',
      'translate/core/language_detection/language_detection_util_unittest.cc',
      # TODO(GYP) bug 523060: these translate tests on iOS.
      'translate/ios/browser/js_translate_manager_unittest.mm',
      'translate/ios/browser/language_detection_controller_unittest.mm',
      'translate/ios/browser/translate_controller_unittest.mm',
    ],
    'ui_unittest_sources': [
      'ui/zoom/page_zoom_unittests.cc',
    ],
    'update_client_unittest_sources': [
      'update_client/component_patcher_unittest.cc',
      'update_client/crx_downloader_unittest.cc',
      'update_client/ping_manager_unittest.cc',
      'update_client/request_sender_unittest.cc',
      'update_client/update_checker_unittest.cc',
      'update_client/update_client_unittest.cc',
      'update_client/update_query_params_unittest.cc',
      'update_client/update_response_unittest.cc',
    ],
    'upload_list_unittest_sources': [
      'upload_list/upload_list_unittest.cc',
    ],
    'url_formatter_unittest_sources': [
      'url_formatter/elide_url_unittest.cc',
      'url_formatter/url_fixer_unittest.cc',
      'url_formatter/url_formatter_unittest.cc',
    ],
    'url_matcher_unittest_sources': [
      'url_matcher/regex_set_matcher_unittest.cc',
      'url_matcher/string_pattern_unittest.cc',
      'url_matcher/substring_set_matcher_unittest.cc',
      'url_matcher/url_matcher_factory_unittest.cc',
      'url_matcher/url_matcher_unittest.cc',
    ],
    'variations_unittest_sources': [
      'variations/active_field_trials_unittest.cc',
      'variations/caching_permuted_entropy_provider_unittest.cc',
      'variations/entropy_provider_unittest.cc',
      'variations/experiment_labels_unittest.cc',
      'variations/metrics_util_unittest.cc',
      'variations/net/variations_http_header_provider_unittest.cc',
      'variations/service/variations_service_unittest.cc',
      'variations/study_filtering_unittest.cc',
      'variations/variations_associated_data_unittest.cc',
      'variations/variations_request_scheduler_mobile_unittest.cc',
      'variations/variations_request_scheduler_unittest.cc',
      'variations/variations_seed_processor_unittest.cc',
      'variations/variations_seed_simulator_unittest.cc',
      'variations/variations_seed_store_unittest.cc',
    ],
    'visitedlink_unittest_sources': [
      'visitedlink/test/visitedlink_unittest.cc',
    ],
    'wallpaper_unittest_sources': [
      'wallpaper/wallpaper_resizer_unittest.cc',
    ],
    'web_cache_unittest_sources': [
      'web_cache/browser/web_cache_manager_unittest.cc',
    ],
    'web_modal_unittest_sources': [
      'web_modal/web_contents_modal_dialog_manager_unittest.cc',
    ],
    'web_resource_unittest_sources': [
      'web_resource/eula_accepted_notifier_unittest.cc',
      'web_resource/promo_resource_service_mobile_ntp_unittest.cc',
      'web_resource/promo_resource_service_unittest.cc',
      'web_resource/resource_request_allowed_notifier_unittest.cc',
    ],
    'webcrypto_unittest_sources': [
      'webcrypto/algorithms/aes_cbc_unittest.cc',
      'webcrypto/algorithms/aes_ctr_unittest.cc',
      'webcrypto/algorithms/aes_gcm_unittest.cc',
      'webcrypto/algorithms/aes_kw_unittest.cc',
      'webcrypto/algorithms/ecdh_unittest.cc',
      'webcrypto/algorithms/ecdsa_unittest.cc',
      'webcrypto/algorithms/hmac_unittest.cc',
      'webcrypto/algorithms/rsa_oaep_unittest.cc',
      'webcrypto/algorithms/rsa_pss_unittest.cc',
      'webcrypto/algorithms/rsa_ssa_unittest.cc',
      'webcrypto/algorithms/sha_unittest.cc',
      'webcrypto/algorithms/test_helpers.cc',
      'webcrypto/algorithms/test_helpers.h',
      'webcrypto/status_unittest.cc',
    ],
    'webdata_unittest_sources': [
      'webdata/common/web_database_migration_unittest.cc',
    ],
    'webusb_detector_unittest_sources': [
      'webusb/webusb_detector_unittest.cc',
    ],
  },
  'targets': [
    {
      # GN version: //components:components_tests_pak
      'target_name': 'components_tests_pak',
      'type': 'none',
      'dependencies': [
        'components_resources.gyp:components_resources',
        'components_strings.gyp:components_strings',
      ],
      'actions': [
        {
          'action_name': 'repack_components_tests_pak',
          'variables': {
            'pak_inputs': [
              '<(SHARED_INTERMEDIATE_DIR)/components/components_resources.pak',
              '<(SHARED_INTERMEDIATE_DIR)/components/strings/components_strings_en-US.pak',
            ],
            'pak_output': '<(PRODUCT_DIR)/components_tests_resources.pak',
          },
          'includes': [ '../build/repack_action.gypi' ],
        },
      ],
      'direct_dependent_settings': {
        'mac_bundle_resources': [
          '<(PRODUCT_DIR)/components_tests_resources.pak',
        ],
      },
    },
    {
      # GN version: //components:components_unittests
      'target_name': 'components_unittests',
      'type': '<(gtest_target_type)',
      'sources': [
        'test/run_all_unittests.cc',

        '<@(auto_login_parser_unittest_sources)',
        '<@(autofill_unittest_sources)',
        '<@(bookmarks_unittest_sources)',
        '<@(browser_watcher_unittest_sources)',
        '<@(bubble_unittest_sources)',
        '<@(captive_portal_unittest_sources)',
        '<@(certificate_reporting_unittest_sources)',
        '<@(cloud_devices_unittest_sources)',
        '<@(component_updater_unittest_sources)',
        '<@(compression_unittest_sources)',
        '<@(content_settings_unittest_sources)',
        '<@(crash_unittest_sources)',
        '<@(crx_file_unittest_sources)',
        '<@(data_reduction_proxy_unittest_sources)',
        '<@(data_use_measurement_unittest_sources)',
        '<@(device_event_log_unittest_sources)',
        '<@(dom_distiller_unittest_sources)',
        '<@(domain_reliability_unittest_sources)',
        '<@(enhanced_bookmarks_unittest_sources)',
        '<@(favicon_base_unittest_sources)',
        '<@(favicon_unittest_sources)',
        '<@(gcm_driver_crypto_unittest_sources)',
        '<@(gcm_driver_unittest_sources)',
        '<@(google_unittest_sources)',
        '<@(history_unittest_sources)',
        '<@(instance_id_unittest_sources)',
        '<@(json_schema_unittest_sources)',
        '<@(keyed_service_unittest_sources)',
        '<@(language_usage_metrics_unittest_sources)',
        '<@(leveldb_proto_unittest_sources)',
        '<@(login_unittest_sources)',
        '<@(memory_pressure_unittest_sources)',
        '<@(metrics_unittest_sources)',
        '<@(mime_util_unittest_sources)',
        '<@(network_time_unittest_sources)',
        '<@(offline_page_unittest_sources)',
        '<@(omnibox_unittest_sources)',
        '<@(open_from_clipboard_unittest_sources)',
        '<@(os_crypt_unittest_sources)',
        '<@(packed_ct_ev_whitelist_unittest_sources)',
        '<@(password_manager_unittest_sources)',
        '<@(precache_unittest_sources)',
        '<@(proxy_config_unittest_sources)',
        '<@(query_parser_unittest_sources)',
        '<@(rappor_unittest_sources)',
        '<@(search_engines_unittest_sources)',
        '<@(search_provider_logos_unittest_sources)',
        '<@(search_unittest_sources)',
        '<@(sessions_unittest_sources)',
        '<@(signin_unittest_sources)',
        '<@(suggestions_unittest_sources)',
        '<@(sync_driver_unittest_sources)',
        '<@(syncable_prefs_unittest_sources)',
        '<@(translate_unittest_sources)',
        '<@(undo_unittest_sources)',
        '<@(update_client_unittest_sources)',
        '<@(upload_list_unittest_sources)',
        '<@(url_formatter_unittest_sources)',
        '<@(url_matcher_unittest_sources)',
        '<@(user_prefs_unittest_sources)',
        '<@(variations_unittest_sources)',
        '<@(wallpaper_unittest_sources)',
        '<@(web_resource_unittest_sources)',
        '<@(webdata_unittest_sources)',
        'net_log/net_log_temp_file_unittest.cc',
      ],
      'include_dirs': [
        '..',
      ],
      'dependencies': [
        '../base/base.gyp:base',
        '../base/base.gyp:base_prefs_test_support',
        '../base/base.gyp:test_support_base',
        '../google_apis/google_apis.gyp:google_apis_test_support',
        '../jingle/jingle.gyp:notifier_test_util',
        '../net/net.gyp:net_test_support',
        '../sql/sql.gyp:test_support_sql',
        '../sync/sync.gyp:sync',
        '../sync/sync.gyp:test_support_sync_api',
        '../testing/gmock.gyp:gmock',
        '../testing/gtest.gyp:gtest',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
        '../third_party/libaddressinput/libaddressinput.gyp:libaddressinput_util',
        '../third_party/libjingle/libjingle.gyp:libjingle',
        '../third_party/libphonenumber/libphonenumber.gyp:libphonenumber',
        '../third_party/libxml/libxml.gyp:libxml',
        '../third_party/protobuf/protobuf.gyp:protobuf_lite',
        '../ui/base/ui_base.gyp:ui_base',
        '../ui/gfx/gfx.gyp:gfx',
        '../ui/gfx/gfx.gyp:gfx_test_support',
        '../ui/resources/ui_resources.gyp:ui_resources',
        '../ui/resources/ui_resources.gyp:ui_test_pak',
        '../ui/strings/ui_strings.gyp:ui_strings',
        '../url/url.gyp:url_lib',
        'components.gyp:auto_login_parser',
        'components.gyp:autofill_core_browser',
        'components.gyp:autofill_core_common',
        'components.gyp:autofill_core_test_support',
        'components.gyp:bookmarks_browser',
        'components.gyp:bookmarks_managed',
        'components.gyp:bookmarks_test_support',
        'components.gyp:bubble',
        'components.gyp:captive_portal_test_support',
        'components.gyp:certificate_reporting',
        'components.gyp:cloud_devices_common',
        'components.gyp:component_updater',
        'components.gyp:compression',
        'components.gyp:content_settings_core_browser',
        'components.gyp:content_settings_core_common',
        'components.gyp:content_settings_core_test_support',
        'components.gyp:crash_core_common',
        'components.gyp:crx_file',
        'components.gyp:data_reduction_proxy_core_browser',
        'components.gyp:data_reduction_proxy_core_common',
        'components.gyp:data_reduction_proxy_test_support',
        'components.gyp:data_use_measurement_core',
        'components.gyp:device_event_log_component',
        'components.gyp:dom_distiller_core',
        'components.gyp:dom_distiller_protos',
        'components.gyp:dom_distiller_test_support',
        'components.gyp:domain_reliability',
        'components.gyp:enhanced_bookmarks',
        'components.gyp:enhanced_bookmarks_test_support',
        'components.gyp:favicon_base',
        'components.gyp:favicon_core',
        'components.gyp:gcm_driver',
        'components.gyp:gcm_driver_test_support',
        'components.gyp:google_core_browser',
        'components.gyp:history_core_browser',
        'components.gyp:history_core_common',
        'components.gyp:history_core_test_support',
        'components.gyp:instance_id_test_support',
        'components.gyp:invalidation_impl',
        'components.gyp:invalidation_test_support',
        'components.gyp:json_schema',
        'components.gyp:keyed_service_core',
        'components.gyp:language_usage_metrics',
        'components.gyp:leveldb_proto',
        'components.gyp:leveldb_proto_test_support',
        'components.gyp:login',
        'components.gyp:memory_pressure',
        'components.gyp:metrics',
        'components.gyp:metrics_net',
        'components.gyp:metrics_test_support',
        'components.gyp:net_log',
        'components.gyp:network_time',
        'components.gyp:offline_pages',
        'components.gyp:omnibox_browser',
        'components.gyp:omnibox_test_support',
        'components.gyp:open_from_clipboard',
        'components.gyp:open_from_clipboard_test_support',
        'components.gyp:os_crypt',
        'components.gyp:packed_ct_ev_whitelist',
        'components.gyp:password_manager_core_browser',
        'components.gyp:password_manager_core_browser_test_support',
        'components.gyp:password_manager_sync_browser',
        'components.gyp:precache_core',
        'components.gyp:pref_registry_test_support',
        'components.gyp:proxy_config',
        'components.gyp:query_parser',
        'components.gyp:rappor',
        'components.gyp:rappor_test_support',
        'components.gyp:search',
        'components.gyp:search_engines',
        'components.gyp:search_engines_test_support',
        'components.gyp:search_provider_logos',
        'components.gyp:sessions_test_support',
        'components.gyp:signin_core_browser',
        'components.gyp:signin_core_browser_test_support',
        'components.gyp:suggestions',
        'components.gyp:sync_driver_test_support',
        'components.gyp:syncable_prefs_test_support',
        'components.gyp:translate_core_browser',
        'components.gyp:translate_core_common',
        'components.gyp:translate_core_language_detection',
        'components.gyp:ui_zoom',
        'components.gyp:undo_component',
        'components.gyp:update_client',
        'components.gyp:update_client_test_support',
        'components.gyp:upload_list',
        'components.gyp:url_matcher',
        'components.gyp:user_prefs_tracked',
        'components.gyp:user_prefs_tracked_test_support',
        'components.gyp:variations',
        'components.gyp:variations_http_provider',
        'components.gyp:variations_service',
        'components.gyp:version_info',
        'components.gyp:wallpaper',
        'components.gyp:web_resource',
        'components.gyp:web_resource_test_support',
        'components_resources.gyp:components_resources',
        'components_strings.gyp:components_strings',
        'components_tests_pak',
        'mime_util/mime_util.gyp:mime_util',
        'url_formatter/url_formatter.gyp:url_formatter',
      ],
      'conditions': [
        ['OS!="mac" and OS!="ios"', {
          'sources!': [
            'crash/core/common/objc_zombie_unittest.mm',
          ],
        }],
        ['enable_rlz_support==1', {
          'sources': [
            '<@(rlz_unittest_sources)',
          ],
          'dependencies': [
            '../net/net.gyp:net_test_support',
            '../rlz/rlz.gyp:test_support_rlz',
            'components.gyp:rlz',
          ],
          'conditions': [
            ['OS == "ios"', {
              'dependencies': [
                '../ui/base/ui_base.gyp:ui_base',
              ],
            }],
          ],
        }],
        ['toolkit_views == 1', {
          'sources': [
            'bookmarks/browser/bookmark_node_data_unittest.cc',
            'constrained_window/constrained_window_views_unittest.cc',
          ],
          'dependencies': [
            '<(DEPTH)/ui/views/views.gyp:views',
            '<(DEPTH)/ui/views/views.gyp:views_test_support',
            'components.gyp:constrained_window',
          ]
        }],
        ['OS=="win"', {
          'dependencies': [
            'components.gyp:browser_watcher',
            'components.gyp:browser_watcher_client',
          ]
        }],
        ['OS=="win" and component!="shared_library" and win_use_allocator_shim==1', {
          'dependencies': [
            '<(DEPTH)/base/allocator/allocator.gyp:allocator',
          ],
        }],
        [ 'cld_version==2', {
          'dependencies': [
            # Unit tests should always use statically-linked CLD data.
            '<(DEPTH)/third_party/cld_2/cld_2.gyp:cld2_static', ],
        }],
        ['OS != "ios"', {
          'sources': [
            '<@(certificate_transparency_unittest_sources)',
            '<@(devtools_http_handler_unittest_sources)',
            '<@(error_page_unittest_sources)',
            '<@(guest_view_unittest_sources)',
            '<@(navigation_interception_unittest_sources)',
            '<@(network_hints_unittest_sources)',
            '<@(page_load_metrics_unittest_sources)',
            '<@(power_unittest_sources)',
            '<@(safe_json_unittest_sources)',
            '<@(scheduler_unittest_sources)',
            '<@(storage_monitor_unittest_sources)',
            '<@(ui_unittest_sources)',
            '<@(visitedlink_unittest_sources)',
            '<@(web_cache_unittest_sources)',
            '<@(webcrypto_unittest_sources)',
            '<@(web_modal_unittest_sources)',
          ],
          'dependencies': [
            '../content/content_shell_and_tests.gyp:test_support_content',
            '../skia/skia.gyp:skia',
            'components.gyp:autofill_content_browser',
            'components.gyp:autofill_content_renderer',
            'components.gyp:autofill_content_test_support',
            'components.gyp:certificate_transparency',
            'components.gyp:crash_test_support',
            'components.gyp:data_reduction_proxy_content_browser',
            'components.gyp:data_use_measurement_content',
            'components.gyp:devtools_http_handler',
            'components.gyp:dom_distiller_content_browser',
            'components.gyp:dom_distiller_content_renderer',
            'components.gyp:error_page_renderer',
            'components.gyp:favicon_content',
            'components.gyp:guest_view_browser',
            'components.gyp:guest_view_common',
            'components.gyp:guest_view_test_support',
            'components.gyp:history_content_browser',
            'components.gyp:keyed_service_content',
            'components.gyp:navigation_interception',
            'components.gyp:network_hints_renderer',
            'components.gyp:metrics_gpu',
            'components.gyp:metrics_profiler',
            'components.gyp:page_load_metrics_browser',
            'components.gyp:page_load_metrics_renderer',
            'components.gyp:password_manager_content_browser',
            'components.gyp:password_manager_content_common',
            'components.gyp:power',
            'components.gyp:precache_content',
            'components.gyp:safe_json',
            'components.gyp:safe_json_test_support',
            'components.gyp:sessions_content',
            'components.gyp:storage_monitor',
            'components.gyp:storage_monitor_test_support',
            'components.gyp:url_matcher',
            'components.gyp:visitedlink_browser',
            'components.gyp:visitedlink_renderer',
            'components.gyp:web_cache_browser',
            'components.gyp:web_modal',
            'components.gyp:web_modal_test_support',
            'scheduler/scheduler.gyp:scheduler',
            'test_runner/test_runner.gyp:test_runner',
            'webcrypto/webcrypto.gyp:webcrypto',
            '../third_party/re2/re2.gyp:re2',
          ],
          'conditions': [
            ['OS=="android"', {
              'dependencies': [
                '../build/android/ndk.gyp:cpu_features',
              ],
            }],
            ['OS=="android" and configuration_policy == 1', {
              'dependencies': [
                'components.gyp:policy_java',
              ],
            }],
            ['use_openssl==1', {
              'dependencies': [
                '../third_party/boringssl/boringssl.gyp:boringssl',
              ],
            }, {
              'conditions': [
                ['os_posix == 1 and OS != "mac" and OS != "ios" and OS != "android"', {
                  'dependencies': [
                    '../build/linux/system.gyp:ssl',
                  ],
                }, {
                  'dependencies': [
                    '../third_party/nss/nss.gyp:nspr',
                    '../third_party/nss/nss.gyp:nss',
                  ],
                }],
              ],
            }],
          ],
        }, { # 'OS == "ios"'
          'sources': [
            'webp_transcode/webp_decoder_unittest.mm',
            'webp_transcode/webp_network_client_unittest.mm',
          ],
          'sources!': [
            'metrics/gpu/gpu_metrics_provider_unittest.cc',
            'metrics/profiler/profiler_metrics_provider_unittest.cc',
            'metrics/profiler/tracking_synchronizer_unittest.cc',
          ],
          'sources/': [
            # Exclude all tests that depends on //content (based on layered-
            # component directory structure).
            ['exclude', '^[^/]*/content/'],
          ],
          'mac_bundle_resources': [
            '<(PRODUCT_DIR)/ui_test.pak',
          ],
          'dependencies': [
            '../ios/ios_tests.gyp:test_support_ios',
            '../ios/web/ios_web.gyp:test_support_ios_web',
            '../third_party/ocmock/ocmock.gyp:ocmock',
            'components.gyp:autofill_ios_browser',
            'components.gyp:sessions_ios',
            'components.gyp:signin_ios_browser',
            'components.gyp:signin_ios_browser_test_support',
            'components.gyp:translate_ios_browser',
            'components.gyp:webp_transcode',
          ],
          'actions': [
            {
              'action_name': 'copy_test_data',
              'variables': {
                'test_data_files': [
                  '../net/data/ssl/certificates',
                  'test/data',
                ],
                'test_data_prefix': 'components',
              },
              'includes': [ '../build/copy_test_data_ios.gypi' ],
            },
          ],
          'conditions': [
            ['configuration_policy==1', {
              'sources/': [
                ['include', '^policy/'],
              ],
            }],
          ],
        }],
        ['disable_nacl==0', {
          'sources': [
            '<@(nacl_unittest_sources)',
          ],
          'dependencies': [
            'nacl.gyp:nacl_browser',
            'nacl.gyp:nacl_common',
          ],
        }],
        ['OS == "mac"', {
          'link_settings': {
            'libraries': [
              '$(SDKROOT)/System/Library/Frameworks/AddressBook.framework',
              '$(SDKROOT)/System/Library/Frameworks/Foundation.framework',
              '$(SDKROOT)/System/Library/Frameworks/ImageCaptureCore.framework',
            ],
          },
          'sources!': [
            'password_manager/core/browser/password_store_default_unittest.cc',
          ],
        }],
        ['OS == "android"', {
          'sources': [
            '<@(cronet_unittest_sources)',
            'data_reduction_proxy/content/browser/data_reduction_proxy_debug_blocking_page_unittest.cc',
            'data_reduction_proxy/content/browser/data_reduction_proxy_debug_resource_throttle_unittest.cc',
            'data_reduction_proxy/content/browser/data_reduction_proxy_debug_ui_manager_unittest.cc',
            'invalidation/impl/invalidation_logger_unittest.cc',
            'invalidation/impl/invalidation_service_android_unittest.cc',
          ],
          'sources!': [
            'gcm_driver/gcm_account_mapper_unittest.cc',
            'gcm_driver/gcm_channel_status_request_unittest.cc',
            'gcm_driver/gcm_client_impl_unittest.cc',
            'gcm_driver/gcm_delayed_task_controller_unittest.cc',
            'gcm_driver/gcm_driver_desktop_unittest.cc',
            'gcm_driver/gcm_stats_recorder_impl_unittest.cc',
            'gcm_driver/instance_id/instance_id_driver_unittest.cc',
            'sessions/core/session_backend_unittest.cc',
            'storage_monitor/media_storage_util_unittest.cc',
            'storage_monitor/storage_info_unittest.cc',
            'storage_monitor/storage_monitor_unittest.cc',
            'web_modal/web_contents_modal_dialog_manager_unittest.cc',
          ],
          'dependencies': [
            'components.gyp:cronet_static',
            'components.gyp:data_reduction_proxy_content',
            'components.gyp:safe_json_java',
            '../content/content.gyp:content_java',
            '../testing/android/native_test.gyp:native_test_native_code',
          ],
          'dependencies!': [
            'components.gyp:storage_monitor',
            'components.gyp:storage_monitor_test_support',
            'components.gyp:web_modal',
            'components.gyp:web_modal_test_support',
          ],
        }, {
          'sources': [
            '<@(invalidation_unittest_sources)',
          ],
        }],
        ['OS != "ios" and OS != "android"', {
          'sources': [
            '<@(audio_modem_unittest_sources)',
            '<@(copresence_unittest_sources)',
            '<@(feedback_unittest_sources)',
            '<@(proximity_auth_unittest_sources)',
            '<@(tracing_unittest_sources)',
            '<@(webusb_detector_unittest_sources)',
          ],
          'sources!': [
            'variations/variations_request_scheduler_mobile_unittest.cc',
            'web_resource/promo_resource_service_mobile_ntp_unittest.cc',
          ],
          'dependencies': [
            '../device/bluetooth/bluetooth.gyp:device_bluetooth_mocks',
            '../device/core/core.gyp:device_core',
            '../device/usb/usb.gyp:device_usb',
            '../device/usb/usb.gyp:device_usb_mocks',
            '../google_apis/google_apis.gyp:google_apis_test_support',
            '../third_party/protobuf/protobuf.gyp:protobuf_lite',
            'components.gyp:audio_modem',
            'components.gyp:audio_modem_test_support',
            'components.gyp:copresence',
            'components.gyp:copresence_test_support',
            'components.gyp:cryptauth',
            'components.gyp:cryptauth_proto',
            'components.gyp:cryptauth_test_support',
            'components.gyp:feedback_component',
            'components.gyp:pref_registry_test_support',
            'components.gyp:proximity_auth',
            'components.gyp:proximity_auth_test_support',
            'components.gyp:webusb',
            'tracing.gyp:tracing',
          ],
        }],
        ['chromeos==1', {
          'sources': [
            'pairing/message_buffer_unittest.cc',
            'timers/alarm_timer_unittest.cc',
            'wifi_sync/wifi_config_delegate_chromeos_unittest.cc',
            'wifi_sync/wifi_credential_syncable_service_unittest.cc',
            'wifi_sync/wifi_credential_unittest.cc',
            'wifi_sync/wifi_security_class_chromeos_unittest.cc',
            'wifi_sync/wifi_security_class_unittest.cc',
            '<@(ownership_unittest_sources)',
          ],
          'sources!': [
            'storage_monitor/storage_monitor_linux_unittest.cc',
          ],
          'dependencies': [
            '../chromeos/chromeos.gyp:chromeos_test_support',
            'components.gyp:ownership',
            'components.gyp:pairing',
            'components.gyp:user_manager_test_support',
            'components.gyp:wifi_sync',
          ],
        }],
        ['OS=="linux"', {
          'sources': [
            'metrics/serialization/serialization_utils_unittest.cc',
          ],
          'dependencies': [
            'components.gyp:metrics_serialization',
            '../dbus/dbus.gyp:dbus',
            '../device/media_transfer_protocol/media_transfer_protocol.gyp:device_media_transfer_protocol',
          ],
        }],
        ['OS=="linux" and use_udev==0', {
          'dependencies!': [
            'components.gyp:storage_monitor',
            'components.gyp:storage_monitor_test_support',
          ],
          'sources/': [
            ['exclude', '^storage_monitor/'],
          ],
        }],
        ['OS=="win" and win_use_allocator_shim==1', {
          'dependencies': [
            '../base/allocator/allocator.gyp:allocator',
          ],
        }],
        ['OS=="linux" and component=="shared_library" and use_allocator!="none"', {
          'dependencies': [
            '<(DEPTH)/base/allocator/allocator.gyp:allocator',
          ],
          'link_settings': {
            'ldflags': ['-rdynamic'],
          },
        }],
        ['configuration_policy==1', {
          'dependencies': [
            'components.gyp:policy_component',
            'components.gyp:policy_component_test_support',
            'components.gyp:policy_test_support',
          ],
          'sources': [
            '<@(policy_unittest_sources)',
            'search_engines/default_search_policy_handler_unittest.cc',
            'sync_driver/sync_policy_handler_unittest.cc',
          ],
          'conditions': [
            ['OS=="android"', {
              'sources/': [
                ['exclude', '^policy/core/common/async_policy_provider_unittest\\.cc'],
              ],
            }],
            ['OS=="android" or OS=="ios"', {
              # Note: 'sources!' is processed before any 'sources/', so the
              # ['include', '^policy/'] on iOS above will include all of the
              # policy source files again. Using 'source/' here too will get
              # these files excluded as expected.
              'sources/': [
                ['exclude', '^policy/core/common/cloud/component_cloud_policy_service_unittest\\.cc'],
                ['exclude', '^policy/core/common/cloud/component_cloud_policy_store_unittest\\.cc'],
                ['exclude', '^policy/core/common/cloud/component_cloud_policy_updater_unittest\\.cc'],
                ['exclude', '^policy/core/common/cloud/external_policy_data_fetcher_unittest\\.cc'],
                ['exclude', '^policy/core/common/cloud/external_policy_data_updater_unittest\\.cc'],
                ['exclude', '^policy/core/common/cloud/resource_cache_unittest\\.cc'],
                ['exclude', '^policy/core/common/config_dir_policy_loader_unittest\\.cc'],
              ],
            }],
            ['chromeos==1', {
              'sources': [
                'policy/core/common/proxy_policy_provider_unittest.cc',
              ],
              'sources!': [
                'policy/core/common/cloud/user_cloud_policy_manager_unittest.cc',
                'policy/core/common/cloud/user_cloud_policy_store_unittest.cc',
              ],
            }],
            ['OS=="ios" or OS=="mac"', {
              'sources': [
                'policy/core/common/mac_util_unittest.cc',
              ],
            }],
          ],
        }],
        ['enable_plugins == 1', {
          'sources': [
            'content_settings/core/browser/content_settings_provider_unittest.cc',
            'content_settings/core/browser/plugins_field_trial_unittest.cc',
          ],
        }],
      ],
      # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
      'msvs_disabled_warnings': [4267, ],
    },
  ],
  'conditions': [
    ['OS == "android"', {
      'variables': {
        'components_browsertests_pak_input_resources': [
          '<(PRODUCT_DIR)/components_tests_resources.pak',
          '<(PRODUCT_DIR)/content_shell/assets/content_shell.pak',
        ],
        'conditions': [
          ['icu_use_data_file_flag==1', {
            'components_browsertests_pak_input_resources': [
              '<(PRODUCT_DIR)/icudtl.dat',
            ],
          }],
          ['v8_use_external_startup_data==1', {
            'components_browsertests_pak_input_resources': [
              '<(PRODUCT_DIR)/natives_blob.bin',
              '<(PRODUCT_DIR)/snapshot_blob.bin',
            ],
          }],
        ],
      },
      'targets': [
        {
          'target_name': 'components_browsertests_paks_copy',
          'type': 'none',
          'dependencies': [
            'components_browsertests',
          ],
          'copies': [
            {
              'destination': '<(PRODUCT_DIR)/components_browsertests_apk_shell/assets',
              'files': [
                '<@(components_browsertests_pak_input_resources)',
              ],
            }
          ],
        },
        {
          'target_name': 'components_browsertests_manifest',
          'type': 'none',
          'variables': {
            'jinja_inputs': ['test/android/browsertests_apk/AndroidManifest.xml.jinja2'],
            'jinja_output': '<(SHARED_INTERMEDIATE_DIR)/components_browsertests_manifest/AndroidManifest.xml',
          },
          'includes': [ '../build/android/jinja_template.gypi' ],
        },
        {
          # TODO(GN)
          'target_name': 'components_browsertests_apk',
          'type': 'none',
          'dependencies': [
            '../content/content.gyp:content_icudata',
            '../content/content.gyp:content_java',
            '../content/content.gyp:content_v8_external_data',
            '../content/content_shell_and_tests.gyp:content_java_test_support',
            '../content/content_shell_and_tests.gyp:content_shell_browsertests_java',
            '../content/content_shell_and_tests.gyp:content_shell_java',
            'components_browsertests_paks_copy',
            'components_browsertests',
          ],
          'variables': {
            'test_suite_name': 'components_browsertests',
            'isolate_file': 'components_browsertests.isolate',
            'java_in_dir': 'test/android/browsertests_apk',
            'android_manifest_path': '<(SHARED_INTERMEDIATE_DIR)/components_browsertests_manifest/AndroidManifest.xml',
            'resource_dir': 'test/android/browsertests_apk/res',
            'asset_location': '<(PRODUCT_DIR)/components_browsertests_apk_shell/assets',
            'conditions': [
              ['icu_use_data_file_flag==1', {
                'additional_input_paths': [
                  '<(PRODUCT_DIR)/icudtl.dat',
                ],
              }],
              ['v8_use_external_startup_data==1', {
                'additional_input_paths': [
                  '<(PRODUCT_DIR)/natives_blob.bin',
                  '<(PRODUCT_DIR)/snapshot_blob.bin',
                ],
              }],
            ],
          },
          'includes': [ '../build/apk_browsertest.gypi' ],
        },
        {
          'target_name': 'components_unittests_apk',
          'isolate_file': 'components_unittests.isolate',
          'type': 'none',
          'dependencies': [
            'components_unittests',
            'components.gyp:invalidation_java',
            'components.gyp:signin_core_browser_java',
          ],
          'variables': {
            'test_suite_name': 'components_unittests',
          },
          'includes': [ '../build/apk_test.gypi' ],
        },
        {
          'target_name': 'components_junit_tests',
          'type': 'none',
          'dependencies': [
            'components.gyp:invalidation_java',
            '../base/base.gyp:base_java',
            '../base/base.gyp:base_java_test_support',
            '../testing/android/junit/junit_test.gyp:junit_test_support',
          ],
          'conditions': [
            ['configuration_policy == 1', {
              'dependencies': [
                'components.gyp:policy_java',
              ],
            }],
          ],
          'variables': {
            'main_class': 'org.chromium.testing.local.JunitTestMain',
            'src_paths': [
              'invalidation/impl/android/junit/',
              'policy/android/junit/'
            ],
          },
          'includes': [ '../build/host_jar.gypi' ],
         },
      ],
    }],
    ['OS != "ios"', {
      'targets': [
        {
          # GN: //components:components_perftests
          'target_name': 'components_perftests',
          'type': '<(gtest_target_type)',
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:test_support_perf',
            '../content/content_shell_and_tests.gyp:test_support_content',
            '../testing/gtest.gyp:gtest',
            '../testing/perf/perf_test.gyp:perf_test',
            'components.gyp:visitedlink_browser',
            'scheduler/scheduler.gyp:scheduler',
          ],
         'include_dirs': [
           '..',
         ],
         'sources': [
           'scheduler/base/nestable_task_runner_for_test.cc',
           'scheduler/base/nestable_task_runner_for_test.h',
           'scheduler/base/task_queue_manager_perftest.cc',
           'visitedlink/test/visitedlink_perftest.cc',
         ],
         'conditions': [
           ['OS == "android"', {
             'dependencies': [
               '../testing/android/native_test.gyp:native_test_native_code',
             ],
           }],
           ['OS=="win" and component!="shared_library" and win_use_allocator_shim==1', {
             'dependencies': [
               '<(DEPTH)/base/allocator/allocator.gyp:allocator',
             ],
           }],
         ],
         # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
         'msvs_disabled_warnings': [ 4267, ],
        },
        {
          'target_name': 'components_browsertests',
          'type': '<(gtest_target_type)',
          'defines!': ['CONTENT_IMPLEMENTATION'],
          'dependencies': [
            '../content/content.gyp:content_common',
            '../content/content.gyp:content_gpu',
            '../content/content.gyp:content_plugin',
            '../content/content.gyp:content_renderer',
            '../content/content_shell_and_tests.gyp:content_browser_test_support',
            '../content/content_shell_and_tests.gyp:content_shell_lib',
            '../content/content_shell_and_tests.gyp:content_shell_pak',
            '../content/content_shell_and_tests.gyp:test_support_content',
            '../skia/skia.gyp:skia',
            '../testing/gmock.gyp:gmock',
            '../testing/gtest.gyp:gtest',
            'components.gyp:autofill_content_browser',
            'components.gyp:autofill_content_renderer',
            'components.gyp:content_settings_core_browser',
            'components.gyp:content_settings_core_common',
            'components.gyp:dom_distiller_content_browser',
            'components.gyp:dom_distiller_content_renderer',
            'components.gyp:dom_distiller_core',
            'components.gyp:password_manager_content_renderer',
            'components.gyp:pref_registry_test_support',
            'components_resources.gyp:components_resources',
            'components_strings.gyp:components_strings',
            'components_tests_pak',
          ],
          'include_dirs': [
            '..',
          ],
          'defines': [
            'HAS_OUT_OF_PROC_TEST_RUNNER',
          ],
          'sources': [
            # Note: test list duplicated in GN build.
            'autofill/content/browser/risk/fingerprint_browsertest.cc',
            'autofill/content/renderer/password_form_conversion_utils_browsertest.cc',
            'dom_distiller/content/browser/distillable_page_utils_browsertest.cc',
            'dom_distiller/content/browser/distiller_page_web_contents_browsertest.cc',
            'dom_distiller/content/browser/test/dom_distiller_js_browsertest.cc',
            'password_manager/content/renderer/credential_manager_client_browsertest.cc',
          ],
          'conditions': [
            ['OS == "android"', {
              'sources' : [
                'test/android/browsertests_apk/components_browser_tests_jni_onload.cc',
              ],
              'sources!': [
                'autofill/content/browser/risk/fingerprint_browsertest.cc',
              ],
              'dependencies': [
                '../testing/android/native_test.gyp:native_test_support',
              ],
            }],
            ['OS == "linux"', {
              'sources': [
                  # content_extractor_browsertest is a standalone content extraction tool built as
                  # a MANUAL component_browsertest.
                  'dom_distiller/standalone/content_extractor_browsertest.cc',
                ],
            }],
            ['OS=="win"', {
              'resource_include_dirs': [
                '<(SHARED_INTERMEDIATE_DIR)/content/app/resources',
              ],
              'sources': [
                '../content/shell/app/resource.h',
                '../content/shell/app/shell.rc',
              ],
              'dependencies': [
                '<(DEPTH)/content/app/resources/content_resources.gyp:content_resources',
                '<(DEPTH)/content/app/strings/content_strings.gyp:content_strings',
                '<(DEPTH)/net/net.gyp:net_resources',
                '<(DEPTH)/third_party/WebKit/public/blink_resources.gyp:blink_resources',
                '<(DEPTH)/third_party/iaccessible2/iaccessible2.gyp:iaccessible2',
                '<(DEPTH)/third_party/isimpledom/isimpledom.gyp:isimpledom',
              ],
              'configurations': {
                'Debug_Base': {
                  'msvs_settings': {
                    'VCLinkerTool': {
                      'LinkIncremental': '<(msvs_large_module_debug_link_mode)',
                    },
                  },
                },
              },
              # TODO(jschuh): crbug.com/167187 fix size_t to int truncations.
              'msvs_disabled_warnings': [ 4267, ],
            }],
            ['OS=="win" and win_use_allocator_shim==1', {
              'dependencies': [
                '../base/allocator/allocator.gyp:allocator',
              ],
            }],
            ['OS=="mac"', {
              'dependencies': [
                '../content/content_shell_and_tests.gyp:content_shell',  # Needed for Content Shell.app's Helper.
              ],
            }],
            ['enable_basic_printing==1 or enable_print_preview==1', {
              'dependencies': [
                'components.gyp:printing_test_support',
              ],
              'sources' : [
                'printing/test/print_web_view_helper_browsertest.cc',
              ],
            }]
          ],
        },
      ],
      'conditions': [
        ['test_isolation_mode != "noop"', {
          'targets': [
            {
              'target_name': 'components_browsertests_run',
              'type': 'none',
              'dependencies': [ 'components_browsertests' ],
              'includes': [
                '../build/isolate.gypi',
              ],
              'sources': [
                'components_browsertests.isolate',
              ],
              'conditions': [
                ['use_x11==1', {
                  'dependencies': [
                    '../tools/xdisplaycheck/xdisplaycheck.gyp:xdisplaycheck',
                  ],
                }],
              ],
            },
          ],
        }],
      ],
    }],
    ['test_isolation_mode != "noop"', {
      'targets': [
        {
          'target_name': 'components_unittests_run',
          'type': 'none',
          'dependencies': [
            'components_unittests',
          ],
          'includes': [
            '../build/isolate.gypi',
          ],
          'sources': [
            'components_unittests.isolate',
          ],
          'conditions': [
            ['use_x11==1', {
              'dependencies': [
                '../tools/xdisplaycheck/xdisplaycheck.gyp:xdisplaycheck',
              ],
            }],
          ],
        },
      ],
    }],
  ],
}
