// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/extensions/extension_install_ui_factory.h"

#include "chrome/browser/ui/extensions/extension_install_ui_default.h"

namespace extensions {

scoped_ptr<ExtensionInstallUI> CreateExtensionInstallUI(
    content::BrowserContext* context) {
  return scoped_ptr<ExtensionInstallUI>(new ExtensionInstallUIDefault(context));
}

}  // namespace extensions
