// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


#ifndef BASE_ANDROID_JNI_GENERATOR_JNI_GENERATOR_HELPER_H_
#define BASE_ANDROID_JNI_GENERATOR_JNI_GENERATOR_HELPER_H_

#include <jni.h>

#include "base/android/jni_android.h"
#include "base/android/scoped_java_ref.h"
#include "base/basictypes.h"
#include "base/logging.h"

// Project-specific macros used by the header files generated by
// jni_generator.py. Different projects can then specify their own
// implementation for this file.
#define CHECK_NATIVE_PTR(env, jcaller, native_ptr, method_name, ...) \
    DCHECK(native_ptr) << method_name;

#define CHECK_CLAZZ(env, jcaller, clazz, ...) \
    DCHECK(clazz);

namespace jni_generator {

  inline void HandleRegistrationError(JNIEnv* env, jclass clazz,
                                      const char* filename) {
    LOG(ERROR) << "RegisterNatives failed in " << filename;
  }

  inline void CheckException(JNIEnv* env) {
    base::android::CheckException(env);
  }

}  // namespace jni_generator

using base::android::ScopedJavaLocalRef;
using base::android::JavaParamRef;

#endif  // BASE_ANDROID_JNI_GENERATOR_JNI_GENERATOR_HELPER_H_
