// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_CHROMEOS_FILE_SYSTEM_PROVIDER_OPERATIONS_ADD_WATCHER_H_
#define CHROME_BROWSER_CHROMEOS_FILE_SYSTEM_PROVIDER_OPERATIONS_ADD_WATCHER_H_

#include "base/files/file.h"
#include "base/memory/scoped_ptr.h"
#include "chrome/browser/chromeos/file_system_provider/operations/operation.h"
#include "chrome/browser/chromeos/file_system_provider/provided_file_system_info.h"
#include "chrome/browser/chromeos/file_system_provider/provided_file_system_interface.h"
#include "chrome/browser/chromeos/file_system_provider/request_value.h"
#include "storage/browser/fileapi/async_file_util.h"

namespace base {
class FilePath;
}  // namespace base

namespace extensions {
class EventRouter;
}  // namespace extensions

namespace chromeos {
namespace file_system_provider {
namespace operations {

// Adds a watcher. If |recursive| is true, than also watches for all of the
// child entries in within, recursively. Recursive must not be set to true for
// files.
class AddWatcher : public Operation {
 public:
  AddWatcher(extensions::EventRouter* event_router,
             const ProvidedFileSystemInfo& file_system_info,
             const base::FilePath& entry_path,
             bool recursive,
             const storage::AsyncFileUtil::StatusCallback& callback);
  ~AddWatcher() override;

  // Operation overrides.
  bool Execute(int request_id) override;
  void OnSuccess(int request_id,
                 scoped_ptr<RequestValue> result,
                 bool has_more) override;
  void OnError(int request_id,
               scoped_ptr<RequestValue> result,
               base::File::Error error) override;

 private:
  const base::FilePath entry_path_;
  const bool recursive_;
  const storage::AsyncFileUtil::StatusCallback callback_;

  DISALLOW_COPY_AND_ASSIGN(AddWatcher);
};

}  // namespace operations
}  // namespace file_system_provider
}  // namespace chromeos

#endif  // CHROME_BROWSER_CHROMEOS_FILE_SYSTEM_PROVIDER_OPERATIONS_ADD_WATCHER_H_
