# Linux Chromium Arm Recipes

[TOC]

## Recipe1: Building for an ARM CrOS device

This recipe uses `ninja` (instead of `make`) so its startup time is much lower
(sub-1s, instead of tens of seconds), is integrated with goma (for
google-internal users) for very high parallelism, and uses `sshfs` instead of
`scp` to significantly speed up the compile-run cycle. It has moved to
https://sites.google.com/a/chromium.org/dev/developers/how-tos/-quickly-building-for-cros-arm-x64
(mostly b/c of the ease of attaching files to sites).


## Recipe2: Explicit Cross compiling

Due to the lack of ARM hardware with the grunt to build Chromium native, cross
compiling is currently the recommended method of building for ARM.

These instruction are designed to run on Ubuntu Precise.

### Installing the toolchain

The install-build-deps script can be used to install all the compiler
and library dependencies directly from Ubuntu:

    $ ./build/install-build-deps.sh --arm

### Installing the rootfs

A prebuilt rootfs image is kept up-to-date on Cloud Storage. It will
automatically be installed by gclient runhooks installed if you have
`target_arch=arm` in your `GYP_DEFINES`.

To install the sysroot manually you can run:

    ./chrome/installer/linux/sysroot_scripts/install-debian.wheezy.sysroot.py \
        --arch=arm

### Building

To build for ARM, using the clang binary in the chrome tree, use the following
settings:

    export GYP_CROSSCOMPILE=1
    export GYP_DEFINES="target_arch=arm"

There variables need to be set at gyp-time (when you run `gyp_chromium`),
but are not needed at build-time (when you run make/ninja).

## Testing

### Automated Build and Testing

Chromium's testing infrastructure for ARM/Linux is (to say the least)
in its infancy. There are currently two builders setup, one on the
FYI waterfall and one the the trybot waterfall:

*   [Linux ARM Cross-Compile](http://build.chromium.org/p/chromium.fyi/builders/Linux%20ARM%20Cross-Compile)
*   [linux_arm](http://build.chromium.org/p/tryserver.chromium.linux/builders/linux_arm)

These builders cross compile on x86-64 and then trigger testing on real ARM hard
bots:

*   [Linux ARM Tests (Panda)](http://build.chromium.org/p/chromium.fyi/builders/Linux%20ARM%20Tests%20%28Panda%29/)
*   [linux_arm_tester](http://build.chromium.org/p/tryserver.chromium.linux/builders/linux_arm_tester)

Unfortunately, even those the builders are usually green, the testers are not
yet well maintained or monitored.

There is compile-only trybot and fyi bot also:

*   [Linux ARM](http://build.chromium.org/p/chromium.fyi/builders/Linux%20ARM)
*   [linux_arm_compile](http://build.chromium.org/p/tryserver.chromium.linux/builders/linux_arm_compile)

### Testing with QEMU

If you don't have a real ARM machine, you can test with QEMU. For instance,
there are some prebuilt QEMU Debian images here:
http://people.debian.org/~aurel32/qemu/. Another option is to use the rootfs
generated by rootstock, as mentioned above.

Here's a minimal xorg.conf if needed:

```
Section "InputDevice"
        Identifier      "Generic Keyboard"
        Driver          "kbd"
        Option          "XkbRules"      "xorg"
        Option          "XkbModel"      "pc105"
        Option          "XkbLayout"     "us"
EndSection

Section "InputDevice"
        Identifier      "Configured Mouse"
        Driver          "mouse"
EndSection

Section "Device"
        Identifier      "Configured Video Device"
        Driver  "fbdev"
        Option          "UseFBDev"              "true"
EndSection

Section "Monitor"
        Identifier      "Configured Monitor"
EndSection

Section "Screen"
        Identifier      "Default Screen"
        Monitor         "Configured Monitor"
        Device          "Configured Video Device"
        DefaultDepth 8
        SubSection "Display"
            Depth 8
            Modes "1024x768" "800x600" "640x480"
        EndSubSection
EndSection
```

### Notes

*   To building for thumb reduces the stripped release binary by around 9MB,
    equating to ~33% of the binary size.  To enable thumb, set `'arm_thumb': 1`
*   TCmalloc does not have an ARM port, so it is disabled.
