// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "mandoline/app/core_services_initialization.h"

#include "mojo/package_manager/package_manager_impl.h"
#include "mojo/runner/context.h"

namespace mandoline {

void InitCoreServicesForContext(mojo::runner::Context* context) {
  // TODO(erg): We should probably handle this differently; these could be
  // autogenerated from package manifests.
  mojo::package_manager::PackageManagerImpl* manager =
      context->package_manager();
  manager->RegisterApplicationPackageAlias(
      GURL("mojo:clipboard"), GURL("mojo:core_services"), "Core");
  manager->RegisterApplicationPackageAlias(GURL("mojo:filesystem"),
                                           GURL("mojo:core_services"), "Files");
#if defined(OS_LINUX) && !defined(OS_ANDROID)
  manager->RegisterApplicationPackageAlias(GURL("mojo:font_service"),
                                           GURL("mojo:core_services"), "Files");
#endif
#if !defined(OS_ANDROID)
  // On Android, these are Java apps which are loaded in the shell process.
  manager->RegisterApplicationPackageAlias(GURL("mojo:mus"),
                                           GURL("mojo:core_services"),
                                           "Surfaces");
  manager->RegisterApplicationPackageAlias(
      GURL("mojo:network_service"), GURL("mojo:core_services"), "Network");
  manager->RegisterApplicationPackageAlias(
      GURL("mojo:resource_provider"), GURL("mojo:core_services"), "Files");
#endif

#if defined(USE_AURA)
  manager->RegisterApplicationPackageAlias(GURL("mojo:desktop_ui"),
                                           GURL("mojo:core_services"),
                                           "Core");
  manager->RegisterApplicationPackageAlias(
      GURL("mojo:omnibox"), GURL("mojo:core_services"), "Core");
#endif
  manager->RegisterApplicationPackageAlias(
      GURL("mojo:web_view"), GURL("mojo:core_services"), "Core");
  manager->RegisterApplicationPackageAlias(
      GURL("mojo:tracing"), GURL("mojo:core_services"), "Core");
}

}  // namespace mandoline
